/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.multicostregular.structure;

import choco.cp.solver.constraints.global.multicostregular.algo.PathFinder;
import choco.cp.solver.constraints.global.multicostregular.structure.Arc;
import choco.cp.solver.constraints.global.multicostregular.structure.Node;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

public class LayeredGraph {
    protected final AllActiveArcIterator activeIterator;
    protected final InArcIterator inIterator;
    protected final OutArcIterator outIterator;
    protected final Node[][] layers;
    protected final int nbLayers;
    protected final Arc[] sortIn;
    protected final Arc[] sortOut;
    protected final IStateBitSet activeIn;
    protected final IStateBitSet activeOut;
    protected final IStateBitSet inStack;
    protected final IntDomainVar[] vars;
    protected final IStateIntVector Q;
    protected int biggestDomainSize;
    protected final Node source;
    protected final Node tink;
    protected final PathFinder pathFinder;
    protected final IntSConstraint mcr;

    public LayeredGraph(IntDomainVar[] vars, Automaton pi, IntSConstraint mcr) throws ContradictionException {
        int j;
        this.vars = vars;
        this.biggestDomainSize = Integer.MIN_VALUE;
        this.mcr = mcr;
        for (IntDomainVar v : vars) {
            int sz = v.getSup() + 1;
            if (this.biggestDomainSize >= sz) continue;
            this.biggestDomainSize = sz;
        }
        ArrayList<Arc> sortIn = new ArrayList<Arc>();
        ArrayList<Arc> sortOut = new ArrayList<Arc>();
        this.Q = vars[0].getSolver().getEnvironment().makeIntVector();
        for (int i = 0; i < this.biggestDomainSize * vars.length; ++i) {
            this.Q.add(0);
        }
        this.activeIterator = new AllActiveArcIterator();
        ArrayList layers = new ArrayList();
        int n = vars.length;
        ArrayList arr = new ArrayList(n);
        for (int i = 0; i <= n + 1; ++i) {
            arr.add(new TIntObjectHashMap());
            layers.add(new TreeSet());
        }
        this.nbLayers = n + 2;
        this.layers = new Node[n + 2][];
        this.source = new Node(0, pi.getStartingState());
        this.tink = new Node(n + 1, Integer.MAX_VALUE);
        ((TIntObjectHashMap)arr.get(0)).put(pi.getStartingState(), this.source);
        ((TIntObjectHashMap)arr.get(n + 1)).put(Integer.MAX_VALUE, this.tink);
        for (int i = 0; i < n; ++i) {
            TIntObjectIterator layerIter = ((TIntObjectHashMap)arr.get(i)).iterator();
            while (layerIter.hasNext()) {
                layerIter.advance();
                Node s = (Node)layerIter.value();
                j = vars[i].getInf();
                int sup = vars[i].getSup();
                while (j <= sup) {
                    int fol = pi.delta(s.state, j);
                    if (fol >= 0) {
                        Node t = (Node)((TIntObjectHashMap)arr.get(i + 1)).get(fol);
                        if (t == null) {
                            t = new Node(i + 1, fol);
                            ((TIntObjectHashMap)arr.get(i + 1)).put(fol, t);
                        }
                        this.incQ(i, j);
                    }
                    j = vars[i].getNextDomainValue(j);
                }
            }
        }
        TIntHashSet toRem = new TIntHashSet();
        for (Object orem : ((TIntObjectHashMap)arr.get(n)).getValues()) {
            Node rem = (Node)orem;
            if (pi.isAccepting(rem.state)) continue;
            toRem.add(rem.state);
        }
        TIntIterator it = toRem.iterator();
        while (it.hasNext()) {
            ((TIntObjectHashMap)arr.get(n)).remove(it.next());
        }
        ((TreeSet)layers.get(n + 1)).add(this.tink);
        ((TreeSet)layers.get(0)).add(this.source);
        BitSet mark = new BitSet(pi.getNbStates());
        for (int i = n - 1; i >= 0; --i) {
            mark.clear(0, pi.getNbStates());
            TIntObjectIterator layerIter = ((TIntObjectHashMap)arr.get(i)).iterator();
            while (layerIter.hasNext()) {
                layerIter.advance();
                Node s = (Node)layerIter.value();
                j = vars[i].getInf();
                int sup = vars[i].getSup();
                while (j <= sup) {
                    int fol = pi.delta(s.state, j);
                    if (fol >= 0) {
                        Node t = (Node)((TIntObjectHashMap)arr.get(i + 1)).get(fol);
                        if (t != null) {
                            ((TreeSet)layers.get(i + 1)).add(t);
                            mark.set(s.state);
                            Arc arc = new Arc(s, t, j);
                            sortOut.add(arc);
                            sortIn.add(arc);
                        } else {
                            this.decQ(i, j);
                        }
                    }
                    j = vars[i].getNextDomainValue(j);
                }
            }
            TIntObjectIterator it2 = ((TIntObjectHashMap)arr.get(i)).iterator();
            while (it2.hasNext()) {
                it2.advance();
                if (mark.get(it2.key())) continue;
                it2.remove();
            }
        }
        TIntObjectIterator layerIter = ((TIntObjectHashMap)arr.get(n)).iterator();
        while (layerIter.hasNext()) {
            layerIter.advance();
            Node end = (Node)layerIter.value();
            Arc e = new Arc(end, this.tink, 0);
            sortOut.add(e);
            sortIn.add(e);
        }
        this.activeOut = vars[0].getSolver().getEnvironment().makeBitSet(sortOut.size());
        this.activeIn = vars[0].getSolver().getEnvironment().makeBitSet(sortOut.size());
        this.inStack = vars[0].getSolver().getEnvironment().makeBitSet(sortOut.size());
        for (int i = 0; i < sortOut.size(); ++i) {
            this.activeOut.set(i);
            this.activeIn.set(i);
        }
        Collections.sort(sortIn);
        Collections.sort(sortOut, Arc.outComparator);
        this.sortIn = sortIn.toArray(new Arc[sortIn.size()]);
        this.sortOut = sortOut.toArray(new Arc[sortOut.size()]);
        if (this.sortOut.length > 0) {
            int i;
            Node out = this.sortOut[0].orig;
            Node in = this.sortIn[0].dest;
            this.inIterator = new InArcIterator(in);
            this.outIterator = new OutArcIterator(out);
            in.inOffset = 0;
            out.outOffset = 0;
            in.nbInArcs = 1;
            out.nbOutArcs = 1;
            this.sortOut[0].outIndex = 0;
            this.sortIn[0].inIndex = 0;
            for (i = 0; i < sortOut.size() - 1; ++i) {
                this.sortOut[i + 1].outIndex = i + 1;
                out = this.sortOut[i].orig;
                Node next = this.sortOut[i + 1].orig;
                if (out == next) {
                    ++out.nbOutArcs;
                } else {
                    next.outOffset = i + 1;
                    ++next.nbOutArcs;
                }
                this.sortIn[i + 1].inIndex = i + 1;
                in = this.sortIn[i].dest;
                next = this.sortIn[i + 1].dest;
                if (in == next) {
                    ++in.nbInArcs;
                    continue;
                }
                next.inOffset = i + 1;
                ++next.nbInArcs;
            }
            i = 0;
            for (TreeSet treeSet : layers) {
                Node[] tmp = treeSet.toArray(new Node[treeSet.size()]);
                this.layers[i++] = tmp;
            }
        } else {
            this.inIterator = null;
            this.outIterator = null;
        }
        System.out.println("NBEDGES IN LAYERED GRAPH : " + sortOut.size());
        this.initialFilter();
        this.pathFinder = new PathFinder(this);
    }

    protected void initialFilter() throws ContradictionException {
        for (int idx = 0; idx < this.Q.size(); ++idx) {
            int i = idx / this.biggestDomainSize;
            int j = idx % this.biggestDomainSize;
            int tmp = this.Q.get(idx);
            if (tmp != Integer.MIN_VALUE && tmp != 0) continue;
            this.vars[i].removeVal(j, this.mcr.getConstraintIdx(i));
        }
    }

    protected int getQ(int i, int j) {
        int idx = i * this.biggestDomainSize + j;
        return this.Q.get(idx);
    }

    protected void setQ(int i, int j, int val) {
        int idx = i * this.biggestDomainSize + j;
        this.Q.set(idx, val);
    }

    public final IStateBitSet getInStack() {
        return this.inStack;
    }

    public final boolean isInStack(int idx) {
        return this.inStack.get(idx);
    }

    public final void setInStack(int idx) {
        this.inStack.set(idx);
    }

    public final void clearInStack(int idx) {
        this.inStack.clear(idx);
    }

    public final IStateBitSet getActiveOut() {
        return this.activeOut;
    }

    protected void decQ(int i, int j) throws ContradictionException {
        if (i < this.vars.length) {
            int tmp = this.getQ(i, j) - 1;
            this.setQ(i, j, tmp);
            if (tmp <= 0) {
                this.vars[i].removeVal(j, this.mcr.getConstraintIdx(i));
            }
        }
    }

    protected void incQ(int i, int j) {
        this.setQ(i, j, this.getQ(i, j) + 1);
    }

    public final PathFinder getPF() {
        return this.pathFinder;
    }

    public void removeEdge(int outIndex, IStateIntVector hs) throws ContradictionException {
        this.removeEdge(this.sortOut[outIndex], hs);
    }

    protected void removeEdge(Arc e, IStateIntVector hs) throws ContradictionException {
        this.inStack.clear(e.outIndex);
        if (this.activeOut.get(e.outIndex)) {
            Arc rm;
            Iterator<Arc> inIt;
            this.activeIn.clear(e.inIndex);
            this.activeOut.clear(e.outIndex);
            this.decQ(e.orig.layer, e.j);
            Node or = e.orig;
            Node de = e.dest;
            Iterator<Arc> outIt = this.getOutEdgeIterator(or);
            if (!outIt.hasNext()) {
                inIt = this.getInEdgeIterator(or);
                while (inIt.hasNext()) {
                    rm = inIt.next();
                    if (this.inStack.get(rm.outIndex)) continue;
                    this.inStack.set(rm.outIndex);
                    hs.add(rm.outIndex);
                }
            }
            if (!(inIt = this.getInEdgeIterator(de)).hasNext()) {
                outIt = this.getOutEdgeIterator(de);
                while (outIt.hasNext()) {
                    rm = outIt.next();
                    if (this.inStack.get(rm.outIndex)) continue;
                    this.inStack.set(rm.outIndex);
                    hs.add(rm.outIndex);
                }
            }
        } else {
            System.err.println("SHOULD NOT BE HERE ARC IS BEING REMOVED TWICE");
        }
    }

    public Iterator<Arc> getOutEdgeIterator(Node n) {
        this.outIterator.n = n;
        this.outIterator.lastReturned = Integer.MIN_VALUE;
        this.outIterator.currentBit = this.activeOut.nextSetBit(n.outOffset);
        return this.outIterator;
    }

    public Iterator<Arc> getInEdgeIterator(Node n) {
        this.inIterator.n = n;
        this.inIterator.lastReturned = Integer.MIN_VALUE;
        this.inIterator.currentBit = this.activeIn.nextSetBit(n.inOffset);
        return this.inIterator;
    }

    public final Iterator<Arc> getAllActiveEdgeIterator() {
        this.activeIterator.current = -1;
        return this.activeIterator;
    }

    public final Node[] getLayer(int i) {
        return this.layers[i];
    }

    public final int getNbLayers() {
        return this.nbLayers;
    }

    public final Node getSource() {
        return this.source;
    }

    public final Node getTink() {
        return this.tink;
    }

    public void toDotty(int nb) {
        StringBuffer sb = new StringBuffer();
        sb.append("digraph G { \nrankdir=LR; \nnode [width=0.3 height=0.3 shape = circle];\n");
        for (int i = 0; i < this.nbLayers; ++i) {
            Node[] tmp;
            for (Node n : tmp = this.getLayer(i)) {
                Iterator<Arc> it = this.getOutEdgeIterator(n);
                while (it.hasNext()) {
                    Arc e = it.next();
                    sb.append(n.id).append(" -> ").append(e.dest.id).append(" [label = \"{").append(e.j).append("}\"];\n");
                }
            }
        }
        sb.append("1 -> 999 [label = \"").append(this.mcr.getIntVar(this.mcr.getNbVars() - 1).getInf()).append("-").append(this.mcr.getIntVar(this.mcr.getNbVars() - 1).getSup()).append("\"];\n");
        sb.append("}");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("lg_58_" + nb + ".dot")));
            bw.write(sb.toString());
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class AllActiveArcIterator
    implements Iterator<Arc> {
        int current = -1;

        @Override
        public boolean hasNext() {
            return LayeredGraph.this.activeOut.nextSetBit(this.current + 1) >= 0;
        }

        @Override
        public Arc next() {
            this.current = LayeredGraph.this.activeOut.nextSetBit(this.current + 1);
            return LayeredGraph.this.sortOut[this.current];
        }

        @Override
        public void remove() {
            Arc e = LayeredGraph.this.sortOut[this.current];
            LayeredGraph.this.activeOut.clear(e.outIndex);
            LayeredGraph.this.activeIn.clear(e.inIndex);
        }
    }

    public class InArcIterator
    implements Iterator<Arc> {
        public int currentBit;
        public int lastReturned = Integer.MIN_VALUE;
        public Node n;

        public InArcIterator(Node n) {
            this.n = n;
            this.currentBit = LayeredGraph.this.activeIn.nextSetBit(n.inOffset);
        }

        @Override
        public final boolean hasNext() {
            return this.currentBit >= 0 && this.currentBit <= this.n.inOffset + this.n.nbInArcs - 1;
        }

        @Override
        public Arc next() {
            Arc out = LayeredGraph.this.sortIn[this.currentBit];
            this.lastReturned = this.currentBit;
            this.currentBit = LayeredGraph.this.activeIn.nextSetBit(this.currentBit + 1);
            return out;
        }

        @Override
        public void remove() {
            LayeredGraph.this.activeIn.clear(this.lastReturned);
            Arc e = LayeredGraph.this.sortIn[this.lastReturned];
            LayeredGraph.this.activeOut.clear(e.outIndex);
        }
    }

    protected class OutArcIterator
    implements Iterator<Arc> {
        public int currentBit;
        public int lastReturned = Integer.MIN_VALUE;
        public Node n;

        public OutArcIterator(Node n) {
            this.n = n;
            this.currentBit = LayeredGraph.this.activeOut.nextSetBit(n.outOffset);
        }

        @Override
        public final boolean hasNext() {
            return this.currentBit >= 0 && this.currentBit <= this.n.outOffset + this.n.nbOutArcs - 1;
        }

        @Override
        public Arc next() {
            Arc out = LayeredGraph.this.sortOut[this.currentBit];
            this.lastReturned = this.currentBit;
            this.currentBit = LayeredGraph.this.activeOut.nextSetBit(this.currentBit + 1);
            return out;
        }

        @Override
        public void remove() {
            LayeredGraph.this.activeOut.clear(this.lastReturned);
            Arc e = LayeredGraph.this.sortOut[this.lastReturned];
            LayeredGraph.this.activeIn.clear(e.inIndex);
        }
    }
}

