/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.multicostregular.structure;

import choco.cp.solver.constraints.global.multicostregular.structure.Node;
import java.util.Comparator;

public class Arc
implements Comparable<Arc> {
    protected final int j;
    protected int outIndex;
    protected int inIndex;
    public final Node orig;
    public final Node dest;
    public static final OutComparator outComparator = new OutComparator();

    public Arc(Node orig, Node dest, int j) {
        this.orig = orig;
        this.dest = dest;
        this.j = j;
    }

    public final int getLabel() {
        return this.j;
    }

    public final int getOutIndex() {
        return this.outIndex;
    }

    public final void setOutIndex(int outIndex) {
        this.outIndex = outIndex;
    }

    public final int getInIndex() {
        return this.inIndex;
    }

    public final void setInIndex(int inIndex) {
        this.inIndex = inIndex;
    }

    @Override
    public int compareTo(Arc edge) {
        return this.dest.id < edge.dest.id ? -1 : (this.dest.id == edge.dest.id ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (o instanceof Arc) {
            Arc e = (Arc)o;
            return this.j == e.j && this.outIndex == e.outIndex && this.inIndex == e.inIndex && this.orig.layer == e.orig.layer;
        }
        return false;
    }

    public String toString() {
        return "" + this.outIndex + " | " + this.j;
    }

    public static class OutComparator
    implements Comparator<Arc> {
        @Override
        public int compare(Arc edge, Arc edge1) {
            return edge.orig.id < edge1.orig.id ? -1 : (edge.orig.id == edge1.orig.id ? 0 : 1);
        }
    }
}

