/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.multicostregular.algo;

import choco.cp.solver.constraints.global.multicostregular.MultiCostRegular;
import choco.cp.solver.constraints.global.multicostregular.structure.Arc;
import choco.cp.solver.constraints.global.multicostregular.structure.LayeredGraph;
import choco.cp.solver.constraints.global.multicostregular.structure.Node;
import choco.kernel.memory.IStateIntVector;
import java.util.Iterator;

public class PathFinder {
    final LayeredGraph graph;
    final Arc[] sp;
    final Arc[] lp;

    public PathFinder(LayeredGraph graph) {
        this.graph = graph;
        this.sp = new Arc[this.graph.getNbLayers() - 1];
        this.lp = new Arc[this.graph.getNbLayers() - 1];
    }

    public Arc[] getShortestPath() {
        Arc e;
        int i = 0;
        Node current = this.graph.getSource();
        do {
            e = current.getSptt();
            this.sp[i++] = e;
        } while ((current = e.dest).getSptt() != null);
        return this.sp;
    }

    public Arc[] getLongestPath() {
        Arc e;
        int i = 0;
        Node current = this.graph.getSource();
        do {
            e = current.getLptt();
            this.lp[i++] = e;
        } while ((current = e.dest).getLptt() != null);
        return this.lp;
    }

    public final double getShortestPathValue() {
        return this.graph.getTink().getSpfs();
    }

    public final double getLongestPathValue() {
        return this.graph.getTink().getLpfs();
    }

    public void resetNodeShortestPathValues() {
        for (int i = 0; i < this.graph.getNbLayers(); ++i) {
            for (Node node : this.graph.getLayer(i)) {
                node.resetShortestPathValues();
            }
        }
    }

    public void resetNodeLongestPathValues() {
        for (int i = 0; i < this.graph.getNbLayers(); ++i) {
            for (Node node : this.graph.getLayer(i)) {
                node.resetLongestPathValues();
            }
        }
    }

    public void resetNodeShortestandLongestPathValues() {
        for (int i = 0; i < this.graph.getNbLayers(); ++i) {
            for (Node node : this.graph.getLayer(i)) {
                node.resetLongestPathValues();
                node.resetShortestPathValues();
            }
        }
    }

    public void computeShortestPath(IStateIntVector removed, double[][] cost, double ub) {
        double newCost;
        Node next;
        Arc e;
        int i;
        this.graph.getSource().setSpfs(0.0);
        this.graph.getTink().setSpft(0.0);
        for (i = 0; i < cost.length; ++i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> out = this.graph.getOutEdgeIterator(n);
                while (out.hasNext()) {
                    e = out.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.dest;
                    newCost = n.getSpfs() + cost[n.getLayer()][e.getLabel()];
                    if (!(next.getSpfs() > newCost)) continue;
                    next.setSpfs(newCost);
                    next.setSpts(e);
                }
            }
        }
        for (i = cost.length; i > 0; --i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> in = this.graph.getInEdgeIterator(n);
                while (in.hasNext()) {
                    e = in.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.orig;
                    newCost = n.getSpft() + cost[next.getLayer()][e.getLabel()];
                    if (newCost + next.getSpfs() - ub >= MultiCostRegular.D_PREC) {
                        this.graph.getInStack().set(e.getOutIndex());
                        removed.add(e.getOutIndex());
                        continue;
                    }
                    if (!(next.getSpft() > newCost)) continue;
                    next.setSpft(newCost);
                    next.setSptt(e);
                }
            }
        }
    }

    public void computeLongestPath(IStateIntVector removed, double[][] cost, double lb) {
        double newCost;
        Node next;
        Arc e;
        int i;
        this.graph.getSource().setLpfs(0.0);
        this.graph.getTink().setLpft(0.0);
        for (i = 0; i < cost.length; ++i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> out = this.graph.getOutEdgeIterator(n);
                while (out.hasNext()) {
                    e = out.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.dest;
                    newCost = n.getLpfs() + cost[n.getLayer()][e.getLabel()];
                    if (!(next.getLpfs() < newCost)) continue;
                    next.setLpfs(newCost);
                    next.setLpts(e);
                }
            }
        }
        for (i = cost.length; i > 0; --i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> in = this.graph.getInEdgeIterator(n);
                while (in.hasNext()) {
                    e = in.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.orig;
                    newCost = n.getLpft() + cost[next.getLayer()][e.getLabel()];
                    if (newCost + next.getLpfs() - lb <= -MultiCostRegular.D_PREC) {
                        this.graph.getInStack().set(e.getOutIndex());
                        removed.add(e.getOutIndex());
                        continue;
                    }
                    if (!(next.getLpft() < newCost)) continue;
                    next.setLpft(newCost);
                    next.setLptt(e);
                }
            }
        }
    }

    public void computeShortestAndLongestPath(IStateIntVector removed, double[][] cost, double lb, double ub) {
        double newCost;
        Node next;
        Arc e;
        int i;
        this.graph.getSource().setLpfs(0.0);
        this.graph.getTink().setLpft(0.0);
        this.graph.getSource().setSpfs(0.0);
        this.graph.getTink().setSpft(0.0);
        for (i = 0; i < cost.length; ++i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> out = this.graph.getOutEdgeIterator(n);
                while (out.hasNext()) {
                    e = out.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.dest;
                    newCost = n.getSpfs() + cost[n.getLayer()][e.getLabel()];
                    if (next.getSpfs() > newCost) {
                        next.setSpfs(newCost);
                        next.setSpts(e);
                    }
                    newCost = n.getLpfs() + cost[n.getLayer()][e.getLabel()];
                    if (!(next.getLpfs() < newCost)) continue;
                    next.setLpfs(newCost);
                    next.setLpts(e);
                }
            }
        }
        for (i = cost.length; i > 0; --i) {
            for (Node n : this.graph.getLayer(i)) {
                Iterator<Arc> in = this.graph.getInEdgeIterator(n);
                while (in.hasNext()) {
                    e = in.next();
                    if (this.graph.isInStack(e.getOutIndex())) continue;
                    next = e.orig;
                    newCost = n.getLpft() + cost[next.getLayer()][e.getLabel()];
                    double newCost2 = n.getSpft() + cost[next.getLayer()][e.getLabel()];
                    if (newCost + next.getLpfs() - lb <= -MultiCostRegular.D_PREC || newCost2 + next.getSpfs() - ub >= MultiCostRegular.D_PREC) {
                        this.graph.getInStack().set(e.getOutIndex());
                        removed.add(e.getOutIndex());
                        continue;
                    }
                    if (next.getLpft() < newCost) {
                        next.setLpft(newCost);
                        next.setLptt(e);
                    }
                    if (!(next.getSpft() > newCost2)) continue;
                    next.setSpft(newCost2);
                    next.setSptt(e);
                }
            }
        }
    }
}

