/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.multicostregular;

import choco.Choco;
import choco.cp.solver.constraints.global.multicostregular.algo.PathFinder;
import choco.cp.solver.constraints.global.multicostregular.structure.Arc;
import choco.cp.solver.constraints.global.multicostregular.structure.LayeredGraph;
import choco.cp.solver.constraints.global.multicostregular.structure.Node;
import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Iterator;

public class MultiCostRegular
extends AbstractLargeIntSConstraint {
    public static final int PRECISION = 5;
    public static final double D_PREC = Math.pow(10.0, -5.0);
    public static final int MAXBOUNDITER = 10;
    public static final int MAXNONIMPROVEITER = 15;
    public static final double U0 = 10.0;
    public static final double RO = 0.75;
    public final TObjectIntHashMap<IntDomainVar> map;
    public Arc[] lastSp;
    public Arc[] lastLp;
    protected final IntDomainVar[] vs;
    protected final IntDomainVar[] z;
    protected final int[][][] costs;
    protected final Automaton pi;
    protected LayeredGraph graph;
    protected final boolean[] modifiedBound;
    protected final double[][] newCosts;
    protected final double[] uUb;
    protected final double[] uLb;
    protected PathFinder slp;
    protected final int nbR;
    protected int lastVisitedWorld;
    protected final IStateIntVector toRemove;
    protected final TIntHashSet removed = new TIntHashSet();

    public MultiCostRegular(IntDomainVar[] vars, IntDomainVar[] CR, Automaton auto, int[][][] costs) {
        super(UtilAlgo.append(vars, CR));
        int i;
        this.vs = vars;
        this.costs = costs;
        this.z = CR;
        this.nbR = this.z.length - 1;
        this.pi = auto;
        this.modifiedBound = new boolean[]{true, true};
        this.newCosts = new double[costs.length + 1][];
        for (i = 0; i < costs.length; ++i) {
            this.newCosts[i] = new double[costs[i].length];
        }
        this.newCosts[costs.length] = new double[1];
        this.uUb = new double[2 * this.nbR];
        this.uLb = new double[2 * this.nbR];
        this.map = new TObjectIntHashMap();
        for (i = 0; i < vars.length; ++i) {
            this.map.put(vars[i], i);
        }
        this.toRemove = this.getSolver().getEnvironment().makeIntVector();
    }

    protected void updateUpperBound() throws ContradictionException {
        Arc[] P;
        boolean modif;
        int k = 0;
        double bk = 0.75;
        int nbNSig = 0;
        int nbNSig2 = 0;
        double bestVal = Double.POSITIVE_INFINITY;
        int nbIter = 0;
        do {
            ++nbIter;
            double coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uUb[i] * (double)this.z[i + 1].getSup();
                coeff -= this.uUb[i + this.nbR] * (double)this.z[i + 1].getInf();
            }
            modif = false;
            this.updateCosts(this.uUb, true);
            boolean tmp = true;
            while (tmp) {
                this.slp.resetNodeLongestPathValues();
                this.slp.computeLongestPath(this.toRemove, this.newCosts, (double)this.z[0].getInf() - coeff);
                tmp = false;
                tmp = this.toRemove.size() > 0;
                this.delayedGraphUpdate();
            }
            double lp = this.slp.getLongestPathValue();
            P = this.slp.getLongestPath();
            this.filterUp(lp + coeff);
            if (bestVal - (lp + coeff) < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (lp + coeff < bestVal) {
                bestVal = lp + coeff;
            }
            double uk = 10.0 * Math.pow(bk, k);
            for (int l = 0; l < this.uUb.length / 2; ++l) {
                double axu = 0.0;
                for (Arc e : P) {
                    int i = e.orig.getLayer();
                    int j = e.getLabel();
                    if (i >= this.vs.length) continue;
                    axu += (double)this.costs[i][j][l + 1];
                }
                double newLB = Math.max(this.uUb[l] - uk * ((double)this.z[l + 1].getSup() - axu), 0.0);
                double newLA = Math.max(this.uUb[l + this.nbR] - uk * (axu - (double)this.z[l + 1].getInf()), 0.0);
                if (Math.abs(this.uUb[l] - newLB) >= D_PREC) {
                    this.uUb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uUb[l + this.nbR] - newLA) >= D_PREC)) continue;
                this.uUb[l + this.nbR] = newLA;
                modif = true;
            }
            ++k;
        } while (modif && nbNSig2 < 15 && nbIter < 10);
        this.lastLp = P;
    }

    protected void updateLowerBound() throws ContradictionException {
        Arc[] P;
        boolean modif;
        int k = 0;
        double bk = 0.75;
        double bestVal = Double.NEGATIVE_INFINITY;
        int nbNSig = 0;
        int nbNSig2 = 0;
        int nbIter = 0;
        do {
            double coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uLb[i] * (double)this.z[i + 1].getSup();
                coeff -= this.uLb[i + this.nbR] * (double)this.z[i + 1].getInf();
            }
            modif = false;
            this.updateCosts(this.uLb, false);
            boolean tmp = true;
            while (tmp) {
                this.slp.resetNodeShortestPathValues();
                this.slp.computeShortestPath(this.toRemove, this.newCosts, (double)this.z[0].getSup() + coeff);
                tmp = false;
                tmp = this.toRemove.size() > 0;
                this.delayedGraphUpdate();
            }
            double sp = this.slp.getShortestPathValue();
            P = this.slp.getShortestPath();
            this.filterDown(sp - coeff);
            if (sp - coeff - bestVal < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (sp - coeff > bestVal) {
                bestVal = sp - coeff;
            }
            double uk = 10.0 * Math.pow(bk, k);
            for (int l = 0; l < this.uLb.length / 2; ++l) {
                double axu = 0.0;
                for (Arc e : P) {
                    int i = e.orig.getLayer();
                    int j = e.getLabel();
                    if (i >= this.vs.length) continue;
                    axu += (double)this.costs[i][j][l + 1];
                }
                double newLB = Math.max(this.uLb[l] + uk * (axu - (double)this.z[l + 1].getSup()), 0.0);
                double newLA = Math.max(this.uLb[l + this.nbR] + uk * ((double)this.z[l + 1].getInf() - axu), 0.0);
                if (Math.abs(this.uLb[l] - newLB) >= D_PREC) {
                    this.uLb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uLb[l + this.nbR] - newLA) >= D_PREC)) continue;
                this.uLb[l + this.nbR] = newLA;
                modif = true;
            }
            ++k;
        } while (modif && nbNSig2 < 15 && nbIter < 10);
        this.lastSp = P;
    }

    protected void prefilter() throws ContradictionException {
        double[] u = new double[this.nbR + this.nbR];
        PathFinder p = this.graph.getPF();
        boolean b = true;
        block0: while (b) {
            b = false;
            for (int i = 0; i < this.nbR + 1; ++i) {
                int bsup = this.z[i].getSup();
                int binf = this.z[i].getInf();
                this.updateCosts(u, i, false);
                p.resetNodeShortestandLongestPathValues();
                p.computeShortestAndLongestPath(this.toRemove, this.newCosts, binf, bsup);
                boolean bl = this.toRemove.size() > 0;
                this.z[i].updateInf((int)Math.ceil(p.getShortestPathValue()), this.getConstraintIdx(this.vs.length));
                this.z[i].updateSup((int)Math.floor(p.getLongestPathValue()), this.getConstraintIdx(this.vs.length));
                if (!(b |= bl)) continue;
                this.delayedGraphUpdate();
                continue block0;
            }
        }
        this.delayedGraphUpdate();
    }

    protected void filterDown(double realsp) throws ContradictionException {
        if (realsp - (double)this.z[0].getSup() >= D_PREC) {
            this.fail();
        }
        if (realsp - (double)this.z[0].getInf() >= D_PREC) {
            double mr = Math.round(realsp);
            double rsp = realsp - mr <= D_PREC ? mr : realsp;
            this.z[0].updateInf((int)Math.ceil(rsp), this.getConstraintIdx(this.vars.length - 1));
            this.modifiedBound[0] = true;
        }
    }

    protected void filterUp(double reallp) throws ContradictionException {
        if (reallp - (double)this.z[0].getInf() <= -D_PREC) {
            this.fail();
        }
        if (reallp - (double)this.z[0].getSup() <= -D_PREC) {
            double mr = Math.round(reallp);
            double rsp = reallp - mr <= D_PREC ? mr : reallp;
            this.z[0].updateSup((int)Math.floor(rsp), this.getConstraintIdx(this.vars.length - 1));
            this.modifiedBound[1] = true;
        }
    }

    protected void updateCosts(double[] u, boolean max) {
        this.updateCosts(u, 0, max);
    }

    protected void updateCosts(double[] u, int resource, boolean max) {
        for (int i = 0; i < this.costs.length; ++i) {
            for (int j = 0; j < this.costs[i].length; ++j) {
                double tmp = 0.0;
                for (int k = 1; k < this.costs[i][j].length; ++k) {
                    tmp += (u[k - 1] - u[k - 1 + this.nbR]) * (double)this.costs[i][j][k];
                }
                if (max) {
                    tmp = -tmp;
                }
                this.newCosts[i][j] = (double)this.costs[i][j][resource] + tmp;
            }
        }
    }

    @Override
    public boolean isSatisfied() {
        for (IntDomainVar var : this.vars) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return this.check();
    }

    public boolean check() {
        int[] word = new int[this.vs.length];
        for (int i = 0; i < this.vs.length; ++i) {
            if (!this.vs[i].isInstantiated()) {
                return true;
            }
            word[i] = this.vs[i].getVal();
        }
        for (IntDomainVar aZ : this.z) {
            if (aZ.isInstantiated()) continue;
            return true;
        }
        if (!this.pi.run(word)) {
            System.err.println("Word is not accepted by the automaton");
            System.err.print("{" + word[0]);
            for (int i = 1; i < word.length; ++i) {
                System.err.print("," + word[i]);
            }
            System.err.println("}");
            return false;
        }
        for (int k = 0; k < this.costs[0][0].length; ++k) {
            int cost = 0;
            for (int i = 0; i < this.vs.length; ++i) {
                cost += this.costs[i][word[i]][k];
            }
            if (k == 0) {
                if (cost == this.z[0].getVal()) continue;
                System.err.println("cost: " + cost + " != z:" + this.z[0].getVal());
                return false;
            }
            if (cost == this.z[k].getVal()) continue;
            System.err.println("cost: " + cost + " != z[" + k + "] :" + this.z[k].getVal());
            return false;
        }
        return true;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.vs.length ? 12 : 11;
    }

    protected void delayedGraphUpdate() throws ContradictionException {
        while (this.toRemove.size() > 0) {
            int n = this.toRemove.get(this.toRemove.size() - 1);
            this.toRemove.removeLast();
            this.graph.removeEdge(n, this.toRemove);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltadomain) throws ContradictionException {
        Node[] sn;
        this.removed.clear();
        while (deltadomain.hasNext()) {
            this.removed.add(deltadomain.next());
        }
        for (Node n : sn = this.graph.getLayer(idx)) {
            Iterator<Arc> it = this.graph.getOutEdgeIterator(n);
            while (it.hasNext()) {
                Arc e = it.next();
                if (!this.removed.contains(e.getLabel()) || this.graph.isInStack(e.getOutIndex())) continue;
                this.graph.setInStack(e.getOutIndex());
                this.toRemove.add(e.getOutIndex());
            }
        }
        if (!this.toRemove.isEmpty()) {
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        Node[] sn;
        for (Node n : sn = this.graph.getLayer(idx)) {
            Iterator<Arc> it = this.graph.getOutEdgeIterator(n);
            while (it.hasNext()) {
                Arc e = it.next();
                if (e.getLabel() != val || this.graph.isInStack(e.getOutIndex())) continue;
                this.graph.setInStack(e.getOutIndex());
                this.toRemove.add(e.getOutIndex());
            }
        }
        if (!this.toRemove.isEmpty()) {
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = this.vars[idx].getVal();
        if (idx >= this.vs.length) {
            this.constAwake(false);
        } else if (idx < this.vs.length) {
            Node[] sn;
            for (Node n : sn = this.graph.getLayer(idx)) {
                Iterator<Arc> it = this.graph.getOutEdgeIterator(n);
                while (it.hasNext()) {
                    Arc e = it.next();
                    if (e.getLabel() == val || this.graph.isInStack(e.getOutIndex())) continue;
                    this.graph.setInStack(e.getOutIndex());
                    this.toRemove.add(e.getOutIndex());
                }
            }
            if (!this.toRemove.isEmpty()) {
                this.constAwake(false);
            }
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        this.awakeOnInf(idx);
        this.awakeOnSup(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx >= this.vs.length) {
            this.constAwake(false);
        } else if (idx < this.vs.length) {
            int inf = this.vars[idx].getInf();
            Node[] sn = this.graph.getLayer(idx);
            for (int i = 0; i < sn.length; ++i) {
                Node n = sn[i];
                Iterator<Arc> it = this.graph.getOutEdgeIterator(n);
                while (it.hasNext()) {
                    Arc e = it.next();
                    if (e.getLabel() >= inf || this.graph.isInStack(e.getOutIndex())) continue;
                    this.graph.setInStack(e.getOutIndex());
                    this.toRemove.add(e.getOutIndex());
                }
            }
            if (!this.toRemove.isEmpty()) {
                this.constAwake(false);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= this.vs.length) {
            this.constAwake(false);
        } else {
            int sup = this.vars[idx].getSup();
            if (idx < this.vs.length) {
                Node[] sn;
                for (Node n : sn = this.graph.getLayer(idx)) {
                    Iterator<Arc> it = this.graph.getOutEdgeIterator(n);
                    while (it.hasNext()) {
                        Arc e = it.next();
                        if (e.getLabel() <= sup || this.graph.isInStack(e.getOutIndex())) continue;
                        this.graph.setInStack(e.getOutIndex());
                        this.toRemove.add(e.getOutIndex());
                    }
                }
            }
            if (!this.toRemove.isEmpty()) {
                this.constAwake(false);
            }
        }
    }

    public void computeSharpBounds() throws ContradictionException {
        while (this.modifiedBound[0] || this.modifiedBound[1]) {
            if (this.modifiedBound[1]) {
                this.modifiedBound[1] = false;
                this.updateLowerBound();
            }
            if (this.modifiedBound[0]) {
                this.modifiedBound[0] = false;
                this.updateUpperBound();
            }
            this.delayedGraphUpdate();
            this.prefilter();
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.graph = new LayeredGraph(this.vs, this.pi, this);
        this.slp = this.graph.getPF();
        if (Choco.DEBUG) {
            System.out.println("NB OF EDGES IN GRAPH : " + this.graph.getActiveOut().cardinality());
            int nbNode = 0;
            for (int i = 0; i < this.graph.getNbLayers(); ++i) {
                nbNode += this.graph.getLayer(i).length;
            }
            System.out.println("NB Of NODES IN GRAPH : " + nbNode);
        }
        this.prefilter();
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.delayedGraphUpdate();
        this.modifiedBound[0] = true;
        this.modifiedBound[1] = true;
        this.computeSharpBounds();
        if (this.toRemove.size() > 0) {
            System.out.println("PB");
        }
        if (Choco.DEBUG && !this.check()) {
            System.out.flush();
            System.err.println("ACCEPTED INSTANTIATION DOES NOT COMPLY WITH CHECKER");
            System.exit(1);
            this.fail();
        }
    }
}

