/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.matching;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.matching.AbstractBipartiteMatching;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Logger;

public class AllDifferent
extends AbstractBipartiteMatching
implements IntSConstraint {
    private Logger logger = Logger.getLogger("choco.kernel.solver.propagation.const");

    public AllDifferent(IntDomainVar[] vars) {
        super(vars, vars.length, AllDifferent.getValueGap(vars));
        this.minValue = Integer.MAX_VALUE;
        this.maxValue = Integer.MIN_VALUE;
        for (int i = 0; i < vars.length; ++i) {
            IntDomainVar var = vars[i];
            this.minValue = Math.min(var.getInf(), this.minValue);
            this.maxValue = Math.max(var.getSup(), this.maxValue);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public AllDifferent(IntDomainVar[] vars, int minValue, int maxValue) {
        super(vars, vars.length, maxValue - minValue + 1);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static int getValueGap(IntDomainVar[] vars) {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (int i = 0; i < vars.length; ++i) {
            IntDomainVar var = vars[i];
            minValue = Math.min(var.getInf(), minValue);
            maxValue = Math.max(var.getSup(), maxValue);
        }
        return maxValue - minValue + 1;
    }

    public void setEdgeAndPublish(int i, int j) throws ContradictionException {
        this.setMatch(i, j);
        for (int i2 = 0; i2 < this.nbLeftVertices; ++i2) {
            if (i2 == i) continue;
            this.vars[i2].removeVal(j + this.minValue, this.cIndices[i2]);
        }
    }

    @Override
    public void deleteEdgeAndPublish(int i, int j) throws ContradictionException {
        this.deleteMatch(i, j);
        this.vars[i].removeVal(j + this.minValue, this.cIndices[i]);
    }

    @Override
    public void awakeOnRem(int idx, int val) {
        this.deleteMatch(idx, val - this.minValue);
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) {
        for (int j = this.minValue; j < this.vars[idx].getInf(); ++j) {
            this.deleteMatch(idx, j - this.minValue);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) {
        for (int j = this.vars[idx].getSup() + 1; j <= this.maxValue; ++j) {
            this.deleteMatch(idx, j - this.minValue);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.setEdgeAndPublish(idx, this.vars[idx].getVal() - this.minValue);
        this.constAwake(false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.vars.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (tuple[i] != tuple[j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AllDifferent({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public int getFineDegree(int idx) {
        return this.vars.length - 1;
    }
}

