/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.util;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.kernel.model.variables.geost.ShiftedBox;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class VRMLwriter {
    public static final String VRML_OUTPUT_FOLDER = "";

    public static boolean printVRML3D(Setup s, Constants c, String name) {
        return VRMLwriter.printVRML3D(s, c, VRML_OUTPUT_FOLDER, name);
    }

    public static boolean printVRML3D(Setup s, Constants c, String outPut, String name) {
        String str = VRML_OUTPUT_FOLDER + outPut + name + ".wrl";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(str));
            System.out.println("writing the VRML to : " + str);
            Iterator<Integer> itr = s.objects.keySet().iterator();
            int ObjectIterationNb = 0;
            int kdim = 0;
            kdim = c.getDIM() == 2 ? 2 : (c.getDIM() == 3 ? 3 : 0);
            out.write("#VRML V2.0 utf8\n");
            if (kdim > 1 && kdim < 4) {
                while (itr.hasNext()) {
                    ++ObjectIterationNb;
                    int id = itr.next();
                    Obj o = s.getObject(id);
                    String temp = VRML_OUTPUT_FOLDER;
                    for (int i = 0; i < c.getDIM(); ++i) {
                        temp = temp + o.getCoord(i).getInf() + " ";
                    }
                    if (kdim == 2) {
                        temp = temp + " 0.0 ";
                    }
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ \n");
                    Vector<ShiftedBox> sb = s.shapes.get(o.getShapeId().getInf());
                    Random rnd = new Random();
                    float fDiff1 = rnd.nextFloat();
                    float fDiff2 = rnd.nextFloat();
                    float fDiff3 = rnd.nextFloat();
                    float fSpec1 = rnd.nextFloat();
                    float fSpec2 = rnd.nextFloat();
                    float fSpec3 = rnd.nextFloat();
                    float shine = rnd.nextFloat();
                    String appearance = "appearance  Appearance {material  Material {  ambientIntensity  0.25  diffuseColor  " + fDiff1 + " " + fDiff2 + " " + fDiff3 + " " + " specularColor  " + fSpec1 + " " + fSpec2 + " " + fSpec3 + " " + " emissiveColor  0 0 0 " + " shininess  " + shine + " " + " transparency  0.40 }} ";
                    double sizeOnZOfFirstShiftedBoxOfObject = 0.0;
                    for (int i = 0; i < sb.size(); ++i) {
                        int j;
                        temp = VRML_OUTPUT_FOLDER;
                        for (j = 0; j < c.getDIM(); ++j) {
                            float k = (float)sb.elementAt(i).getOffset(j) + (float)sb.elementAt(i).getSize(j) / 2.0f;
                            temp = temp + VRML_OUTPUT_FOLDER + k + " ";
                        }
                        sizeOnZOfFirstShiftedBoxOfObject = sb.elementAt(0).getSize(c.getDIM() - 1);
                        if (kdim == 2) {
                            temp = temp + " 0.0 ";
                        }
                        out.write("Transform { translation " + temp + '\n');
                        out.write("children [ ");
                        temp = VRML_OUTPUT_FOLDER;
                        for (j = 0; j < c.getDIM(); ++j) {
                            int k = sb.elementAt(i).getSize(j);
                            temp = temp + VRML_OUTPUT_FOLDER + k + " ";
                        }
                        if (kdim == 2) {
                            temp = temp + " 0.0 ";
                        }
                        out.write("Shape { " + appearance);
                        out.write(" geometry Box { size " + temp + "}}]}" + '\n');
                    }
                    out.write(" Transform { translation .0 .0 " + sizeOnZOfFirstShiftedBoxOfObject + " \n");
                    out.write("children [ ");
                    out.write("   Shape {appearance Appearance { material Material { diffuseColor .0 .0 .0  transparency  0}} geometry Text { string [ \" " + o.getObjectId() + "\" ");
                    out.write("]  fontStyle FontStyle { style \"BOLD\" size 2.0 }}}\n");
                    out.write(" ]} \n");
                    out.write(" ]} \n");
                }
                String temp = VRML_OUTPUT_FOLDER;
                if (kdim == 3) {
                    temp = " 25.0 0.1 0.1 ";
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  1.0 0.0 0.0 }} ");
                    out.write(" geometry Box { size 50.0 0.2 0.2 }}]}\n");
                    temp = " 0.1 25.0 0.1 ";
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 1.0 0.0 }} ");
                    out.write(" geometry Box { size 0.2 50.0 0.2 }}]}\n");
                    temp = " 0.1 0.1 25.0 ";
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 0.0 1.0 }} ");
                    out.write(" geometry Box { size 0.2 0.2 50.0 }}]}\n");
                } else if (kdim == 2) {
                    temp = " 25.0 0.1 0.0 ";
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  1.0 0.0 0.0 }} ");
                    out.write(" geometry Box { size 50.0 0.2 0.0 }}]}\n");
                    temp = " 0.1 25.0 0.0 ";
                    out.write("Transform { translation " + temp + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 1.0 0.0 }} ");
                    out.write(" geometry Box { size 0.2 50.0 0.0 }}]}\n");
                }
                out.close();
            } else {
                System.err.println("Dimension is not 2 nor 3 therefore no VRML file was written.");
            }
        }
        catch (IOException e) {
            System.out.println("ERROR; Couldn't write VRML file");
        }
        return true;
    }

    public static boolean printVRML3D(Setup s, Constants c, String prefix, int solNb) {
        String str = VRML_OUTPUT_FOLDER + prefix + "_" + solNb;
        return VRMLwriter.printVRML3D(s, c, str);
    }

    public static boolean printVRML3D(Setup s, Constants c, String output, String prefix, int solNb) {
        String str = VRML_OUTPUT_FOLDER + prefix + "_" + solNb;
        return VRMLwriter.printVRML3D(s, c, output, str);
    }
}

