/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.util;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.kernel.model.Model;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Random;
import java.util.Vector;

public class RandomProblemGenerator {
    private Vector<GeostObject> objects = new Vector();
    private Vector<ShiftedBox> sBoxes = new Vector();
    private Model m = new CPModel();
    private int nbOfObjects;
    private int nbOfShapes;
    private int nbOfShiftedBoxes;
    private int maxLength;
    private int dim;

    public RandomProblemGenerator(int k, int nbOfObjects, int nbOfShapes, int nbOfShiftedBoxes, int maxLength) {
        this.nbOfObjects = nbOfObjects;
        this.nbOfShapes = nbOfShapes;
        this.nbOfShiftedBoxes = nbOfShiftedBoxes;
        this.maxLength = maxLength;
        this.dim = k;
    }

    public void generateProb() {
        this.generateRandomProblem(this.nbOfObjects, this.nbOfShapes, this.nbOfShiftedBoxes, this.maxLength);
    }

    private void generateRandomProblem(int nbOfObjects, int nbOfShapes, int nbOfShiftedBoxes, int maxLength) {
        int j;
        int i;
        if (nbOfShapes > nbOfShiftedBoxes) {
            System.out.println("The number of shifted boxes should be greater or equal to the number of shapes");
            return;
        }
        Random rnd = new Random();
        int[] maxDomain = new int[this.dim];
        Vector<Integer> shapeIDS = new Vector<Integer>();
        for (i = 0; i < nbOfShapes; ++i) {
            shapeIDS.add(i, i);
        }
        for (i = 0; i < nbOfObjects; ++i) {
            int index = rnd.nextInt(shapeIDS.size());
            int sid = (Integer)shapeIDS.elementAt(index);
            shapeIDS.removeElementAt(index);
            IntegerVariable shapeId = Choco.makeIntVar("sid", sid, sid, new String[0]);
            Variable[] coords = new IntegerVariable[this.dim];
            for (int j2 = 0; j2 < this.dim; ++j2) {
                int max = rnd.nextInt(maxLength);
                while (max == 0) {
                    max = rnd.nextInt(maxLength);
                }
                int min = rnd.nextInt(max);
                coords[j2] = Choco.makeIntVar("x" + j2, min, max, new String[0]);
            }
            this.m.addVariables("cp:bound", coords);
            IntegerVariable start = Choco.makeIntVar("start", 1, 1, new String[0]);
            IntegerVariable duration = Choco.makeIntVar("duration", 1, 1, new String[0]);
            IntegerVariable end = Choco.makeIntVar("end", 1, 1, new String[0]);
            this.objects.add(new GeostObject(this.dim, i, shapeId, (IntegerVariable[])coords, start, duration, end));
        }
        for (i = 0; i < this.dim; ++i) {
            int max = 0;
            for (int j3 = 0; j3 < this.objects.size(); ++j3) {
                if (max >= this.objects.elementAt(j3).getCoordinates()[i].getUppB()) continue;
                max = this.objects.elementAt(j3).getCoordinates()[i].getUppB();
            }
            maxDomain[i] = max;
        }
        for (j = 0; j < nbOfShapes; ++j) {
            int[] t = new int[this.dim];
            int[] s = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                t[k] = 0;
                s[k] = rnd.nextInt(maxLength);
                while (s[k] == 0) {
                    s[k] = rnd.nextInt(maxLength);
                }
            }
            this.sBoxes.add(new ShiftedBox(j, t, s));
        }
        for (j = 0; j < nbOfShapes; ++j) {
            shapeIDS.add(j, j);
        }
        for (int remainingSBtoCreate = nbOfShiftedBoxes - nbOfShapes; remainingSBtoCreate > 0; --remainingSBtoCreate) {
            int index = rnd.nextInt(shapeIDS.size());
            int sid = (Integer)shapeIDS.elementAt(index);
            for (int i2 = 0; i2 < this.sBoxes.size(); ++i2) {
                if (this.sBoxes.elementAt(i2).getShapeId() != sid) continue;
                index = i2;
                break;
            }
            int[] t = new int[this.dim];
            int[] s = new int[this.dim];
            for (int k = 0; k < this.dim; ++k) {
                t[k] = rnd.nextInt(this.sBoxes.elementAt(index).getSize(k));
                s[k] = rnd.nextInt(maxLength);
                while (s[k] == 0) {
                    s[k] = rnd.nextInt(maxLength);
                }
            }
            this.sBoxes.add(new ShiftedBox(this.sBoxes.elementAt(index).getShapeId(), t, s));
        }
    }

    public Vector<GeostObject> getObjects() {
        return this.objects;
    }

    public Vector<ShiftedBox> getSBoxes() {
        return this.sBoxes;
    }

    public Model getModel() {
        return this.m;
    }
}

