/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.AvoidHoles;
import choco.cp.solver.constraints.global.geost.internalConstraints.Inbox;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import java.util.Vector;

public class IntermediateLayer {
    public Vector LexInFeasible(InternalConstraint ictr, boolean minLex, int d, int k, Obj o) {
        Vector result = new Vector();
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.LexInFeasibleForInbox((Inbox)ictr, minLex, d, k, o);
                break;
            }
            case 2: {
                result = this.LexInFeasibleForOutbox((Outbox)ictr, minLex, d, k, o);
                break;
            }
            case 3: {
                result = this.LexInFeasibleForAvoidHoles((AvoidHoles)ictr, minLex, d, k, o);
                break;
            }
            default: {
                System.err.println("A call to LexFeasible with incorrect ictrID parameter");
            }
        }
        return result;
    }

    public Vector IsFeasible(InternalConstraint ictr, boolean min, int d, int k, Obj o, Point c) {
        Vector result = new Vector();
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.IsFeasibleForInbox((Inbox)ictr, min, d, k, o, c);
                break;
            }
            case 2: {
                result = this.IsFeasibleForOutbox((Outbox)ictr, min, d, k, o, c);
                break;
            }
            case 3: {
                result = this.IsFeasibleForAvoidHoles((AvoidHoles)ictr, min, d, k, o, c);
                break;
            }
            default: {
                System.err.println("A call to IsFeasible with incorrect ictrID parameter");
            }
        }
        return result;
    }

    public int CardInfeasible(InternalConstraint ictr, int k, Obj o) {
        int result = 0;
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.CardInfeasibleForInbox((Inbox)ictr, k, o);
                break;
            }
            case 2: {
                result = this.CardInfeasibleForOutbox((Outbox)ictr, k, o);
                break;
            }
            case 3: {
                result = this.CardInfeasibleForAvoidHoles((AvoidHoles)ictr, k, o);
                break;
            }
            default: {
                System.err.println("A call to CardInfeasible with incorrect ictr parameter");
            }
        }
        return result;
    }

    private Vector LexInFeasibleForInbox(Inbox ictr, boolean minLex, int d, int k, Obj o) {
        int j;
        Vector<Object> result = new Vector<Object>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        boolean in = true;
        Point p = new Point(k);
        for (j = 0; j < k; ++j) {
            if (minLex) {
                p.setCoord(j, o.getCoord(j).getInf());
            } else {
                p.setCoord(j, o.getCoord(j).getSup());
            }
            if (p.getCoord(j) >= t[j] && p.getCoord(j) <= t[j] + l[j] - 1) continue;
            in = false;
        }
        if (in) {
            for (j = k - 1; j >= 0; --j) {
                int jPrime = (j + d) % k;
                if (!minLex) continue;
                if (t[jPrime] + l[jPrime] <= o.getCoord(jPrime).getSup()) {
                    p.setCoord(jPrime, t[jPrime] + l[jPrime]);
                    result.clear();
                    result.add(0, true);
                    result.add(1, p);
                    return result;
                }
                if (t[jPrime] - 1 < o.getCoord(jPrime).getInf()) continue;
                p.setCoord(jPrime, t[jPrime] - 1);
                result.clear();
                result.add(0, new Boolean(true));
                result.add(1, p);
                return result;
            }
            result.clear();
            result.add(0, new Boolean(false));
            result.add(1, p);
            return result;
        }
        result.clear();
        result.add(0, new Boolean(true));
        result.add(1, p);
        return result;
    }

    private Vector LexInFeasibleForOutbox(Outbox ictr, boolean minLex, int d, int k, Obj o) {
        Vector<Object> result = new Vector<Object>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        Point p = new Point(k);
        for (int j = 0; j < k; ++j) {
            if (o.getCoord(j).getSup() < t[j] || o.getCoord(j).getInf() > t[j] + l[j] - 1) {
                result.clear();
                result.add(0, false);
                result.add(1, p);
                return result;
            }
            if (minLex) {
                p.setCoord(j, Math.max(t[j], o.getCoord(j).getInf()));
                continue;
            }
            p.setCoord(j, Math.max(t[j] + l[j] - 1, o.getCoord(j).getSup()));
        }
        result.clear();
        result.add(0, new Boolean(true));
        result.add(1, p);
        return result;
    }

    private Vector LexInFeasibleForAvoidHoles(AvoidHoles ictr, boolean minLex, int d, int k, Obj o) {
        Vector result = new Vector();
        return result;
    }

    private Vector IsFeasibleForInbox(Inbox ictr, boolean min, int d, int k, Obj o, Point c) {
        Vector<Object> result = new Vector<Object>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        boolean before = false;
        boolean after = false;
        boolean feasible = false;
        Region f = new Region(k, o.getObjectId());
        for (int j = 0; j < k; ++j) {
            int jPrime = (j + d) % k;
            if (min) {
                f.setMinimumBoundary(jPrime, c.getCoord(jPrime));
                if (c.getCoord(jPrime) < t[jPrime] && !before) {
                    f.setMaximumBoundary(jPrime, t[jPrime] - 1);
                    before = true;
                    continue;
                }
                f.setMaximumBoundary(jPrime, o.getCoord(jPrime).getSup());
                if (c.getCoord(jPrime) <= t[jPrime] + l[jPrime] - 1) continue;
                after = true;
                continue;
            }
            f.setMaximumBoundary(jPrime, c.getCoord(jPrime));
            if (c.getCoord(jPrime) >= t[jPrime]) continue;
            before = true;
        }
        feasible = !before && !after;
        result.clear();
        result.add(0, feasible);
        result.add(1, f);
        return result;
    }

    private Vector IsFeasibleForOutbox(Outbox ictr, boolean min, int d, int k, Obj o, Point c) {
        Vector<Object> result = new Vector<Object>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        Region f = new Region(k, o.getObjectId());
        for (int j = 0; j < k; ++j) {
            if (c.getCoord(j) < t[j] || c.getCoord(j) > t[j] + l[j] - 1) {
                result.clear();
                result.add(0, true);
                result.add(1, f);
                return result;
            }
            if (min) {
                f.setMinimumBoundary(j, c.getCoord(j));
                f.setMaximumBoundary(j, Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1));
                continue;
            }
            f.setMaximumBoundary(j, c.getCoord(j));
            f.setMinimumBoundary(j, Math.max(o.getCoord(j).getInf(), t[j]));
        }
        result.clear();
        result.add(0, new Boolean(false));
        result.add(1, f);
        return result;
    }

    private Vector IsFeasibleForAvoidHoles(AvoidHoles ictr, boolean min, int d, int k, Obj o, Point c) {
        Vector result = new Vector();
        return result;
    }

    private int CardInfeasibleForInbox(Inbox ictr, int k, Obj o) {
        int n = 1;
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        for (int j = 0; j < k; ++j) {
            n *= o.getCoord(j).getSup() - o.getCoord(j).getInf() + 1;
        }
        int m = 1;
        for (int j = 0; j < k; ++j) {
            m *= Math.max(0, Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1) - Math.max(o.getCoord(j).getInf(), t[j]) + 1);
        }
        return n - m;
    }

    private int CardInfeasibleForOutbox(Outbox ictr, int k, Obj o) {
        int n = 1;
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        for (int j = 0; j < k; ++j) {
            n *= Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1) - Math.max(o.getCoord(j).getInf(), t[j]) + 1;
        }
        return n;
    }

    private int CardInfeasibleForAvoidHoles(AvoidHoles ictr, int k, Obj o) {
        int result = 0;
        return result;
    }
}

