/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.layers.ExternalLayer;
import choco.cp.solver.constraints.global.geost.layers.IntermediateLayer;
import choco.kernel.solver.ContradictionException;
import java.util.Vector;

public class GeometricKernel {
    Constants cst;
    Setup stp;
    ExternalLayer externalLayer;
    IntermediateLayer intermediateLayer;

    public GeometricKernel(Constants c, Setup s, ExternalLayer extrL, IntermediateLayer intermL) {
        this.cst = c;
        this.stp = s;
        this.externalLayer = extrL;
        this.intermediateLayer = intermL;
    }

    public Vector GetFR(int d, int k, Obj o, Point c, Vector<InternalConstraint> ACTRS, boolean increase) {
        Vector<Object> result = new Vector<Object>();
        Vector v = new Vector();
        if (increase) {
            for (int i = 0; i < ACTRS.size(); ++i) {
                v = this.intermediateLayer.IsFeasible(ACTRS.elementAt(i), true, d, k, o, c);
                if (((Boolean)v.elementAt(0)).booleanValue()) continue;
                result.clear();
                result.add(0, true);
                result.add(1, v.elementAt(1));
                return result;
            }
            result.clear();
            result.add(0, new Boolean(false));
            result.add(1, new Region(this.cst.getDIM(), -1));
            return result;
        }
        for (int i = 0; i < ACTRS.size(); ++i) {
            v = this.intermediateLayer.IsFeasible(ACTRS.elementAt(i), false, d, k, o, c);
            if (((Boolean)v.elementAt(0)).booleanValue()) continue;
            result.clear();
            result.add(0, new Boolean(true));
            result.add(1, v.elementAt(1));
            return result;
        }
        result.clear();
        result.add(0, new Boolean(false));
        result.add(1, new Region(this.cst.getDIM(), -1));
        return result;
    }

    public boolean FilterCtrs(int k, int[] oIDs, Vector<ExternalConstraint> ectrs) throws ContradictionException {
        boolean nonFix = true;
        while (nonFix) {
            int i;
            nonFix = false;
            for (i = 0; i < ectrs.size(); ++i) {
                ectrs.elementAt(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.elementAt(i), oIDs));
            }
            for (i = 0; i < oIDs.length; ++i) {
                Obj o = this.stp.getObject(oIDs[i]);
                int domainsSize = o.calculateDomainSize();
                if (!this.FilterObjWP(k, oIDs[i])) {
                    return false;
                }
                if (domainsSize == o.calculateDomainSize()) continue;
                for (int j = 0; j < o.getRelatedExternalConstraints().size(); ++j) {
                    o.getRelatedExternalConstraints().elementAt(j).getFrame().getRelForbidRegions().remove(o.getObjectId());
                    int[] oIDi = new int[]{oIDs[i]};
                    o.getRelatedExternalConstraints().elementAt(j).getFrame().getRelForbidRegions().put(o.getObjectId(), this.externalLayer.InitFrameExternalConstraint(o.getRelatedExternalConstraints().elementAt(j), oIDi).getRelForbidRegions(oIDs[i]));
                }
                nonFix = true;
            }
        }
        return true;
    }

    public boolean FilterObjWP(int k, int oid) throws ContradictionException {
        int d;
        Obj o = this.stp.getObject(oid);
        if (o.getShapeId().isInstantiated()) {
            return this.FilterObj(k, oid);
        }
        int[] minG = new int[k];
        int[] maxG = new int[k];
        for (d = 0; d < k; ++d) {
            minG[d] = o.getCoord(d).getSup() + 1;
            maxG[d] = o.getCoord(d).getInf() - 1;
        }
        int sid = o.getShapeId().getInf();
        while (sid <= o.getShapeId().getSup()) {
            int d2;
            int[] max = new int[k];
            int[] min = new int[k];
            boolean b = false;
            o.getCoord(0).getSolver().worldPushDuringPropagation();
            o.getShapeId().instantiate(sid, -1);
            b = this.FilterObj(k, oid);
            if (b) {
                for (d2 = 0; d2 < k; ++d2) {
                    max[d2] = o.getCoord(d2).getSup();
                    min[d2] = o.getCoord(d2).getInf();
                }
            }
            o.getCoord(0).getSolver().worldPopDuringPropagation();
            if (!b) {
                o.getShapeId().removeVal(sid, -1);
            } else {
                for (d2 = 0; d2 < k; ++d2) {
                    minG[d2] = Math.min(min[d2], minG[d2]);
                    maxG[d2] = Math.max(max[d2], maxG[d2]);
                }
            }
            sid = o.getShapeId().getNextDomainValue(sid);
        }
        for (d = 0; d < k; ++d) {
            o.getCoord(d).updateInf(minG[d], -1);
            o.getCoord(d).updateSup(maxG[d], -1);
        }
        return true;
    }

    public boolean FilterObj(int k, int oid) throws ContradictionException {
        Obj o = this.stp.getObject(oid);
        o.getRelatedInternalConstraints().clear();
        for (int i = 0; i < o.getRelatedExternalConstraints().size(); ++i) {
            Vector<InternalConstraint> v = this.externalLayer.GenInternalCtrs(o.getRelatedExternalConstraints().elementAt(i), o);
            for (int j = 0; j < v.size(); ++j) {
                o.addRelatedInternalConstraint(v.elementAt(j));
            }
        }
        for (int d = 0; d < k; ++d) {
            if (o.getRelatedInternalConstraints().size() <= 0 || this.PruneMin(o, d, k, o.getRelatedInternalConstraints()) && this.PruneMax(o, d, k, o.getRelatedInternalConstraints())) continue;
            return false;
        }
        return true;
    }

    public boolean PruneMin(Obj o, int d, int k, Vector<InternalConstraint> ictrs) throws ContradictionException {
        boolean b = true;
        Point c = new Point(k);
        Point n = new Point(k);
        Vector<InternalConstraint> ACTRS = new Vector();
        ACTRS = ictrs;
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getInf());
            n.setCoord(i, o.getCoord(i).getSup() + 1);
        }
        Vector forbidRegion = this.GetFR(d, k, o, c, ACTRS, true);
        boolean infeasible = (Boolean)forbidRegion.elementAt(0);
        Region f = (Region)forbidRegion.elementAt(1);
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.min(n.getCoord(i), f.getMaximumBoundary(i) + 1));
            }
            Vector adjUp = this.AdjustUp(c, n, o, d, k);
            c = (Point)adjUp.elementAt(0);
            n = (Point)adjUp.elementAt(1);
            b = (Boolean)adjUp.elementAt(2);
            forbidRegion = this.GetFR(d, k, o, c, ACTRS, true);
            infeasible = (Boolean)forbidRegion.elementAt(0);
            f = (Region)forbidRegion.elementAt(1);
        }
        if (b) {
            o.getCoord(d).updateInf(c.getCoord(d), -1);
            ++this.cst.nbOfUpdates;
        }
        return b;
    }

    public Vector AdjustUp(Point c, Point n, Obj o, int d, int k) {
        Vector<Object> result = new Vector<Object>();
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getSup() + 1);
            if (c.getCoord(jPrime) <= o.getCoord(jPrime).getSup()) {
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, true);
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getInf());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, new Boolean(false));
        return result;
    }

    public boolean PruneMax(Obj o, int d, int k, Vector<InternalConstraint> ictrs) throws ContradictionException {
        boolean b = true;
        Point c = new Point(k);
        Point n = new Point(k);
        Vector<InternalConstraint> ACTRS = new Vector();
        ACTRS = ictrs;
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getSup());
            n.setCoord(i, o.getCoord(i).getInf() - 1);
        }
        Vector forbidRegion = this.GetFR(d, k, o, c, ACTRS, false);
        boolean infeasible = (Boolean)forbidRegion.elementAt(0);
        Region f = (Region)forbidRegion.elementAt(1);
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.max(n.getCoord(i), f.getMinimumBoundary(i) - 1));
            }
            Vector adjDown = this.AdjustDown(c, n, o, d, k);
            c = (Point)adjDown.elementAt(0);
            n = (Point)adjDown.elementAt(1);
            b = (Boolean)adjDown.elementAt(2);
            forbidRegion = this.GetFR(d, k, o, c, ACTRS, false);
            infeasible = (Boolean)forbidRegion.elementAt(0);
            f = (Region)forbidRegion.elementAt(1);
        }
        if (b) {
            o.getCoord(d).updateSup(c.getCoord(d), -1);
            ++this.cst.nbOfUpdates;
        }
        return b;
    }

    public Vector AdjustDown(Point c, Point n, Obj o, int d, int k) {
        Vector<Object> result = new Vector<Object>();
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getInf() - 1);
            if (c.getCoord(jPrime) >= o.getCoord(jPrime).getInf()) {
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, true);
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getSup());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, new Boolean(false));
        return result;
    }

    public boolean FixAllObjs(int k, int[] oIDs, Vector<ExternalConstraint> ectrs, Vector<int[]> ctrlVs) throws ContradictionException {
        for (int i = 0; i < ectrs.size(); ++i) {
            ectrs.elementAt(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.elementAt(i), oIDs));
        }
        int nbOfCtrlV = ctrlVs.size();
        for (int i = 0; i < oIDs.length; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            int m = i % nbOfCtrlV;
            if (!this.FixObj(k, oIDs[i], ctrlVs.elementAt(m))) {
                return false;
            }
            for (int j = 0; j < o.getRelatedExternalConstraints().size(); ++j) {
                int[] oIDi = new int[]{oIDs[i]};
                o.getRelatedExternalConstraints().elementAt(j).getFrame().getRelForbidRegions().remove(o.getObjectId());
                o.getRelatedExternalConstraints().elementAt(j).getFrame().getRelForbidRegions().put(o.getObjectId(), this.externalLayer.InitFrameExternalConstraint(o.getRelatedExternalConstraints().elementAt(j), oIDi).getRelForbidRegions(oIDs[i]));
            }
        }
        return true;
    }

    public boolean FixObj(int k, int oid, int[] ctrlV) throws ContradictionException {
        Obj o = this.stp.getObject(oid);
        if (ctrlV[0] < 0) {
            o.getShapeId().instantiate(o.getShapeId().getInf(), -1);
        } else {
            o.getShapeId().instantiate(o.getShapeId().getSup(), -1);
        }
        o.getRelatedInternalConstraints().clear();
        for (int i = 0; i < o.getRelatedExternalConstraints().size(); ++i) {
            Vector<InternalConstraint> v = this.externalLayer.GenInternalCtrs(o.getRelatedExternalConstraints().elementAt(i), o);
            for (int j = 0; j < v.size(); ++j) {
                o.addRelatedInternalConstraint(v.elementAt(j));
            }
        }
        return this.PruneFix(o, k, ctrlV, o.getRelatedInternalConstraints());
    }

    public boolean PruneFix(Obj o, int k, int[] ctrlV, Vector<InternalConstraint> ictrs) throws ContradictionException {
        int d;
        Point c = new Point(k);
        Point n = new Point(k);
        int dPrime = 0;
        for (int d2 = k - 1; d2 > -1; --d2) {
            dPrime = Math.abs(ctrlV[d2 + 1]) - 2;
            if (ctrlV[d2 + 1] < 0) {
                c.setCoord(dPrime, o.getCoord(dPrime).getInf());
                n.setCoord(dPrime, o.getCoord(dPrime).getSup() + 1);
                continue;
            }
            c.setCoord(dPrime, o.getCoord(dPrime).getSup());
            n.setCoord(dPrime, o.getCoord(dPrime).getInf() - 1);
        }
        Vector forbidRegion = this.GetFR(Math.abs(ctrlV[1]) - 2, k, o, c, ictrs, false);
        boolean infeasible = (Boolean)forbidRegion.elementAt(0);
        Region f = (Region)forbidRegion.elementAt(1);
        while (infeasible) {
            block11: {
                for (d = k - 1; d > -1; --d) {
                    dPrime = Math.abs(ctrlV[d + 1]) - 2;
                    if (ctrlV[d + 1] < 0) {
                        n.setCoord(dPrime, Math.min(n.getCoord(dPrime), f.getMaximumBoundary(dPrime) + 1));
                        continue;
                    }
                    n.setCoord(dPrime, Math.max(n.getCoord(dPrime), f.getMinimumBoundary(dPrime) - 1));
                }
                for (d = k - 1; d > -1; --d) {
                    dPrime = Math.abs(ctrlV[d + 1]) - 2;
                    c.setCoord(dPrime, n.getCoord(dPrime));
                    if (ctrlV[d + 1] < 0) {
                        n.setCoord(dPrime, o.getCoord(dPrime).getSup() + 1);
                        if (c.getCoord(dPrime) >= n.getCoord(dPrime)) {
                            c.setCoord(dPrime, o.getCoord(dPrime).getInf());
                            continue;
                        }
                    } else {
                        n.setCoord(dPrime, o.getCoord(dPrime).getInf() - 1);
                        if (c.getCoord(dPrime) <= n.getCoord(dPrime)) {
                            c.setCoord(dPrime, o.getCoord(dPrime).getSup());
                            continue;
                        }
                    }
                    break block11;
                }
                return false;
            }
            forbidRegion = this.GetFR(Math.abs(ctrlV[1]) - 2, k, o, c, ictrs, true);
            infeasible = (Boolean)forbidRegion.elementAt(0);
            f = (Region)forbidRegion.elementAt(1);
        }
        for (d = 0; d < k; ++d) {
            o.getCoord(d).instantiate(c.getCoord(d), -1);
        }
        return true;
    }
}

