/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.Compatible;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.externalConstraints.Included;
import choco.cp.solver.constraints.global.geost.externalConstraints.NonOverlapping;
import choco.cp.solver.constraints.global.geost.externalConstraints.Visible;
import choco.cp.solver.constraints.global.geost.frames.Frame;
import choco.cp.solver.constraints.global.geost.frames.NonOverlappingFrame;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import choco.kernel.model.variables.geost.ShiftedBox;
import java.util.Vector;

public class ExternalLayer {
    Constants cst;
    Setup stp;

    public ExternalLayer(Constants c, Setup s) {
        this.cst = c;
        this.stp = s;
    }

    public Frame InitFrameExternalConstraint(ExternalConstraint ectr, int[] oIDs) {
        Frame result;
        switch (ectr.getEctrID()) {
            case 1: {
                result = this.InitFrameExternalConstraintForCompatible((Compatible)ectr, oIDs);
                break;
            }
            case 2: {
                result = this.InitFrameExternalConstraintForIncluded((Included)ectr, oIDs);
                break;
            }
            case 3: {
                result = this.InitFrameExternalConstraintForNonOverlapping((NonOverlapping)ectr, oIDs);
                break;
            }
            case 4: {
                result = this.InitFrameExternalConstraintForVisible((Visible)ectr, oIDs);
                break;
            }
            default: {
                System.err.println("A call to InitFrameExternalConstraint with incorrect ectr parameter");
                result = null;
            }
        }
        return result;
    }

    public Vector<InternalConstraint> GenInternalCtrs(ExternalConstraint ectr, Obj o) {
        Vector<InternalConstraint> result;
        switch (ectr.getEctrID()) {
            case 1: {
                result = this.GenInternalCtrsForCompatible((Compatible)ectr, o);
                break;
            }
            case 2: {
                result = this.GenInternalCtrsForIncluded((Included)ectr, o);
                break;
            }
            case 3: {
                result = this.GenInternalCtrsForNonOverlapping((NonOverlapping)ectr, o);
                break;
            }
            case 4: {
                result = this.GenInternalCtrsForVisible((Visible)ectr, o);
                break;
            }
            default: {
                System.err.println("A call to InitFrameExternalConstraint with incorrect ectr parameter");
                result = null;
            }
        }
        return result;
    }

    private Frame InitFrameExternalConstraintForCompatible(Compatible ectr, int[] oIDs) {
        NonOverlappingFrame f = new NonOverlappingFrame();
        return f;
    }

    private Frame InitFrameExternalConstraintForIncluded(Included ectr, int[] oIDs) {
        NonOverlappingFrame f = new NonOverlappingFrame();
        return f;
    }

    private Frame InitFrameExternalConstraintForNonOverlapping(NonOverlapping ectr, int[] oIDs) {
        NonOverlappingFrame f = new NonOverlappingFrame();
        for (int i = 0; i < oIDs.length; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            int m = o.getShapeId().getDomainSize();
            Vector<Region> regions = new Vector<Region>();
            int[][] set = new int[m][];
            int ivalue = 0;
            int sid = o.getShapeId().getInf();
            while (sid <= o.getShapeId().getSup()) {
                int nbOfSbox = this.stp.getShape(sid).size();
                set[ivalue] = new int[nbOfSbox];
                for (int j = 0; j < nbOfSbox; ++j) {
                    set[ivalue][j] = j;
                }
                ++ivalue;
                sid = o.getShapeId().getNextDomainValue(sid);
            }
            int[] pointer = new int[m];
            boolean print = true;
            block3: do {
                int j;
                Region r = new Region(this.cst.getDIM(), o.getObjectId());
                for (j = 0; j < this.cst.getDIM(); ++j) {
                    int max = this.stp.getShape(o.getShapeId().getInf()).elementAt(set[0][pointer[0]]).getOffset(j);
                    int min = this.stp.getShape(o.getShapeId().getInf()).elementAt(set[0][pointer[0]]).getOffset(j) + this.stp.getShape(o.getShapeId().getInf()).elementAt(set[0][pointer[0]]).getSize(j);
                    int curDomVal = o.getShapeId().getNextDomainValue(o.getShapeId().getInf());
                    for (int s = 1; s < m; ++s) {
                        max = Math.max(max, this.stp.getShape(curDomVal).elementAt(set[s][pointer[s]]).getOffset(j));
                        min = Math.min(min, this.stp.getShape(curDomVal).elementAt(set[s][pointer[s]]).getOffset(j) + this.stp.getShape(curDomVal).elementAt(set[s][pointer[s]]).getSize(j));
                        curDomVal = o.getShapeId().getNextDomainValue(curDomVal);
                    }
                    r.setMinimumBoundary(j, o.getCoord(j).getSup() + max + 1);
                    r.setMaximumBoundary(j, o.getCoord(j).getInf() + min - 1);
                }
                regions.add(r);
                for (j = m - 1; j >= 0; --j) {
                    if (pointer[j] == set[j].length - 1) {
                        if (j == 0) {
                            print = false;
                        }
                    } else {
                        int n = j;
                        pointer[n] = pointer[n] + 1;
                        continue block3;
                    }
                    pointer[j] = 0;
                }
            } while (print);
            f.addForbidRegions(o.getObjectId(), regions);
        }
        return f;
    }

    private Frame InitFrameExternalConstraintForVisible(Visible ectr, int[] oIDs) {
        NonOverlappingFrame f = new NonOverlappingFrame();
        return f;
    }

    private Vector<InternalConstraint> GenInternalCtrsForCompatible(Compatible ectr, Obj o) {
        Vector<InternalConstraint> ictrs = new Vector<InternalConstraint>();
        return ictrs;
    }

    private Vector<InternalConstraint> GenInternalCtrsForIncluded(Included ectr, Obj o) {
        Vector<InternalConstraint> ictrs = new Vector<InternalConstraint>();
        return ictrs;
    }

    private Vector<InternalConstraint> GenInternalCtrsForNonOverlapping(NonOverlapping ectr, Obj o) {
        Vector<InternalConstraint> ictrs = new Vector<InternalConstraint>();
        Vector<ShiftedBox> sb = this.stp.getShape(o.getShapeId().getInf());
        for (int i : ectr.getFrame().getRelForbidRegions().keySet()) {
            if (o.getObjectId() == i) continue;
            for (int k = 0; k < sb.size(); ++k) {
                block2: for (int l = 0; l < ectr.getFrame().getRelForbidRegions(i).size(); ++l) {
                    int[] t = new int[this.cst.getDIM()];
                    int[] s = new int[this.cst.getDIM()];
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        int min = ectr.getFrame().getRelForbidRegions(i).elementAt(l).getMinimumBoundary(j) - sb.elementAt(k).getOffset(j) - sb.elementAt(k).getSize(j);
                        int max = ectr.getFrame().getRelForbidRegions(i).elementAt(l).getMaximumBoundary(j) - sb.elementAt(k).getOffset(j);
                        s[j] = max - min + 1;
                        if (s[j] <= 0) continue block2;
                        t[j] = min;
                        if (o.getCoord(j).getSup() < t[j] || o.getCoord(j).getInf() > t[j] + s[j] - 1) continue block2;
                    }
                    ictrs.add(new Outbox(t, s));
                }
            }
        }
        return ictrs;
    }

    private Vector<InternalConstraint> GenInternalCtrsForVisible(Visible ectr, Obj o) {
        Vector<InternalConstraint> ictrs = new Vector<InternalConstraint>();
        return ictrs;
    }
}

