/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.geometricPrim;

public class Point {
    private int[] coords;
    private int dim;

    public Point(int dim) {
        this.dim = dim;
        this.coords = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.coords[i] = 0;
        }
    }

    public Point(int[] coordinates) {
        this.coords = new int[coordinates.length];
        this.setCoords(coordinates);
    }

    public Point(Point p) {
        this.coords = new int[this.dim];
        for (int i = 0; i < p.getCoords().length; ++i) {
            this.coords[i] = p.getCoord(i);
        }
    }

    public int[] getCoords() {
        return this.coords;
    }

    public void setCoords(int[] coordinates) {
        System.arraycopy(coordinates, 0, this.coords, 0, coordinates.length);
    }

    public int getCoord(int index) {
        return this.coords[index];
    }

    public void setCoord(int index, int value) {
        this.coords[index] = value;
    }

    public boolean lexGreaterThanOrEqual(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) >= other.getCoord(jPrime);
        }
        return true;
    }

    public boolean lexGreaterThan(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) >= other.getCoord(jPrime);
        }
        return false;
    }

    public boolean lexLessThanOrEqual(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) <= other.getCoord(jPrime);
        }
        return true;
    }

    public boolean lexLessThan(Point other, int d) {
        int jPrime = 0;
        for (int j = 0; j < this.dim; ++j) {
            jPrime = (j + d) % this.dim;
            if (this.getCoord(jPrime) == other.getCoord(jPrime)) continue;
            return this.getCoord(jPrime) <= other.getCoord(jPrime);
        }
        return false;
    }
}

