/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.geometricPrim;

import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Vector;

public class Obj {
    private int oid;
    private IntDomainVar sid;
    private IntDomainVar[] coords;
    private IntDomainVar start;
    private IntDomainVar duration;
    private IntDomainVar end;
    private Vector<ExternalConstraint> relatedExternalConstraints;
    private Vector<InternalConstraint> relatedInternalConstraints;
    private int dim;

    public Obj(int dim, int objectId, IntDomainVar shapeId, IntDomainVar[] coordinates, IntDomainVar startTime, IntDomainVar durationTime, IntDomainVar endTime) {
        this.dim = dim;
        this.oid = objectId;
        this.sid = shapeId;
        this.coords = coordinates;
        this.start = startTime;
        this.duration = durationTime;
        this.end = endTime;
        this.relatedExternalConstraints = new Vector();
        this.relatedInternalConstraints = new Vector();
    }

    public Obj(int dim) {
        this.dim = dim;
        this.coords = new IntDomainVar[this.dim];
        this.relatedExternalConstraints = new Vector();
        this.relatedInternalConstraints = new Vector();
    }

    public int getObjectId() {
        return this.oid;
    }

    public void setObjectId(int objectId) {
        this.oid = objectId;
    }

    public IntDomainVar getShapeId() {
        return this.sid;
    }

    public void setShapeId(IntDomainVar shapeId) {
        this.sid = shapeId;
    }

    public IntDomainVar[] getCoordinates() {
        return this.coords;
    }

    public void setCoordinates(IntDomainVar[] coordinates) {
        this.coords = coordinates;
    }

    public void setCoord(int index, IntDomainVar value) {
        this.coords[index] = value;
    }

    public IntDomainVar getCoord(int index) {
        return this.coords[index];
    }

    public IntDomainVar getDuration() {
        return this.duration;
    }

    public void setDuration(IntDomainVar duration) {
        this.duration = duration;
    }

    public IntDomainVar getEnd() {
        return this.end;
    }

    public void setEnd(IntDomainVar end) {
        this.end = end;
    }

    public IntDomainVar getStart() {
        return this.start;
    }

    public void setStart(IntDomainVar start) {
        this.start = start;
    }

    public Vector<ExternalConstraint> getRelatedExternalConstraints() {
        return this.relatedExternalConstraints;
    }

    public Vector<InternalConstraint> getRelatedInternalConstraints() {
        return this.relatedInternalConstraints;
    }

    public void setRelatedExternalConstraints(Vector<ExternalConstraint> relatedExtConstraints) {
        this.relatedExternalConstraints = relatedExtConstraints;
    }

    public void setRelatedInternalConstraints(Vector<InternalConstraint> relatedIntConstraints) {
        this.relatedInternalConstraints = relatedIntConstraints;
    }

    public void addRelatedExternalConstraint(ExternalConstraint ectr) {
        this.relatedExternalConstraints.add(ectr);
    }

    public void addRelatedInternalConstraint(InternalConstraint ictr) {
        this.relatedInternalConstraints.add(ictr);
    }

    public int calculateDomainSize() {
        int result = 0;
        for (int i = 0; i < this.coords.length; ++i) {
            result = result + (this.getCoord(i).getSup() - this.getCoord(i).getInf()) + 1;
        }
        return result += this.sid.getDomainSize();
    }
}

