/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.dataStructures;

import choco.cp.solver.constraints.global.geost.dataStructures.HeapImpl;
import choco.cp.solver.constraints.global.geost.dataStructures.Heapable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class HeapAscending
extends Vector
implements HeapImpl {
    private static final long serialVersionUID = -6129722552080498898L;

    public HeapAscending(Heapable[] anArray) {
        super(anArray.length);
        int i;
        this.setSize(anArray.length);
        for (i = 0; i < anArray.length; ++i) {
            this.setElementAt(anArray[i], i);
        }
        for (i = (int)Math.floor(this.size() / 2) - 1; i >= 0; --i) {
            this.heapify(i);
        }
    }

    public HeapAscending() {
        super(0);
    }

    protected int left(int i) {
        return (i + 1 << 1) - 1;
    }

    protected int right(int i) {
        return i + 1 << 1;
    }

    protected int parent(int i) {
        return (i + 1 >> 1) - 1;
    }

    protected synchronized void exchange(int i, int j) {
        Object temp = this.elementAt(j);
        this.setElementAt(this.elementAt(i), j);
        this.setElementAt(temp, i);
    }

    protected synchronized void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int smallest = l < this.size() && ((Heapable)this.elementAt(l)).lessThan(this.elementAt(i)) ? l : i;
        if (r < this.size() && ((Heapable)this.elementAt(r)).lessThan(this.elementAt(smallest))) {
            smallest = r;
        }
        if (smallest != i) {
            this.exchange(i, smallest);
            this.heapify(smallest);
        }
    }

    public synchronized Heapable extractMin() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        Object min = this.elementAt(0);
        this.setElementAt(this.lastElement(), 0);
        this.removeElementAt(this.size() - 1);
        this.heapify(0);
        return (Heapable)min;
    }

    public synchronized Heapable getMin() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        Object min = this.elementAt(0);
        return (Heapable)min;
    }

    @Override
    public Heapable remove() throws NoSuchElementException {
        return this.extractMin();
    }

    @Override
    public synchronized void insert(Heapable key) {
        int i = this.size();
        this.setSize(this.size() + 1);
        while (i > 0 && ((Heapable)this.elementAt(this.parent(i))).greaterThan(key)) {
            this.setElementAt(this.elementAt(this.parent(i)), i);
            i = this.parent(i);
        }
        this.setElementAt(key, i);
    }
}

