/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.dataStructures.HeapAscending;
import choco.cp.solver.constraints.global.geost.dataStructures.HeapDescending;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.kernel.model.variables.geost.ShiftedBox;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Setup {
    Constants cst;
    public Hashtable<Integer, Vector<ShiftedBox>> shapes = new Hashtable();
    public Hashtable<Integer, Obj> objects = new Hashtable();
    public Vector<ExternalConstraint> constraints = new Vector();
    public HeapAscending ictrMinHeap = new HeapAscending();
    public HeapDescending ictrMaxHeap = new HeapDescending();

    public Setup(Constants c) {
        this.cst = c;
    }

    public void insertShape(int sid, Vector<ShiftedBox> shiftedBoxes) {
        this.shapes.put(sid, shiftedBoxes);
    }

    public void insertObject(int oid, Obj o) {
        this.objects.put(oid, o);
    }

    public Vector<ShiftedBox> getShape(int sid) {
        return this.shapes.get(sid);
    }

    public Obj getObject(int oid) {
        return this.objects.get(oid);
    }

    public int getNbOfObjects() {
        return this.objects.size();
    }

    public int getNbOfShapes() {
        return this.shapes.size();
    }

    public int getNbOfDomainVariables() {
        int originOfObjects = this.getNbOfObjects() * this.cst.getDIM();
        int otherVariables = this.getNbOfObjects() * 4;
        return originOfObjects + otherVariables;
    }

    public void SetupTheProblem(Vector<Obj> objects, Vector<ShiftedBox> shiftedBoxes, Vector<ExternalConstraint> ectr) {
        int i;
        for (i = 0; i < objects.size(); ++i) {
            this.addObject(objects.elementAt(i));
        }
        for (i = 0; i < shiftedBoxes.size(); ++i) {
            this.addShiftedBox(shiftedBoxes.elementAt(i));
        }
        for (i = 0; i < ectr.size(); ++i) {
            this.addConstraint(ectr.elementAt(i));
            for (int j = 0; j < ectr.elementAt(i).getObjectIds().length; ++j) {
                this.getObject(ectr.elementAt(i).getObjectIds()[j]).addRelatedExternalConstraint(ectr.elementAt(i));
            }
        }
    }

    public void addConstraint(ExternalConstraint ectr) {
        this.constraints.add(ectr);
    }

    public Vector<ExternalConstraint> getConstraints() {
        return this.constraints;
    }

    public HeapAscending getIctrMinHeap() {
        return this.ictrMinHeap;
    }

    public HeapDescending getIctrMaxHeap() {
        return this.ictrMaxHeap;
    }

    public void addShiftedBox(ShiftedBox sb) {
        if (this.shapes.containsKey(sb.getShapeId())) {
            this.shapes.get(sb.getShapeId()).add(sb);
        } else {
            Vector<ShiftedBox> v = new Vector<ShiftedBox>();
            v.add(sb);
            this.shapes.put(sb.getShapeId(), v);
        }
    }

    public void addObject(Obj o) {
        if (this.objects.containsKey(o.getObjectId())) {
            System.out.println("Trying to add an already existing object. In addObject in Setup");
        } else {
            this.objects.put(o.getObjectId(), o);
        }
    }

    public Enumeration<Integer> getObjectKeys() {
        return this.objects.keys();
    }

    public Enumeration<Integer> getShapeKeys() {
        return this.shapes.keys();
    }

    public Set<Integer> getObjectKeySet() {
        return this.objects.keySet();
    }

    public Set<Integer> getShapeKeySet() {
        return this.shapes.keySet();
    }

    public void print() {
        int i;
        for (int id : this.objects.keySet()) {
            Obj o = this.objects.get(id);
            System.out.println("object id: " + id);
            System.out.println("    shape id: " + o.getShapeId().getInf());
            for (i = 0; i < this.cst.getDIM(); ++i) {
                System.out.println("    Coords x" + i + " : " + o.getCoord(i).getInf() + "    " + o.getCoord(i).getSup());
            }
        }
        for (int sid : this.shapes.keySet()) {
            Vector<ShiftedBox> sb = this.shapes.get(sid);
            System.out.println("shape id: " + sid);
            for (i = 0; i < sb.size(); ++i) {
                String offset = "";
                String size = "";
                for (int j = 0; j < this.cst.getDIM(); ++j) {
                    offset = offset + sb.elementAt(i).getOffset(j) + "  ";
                    size = size + sb.elementAt(i).getSize(j) + "  ";
                }
                System.out.println("    sb" + i + ": ");
                System.out.println("       Offset: " + offset);
                System.out.println("       Size: " + size);
            }
        }
    }

    public boolean printToFileHumanFormat(String path) {
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            for (int id : this.objects.keySet()) {
                Obj o = this.objects.get(id);
                out.write("object id: " + id + '\n');
                out.write("    shape id: " + o.getShapeId().getInf() + '\n');
                for (i = 0; i < this.cst.getDIM(); ++i) {
                    out.write("    Coords x" + i + " : " + o.getCoord(i).getInf() + "    " + o.getCoord(i).getSup() + '\n');
                }
            }
            for (int sid : this.shapes.keySet()) {
                Vector<ShiftedBox> sb = this.shapes.get(sid);
                out.write("shape id: " + sid + '\n');
                for (i = 0; i < sb.size(); ++i) {
                    String offset = "";
                    String size = "";
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        offset = offset + sb.elementAt(i).getOffset(j) + "  ";
                        size = size + sb.elementAt(i).getSize(j) + "  ";
                    }
                    out.write("    sb" + i + ": " + '\n');
                    out.write("       Offset: " + offset + '\n');
                    out.write("       Size: " + size + '\n');
                }
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean printToFileInputFormat(String path) {
        try {
            int sid;
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            Iterator<Integer> itr = this.objects.keySet().iterator();
            out.write("Objects\n");
            while (itr.hasNext()) {
                int id = itr.next();
                Obj o = this.objects.get(id);
                out.write(id + " ");
                out.write(o.getShapeId().getInf() + " " + o.getShapeId().getSup() + " ");
                for (i = 0; i < this.cst.getDIM(); ++i) {
                    out.write(o.getCoord(i).getInf() + " " + o.getCoord(i).getSup() + " ");
                }
                out.write("1 1 1 1 1 1\n");
            }
            itr = this.shapes.keySet().iterator();
            out.write("Shapes\n");
            while (itr.hasNext()) {
                sid = itr.next();
                out.write(sid + "" + '\n');
            }
            itr = this.shapes.keySet().iterator();
            out.write("ShiftedBoxes\n");
            while (itr.hasNext()) {
                sid = itr.next();
                Vector<ShiftedBox> sb = this.shapes.get(sid);
                for (i = 0; i < sb.size(); ++i) {
                    String offset = "";
                    String size = "";
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        offset = offset + sb.elementAt(i).getOffset(j) + " ";
                        size = size + sb.elementAt(i).getSize(j) + " ";
                    }
                    out.write(sid + " ");
                    out.write(offset + size + '\n');
                }
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void clear() {
        this.shapes.clear();
        this.objects.clear();
        this.constraints.clear();
        this.ictrMinHeap.clear();
        this.ictrMaxHeap.clear();
    }
}

