/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.costregular;

import choco.cp.model.managers.IntConstraintManager;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;

public class RegularI
extends AbstractLargeIntSConstraint {
    public static final boolean INCREMENTAL = true;
    public Automaton automaton;
    private int nbNodes;
    private int[] start;
    private int[] offset;
    private int[] size;
    private DLList[] Q;
    private DLList[] outarc;
    private DLList[] inarc;
    private DLList[][] outSave;
    private int lastPropagatedWorld;

    public RegularI(IntDomainVar[] vars, Automaton auto) {
        super(vars);
        this.automaton = auto;
        this.nbNodes = this.automaton.size();
        this.start = new int[vars.length];
        this.size = new int[vars.length];
        this.offset = new int[vars.length];
        this.start[0] = 0;
        int totalSize = 0;
        for (int i = 0; i < vars.length; ++i) {
            int sz;
            this.offset[i] = vars[i].getInf();
            this.size[i] = sz = vars[i].getSup() - vars[i].getInf() + 1;
            if (i > 0) {
                this.start[i] = this.size[i - 1] + this.start[i - 1];
            }
            totalSize += sz;
        }
        this.Q = new DLList[totalSize];
        this.outarc = new DLList[(this.nbNodes + 1) * vars.length];
        this.inarc = new DLList[(this.nbNodes + 1) * vars.length];
        this.outSave = new DLList[vars[0].getSolver().getNbIntVars() + 2][];
        this.outSave = new DLList[vars[0].getSolver().getNbIntVars() + 2][];
    }

    public RegularI(IntDomainVar[] vars, String regexp) {
        this(vars, new Automaton(regexp));
    }

    private int getCurrentWorld() {
        return this.vars[0].getSolver().getEnvironment().getWorldIndex();
    }

    private DLList getQij(int i, int j) {
        return this.Q[this.start[i] + j - this.offset[i]];
    }

    private void addToQij(int i, int j, int state) {
        int idx = this.start[i] + j - this.offset[i];
        if (this.Q[idx] == null) {
            this.Q[idx] = new DLList(this.nbNodes);
        }
        this.Q[idx].add(state);
    }

    private void addToOutarc(int orig, int dest, int symb, int var) {
        int representation = symb * this.nbNodes + dest;
        int idx = var * this.nbNodes + orig;
        if (this.outarc[idx] == null) {
            this.outarc[idx] = new DLList(this.size[var] * this.nbNodes);
        }
        this.outarc[idx].add(representation);
    }

    private DLList getOutArc(int var, int node) {
        int idx = var * this.nbNodes + node;
        return this.outarc[idx];
    }

    private void remFromOutarc(int orig, int dest, int symb, int var) {
        int representation = symb * this.nbNodes + dest;
        int idx = var * this.nbNodes + orig;
        this.outarc[idx].remove(representation);
        this.save(idx, representation);
    }

    private void addToInarc(int orig, int dest, int symb, int var) {
        int representation = symb * this.nbNodes + orig;
        int idx = var * this.nbNodes + dest;
        if (this.inarc[idx] == null) {
            this.inarc[idx] = new DLList(this.nbNodes * this.size[var - 1]);
        }
        this.inarc[idx].add(representation);
    }

    private DLList getInArc(int var, int node) {
        int idx = var * this.nbNodes + node;
        return this.inarc[idx];
    }

    private void remFromInarc(int orig, int dest, int symb, int var) {
        int representation = symb * this.nbNodes + orig;
        int idx = var * this.nbNodes + dest;
        this.inarc[idx].remove(representation);
    }

    private void save(int idx, int representation) {
        DLList l;
        DLList[] tmp = this.outSave[this.getCurrentWorld()];
        if (tmp == null) {
            this.outSave[this.getCurrentWorld()] = new DLList[(this.nbNodes + 1) * this.vars.length];
        }
        if ((l = this.outSave[this.getCurrentWorld()][idx]) == null) {
            this.outSave[this.getCurrentWorld()][idx] = new DLList(this.nbNodes * this.size[idx / this.nbNodes]);
        }
        this.outSave[this.getCurrentWorld()][idx].add(representation);
    }

    private void restoreGraph(int world) {
        for (int sw = this.lastPropagatedWorld; sw > world; --sw) {
            DLList[] rem = this.outSave[sw];
            for (int idx = 0; idx < rem.length; ++idx) {
                DLList l = rem[idx];
                if (l == null) continue;
                int orig = idx % this.nbNodes;
                int var = idx / this.nbNodes;
                IntIterator lit = l.getIterator();
                while (lit.hasNext()) {
                    int repr = lit.next();
                    int dest = repr % this.nbNodes;
                    int symb = repr / this.nbNodes;
                    this.addToOutarc(orig, dest, symb, var);
                    this.addToInarc(orig, dest, symb, var + 1);
                    this.addToQij(var, symb, orig);
                }
                l.clear();
            }
        }
    }

    private void resetData() {
        for (DLList qij : this.Q) {
            if (qij == null) continue;
            qij.clear();
        }
        for (DLList a : this.outarc) {
            if (a == null) continue;
            a.clear();
        }
        for (DLList a : this.inarc) {
            if (a == null) continue;
            a.clear();
        }
    }

    private void initGraph() {
        int k;
        IntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int n = this.vars.length;
        DLList[] layer = new DLList[this.vars.length + 1];
        for (i = 0; i <= n; ++i) {
            layer[i] = new DLList(this.nbNodes);
        }
        layer[0].add(this.automaton.getStartingState());
        for (i = 0; i < n; ++i) {
            varIter = this.vars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = layer[i].getIterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    int succ = this.automaton.delta(k, j);
                    if (succ < 0) continue;
                    layer[i + 1].add(succ);
                    this.addToQij(i, j, k);
                }
            }
        }
        layerIter = layer[n].getIterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (this.automaton.isAccepting(k)) continue;
            layerIter.remove();
        }
        BitSet mark = new BitSet(this.nbNodes);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, this.nbNodes);
            varIter = this.vars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                DLList l = this.getQij(i, j);
                if (l == null) continue;
                IntIterator qijIter = this.getQij(i, j).getIterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    int qn = this.automaton.delta(k, j);
                    if (layer[i + 1].contains(qn)) {
                        this.addToOutarc(k, qn, j, i);
                        this.addToInarc(k, qn, j, i + 1);
                        mark.set(k);
                        continue;
                    }
                    qijIter.remove();
                }
            }
            layerIter = layer[i].getIterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
    }

    public void initialFilter() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            DisposableIntIterator it = this.vars[i].getDomain().getIterator();
            while (it.hasNext()) {
                int j = it.next();
                DLList l = this.getQij(i, j);
                if (l != null && !l.isEmpty()) continue;
                this.vars[i].removeVal(j, this.cIndices[i]);
            }
        }
    }

    public void decrementOutdeg(int i, int k) throws ContradictionException {
        DLList lst = this.getOutArc(i, k);
        if (lst.size() == 0 && i > 0) {
            DLList inarc = this.getInArc(i, k);
            IntIterator it = inarc.getIterator();
            while (it.hasNext()) {
                int repr = it.next();
                int l = repr % this.nbNodes;
                int j = repr / this.nbNodes;
                this.remFromOutarc(l, k, j, i - 1);
                DLList qij = this.getQij(i - 1, j);
                qij.remove(l);
                if (qij.isEmpty()) {
                    this.vars[i - 1].removeVal(j, this.cIndices[i - 1]);
                }
                this.decrementOutdeg(i - 1, l);
            }
            this.getInArc(i, k).clear();
        }
    }

    public void decrementIndeg(int i, int k) throws ContradictionException {
        DLList outarc;
        DLList lst = this.getInArc(i, k);
        if (lst.size() == 0 && i <= this.vars.length && (outarc = this.getOutArc(i, k)) != null) {
            IntIterator it = outarc.getIterator();
            while (it.hasNext()) {
                int repr = it.next();
                this.save(i * this.nbNodes + k, repr);
                int l = repr % this.nbNodes;
                int j = repr / this.nbNodes;
                this.remFromInarc(k, l, j, i + 1);
                DLList qij = this.getQij(i, j);
                qij.remove(k);
                if (qij.isEmpty()) {
                    this.vars[i].removeVal(j, this.cIndices[i]);
                }
                this.decrementIndeg(i + 1, l);
            }
            this.getOutArc(i, k).clear();
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.lastPropagatedWorld = this.getCurrentWorld();
        this.resetData();
        this.initGraph();
        this.initialFilter();
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        int world = this.getCurrentWorld();
        if (this.lastPropagatedWorld > world) {
            this.restoreGraph(world);
        }
        this.lastPropagatedWorld = world;
        DLList qij = this.getQij(idx, val);
        if (qij != null) {
            IntIterator it = qij.getIterator();
            while (it.hasNext()) {
                int k = it.next();
                int kn = this.automaton.delta(k, val);
                this.remFromOutarc(k, kn, val, idx);
                this.remFromInarc(k, kn, val, idx + 1);
                this.decrementOutdeg(idx, k);
                this.decrementIndeg(idx + 1, kn);
            }
            qij.clear();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    public void filter(int idx) throws ContradictionException {
        int upper = idx + 1 == this.vars.length ? this.Q.length : this.start[idx + 1];
        for (int j = this.offset[idx]; j < upper - this.start[idx] + this.offset[idx]; ++j) {
            if (this.getQij(idx, j) == null || this.getQij(idx, j).isEmpty() || this.vars[idx].canBeInstantiatedTo(j)) continue;
            this.awakeOnRem(idx, j);
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public boolean isSatisfied() {
        int[] str = new int[this.vars.length];
        int idx = 0;
        for (IntDomainVar var : this.vars) {
            if (!var.isInstantiated()) {
                return false;
            }
            str[idx++] = var.getVal();
        }
        return this.automaton.run(str);
    }

    public static class RegularIManager
    extends IntConstraintManager {
        @Override
        public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
            if (parameters instanceof Automaton) {
                Automaton auto = (Automaton)parameters;
                IntDomainVar[] vs = solver.getVar((IntegerVariable[])variables);
                return new RegularI(vs, auto);
            }
            return null;
        }
    }

    private static class DLList
    implements IntIterator {
        int[] succ;
        int[] pred;
        int first;
        int last;
        int nbEl;
        int current;
        public static int nbDLL = 0;

        public DLList(int size) {
            this.succ = new int[size];
            this.pred = new int[size];
            Arrays.fill(this.succ, Integer.MIN_VALUE);
            Arrays.fill(this.pred, Integer.MIN_VALUE);
            this.first = -1;
            this.last = -1;
            this.nbEl = 0;
        }

        public DLList() {
            this(1);
        }

        private DLList(int[] su, int[] pr, int fi, int la, int nb, int cu) {
            this.succ = new int[su.length];
            this.pred = new int[pr.length];
            System.arraycopy(su, 0, this.succ, 0, su.length);
            System.arraycopy(pr, 0, this.pred, 0, pr.length);
            this.first = fi;
            this.last = la;
            this.nbEl = nb;
            this.current = cu;
        }

        public Object clone() throws CloneNotSupportedException {
            return new DLList(this.succ, this.pred, this.first, this.last, this.nbEl, this.current);
        }

        public int size() {
            return this.nbEl;
        }

        public void clear() {
            Arrays.fill(this.succ, Integer.MIN_VALUE);
            Arrays.fill(this.pred, Integer.MIN_VALUE);
            this.first = -1;
            this.last = -1;
            this.nbEl = 0;
        }

        private void ensureCapacity(int size) {
            int[] su = new int[size * 3 / 2 + 1];
            int[] pr = new int[size * 3 / 2 + 1];
            Arrays.fill(su, Integer.MIN_VALUE);
            Arrays.fill(pr, Integer.MIN_VALUE);
            System.arraycopy(this.succ, 0, su, 0, this.succ.length);
            System.arraycopy(this.pred, 0, pr, 0, this.pred.length);
            this.succ = su;
            this.pred = pr;
        }

        public void add(int elem) {
            if (elem >= this.succ.length) {
                this.ensureCapacity(elem);
            }
            if (this.succ[elem] == Integer.MIN_VALUE) {
                if (this.nbEl == 0) {
                    this.first = elem;
                    this.last = -1;
                }
                this.succ[elem] = -1;
                this.pred[elem] = this.last;
                if (this.last != -1) {
                    this.succ[this.last] = elem;
                }
                this.last = elem;
                ++this.nbEl;
            }
        }

        public boolean isEmpty() {
            return this.nbEl == 0;
        }

        public void remove(int elem) {
            int tsucc = this.succ[elem];
            int tpred = this.pred[elem];
            if (tsucc != Integer.MIN_VALUE) {
                if (tsucc != -1) {
                    this.pred[tsucc] = tpred;
                } else {
                    this.last = tpred;
                }
                if (tpred != -1) {
                    this.succ[tpred] = tsucc;
                } else {
                    this.first = tsucc;
                }
                --this.nbEl;
            }
            this.succ[elem] = Integer.MIN_VALUE;
            this.pred[elem] = Integer.MIN_VALUE;
        }

        public boolean contains(int elem) {
            return this.succ[elem] != Integer.MIN_VALUE;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("{");
            int k = this.first;
            if (!this.isEmpty()) {
                while (k != -1) {
                    s.append(k);
                    if ((k = this.succ[k]) == -1) continue;
                    s.append(",");
                }
            }
            s.append("}");
            return s.toString();
        }

        public IntIterator getIterator() {
            this.current = this.first;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.current != -1;
        }

        @Override
        public int next() {
            int out = this.current;
            this.current = this.succ[out];
            return out;
        }

        @Override
        public void remove() {
            int toRemove = this.current == -1 ? this.last : this.pred[this.current];
            this.remove(toRemove);
        }
    }
}

