/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.costregular;

import choco.cp.solver.constraints.global.costregular.CostRegular;
import choco.kernel.solver.search.AbstractSearchHeuristic;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class CostRegularValSelector
extends AbstractSearchHeuristic
implements ValSelector {
    boolean max;
    CostRegular cr;

    public CostRegularValSelector(CostRegular cr, boolean max) {
        this.cr = cr;
        this.max = max;
    }

    @Override
    public int getBestVal(IntDomainVar x) {
        int idx = x.getVarIndex(this.cr.getConstraintIdx(0));
        if (idx == this.cr.myVars.length) {
            return x.getInf();
        }
        CostRegular.State s = null;
        CostRegular.State next = this.cr.source;
        for (int i = 0; i <= idx; ++i) {
            s = next;
            next = this.cr.getLayer(i + 1).get(this.max ? s.pgcSucc.get() : s.pccSucc.get());
        }
        int bestCost = this.max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        CostRegular.Arc out = null;
        for (int k = 0; k < s.outArcs.size(); ++k) {
            boolean b;
            CostRegular.Arc n = (CostRegular.Arc)s.outArcs.get(k);
            if (!n.getArcOrigin().equals(s) || !n.getArcDestination().equals(next)) continue;
            int cost = this.cr.getCost(idx, n.getArcLabel());
            boolean bl = this.max ? bestCost < cost : (b = bestCost > cost);
            if (!b) continue;
            bestCost = cost;
            out = n;
        }
        return out.getArcLabel();
    }
}

