/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.costregular;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateVector;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;

public class CostRegular
extends AbstractLargeIntSConstraint {
    public static final boolean INCREMENTAL = true;
    protected IEnvironment env;
    protected int[][] costs;
    private Automaton automaton;
    protected int nbNodes;
    protected IStateVector[][] Q;
    protected int[] size;
    public int[] offset;
    public IntDomainVar cVar;
    public IntDomainVar[] myVars;
    protected HashMap<Integer, State>[] layer;
    public Stack<Arc> toVisit;
    public HashSet<State>[] toUpdate = new HashSet[4];
    public State source;
    protected State puit;
    public static int appel = 0;

    public static CostRegular make(IntDomainVar[] vars, IntDomainVar costVar, Automaton auto, int[][] costs) {
        IntDomainVar[] tab = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, tab, 0, vars.length);
        tab[vars.length] = costVar;
        return new CostRegular(tab, auto, costs);
    }

    protected CostRegular(IntDomainVar[] vars, Automaton auto, int[][] costs) {
        super(vars);
        int i;
        this.automaton = auto;
        if (costs != null) {
            this.costs = new int[costs.length + 1][];
            System.arraycopy(costs, 0, this.costs, 0, costs.length);
            this.costs[costs.length] = new int[1];
        }
        this.env = vars[0].getSolver().getEnvironment();
        if (auto != null) {
            this.nbNodes = auto.size();
        }
        this.cVar = vars[vars.length - 1];
        this.myVars = new IntDomainVar[vars.length - 1];
        System.arraycopy(vars, 0, this.myVars, 0, vars.length - 1);
        this.size = new int[this.myVars.length];
        this.offset = new int[vars.length];
        this.offset[this.myVars.length] = 0;
        this.Q = new IStateVector[this.myVars.length][];
        for (i = 0; i < this.myVars.length; ++i) {
            this.size[i] = this.myVars[i].getSup() - this.myVars[i].getInf() + 1;
            this.offset[i] = this.myVars[i].getInf();
            this.Q[i] = new IStateVector[this.size[i]];
        }
        this.layer = new HashMap[this.myVars.length + 2];
        this.toVisit = new Stack();
        for (i = 0; i < this.toUpdate.length; ++i) {
            this.toUpdate[i] = new HashSet();
        }
    }

    protected void addToQij(int i, int j, State s) {
        if (this.Q[i][j - this.offset[i]] == null) {
            this.Q[i][j - this.offset[i]] = this.env.makeVector();
        }
        this.getQij(i, j).add(s);
    }

    protected void remFromQij(int i, int j, State s) {
        CostRegular.remove(this.getQij(i, j), s);
    }

    protected IStateVector getQij(int i, int j) {
        return this.Q[i][j - this.offset[i]];
    }

    protected int getCost(int i, int j) {
        return this.costs[i][j - this.offset[i]];
    }

    protected void clearStructures() {
        if (!this.toVisit.isEmpty()) {
            this.toVisit.clear();
        }
        IStateVector[][] arr$ = this.Q;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IStateVector[] aQ;
            for (IStateVector anAQ : aQ = arr$[i$]) {
                int l = anAQ == null ? 0 : anAQ.size();
                for (int k = 0; k < l; ++k) {
                    anAQ.removeLast();
                }
            }
        }
    }

    protected HashMap<Integer, State> getLayer(int i) {
        return this.layer[i];
    }

    protected int delta(int i, int j, int k) {
        return this.automaton.delta(k, j);
    }

    protected boolean isAccepting(int idx) {
        return this.automaton.isAccepting(idx);
    }

    protected int getStart() {
        return this.automaton.getStartingState();
    }

    protected void initGraph() throws ContradictionException {
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i] = new HashMap();
        }
        this.source = new State(0, this.getStart(), this);
        this.source.pccS.set(0);
        this.source.pgcS.set(0);
        this.layer[0].put(this.source.index, this.source);
        for (int i = 0; i < this.myVars.length; ++i) {
            DisposableIntIterator varIter = this.myVars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                int j = varIter.next();
                for (State s : this.layer[i].values()) {
                    int k = s.index;
                    int succ = this.delta(i, j, k);
                    if (succ < 0) continue;
                    State next = this.layer[i + 1].get(succ);
                    if (next == null) {
                        next = new State(i + 1, succ, this);
                        next.pccS.set(s.pccS.get() + this.getCost(i, j));
                        next.pccPred.set(s.index);
                        next.pgcS.set(s.pgcS.get() + this.getCost(i, j));
                        next.pgcPred.set(s.index);
                        this.layer[i + 1].put(succ, next);
                    } else {
                        int pgcSNew;
                        int pgcSTmp;
                        int pccSNew;
                        int pccSTmp = next.pccS.get();
                        if (pccSTmp > (pccSNew = s.pccS.get() + this.getCost(i, j))) {
                            next.pccS.set(pccSNew);
                            next.pccPred.set(s.index);
                        }
                        if ((pgcSTmp = next.pgcS.get()) < (pgcSNew = s.pgcS.get() + this.getCost(i, j))) {
                            next.pgcS.set(pgcSNew);
                            next.pgcPred.set(s.index);
                        }
                    }
                    Arc tmp = new Arc(s, j, next);
                    this.addToQij(i, j, s);
                    next.addInarc(tmp);
                    s.addOutarc(tmp);
                }
            }
        }
        this.puit = new State(this.myVars.length + 1, Integer.MAX_VALUE, this);
        this.layer[this.myVars.length + 1].put(Integer.MAX_VALUE, this.puit);
        HashSet<Integer> toRemoveA = new HashSet<Integer>(this.nbNodes);
        for (int idx : this.layer[this.myVars.length].keySet()) {
            if (!this.isAccepting(idx)) {
                toRemoveA.add(idx);
                continue;
            }
            State s = this.layer[this.myVars.length].get(idx);
            if (s.pccS.get() < this.puit.pccS.get()) {
                this.puit.pccS.set(s.pccS.get());
                this.puit.pccPred.set(s.index);
            }
            if (s.pgcS.get() > this.puit.pgcS.get()) {
                this.puit.pgcS.set(s.pgcS.get());
                this.puit.pgcPred.set(s.index);
            }
            s.pccP.set(0);
            s.pgcP.set(0);
            s.pccSucc.set(Integer.MAX_VALUE);
            s.pgcSucc.set(Integer.MAX_VALUE);
            Arc tmp = new Arc(s, 0, this.puit);
            s.addOutarc(tmp);
            this.puit.addInarc(tmp);
            this.puit.pccP.set(0);
            this.puit.pgcP.set(0);
        }
        for (Integer r : toRemoveA) {
            this.layer[this.myVars.length].remove(r);
        }
        BitSet mark = new BitSet(this.nbNodes);
        for (int i = this.myVars.length - 1; i >= 0; --i) {
            mark.set(0, this.nbNodes);
            DisposableIntIterator varIter = this.myVars[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                HashSet<State> toRemove = new HashSet<State>(this.nbNodes);
                int j = varIter.next();
                int sz = this.getQij(i, j) == null ? 0 : this.getQij(i, j).size();
                for (int m = 0; m < sz; ++m) {
                    State s = (State)this.getQij(i, j).get(m);
                    int succ = this.delta(i, j, s.index);
                    if (this.layer[i + 1].containsKey(succ)) {
                        State next = this.layer[i + 1].get(succ);
                        int c1 = s.pccS.get() + next.pccP.get() + this.getCost(i, j);
                        int c2 = s.pgcS.get() + next.pgcP.get() + this.getCost(i, j);
                        if (c1 > this.cVar.getSup() || c2 < this.cVar.getInf()) {
                            toRemove.add(s);
                            Arc tmp = new Arc(s, j, next);
                            s.remOutArc(tmp);
                            next.remInarc(tmp);
                            if (next.pccPred.get() == s.index) {
                                next.updatePccS();
                            }
                            if (next.pgcPred.get() != s.index) continue;
                            next.updatePgcS();
                            continue;
                        }
                        int pccPTmp = s.pccP.get();
                        int pccPNew = next.pccP.get() + this.getCost(i, j);
                        if (pccPNew < pccPTmp) {
                            s.pccP.set(pccPNew);
                            s.pccSucc.set(succ);
                        }
                        int pgcPTmp = s.pgcP.get();
                        int pgcPNew = next.pgcP.get() + this.getCost(i, j);
                        if (pgcPNew > pgcPTmp) {
                            s.pgcP.set(pgcPNew);
                            s.pgcSucc.set(succ);
                        }
                        mark.clear(s.index);
                        continue;
                    }
                    toRemove.add(s);
                    s.remOutArc(new Arc(s, j, new State(0, succ, this)));
                }
                for (State s : toRemove) {
                    this.remFromQij(i, j, s);
                }
            }
            int b = mark.nextSetBit(0);
            while (b >= 0) {
                this.layer[i].remove(b);
                b = mark.nextSetBit(b + 1);
            }
        }
    }

    public void printAll() {
        this.printAll(this.source);
    }

    protected void printAll(State s) {
        int i;
        HashSet[] map = new HashSet[this.vars.length + 1];
        System.out.println(this.puit);
        System.out.println(this.size[0]);
        for (i = 0; i < map.length; ++i) {
            map[i] = new HashSet();
        }
        this.printAll(s, map);
        for (i = 0; i < map.length; ++i) {
            System.out.println("");
            System.out.println("VAR = " + i + "  AT WORLD : " + this.vars[0].getSolver().getEnvironment().getWorldIndex());
            for (Arc a : map[i]) {
                System.out.println(a);
            }
        }
    }

    protected void printAll(State s, HashSet<Arc>[] map) {
        HashSet<State> next = new HashSet<State>();
        for (int i = 0; i < s.outArcs.size(); ++i) {
            Arc a = (Arc)s.outArcs.get(i);
            map[s.layer].add(a);
            next.add(a.getArcDestination());
        }
        for (State sn : next) {
            this.printAll(sn, map);
        }
    }

    protected void filter() throws ContradictionException {
        for (int i = 0; i < this.myVars.length; ++i) {
            for (int j = 0; j < this.Q[i].length; ++j) {
                if (this.Q[i][j] != null && !this.Q[i][j].isEmpty()) continue;
                this.vars[i].removeVal(j + this.offset[i], this.cIndices[i]);
            }
        }
        this.updateCostBound();
    }

    protected void updateCostBound() throws ContradictionException {
        for (State s : this.layer[0].values()) {
            int pgcP = s.pgcP.get();
            if (pgcP >= this.cVar.getSup()) continue;
            this.cVar.updateSup(pgcP, -1);
        }
        for (State s : this.layer[this.myVars.length + 1].values()) {
            int pccS = s.pccS.get();
            if (pccS <= this.cVar.getInf()) continue;
            this.cVar.updateInf(pccS, -1);
        }
    }

    protected void awakeOnCost() throws ContradictionException {
        for (int i = 0; i < this.myVars.length; ++i) {
            for (State s : this.layer[i].values()) {
                for (int k = 0; k < s.outArcs.size(); ++k) {
                    boolean delete;
                    Arc n = (Arc)s.outArcs.get(k);
                    boolean removed = false;
                    boolean bl = delete = n.getArcOrigin().pccS.get() == Integer.MAX_VALUE || n.getArcDestination().pccP.get() == Integer.MAX_VALUE;
                    if (delete || n.getArcOrigin().pccS.get() + this.getCost(i, n.getArcLabel()) + n.getArcDestination().pccP.get() > this.cVar.getSup()) {
                        n.getArcOrigin().remArc(n);
                        removed = true;
                    }
                    boolean bl2 = delete = n.getArcOrigin().pgcS.get() == Integer.MIN_VALUE || n.getArcDestination().pgcP.get() == Integer.MIN_VALUE;
                    if (!removed && delete || n.getArcOrigin().pgcS.get() + this.getCost(i, n.getArcLabel()) + n.getArcDestination().pgcP.get() < this.cVar.getInf()) {
                        n.getArcOrigin().remArc(n);
                        removed = true;
                    }
                    this.emptyStack();
                    if (!removed || i == this.myVars.length) continue;
                    --k;
                }
            }
        }
    }

    protected void emptyStack() throws ContradictionException {
        while (!this.toVisit.isEmpty()) {
            Arc toRemove = this.remFromQueue();
            toRemove.getArcOrigin().remArc(toRemove);
            this.updateCostBound();
        }
    }

    protected Arc remFromQueue() {
        Arc tmp = this.toVisit.pop();
        tmp.inQueue = false;
        return tmp;
    }

    @Override
    public void awake() throws ContradictionException {
        this.initGraph();
        this.filter();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.clearStructures();
        this.initGraph();
        this.filter();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.myVars.length ? 12 : 11;
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        this.toVisit.clear();
        IStateVector v = this.getQij(idx, val);
        if (v != null) {
            for (int k = 0; k < v.size(); ++k) {
                int succ;
                State next;
                Arc tmp;
                State s = (State)v.get(k);
                if (!s.remArc(tmp = new Arc(s, val, next = this.layer[idx + 1].get(succ = this.delta(idx, val, s.index))))) continue;
                --k;
            }
            this.emptyStack();
        }
    }

    public void filter(int idx) throws ContradictionException {
        if (idx != this.myVars.length) {
            for (int j = 0; j < this.Q[idx].length; ++j) {
                if (this.Q[idx][j] == null || this.Q[idx][j].isEmpty() || this.vars[idx].canBeInstantiatedTo(j + this.offset[idx])) continue;
                this.awakeOnRem(idx, j + this.offset[idx]);
            }
        } else {
            this.toVisit.clear();
            this.awakeOnCost();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public boolean isSatisfied() {
        int[] str = new int[this.myVars.length];
        int idx = 0;
        int sum = 0;
        for (IntDomainVar myVar : this.myVars) {
            if (!myVar.isInstantiated()) {
                return false;
            }
            str[idx] = myVar.getVal();
            sum += this.getCost(idx++, myVar.getVal());
        }
        return this.automaton.run(str) && this.cVar.getVal() == sum;
    }

    public static void remove(IStateVector sv, int idx) {
        if (sv.size() == idx + 1) {
            sv.removeLast();
        } else {
            Object o = sv.get(sv.size() - 1);
            sv.removeLast();
            sv.set(idx, o);
        }
    }

    public static boolean remove(IStateVector sv, Object idx) {
        int s = sv.size();
        for (int i = 0; i < s; ++i) {
            if (!sv.get(i).equals(idx)) continue;
            CostRegular.remove(sv, i);
            return false;
        }
        return true;
    }

    public static class State {
        public int layer;
        public int index;
        public IStateInt pccS;
        public IStateInt pgcS;
        public IStateInt pccP;
        public IStateInt pgcP;
        public IStateInt pccPred;
        public IStateInt pccSucc;
        public IStateInt pgcPred;
        public IStateInt pgcSucc;
        public IStateVector inArcs;
        public IStateVector outArcs;
        CostRegular cr;

        public State(int layer, int index, CostRegular constraint) {
            IEnvironment env = constraint.getSolver().getEnvironment();
            this.cr = constraint;
            this.layer = layer;
            this.index = index;
            this.pccS = env.makeInt(Integer.MAX_VALUE);
            this.pgcS = env.makeInt(Integer.MIN_VALUE);
            this.pccP = env.makeInt(Integer.MAX_VALUE);
            this.pgcP = env.makeInt(Integer.MIN_VALUE);
            this.pccPred = env.makeInt(-1);
            this.pccSucc = env.makeInt(-1);
            this.pgcPred = env.makeInt(-1);
            this.pgcSucc = env.makeInt(-1);
            this.inArcs = env.makeVector();
            this.outArcs = env.makeVector();
        }

        public void updatePccS() throws ContradictionException {
            ++appel;
            int newCost = Integer.MAX_VALUE;
            int newPred = Integer.MIN_VALUE;
            for (int k = 0; k < this.inArcs.size(); ++k) {
                Arc p = (Arc)this.inArcs.get(k);
                int i = p.getArcOrigin().layer;
                int j = p.getArcLabel();
                boolean used = p.getArcOrigin().pccS.get() != Integer.MAX_VALUE;
                int pccT = p.getArcOrigin().pccS.get() + this.getCost(i, j);
                if (!used || pccT >= newCost) continue;
                newCost = pccT;
                newPred = p.getArcOrigin().index;
            }
            boolean updated = newCost != this.pccS.get();
            this.pccS.set(newCost);
            this.pccPred.set(newPred);
            if (updated) {
                for (int k = 0; k < this.outArcs.size(); ++k) {
                    boolean deleted;
                    Arc n = (Arc)this.outArcs.get(k);
                    int i = n.getArcOrigin().layer;
                    int j = n.getArcLabel();
                    if (n.getArcDestination().pccPred.get() == this.index) {
                        n.getArcDestination().updatePccS();
                    }
                    boolean bl = deleted = newCost == Integer.MAX_VALUE || n.getArcDestination().pccP.get() == Integer.MAX_VALUE;
                    if (!deleted && newCost + n.getArcDestination().pccP.get() + this.getCost(i, j) <= this.cr.cVar.getSup()) continue;
                    this.addToQueue(n);
                }
            }
        }

        public void updatePgcS() throws ContradictionException {
            int newCost = Integer.MIN_VALUE;
            int newPred = Integer.MIN_VALUE;
            for (int k = 0; k < this.inArcs.size(); ++k) {
                Arc p = (Arc)this.inArcs.get(k);
                int i = p.getArcOrigin().layer;
                int j = p.getArcLabel();
                boolean used = p.getArcOrigin().pgcS.get() != Integer.MIN_VALUE;
                int pgcT = p.getArcOrigin().pgcS.get() + this.getCost(i, j);
                if (!used || pgcT <= newCost) continue;
                newCost = pgcT;
                newPred = p.getArcOrigin().index;
            }
            boolean updated = newCost != this.pgcS.get();
            this.pgcS.set(newCost);
            this.pgcPred.set(newPred);
            if (updated) {
                for (int k = 0; k < this.outArcs.size(); ++k) {
                    boolean deleted;
                    Arc n = (Arc)this.outArcs.get(k);
                    int i = n.getArcOrigin().layer;
                    int j = n.getArcLabel();
                    if (n.getArcDestination().pgcPred.get() == this.index) {
                        n.getArcDestination().updatePgcS();
                    }
                    boolean bl = deleted = newCost == Integer.MIN_VALUE || n.getArcDestination().pgcP.get() == Integer.MIN_VALUE;
                    if (!deleted && newCost + n.getArcDestination().pgcP.get() + this.getCost(i, j) >= this.cr.cVar.getInf()) continue;
                    this.addToQueue(n);
                }
            }
        }

        public void updatePccP() throws ContradictionException {
            int newCost = Integer.MAX_VALUE;
            int newSucc = Integer.MIN_VALUE;
            for (int k = 0; k < this.outArcs.size(); ++k) {
                Arc p = (Arc)this.outArcs.get(k);
                int i = p.getArcOrigin().layer;
                int j = p.getArcLabel();
                boolean used = p.getArcDestination().pccP.get() != Integer.MAX_VALUE;
                int pccT = p.getArcDestination().pccP.get() + this.getCost(i, j);
                if (!used || pccT >= newCost) continue;
                newCost = pccT;
                newSucc = p.getArcDestination().index;
            }
            boolean updated = newCost != this.pccP.get();
            this.pccP.set(newCost);
            this.pccSucc.set(newSucc);
            if (updated) {
                for (int k = 0; k < this.inArcs.size(); ++k) {
                    boolean deleted;
                    Arc n = (Arc)this.inArcs.get(k);
                    int i = n.getArcOrigin().layer;
                    int j = n.getArcLabel();
                    if (n.getArcOrigin().pccSucc.get() == this.index) {
                        n.getArcOrigin().updatePccP();
                    }
                    boolean bl = deleted = newCost == Integer.MAX_VALUE || n.getArcOrigin().pccS.get() == Integer.MAX_VALUE;
                    if (!deleted && newCost + this.getCost(i, j) + n.getArcOrigin().pccS.get() <= this.cr.cVar.getSup()) continue;
                    this.addToQueue(n);
                }
            }
        }

        public void updatePgcP() throws ContradictionException {
            int newCost = Integer.MIN_VALUE;
            int newSucc = Integer.MIN_VALUE;
            for (int k = 0; k < this.outArcs.size(); ++k) {
                Arc p = (Arc)this.outArcs.get(k);
                int i = p.getArcOrigin().layer;
                int j = p.getArcLabel();
                boolean used = p.getArcDestination().pgcP.get() != Integer.MIN_VALUE;
                int pgcT = p.getArcDestination().pgcP.get() + this.getCost(i, j);
                if (!used || pgcT <= newCost) continue;
                newCost = pgcT;
                newSucc = p.getArcDestination().index;
            }
            boolean updated = newCost != this.pgcP.get();
            this.pgcP.set(newCost);
            this.pgcSucc.set(newSucc);
            if (updated) {
                for (int k = 0; k < this.inArcs.size(); ++k) {
                    boolean deleted;
                    Arc n = (Arc)this.inArcs.get(k);
                    int i = n.getArcOrigin().layer;
                    int j = n.getArcLabel();
                    if (n.getArcOrigin().pgcSucc.get() == this.index) {
                        n.getArcOrigin().updatePgcP();
                    }
                    boolean bl = deleted = newCost == Integer.MIN_VALUE || n.getArcOrigin().pgcS.get() == Integer.MIN_VALUE;
                    if (!deleted && newCost + this.getCost(i, j) + n.getArcOrigin().pgcS.get() >= this.cr.cVar.getInf()) continue;
                    this.addToQueue(n);
                }
            }
        }

        public boolean remArc(Arc a) throws ContradictionException {
            boolean out = false;
            int i = a.getArcOrigin().layer;
            int j = a.getArcLabel();
            if (i < this.cr.myVars.length) {
                this.remOutArc(a);
                a.getArcDestination().remInarc(a);
                this.cr.remFromQij(i, j, a.getArcOrigin());
                out = true;
            }
            if (a.getArcDestination().pccPred.get() == a.getArcOrigin().index) {
                a.getArcDestination().updatePccS();
            }
            if (a.getArcDestination().pgcPred.get() == a.getArcOrigin().index) {
                a.getArcDestination().updatePgcS();
            }
            if (a.getArcOrigin().pccSucc.get() == a.getArcDestination().index) {
                a.getArcOrigin().updatePccP();
            }
            if (a.getArcOrigin().pgcSucc.get() == a.getArcDestination().index) {
                a.getArcOrigin().updatePgcP();
            }
            this.cr.updateCostBound();
            if (i < this.cr.myVars.length && this.getQij(i, j).isEmpty()) {
                this.getVar(i).removeVal(j, this.cr.cIndices[i]);
            }
            return out;
        }

        protected IStateVector getQij(int i, int j) {
            return this.cr.getQij(i, j);
        }

        protected int getCost(int i, int j) {
            return this.cr.getCost(i, j);
        }

        protected IntDomainVar getVar(int idx) {
            return this.cr.vars[idx];
        }

        protected void addToQueue(Arc a) {
            if (!a.inQueue) {
                a.inQueue = true;
                this.cr.toVisit.add(a);
            }
        }

        protected Arc remFromQueue() {
            Arc tmp = this.cr.toVisit.pop();
            tmp.inQueue = false;
            return tmp;
        }

        public void addInarc(Arc a) {
            this.inArcs.add(a);
        }

        public void remInarc(Arc a) {
            CostRegular.remove(this.inArcs, a);
        }

        public void addOutarc(Arc a) {
            this.outArcs.add(a);
        }

        public void remOutArc(Arc a) {
            CostRegular.remove(this.outArcs, a);
        }

        public boolean equals(Object o) {
            if (o instanceof State) {
                State os = (State)o;
                return this.index == os.index;
            }
            return false;
        }

        public String toString() {
            return "State " + this.index + "{" + this.layer + "}" + " [" + this.pccS.get() + "," + this.pgcS.get() + " ; " + this.pccP.get() + "," + this.pgcP.get() + "]";
        }
    }

    public static class Arc {
        State from;
        int val;
        State to;
        boolean inQueue;

        public Arc(State from, int val, State to) {
            this.from = from;
            this.val = val;
            this.to = to;
            this.inQueue = false;
        }

        public State getArcOrigin() {
            return this.from;
        }

        public State getArcDestination() {
            return this.to;
        }

        public int getArcLabel() {
            return this.val;
        }

        public boolean equals(Object o) {
            if (o instanceof Arc) {
                Arc oa = (Arc)o;
                return this.from.equals(oa.from) && this.val == oa.val && this.to.equals(oa.to);
            }
            return false;
        }

        public String toString() {
            return this.from + " -> " + this.val + " -> " + this.to;
        }
    }
}

