/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.costregular;

import choco.cp.solver.constraints.global.costregular.CostRegular;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;

public class CostKS
extends CostRegular {
    IntDomainVar bVar;
    IntDomainVar cVar;
    int[] cost;
    int[] gain;

    private static IntDomainVar[] merge(IntDomainVar[] vars, IntDomainVar bound, IntDomainVar cost) {
        IntDomainVar[] nyv = new IntDomainVar[vars.length + 2];
        System.arraycopy(vars, 0, nyv, 0, vars.length);
        nyv[vars.length] = bound;
        nyv[vars.length + 1] = cost;
        return nyv;
    }

    public static CostKS make(IntDomainVar[] vars, IntDomainVar bVar, IntDomainVar cVar, int[] cost, int[] gain) {
        return new CostKS(vars, bVar, cVar, cost, gain);
    }

    protected CostKS(IntDomainVar[] vars, IntDomainVar bVar, IntDomainVar cVar, int[] cost, int[] gain) {
        super(CostKS.merge(vars, bVar, cVar), null, null);
        this.bVar = bVar;
        this.cVar = cVar;
        this.cost = cost;
        this.gain = gain;
    }

    @Override
    protected int getCost(int i, int j) {
        if (i >= this.myVars.length - 1) {
            return 0;
        }
        return j * this.gain[i];
    }

    @Override
    protected int delta(int i, int j, int k) {
        if (i == this.myVars.length - 1) {
            return j == k ? 0 : -1;
        }
        int lgth = k + this.cost[i] * (j + this.offset[i]);
        if (lgth <= this.bVar.getSup()) {
            return lgth;
        }
        return -1;
    }

    @Override
    protected boolean isAccepting(int idx) {
        return idx == 0;
    }

    @Override
    protected int getStart() {
        return 0;
    }

    public static int findIdx(ArrayList<Integer> arr, int el) {
        int i = 0;
        boolean stop = false;
        while (i < arr.size() && !stop) {
            if (arr.get(i) > el) {
                ++i;
                continue;
            }
            stop = true;
        }
        return i;
    }

    @Override
    public boolean isSatisfied() {
        return true;
    }
}

