/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.Arrays;

public class SortingSConstraint
extends AbstractLargeIntSConstraint {
    private int n;
    private PriorityQueue pQueue;
    private IntDomainVar[] x;
    private IntDomainVar[] y;
    private int[] f;
    private int[] fPrime;
    private int[][] xyGraph;
    private int[] dfsNodes;
    private int[] sccNumbers;
    private int currentSccNumber;
    private int[] tmpArray;
    private int[][] sccSequences;
    private Stack1 s1;
    private Stack2 s2;
    private int[] recupStack = new int[3];
    private int[] recupStack2 = new int[3];

    public SortingSConstraint(IntDomainVar[] x, IntDomainVar[] y) {
        super(SortingSConstraint.mergeIntVarArrays(x, y));
        if (x.length != y.length || x.length == 0 || y.length == 0) {
            throw new IllegalArgumentException("SortingConstraint Error: the two vectors must be of the same (non zero) size");
        }
        this.n = x.length;
        this.solver = x[0].getSolver();
        this.x = x;
        this.y = y;
        this.f = new int[this.n];
        this.fPrime = new int[this.n];
        this.xyGraph = new int[this.n][this.n];
        this.sccSequences = new int[this.n][this.n];
        this.dfsNodes = new int[this.n];
        this.sccNumbers = new int[this.n];
        this.tmpArray = new int[this.n];
        this.pQueue = new PriorityQueue(this.n);
        this.s1 = new Stack1(this.n);
        this.s2 = new Stack2(this.n);
    }

    public void boundConsistency() throws ContradictionException {
        int k;
        int jprime;
        int j;
        int i;
        for (i = 0; i < this.n; ++i) {
            Arrays.fill(this.xyGraph[i], -1);
            Arrays.fill(this.sccSequences[i], -1);
        }
        this.pQueue.clear();
        for (i = 1; i < this.n; ++i) {
            if (this.y[i].getInf() >= this.y[i - 1].getInf()) continue;
            this.y[i].updateInf(this.y[i - 1].getInf(), this.cIndices[this.n + i]);
        }
        for (i = this.n - 2; i >= 0; --i) {
            if (this.y[i].getSup() <= this.y[i + 1].getSup()) continue;
            this.y[i].updateSup(this.y[i + 1].getSup(), this.cIndices[this.n + i]);
        }
        for (i = 0; i < this.n; ++i) {
            if (!(this.x[i].getInf() >= this.y[0].getInf() && this.x[i].getInf() <= this.y[0].getSup() || this.x[i].getSup() >= this.y[0].getInf() && this.x[i].getSup() <= this.y[0].getSup() || this.y[0].getInf() >= this.x[i].getInf() && this.y[0].getInf() <= this.x[i].getSup()) && (this.y[0].getSup() < this.x[i].getInf() || this.y[0].getSup() > this.x[i].getSup())) continue;
            this.pQueue.addElement(i, this.x[i].getSup());
        }
        this.f[0] = this.computeF(0);
        for (j = 1; j < this.n; ++j) {
            for (i = 0; i < this.n; ++i) {
                if (this.x[i].getInf() <= this.y[j - 1].getSup() || this.x[i].getInf() > this.y[j].getSup()) continue;
                this.pQueue.addElement(i, this.x[i].getSup());
            }
            this.f[j] = this.computeF(j);
        }
        for (i = 0; i < this.n; ++i) {
            if (this.x[this.f[i]].getSup() >= this.y[i].getSup()) continue;
            this.y[i].updateSup(this.x[this.f[i]].getSup(), this.cIndices[this.n + i]);
        }
        this.pQueue.clear();
        for (i = 0; i < this.n; ++i) {
            if (!(this.x[i].getInf() >= this.y[this.n - 1].getInf() && this.x[i].getInf() <= this.y[this.n - 1].getSup() || this.x[i].getSup() >= this.y[this.n - 1].getInf() && this.x[i].getSup() <= this.y[this.n - 1].getSup() || this.y[this.n - 1].getInf() >= this.x[i].getInf() && this.y[this.n - 1].getInf() <= this.x[i].getSup()) && (this.y[this.n - 1].getSup() < this.x[i].getInf() || this.y[this.n - 1].getSup() > this.x[i].getSup())) continue;
            this.pQueue.addElement(i, -this.x[i].getInf());
        }
        this.fPrime[this.n - 1] = this.computeFPrime(this.n - 1);
        for (j = this.n - 2; j >= 0; --j) {
            for (i = 0; i < this.n; ++i) {
                if (this.x[i].getSup() >= this.y[j + 1].getInf() || this.x[i].getSup() < this.y[j].getInf()) continue;
                this.pQueue.addElement(i, -this.x[i].getInf());
            }
            this.fPrime[j] = this.computeFPrime(j);
        }
        for (i = 0; i < this.n; ++i) {
            if (this.x[this.fPrime[i]].getInf() <= this.y[i].getInf()) continue;
            this.y[i].updateInf(this.x[this.fPrime[i]].getInf(), this.cIndices[this.n + i]);
        }
        for (j = 0; j < this.n; ++j) {
            int tmp = 0;
            jprime = this.f[j];
            for (i = 0; i < this.n; ++i) {
                if (j == i || !(this.x[jprime].getInf() >= this.y[i].getInf() && this.x[jprime].getInf() <= this.y[i].getSup() || this.x[jprime].getSup() >= this.y[i].getInf() && this.x[jprime].getSup() <= this.y[i].getSup() || this.y[i].getInf() >= this.x[jprime].getInf() && this.y[i].getInf() <= this.x[jprime].getSup()) && (this.y[i].getSup() < this.x[jprime].getInf() || this.y[i].getSup() > this.x[jprime].getSup())) continue;
                this.xyGraph[j][tmp] = i;
                ++tmp;
            }
        }
        this.dfs2();
        Arrays.fill(this.tmpArray, 0);
        for (i = 0; i < this.n; ++i) {
            this.sccSequences[this.sccNumbers[i]][this.tmpArray[this.sccNumbers[i]]] = i;
            int n = this.sccNumbers[i];
            this.tmpArray[n] = this.tmpArray[n] + 1;
        }
        for (i = 0; i < this.n && this.sccSequences[i][0] != -1; ++i) {
            for (j = 0; j < this.n && this.sccSequences[i][j] != -1; ++j) {
                jprime = this.f[this.sccSequences[i][j]];
                for (k = 0; k < this.n && this.sccSequences[i][k] != -1 && this.x[jprime].getInf() > this.y[this.sccSequences[i][k]].getSup(); ++k) {
                }
                assert (this.sccSequences[i][k] != -1);
                if (this.y[this.sccSequences[i][k]].getInf() <= this.x[jprime].getInf()) continue;
                this.x[jprime].updateInf(this.y[this.sccSequences[i][k]].getInf(), this.cIndices[jprime]);
            }
        }
        Arrays.fill(this.tmpArray, 0);
        for (i = this.n - 1; i >= 0; --i) {
            this.sccSequences[this.sccNumbers[i]][this.tmpArray[this.sccNumbers[i]]] = i;
            int n = this.sccNumbers[i];
            this.tmpArray[n] = this.tmpArray[n] + 1;
        }
        for (i = 0; i < this.n && this.sccSequences[i][0] != -1; ++i) {
            for (j = 0; j < this.n && this.sccSequences[i][j] != -1; ++j) {
                jprime = this.f[this.sccSequences[i][j]];
                for (k = 0; k < this.n && this.sccSequences[i][k] != -1 && this.x[jprime].getSup() < this.y[this.sccSequences[i][k]].getInf(); ++k) {
                }
                assert (this.sccSequences[i][k] != -1);
                if (this.y[this.sccSequences[i][k]].getSup() >= this.x[jprime].getSup()) continue;
                this.x[jprime].updateSup(this.y[this.sccSequences[i][k]].getSup(), this.cIndices[jprime]);
            }
        }
    }

    private int computeF(int j) throws ContradictionException {
        int i;
        if (this.pQueue.isEmpty()) {
            this.getSolver().getPropagationEngine().raiseContradiction(this, 2);
        }
        if (this.x[i = this.pQueue.pop()].getSup() < this.y[j].getInf()) {
            this.getSolver().getPropagationEngine().raiseContradiction(this, 2);
        }
        return i;
    }

    private int computeFPrime(int j) throws ContradictionException {
        int i;
        if (this.pQueue.isEmpty()) {
            this.getSolver().getPropagationEngine().raiseContradiction(this, 2);
        }
        if (this.x[i = this.pQueue.pop()].getInf() > this.y[j].getSup()) {
            this.getSolver().getPropagationEngine().raiseContradiction(this, 2);
        }
        return i;
    }

    private void dfs2() {
        int i;
        Arrays.fill(this.dfsNodes, 0);
        this.s1.clear();
        this.s2.clear();
        this.currentSccNumber = 0;
        for (i = 0; i < this.n; ++i) {
            if (this.dfsNodes[i] != 0) continue;
            this.dfsVisit2(i);
        }
        while (!this.s1.isEmpty()) {
            i = this.s1.pop();
            this.sccNumbers[i] = this.currentSccNumber;
        }
        this.s2.pop();
    }

    private void dfsVisit2(int node) {
        this.dfsNodes[node] = 1;
        if (this.s2.isEmpty()) {
            this.s1.push(node);
            this.s2.push(node, node, this.x[this.f[node]].getSup());
            int i = 0;
            while (this.xyGraph[node][i] != -1) {
                if (this.dfsNodes[this.xyGraph[node][i]] == 0) {
                    this.dfsVisit2(this.xyGraph[node][i]);
                }
                ++i;
            }
        } else {
            int i;
            this.s2.peek(this.recupStack);
            if (this.recupStack[2] < this.y[node].getInf()) {
                while ((i = this.s1.pop()) != this.recupStack[0]) {
                    this.sccNumbers[i] = this.currentSccNumber;
                }
                this.sccNumbers[i] = this.currentSccNumber++;
                this.s2.pop();
            }
            this.s1.push(node);
            this.recupStack[0] = node;
            this.recupStack[1] = node;
            this.recupStack[2] = this.x[this.f[node]].getSup();
            if (this.mergeStack(node)) {
                // empty if block
            }
            i = 0;
            while (this.xyGraph[node][i] != -1) {
                if (this.dfsNodes[this.xyGraph[node][i]] == 0) {
                    this.dfsVisit2(this.xyGraph[node][i]);
                }
                ++i;
            }
        }
        this.dfsNodes[node] = 2;
    }

    private boolean mergeStack(int node) {
        this.s2.peek(this.recupStack2);
        boolean flag = false;
        while (!this.s2.isEmpty() && this.y[this.recupStack2[1]].getSup() >= this.x[this.f[node]].getInf()) {
            flag = true;
            this.recupStack[0] = this.recupStack2[0];
            this.recupStack[1] = node;
            this.recupStack[2] = this.recupStack[2] > this.recupStack2[2] ? this.recupStack[2] : this.recupStack2[2];
            this.s2.pop();
            this.s2.peek(this.recupStack2);
        }
        this.s2.push(this.recupStack[0], this.recupStack[1], this.recupStack[2]);
        return flag;
    }

    private static IntDomainVar[] mergeIntVarArrays(IntVar[] firstArray, IntVar[] secondArray) {
        int i;
        IntDomainVar[] newArray = new IntDomainVar[firstArray.length + secondArray.length];
        for (i = 0; i < firstArray.length; ++i) {
            newArray[i] = (IntDomainVar)firstArray[i];
        }
        for (i = 0; i < secondArray.length; ++i) {
            newArray[i + firstArray.length] = (IntDomainVar)secondArray[i];
        }
        return newArray;
    }

    @Override
    public void awake() throws ContradictionException {
        this.boundConsistency();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.boundConsistency();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int[] x = new int[this.n];
        int[] y = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            x[i] = tuple[i];
            y[i] = tuple[this.n + i];
        }
        Arrays.sort(x);
        for (i = 0; i < this.n && x[i] == y[i]; ++i) {
        }
        return i == this.n;
    }

    public void printVectors() {
        int i;
        System.out.print("x = ( ");
        for (i = 0; i < this.x.length; ++i) {
            System.out.print("[" + this.x[i].getInf() + "," + this.x[i].getSup() + "] ");
        }
        System.out.println(")");
        System.out.print("y = ( ");
        for (i = 0; i < this.y.length; ++i) {
            System.out.print("[" + this.y[i].getInf() + "," + this.y[i].getSup() + "] ");
        }
        System.out.println(")");
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Sorting({");
        for (i = 0; i < this.x.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.x[i].pretty());
        }
        sb.append("}) = {");
        for (i = 0; i < this.y.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.y[i].pretty());
        }
        sb.append("}");
        return sb.toString();
    }

    private static class Stack2 {
        private int[] roots;
        private int[] rightMosts;
        private int[] maxXs;
        private int n;
        private int nbElts = 0;

        public Stack2(int _n) {
            this.n = _n;
            this.roots = new int[_n];
            this.rightMosts = new int[_n];
            this.maxXs = new int[_n];
        }

        public boolean push(int root, int rightMost, int maxX) {
            if (this.nbElts == this.n) {
                return false;
            }
            this.roots[this.nbElts] = root;
            this.rightMosts[this.nbElts] = rightMost;
            this.maxXs[this.nbElts] = maxX;
            ++this.nbElts;
            return true;
        }

        public boolean pop() {
            if (this.isEmpty()) {
                return false;
            }
            --this.nbElts;
            return true;
        }

        public boolean pop(int[] x) {
            if (this.isEmpty()) {
                return false;
            }
            --this.nbElts;
            x[0] = this.roots[this.nbElts];
            x[1] = this.rightMosts[this.nbElts];
            x[2] = this.maxXs[this.nbElts];
            return true;
        }

        public boolean peek(int[] x) {
            if (this.isEmpty()) {
                return false;
            }
            x[0] = this.roots[this.nbElts - 1];
            x[1] = this.rightMosts[this.nbElts - 1];
            x[2] = this.maxXs[this.nbElts - 1];
            return true;
        }

        public boolean isEmpty() {
            return this.nbElts == 0;
        }

        public void clear() {
            this.nbElts = 0;
        }

        public String toString() {
            String s = "";
            for (int i = 0; i < this.nbElts; ++i) {
                s = s + " <" + this.roots[i] + ", " + this.rightMosts[i] + ", " + this.maxXs[i] + ">";
            }
            return s;
        }
    }

    private static class Stack1 {
        private int[] values;
        private int n;
        private int nbElts = 0;

        public Stack1(int _n) {
            this.n = _n;
            this.values = new int[_n];
        }

        public boolean push(int elt) {
            if (this.nbElts == this.n) {
                return false;
            }
            this.values[this.nbElts] = elt;
            ++this.nbElts;
            return true;
        }

        public int pop() {
            if (this.isEmpty()) {
                return -1;
            }
            --this.nbElts;
            return this.values[this.nbElts];
        }

        public int peek() {
            if (this.isEmpty()) {
                return -1;
            }
            return this.values[this.nbElts - 1];
        }

        public boolean isEmpty() {
            return this.nbElts == 0;
        }

        public void clear() {
            this.nbElts = 0;
        }

        public String toString() {
            String s = "";
            for (int i = 0; i < this.nbElts; ++i) {
                s = s + " " + this.values[i];
            }
            return s;
        }
    }

    private static class PriorityQueue {
        private int n;
        private int[] indices;
        private int[] values;
        private int[] pointers;
        private int first;
        private int lastElt;

        public PriorityQueue(int _n) {
            this.n = _n;
            this.indices = new int[_n];
            this.pointers = new int[_n];
            this.values = new int[_n];
            this.clear();
        }

        public boolean addElement(int index, int value) {
            int j = -1;
            if (this.lastElt == this.n) {
                return false;
            }
            this.indices[this.lastElt] = index;
            this.values[this.lastElt] = value;
            int i = this.first;
            while (i != -1 && this.values[i] <= value) {
                j = i;
                i = this.pointers[i];
            }
            this.pointers[this.lastElt] = i;
            if (j == -1) {
                this.first = this.lastElt;
            } else {
                this.pointers[j] = this.lastElt;
            }
            ++this.lastElt;
            return true;
        }

        public int pop() {
            if (this.isEmpty()) {
                return -1;
            }
            int elt = this.indices[this.first];
            this.first = this.pointers[this.first];
            return elt;
        }

        public boolean isEmpty() {
            return this.first == -1;
        }

        public void clear() {
            this.first = -1;
            this.lastElt = 0;
        }

        public String toString() {
            String s = "<";
            int i = this.first;
            while (i != -1) {
                s = s + " " + this.indices[i];
                i = this.pointers[i];
            }
            s = s + " >";
            return s;
        }
    }
}

