/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.Comparator;

public class SemiLeximinSConstraint
extends AbstractLargeIntSConstraint {
    private IStateInt alpha;
    private IStateInt beta;
    private IStateInt gamma;
    private IStateInt delta;
    private IStateBitSet epsilon;
    private IStateInt[] ceily;
    private IStateInt[] sortedCeily;
    private int[] x;
    private int maximum;
    private int minimum;
    private int n;
    public boolean verbose = false;

    public SemiLeximinSConstraint(int[] x, IntDomainVar[] y) {
        super(y);
        if (x.length != y.length || x.length == 0 || y.length == 0) {
            throw new IllegalArgumentException("LeximinConstraint Error: the two vectors must be of the same (non zero) size");
        }
        this.n = x.length;
        this.x = new int[this.n];
        System.arraycopy(x, 0, this.x, 0, x.length);
        this.solver = y[0].getSolver();
        this.alpha = this.solver.getEnvironment().makeInt();
        this.beta = this.solver.getEnvironment().makeInt();
        this.gamma = this.solver.getEnvironment().makeInt();
        this.delta = this.solver.getEnvironment().makeInt();
        this.epsilon = this.solver.getEnvironment().makeBitSet(4);
        this.generateVectors();
    }

    private void generateVectors() {
        this.ceily = new IStateInt[this.n];
        this.sortedCeily = new IStateInt[this.n];
        int minimumX = Integer.MAX_VALUE;
        int minimumY = Integer.MAX_VALUE;
        int maximumX = 0;
        int maximumY = 0;
        for (int i = 0; i < this.n; ++i) {
            minimumX = minimumX > this.x[i] ? this.x[i] : minimumX;
            maximumX = maximumX < this.x[i] ? this.x[i] : maximumX;
            this.sortedCeily[i] = this.solver.getEnvironment().makeInt(this.vars[i].getSup());
            this.ceily[i] = this.solver.getEnvironment().makeInt(this.vars[i].getSup());
            minimumY = minimumY > this.sortedCeily[i].get() ? this.sortedCeily[i].get() : minimumY;
            maximumY = maximumY < this.sortedCeily[i].get() ? this.sortedCeily[i].get() : maximumY;
        }
        this.minimum = minimumX < minimumY ? minimumX : minimumY;
        this.maximum = maximumX > maximumY ? maximumX : maximumY;
        Arrays.sort(this.x);
        Arrays.sort(this.sortedCeily, new SIComparator());
    }

    public void updateVectors(int idx) {
        for (int i = 0; i < this.n; ++i) {
            this.sortedCeily[i] = this.solver.getEnvironment().makeInt(this.vars[i].getSup());
            this.ceily[i] = this.solver.getEnvironment().makeInt(this.vars[i].getSup());
        }
        Arrays.sort(this.sortedCeily, new SIComparator());
    }

    public void setPointersAndFlags() throws ContradictionException {
        int i;
        int l = this.minimum;
        int u = this.maximum;
        int currentX = 0;
        int currentY = 0;
        int currentOccX = 0;
        int currentOccY = 0;
        this.gamma.set(0);
        this.delta.set(0);
        this.alpha.set(l - 1);
        for (i = 0; i < 4; ++i) {
            this.epsilon.set(i, false);
        }
        if (this.verbose) {
            System.out.println("l = " + l + " / u = " + u);
        }
        while (this.alpha.get() <= u && currentOccX == currentOccY) {
            this.alpha.set(this.alpha.get() + 1);
            currentOccX = 0;
            while (currentX < this.x.length && this.x[currentX] == this.alpha.get()) {
                ++currentOccX;
                ++currentX;
            }
            currentOccY = 0;
            while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == this.alpha.get()) {
                ++currentOccY;
                ++currentY;
            }
            if (!this.verbose) continue;
            System.out.println("cX = " + currentX + " / cOX = " + currentOccX);
            System.out.println("cY = " + currentY + " / cOY = " + currentOccY);
        }
        if (this.alpha.get() <= u && currentOccX < currentOccY) {
            this.fail();
        }
        if (this.alpha.get() == u + 1) {
            this.alpha.set(Integer.MAX_VALUE);
            this.beta.set(Integer.MAX_VALUE);
        } else {
            if (currentOccX == currentOccY - 1) {
                this.epsilon.set(0, true);
            }
            if (currentOccX == currentOccY + 1) {
                this.epsilon.set(1, true);
            }
            this.beta.set(this.alpha.get());
            this.gamma.set(1);
            currentOccX = 0;
            currentOccY = 0;
            while (this.beta.get() <= u && currentOccX >= currentOccY) {
                if (currentOccX > currentOccY) {
                    this.gamma.set(0);
                }
                this.beta.set(this.beta.get() + 1);
                currentOccX = 0;
                while (currentX < this.x.length && this.x[currentX] == this.beta.get()) {
                    ++currentOccX;
                    ++currentX;
                }
                currentOccY = 0;
                while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == this.beta.get()) {
                    ++currentOccY;
                    ++currentY;
                }
            }
            if (this.beta.get() == u + 1) {
                this.beta.set(Integer.MAX_VALUE);
                this.gamma.set(0);
            }
            if (currentOccX == currentOccY - 1) {
                this.epsilon.set(2, true);
            }
            if (currentOccX == currentOccY + 1) {
                this.epsilon.set(3, true);
            }
            if (this.beta.get() < u) {
                i = this.beta.get();
                currentOccX = 0;
                currentOccY = 0;
                while (i <= u && currentOccX == currentOccY) {
                    ++i;
                    currentOccX = 0;
                    while (currentX < this.x.length && this.x[currentX] == i) {
                        ++currentOccX;
                        ++currentX;
                    }
                    currentOccY = 0;
                    while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == i) {
                        ++currentOccY;
                        ++currentY;
                    }
                }
                if (i <= u && currentOccX < currentOccY) {
                    this.delta.set(1);
                }
            }
        }
    }

    public void updatePointersAndFlags(int idx, boolean inf) throws ContradictionException {
    }

    private void gac() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int b;
            int a = this.vars[i].getInf();
            if (a >= (b = this.vars[i].getSup())) continue;
            if (b <= this.alpha.get()) {
                this.vars[i].instantiate(b, this.cste);
            }
            if (this.alpha.get() < b && b < this.beta.get() && a <= this.alpha.get()) {
                this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
            }
            if (b == this.beta.get() && a <= this.alpha.get()) {
                if (this.epsilon.get(1)) {
                    if (this.gamma.get() > 0 && this.epsilon.get(2) && this.delta.get() > 0) {
                        this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
                    } else {
                        this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
                    }
                } else {
                    this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
                }
            }
            if (b <= this.beta.get() || a > this.alpha.get()) continue;
            if (this.epsilon.get(1)) {
                if (this.gamma.get() <= 0) continue;
                this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
                continue;
            }
            this.vars[i].updateInf(this.alpha.get(), this.cIndices[i]);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (this.vars[idx].getSup() < this.minimum) {
            this.minimum = this.vars[idx].getSup();
        }
        this.updateVectors(idx);
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.vars[idx].getSup() < this.minimum) {
            this.minimum = this.vars[idx].getSup();
        }
        this.updateVectors(idx);
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public boolean isSatisfied() {
        int i;
        int[] x = new int[this.n];
        IntDomainVar[] y = new IntDomainVar[this.n];
        for (i = 0; i < this.n; ++i) {
            x[i] = this.x[i];
            y[i] = this.vars[i];
        }
        Arrays.sort(x);
        Arrays.sort(y, new IDVComparator());
        for (i = 0; i < this.n && x[i] == y[i].getVal(); ++i) {
        }
        return i != this.n && x[i] <= y[i].getVal();
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Leximin({");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.x[i]);
        }
        sb.append("}, {");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    public String toString() {
        return "Semi-leximin ordering constraint.";
    }

    public void printOccVectors() {
        int i;
        System.out.print("x = [");
        for (i = 0; i < this.x.length; ++i) {
            System.out.print(" " + this.x[i]);
        }
        System.out.print(" ]\n");
        System.out.print("y = [");
        for (i = 0; i < this.sortedCeily.length; ++i) {
            System.out.print(" " + this.vars[i].pretty());
        }
        System.out.print(" ]\n");
        System.out.print("sortedFloor(x) = [");
        for (i = 0; i < this.x.length; ++i) {
            System.out.print(" " + this.x[i]);
        }
        System.out.print(" ]\n");
        System.out.print("sortedCeil(y) = [");
        for (i = 0; i < this.sortedCeily.length; ++i) {
            System.out.print(" " + this.sortedCeily[i].get());
        }
        System.out.print(" ]\n");
        System.out.print("ceil(y) = [");
        for (i = 0; i < this.ceily.length; ++i) {
            System.out.print(" " + this.ceily[i].get());
        }
        System.out.print(" ]\n");
        System.out.println("alpha = " + this.alpha.get());
        System.out.println("beta = " + this.beta.get());
        System.out.println("gamma = " + this.gamma.get());
        System.out.println("delta = " + this.delta.get());
        System.out.print("epsilon = [");
        for (i = 0; i < 4; ++i) {
            System.out.print(" " + this.epsilon.get(i));
        }
        System.out.print(" ]\n");
    }

    public void setX(int[] x) {
        System.arraycopy(x, 0, this.x, 0, x.length);
        Arrays.sort(x);
        try {
            this.generateVectors();
            this.propagate();
        }
        catch (ContradictionException e) {
            e.printStackTrace();
        }
    }

    private static class SIComparator
    implements Comparator<IStateInt> {
        private SIComparator() {
        }

        @Override
        public int compare(IStateInt o1, IStateInt o2) throws ClassCastException {
            return o1.get() > o2.get() ? 1 : (o1.get() < o2.get() ? -1 : 0);
        }
    }

    private static class IDVComparator
    implements Comparator<IntDomainVar> {
        private IDVComparator() {
        }

        @Override
        public int compare(IntDomainVar o1, IntDomainVar o2) throws ClassCastException {
            return o1.getVal() > o2.getVal() ? 1 : (o1.getVal() < o2.getVal() ? -1 : 0);
        }
    }
}

