/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Logger;

public class Occurrence
extends AbstractLargeIntSConstraint {
    private Logger logger = Logger.getLogger("choco.kernel.solver.propagation.const");
    public IStateInt nbPossible;
    public IStateInt nbSure;
    public boolean constrainOnInfNumber = false;
    public boolean constrainOnSupNumber = false;
    public IntDomainVar[] relevantVar;

    public Occurrence(IntDomainVar[] vars, int occval, boolean onInf, boolean onSup) {
        super(vars);
        this.init(occval, onInf, onSup);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Occurrence newc = (Occurrence)super.clone();
        newc.init(this.cste, this.constrainOnInfNumber, this.constrainOnSupNumber);
        return newc;
    }

    public void init(int occval, boolean onInf, boolean onSup) {
        int i;
        this.cste = occval;
        this.constrainOnInfNumber = onInf;
        this.constrainOnSupNumber = onSup;
        IEnvironment envi = this.vars[0].getSolver().getEnvironment();
        this.solver = this.vars[0].getSolver();
        this.nbPossible = envi.makeInt(0);
        this.nbSure = envi.makeInt(0);
        int cpt = 0;
        for (i = 0; i < this.vars.length - 1; ++i) {
            if (!this.vars[i].canBeInstantiatedTo(this.cste)) continue;
            this.nbPossible.add(1);
            ++cpt;
        }
        this.relevantVar = new IntDomainVar[cpt];
        cpt = 0;
        for (i = 0; i < this.vars.length - 1; ++i) {
            if (!this.vars[i].canBeInstantiatedTo(this.cste)) continue;
            this.relevantVar[cpt] = this.vars[i];
            ++cpt;
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (idx == nbVars) {
            this.checkNbPossible();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (idx == nbVars) {
            this.checkNbSure();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (idx < nbVars && this.vars[idx].getVal() == this.cste) {
            this.nbSure.add(1);
            this.checkNbSure();
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (idx < nbVars) {
            while (deltaDomain.hasNext()) {
                int x = deltaDomain.next();
                if (x != this.cste) continue;
                this.nbPossible.add(-1);
            }
            this.checkNbPossible();
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int nbVars = this.vars.length - 1;
        int cptVal = 0;
        for (int i = 0; i < nbVars; ++i) {
            if (this.vars[i].getVal() != this.cste) continue;
            ++cptVal;
        }
        if (this.constrainOnInfNumber & this.constrainOnSupNumber) {
            return cptVal == this.vars[nbVars].getVal();
        }
        if (this.constrainOnInfNumber) {
            return cptVal >= this.vars[nbVars].getVal();
        }
        return cptVal <= this.vars[nbVars].getVal();
    }

    public void checkNbPossible() throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (this.constrainOnInfNumber) {
            this.vars[nbVars].updateSup(this.nbPossible.get(), this.cIndices[nbVars]);
            if (this.vars[nbVars].getInf() == this.nbPossible.get()) {
                for (int i = 0; i < this.relevantVar.length; ++i) {
                    if (!this.relevantVar[i].getDomain().contains(this.cste) || this.relevantVar[i].isInstantiated()) continue;
                    this.relevantVar[i].instantiate(this.cste, -1);
                }
            }
        }
    }

    public void checkNbSure() throws ContradictionException {
        int nbVars = this.vars.length - 1;
        if (this.constrainOnSupNumber) {
            this.vars[nbVars].updateInf(this.nbSure.get(), this.cIndices[nbVars]);
            if (this.vars[nbVars].getSup() == this.nbSure.get()) {
                for (int i = 0; i < this.relevantVar.length; ++i) {
                    if (!this.relevantVar[i].getDomain().contains(this.cste) || this.relevantVar[i].isInstantiated()) continue;
                    this.relevantVar[i].removeVal(this.cste, -1);
                }
            }
        }
    }

    public void filter() throws ContradictionException {
        this.checkNbPossible();
        this.checkNbSure();
    }

    @Override
    public void propagate() throws ContradictionException {
        int nbVars = this.vars.length - 1;
        int nbSure = 0;
        int nbPossible = 0;
        for (int i = 0; i < nbVars; ++i) {
            if (!this.vars[i].canBeInstantiatedTo(this.cste)) continue;
            ++nbPossible;
            if (!this.vars[i].isInstantiatedTo(this.cste)) continue;
            ++nbSure;
        }
        this.nbSure.set(nbSure);
        this.nbPossible.set(nbPossible);
        this.checkNbPossible();
        this.checkNbSure();
    }

    @Override
    public void awake() throws ContradictionException {
        int i;
        int nbVars = this.vars.length;
        this.nbSure.set(0);
        this.nbPossible.set(0);
        int cpt = 0;
        for (i = 0; i < nbVars - 1; ++i) {
            if (this.vars[i].canBeInstantiatedTo(this.cste)) {
                this.nbPossible.add(1);
                ++cpt;
            }
            if (!this.vars[i].isInstantiatedTo(this.cste)) continue;
            this.nbSure.add(1);
        }
        this.relevantVar = new IntDomainVar[cpt];
        cpt = 0;
        for (i = 0; i < nbVars - 1; ++i) {
            if (!this.vars[i].canBeInstantiatedTo(this.cste)) continue;
            this.relevantVar[cpt] = this.vars[i];
            ++cpt;
        }
        if (this.constrainOnInfNumber) {
            this.vars[nbVars - 1].updateSup(nbVars - 1, this.cIndices[nbVars - 1]);
        }
        if (this.constrainOnSupNumber) {
            this.vars[nbVars - 1].updateInf(0, this.cIndices[nbVars - 1]);
        }
        this.filter();
    }

    @Override
    public Boolean isEntailed() {
        int nbVars = this.vars.length - 1;
        int nbPos = 0;
        int nbSur = 0;
        for (int i = 0; i < this.relevantVar.length; ++i) {
            if (!this.vars[i].getDomain().contains(this.cste)) continue;
            ++nbPos;
            if (!this.vars[i].isInstantiated() || this.vars[i].getVal() != this.cste) continue;
            ++nbSur;
        }
        if (this.constrainOnInfNumber & this.constrainOnSupNumber) {
            if (this.vars[nbVars].isInstantiated()) {
                if (nbPos == nbSur && nbPos == this.vars[nbVars].getVal()) {
                    return Boolean.TRUE;
                }
            } else if (nbPos < this.vars[nbVars].getInf() || nbSur > this.vars[nbVars].getSup()) {
                return Boolean.FALSE;
            }
        } else if (this.constrainOnInfNumber) {
            if (nbPos >= this.vars[nbVars].getSup()) {
                return Boolean.TRUE;
            }
            if (nbPos < this.vars[nbVars].getInf()) {
                return Boolean.FALSE;
            }
        } else {
            if (nbPos <= this.vars[nbVars].getInf()) {
                return Boolean.TRUE;
            }
            if (nbPos > this.vars[nbVars].getSup()) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String pretty() {
        String s = "occur([";
        for (int i = 0; i < this.vars.length - 2; ++i) {
            s = s + this.vars[i] + ",";
        }
        s = s + this.vars[this.vars.length - 2] + "], " + this.cste + ")";
        s = this.constrainOnInfNumber && this.constrainOnSupNumber ? s + " = " : (this.constrainOnInfNumber ? s + " >= " : s + " <= ");
        s = s + this.vars[this.vars.length - 1];
        return s;
    }
}

