/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.Arrays;
import java.util.Comparator;

public class LeximinSConstraint
extends AbstractLargeIntSConstraint {
    private IStateInt alpha;
    private IStateInt beta;
    private IStateInt gamma;
    private IStateInt delta;
    private IStateBitSet epsilon;
    private IStateInt[] floorx;
    private IStateInt[] ceily;
    private IStateInt[] sortedFloorx;
    private IStateInt[] sortedCeily;
    private int maximum;
    private int minimum;
    private int n;
    public boolean verbose = false;

    public LeximinSConstraint(IntVar[] x, IntVar[] y) {
        super(LeximinSConstraint.mergeIntVarArrays(x, y));
        if (x.length != y.length || x.length == 0 || y.length == 0) {
            throw new IllegalArgumentException("LeximinConstraint Error: the two vectors must be of the same (non zero) size");
        }
        this.n = x.length;
        this.solver = x[0].getSolver();
        this.alpha = this.solver.getEnvironment().makeInt();
        this.beta = this.solver.getEnvironment().makeInt();
        this.gamma = this.solver.getEnvironment().makeInt();
        this.delta = this.solver.getEnvironment().makeInt();
        this.epsilon = this.solver.getEnvironment().makeBitSet(4);
        this.generateVectors();
    }

    public LeximinSConstraint(IntDomainVar[] x) {
        super(x);
        if (x.length % 2 != 0 || x.length == 0) {
            throw new IllegalArgumentException("LeximinConstraint Error: the two vectors must be of the same (non zero) size");
        }
        this.n = x.length / 2;
        this.solver = x[0].getSolver();
        this.alpha = this.solver.getEnvironment().makeInt();
        this.beta = this.solver.getEnvironment().makeInt();
        this.gamma = this.solver.getEnvironment().makeInt();
        this.delta = this.solver.getEnvironment().makeInt();
        this.epsilon = this.solver.getEnvironment().makeBitSet(4);
        this.generateVectors();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    private static IntDomainVar[] mergeIntVarArrays(IntVar[] firstArray, IntVar[] secondArray) {
        int i;
        IntDomainVar[] newArray = new IntDomainVar[firstArray.length + secondArray.length];
        for (i = 0; i < firstArray.length; ++i) {
            newArray[i] = (IntDomainVar)firstArray[i];
        }
        for (i = 0; i < secondArray.length; ++i) {
            newArray[i + firstArray.length] = (IntDomainVar)secondArray[i];
        }
        return newArray;
    }

    private void generateVectors() {
        this.floorx = new IStateInt[this.n];
        this.ceily = new IStateInt[this.n];
        this.sortedFloorx = new IStateInt[this.n];
        this.sortedCeily = new IStateInt[this.n];
        int minimumX = Integer.MAX_VALUE;
        int minimumY = Integer.MAX_VALUE;
        int maximumX = 0;
        int maximumY = 0;
        for (int i = 0; i < this.n; ++i) {
            this.sortedFloorx[i] = this.solver.getEnvironment().makeInt(this.vars[i].getInf());
            this.floorx[i] = this.solver.getEnvironment().makeInt(this.vars[i].getInf());
            minimumX = minimumX > this.sortedFloorx[i].get() ? this.sortedFloorx[i].get() : minimumX;
            maximumX = maximumX < this.sortedFloorx[i].get() ? this.sortedFloorx[i].get() : maximumX;
            this.sortedCeily[i] = this.solver.getEnvironment().makeInt(this.vars[this.n + i].getSup());
            this.ceily[i] = this.solver.getEnvironment().makeInt(this.vars[this.n + i].getSup());
            minimumY = minimumY > this.sortedCeily[i].get() ? this.sortedCeily[i].get() : minimumY;
            maximumY = maximumY < this.sortedCeily[i].get() ? this.sortedCeily[i].get() : maximumY;
        }
        this.minimum = minimumX < minimumY ? minimumX : minimumY;
        this.maximum = maximumX > maximumY ? maximumX : maximumY;
        Arrays.sort(this.sortedFloorx, new SIComparator());
        Arrays.sort(this.sortedCeily, new SIComparator());
    }

    private void updateVectors(int idx) {
        if (idx < this.n) {
            int j;
            int oldValue = this.floorx[idx].get();
            int newValue = this.vars[idx].getInf();
            this.floorx[idx].set(newValue);
            int i = 0;
            while (this.sortedFloorx[i].get() < oldValue) {
                ++i;
            }
            for (j = i + 1; j < this.n && this.sortedFloorx[j].get() < newValue; ++j) {
                this.sortedFloorx[j - 1].set(this.sortedFloorx[j].get());
            }
            this.sortedFloorx[j - 1].set(newValue);
        } else {
            int j;
            int oldValue = this.ceily[idx - this.n].get();
            int newValue = this.vars[idx].getSup();
            this.ceily[idx - this.n].set(newValue);
            int i = this.n - 1;
            while (this.sortedCeily[i].get() > oldValue) {
                --i;
            }
            for (j = i - 1; j >= 0 && this.sortedCeily[j].get() > newValue; --j) {
                this.sortedCeily[j + 1].set(this.sortedCeily[j].get());
            }
            this.sortedCeily[j + 1].set(newValue);
        }
    }

    public void setPointersAndFlags() throws ContradictionException {
        int i;
        int l = this.minimum;
        int u = this.maximum;
        int currentX = 0;
        int currentY = 0;
        int currentOccX = 0;
        int currentOccY = 0;
        this.gamma.set(0);
        this.delta.set(0);
        this.alpha.set(l - 1);
        for (i = 0; i < 4; ++i) {
            this.epsilon.set(i, false);
        }
        if (this.verbose) {
            System.out.println("l = " + l + " / u = " + u);
        }
        while (this.alpha.get() <= u && currentOccX == currentOccY) {
            this.alpha.set(this.alpha.get() + 1);
            currentOccX = 0;
            while (currentX < this.sortedFloorx.length && this.sortedFloorx[currentX].get() == this.alpha.get()) {
                ++currentOccX;
                ++currentX;
            }
            currentOccY = 0;
            while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == this.alpha.get()) {
                ++currentOccY;
                ++currentY;
            }
            if (!this.verbose) continue;
            System.out.println("cX = " + currentX + " / cOX = " + currentOccX);
            System.out.println("cY = " + currentY + " / cOY = " + currentOccY);
        }
        if (this.alpha.get() <= u && currentOccX < currentOccY) {
            this.fail();
        }
        if (this.alpha.get() == u + 1) {
            this.fail();
        } else {
            if (currentOccX == currentOccY - 1) {
                this.epsilon.set(0, true);
            }
            if (currentOccX == currentOccY + 1) {
                this.epsilon.set(1, true);
            }
            this.beta.set(this.alpha.get());
            this.gamma.set(1);
            currentOccX = 0;
            currentOccY = 0;
            while (this.beta.get() <= u && currentOccX >= currentOccY) {
                if (currentOccX > currentOccY) {
                    this.gamma.set(0);
                }
                this.beta.set(this.beta.get() + 1);
                currentOccX = 0;
                while (currentX < this.sortedFloorx.length && this.sortedFloorx[currentX].get() == this.beta.get()) {
                    ++currentOccX;
                    ++currentX;
                }
                currentOccY = 0;
                while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == this.beta.get()) {
                    ++currentOccY;
                    ++currentY;
                }
            }
            if (this.beta.get() == u + 1) {
                this.beta.set(Integer.MAX_VALUE);
                this.gamma.set(0);
            }
            if (currentOccX == currentOccY - 1) {
                this.epsilon.set(2, true);
            }
            if (currentOccX == currentOccY + 1) {
                this.epsilon.set(3, true);
            }
            if (this.beta.get() < u) {
                i = this.beta.get();
                currentOccX = 0;
                currentOccY = 0;
                while (i <= u && currentOccX == currentOccY) {
                    ++i;
                    currentOccX = 0;
                    while (currentX < this.sortedFloorx.length && this.sortedFloorx[currentX].get() == i) {
                        ++currentOccX;
                        ++currentX;
                    }
                    currentOccY = 0;
                    while (currentY < this.sortedCeily.length && this.sortedCeily[currentY].get() == i) {
                        ++currentOccY;
                        ++currentY;
                    }
                }
                if (i <= u && currentOccX < currentOccY) {
                    this.delta.set(1);
                }
            }
        }
    }

    public void updatePointersAndFlags(int idx, boolean inf) throws ContradictionException {
    }

    private void gac() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int b;
            int a = this.vars[i].getInf();
            if (a < (b = this.vars[i].getSup())) {
                if (a < this.alpha.get()) {
                    this.vars[i].instantiate(a, this.cste);
                }
                if (a == this.alpha.get() && this.epsilon.get(1)) {
                    if (b >= this.beta.get() && this.gamma.get() > 0) {
                        if (this.epsilon.get(2)) {
                            if (this.delta.get() > 0) {
                                this.vars[i].updateSup(this.beta.get(), this.cIndices[i]);
                            } else {
                                this.vars[i].updateSup(this.beta.get(), this.cIndices[i]);
                            }
                        } else {
                            this.vars[i].updateSup(this.beta.get(), this.cIndices[i]);
                        }
                    } else {
                        this.vars[i].updateSup(this.beta.get(), this.cIndices[i]);
                    }
                }
            }
            if ((a = this.vars[this.n + i].getInf()) >= (b = this.vars[this.n + i].getSup())) continue;
            if (b <= this.alpha.get()) {
                this.vars[this.n + i].instantiate(b, this.cste);
            }
            if (this.alpha.get() < b && b < this.beta.get() && a <= this.alpha.get()) {
                this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
            }
            if (b == this.beta.get() && a <= this.alpha.get()) {
                if (this.epsilon.get(1)) {
                    if (this.gamma.get() > 0 && this.epsilon.get(2) && this.delta.get() > 0) {
                        this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
                    } else {
                        this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
                    }
                } else {
                    this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
                }
            }
            if (b <= this.beta.get() || a > this.alpha.get()) continue;
            if (this.epsilon.get(1)) {
                if (this.gamma.get() <= 0) continue;
                this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
                continue;
            }
            this.vars[this.n + i].updateInf(this.alpha.get(), this.cIndices[this.n + i]);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.n && this.vars[idx].getInf() > this.maximum) {
            this.maximum = this.vars[idx].getInf();
        }
        if (idx >= this.n && this.vars[idx].getSup() < this.minimum) {
            this.minimum = this.vars[idx].getSup();
        }
        this.updateVectors(idx);
        this.setPointersAndFlags();
        this.gac();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.n) {
            if (this.vars[idx].getInf() > this.maximum) {
                this.maximum = this.vars[idx].getInf();
            }
            this.updateVectors(idx);
            this.setPointersAndFlags();
            this.gac();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= this.n) {
            if (this.vars[idx].getSup() < this.minimum) {
                this.minimum = this.vars[idx].getSup();
            }
            this.updateVectors(idx);
            this.setPointersAndFlags();
            this.gac();
        }
    }

    @Override
    public boolean isSatisfied() {
        int i;
        IntDomainVar[] x = new IntDomainVar[this.n];
        IntDomainVar[] y = new IntDomainVar[this.n];
        for (i = 0; i < this.n; ++i) {
            x[i] = this.vars[i];
            y[i] = this.vars[this.n + i];
        }
        Arrays.sort(x, new IDVComparator());
        Arrays.sort(y, new IDVComparator());
        for (i = 0; i < this.n && x[i].getVal() >= y[i].getVal(); ++i) {
        }
        return i != this.n;
    }

    public String toString() {
        return "Leximin ordering constraint.";
    }

    @Override
    public String pretty() {
        IntDomainVar var;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Leximin({");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.vars[this.n + i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    public void printOccVectors() {
        int i;
        System.out.print("x = [");
        for (i = 0; i < this.sortedFloorx.length; ++i) {
            System.out.print(" " + this.vars[i].pretty());
        }
        System.out.print(" ]\n");
        System.out.print("y = [");
        for (i = 0; i < this.sortedCeily.length; ++i) {
            System.out.print(" " + this.vars[this.n + i].pretty());
        }
        System.out.print(" ]\n");
        System.out.print("sortedFloor(x) = [");
        for (i = 0; i < this.sortedFloorx.length; ++i) {
            System.out.print(" " + this.sortedFloorx[i].get());
        }
        System.out.print(" ]\n");
        System.out.print("sortedCeil(y) = [");
        for (i = 0; i < this.sortedCeily.length; ++i) {
            System.out.print(" " + this.sortedCeily[i].get());
        }
        System.out.print(" ]\n");
        System.out.print("floor(x) = [");
        for (i = 0; i < this.floorx.length; ++i) {
            System.out.print(" " + this.floorx[i].get());
        }
        System.out.print(" ]\n");
        System.out.print("ceil(y) = [");
        for (i = 0; i < this.ceily.length; ++i) {
            System.out.print(" " + this.ceily[i].get());
        }
        System.out.print(" ]\n");
        System.out.println("alpha = " + this.alpha.get());
        System.out.println("beta = " + this.beta.get());
        System.out.println("gamma = " + this.gamma.get());
        System.out.println("delta = " + this.delta.get());
        System.out.print("epsilon = [");
        for (i = 0; i < 4; ++i) {
            System.out.print(" " + this.epsilon.get(i));
        }
        System.out.print(" ]\n");
    }

    private static class SIComparator
    implements Comparator<IStateInt> {
        private SIComparator() {
        }

        @Override
        public int compare(IStateInt o1, IStateInt o2) throws ClassCastException {
            return o1.get() > o2.get() ? 1 : (o1.get() < o2.get() ? -1 : 0);
        }
    }

    private static class IDVComparator
    implements Comparator<IntDomainVar> {
        private IDVComparator() {
        }

        @Override
        public int compare(IntDomainVar o1, IntDomainVar o2) throws ClassCastException {
            return o1.getVal() > o2.getVal() ? 1 : (o1.getVal() < o2.getVal() ? -1 : 0);
        }
    }
}

