/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.layers.ExternalLayer;
import choco.cp.solver.constraints.global.geost.layers.GeometricKernel;
import choco.cp.solver.constraints.global.geost.layers.IntermediateLayer;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Vector;

public class Geost_Constraint
extends AbstractLargeIntSConstraint {
    int[] oIDs;
    Constants cst = new Constants();
    Setup stp = new Setup(this.cst);
    ExternalLayer externalLayer;
    GeometricKernel geometricKernel;
    IntermediateLayer intermediateLayer = new IntermediateLayer();
    protected Solver s;
    private int greedyMode = 0;
    Vector<int[]> ctrlVs;

    public Geost_Constraint(IntDomainVar[] vars, int k, Vector<Obj> objects, Vector<ShiftedBox> shiftedBoxes, Vector<ExternalConstraint> ectr, Vector<int[]> ctrlVs) {
        super(vars);
        this.externalLayer = new ExternalLayer(this.cst, this.stp);
        this.geometricKernel = new GeometricKernel(this.cst, this.stp, this.externalLayer, this.intermediateLayer);
        this.cst.setDIM(k);
        this.ctrlVs = ctrlVs;
        this.stp.SetupTheProblem(objects, shiftedBoxes, ectr);
        this.oIDs = new int[this.stp.getNbOfObjects()];
        for (int i = 0; i < this.stp.getNbOfObjects(); ++i) {
            this.oIDs[i] = objects.elementAt(i).getObjectId();
        }
        this.s = vars[0].getSolver();
        this.greedyMode = 1;
    }

    public Geost_Constraint(IntDomainVar[] vars, int k, Vector<Obj> objects, Vector<ShiftedBox> shiftedBoxes, Vector<ExternalConstraint> ectr) {
        super(vars);
        this.externalLayer = new ExternalLayer(this.cst, this.stp);
        this.geometricKernel = new GeometricKernel(this.cst, this.stp, this.externalLayer, this.intermediateLayer);
        this.cst.setDIM(k);
        this.stp.SetupTheProblem(objects, shiftedBoxes, ectr);
        this.oIDs = new int[this.stp.getNbOfObjects()];
        for (int i = 0; i < this.stp.getNbOfObjects(); ++i) {
            this.oIDs[i] = objects.elementAt(i).getObjectId();
        }
        this.s = vars[0].getSolver();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (this.vars[idx].hasEnumeratedDomain()) {
            return 4;
        }
        return 11;
    }

    public void filter() throws ContradictionException {
        if (this.greedyMode == 0) {
            this.filterWithoutGreedyMode();
        } else {
            this.filterWithGreedyMode();
        }
    }

    private void filterWithGreedyMode() throws ContradictionException {
        this.s.worldPush();
        if (!this.geometricKernel.FixAllObjs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints(), this.ctrlVs)) {
            this.s.worldPop();
            this.filterWithoutGreedyMode();
        } else {
            Solution sol = new Solution(this.s);
            for (IntDomainVar var : this.vars) {
                int idx = this.s.getIntVarIndex(var);
                if (idx == -1) continue;
                sol.recordIntValue(idx, var.getVal());
            }
            this.s.worldPop();
            this.s.restoreSolution(sol);
        }
    }

    private void filterWithoutGreedyMode() throws ContradictionException {
        if (!this.geometricKernel.FilterCtrs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints())) {
            this.fail();
        }
    }

    @Override
    public boolean isSatisfied() {
        boolean b = false;
        this.s.worldPushDuringPropagation();
        try {
            b = this.geometricKernel.FilterCtrs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints());
        }
        catch (ContradictionException e) {
            b = false;
        }
        this.s.worldPopDuringPropagation();
        return b;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public void awake() throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.constAwake(false);
    }

    public Constants getCst() {
        return this.cst;
    }

    public Setup getStp() {
        return this.stp;
    }

    public void setCst(Constants cst) {
        this.cst = cst;
    }

    public void setStp(Setup stp) {
        this.stp = stp;
    }
}

