/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoundGccVar
extends AbstractLargeIntSConstraint {
    int[] t;
    int[] d;
    int[] h;
    int[] bounds;
    int[] stableInterval;
    int[] potentialStableSets;
    int[] newMin;
    int offset = 0;
    int nbBounds;
    int nbVars;
    IntDomainVar[] card;
    Interval[] intervals;
    Interval[] minsorted;
    Interval[] maxsorted;
    PartialSum l;
    PartialSum u;
    boolean infBoundModified = true;
    boolean supBoundModified = true;
    int firstValue;
    int range;
    IStateInt[] val_maxOcc;
    IStateInt[] val_minOcc;

    public static IntDomainVar[] makeVarTable(IntDomainVar[] vars, IntDomainVar[] card) {
        if (card != null) {
            IntDomainVar[] allvars = new IntDomainVar[vars.length + card.length];
            System.arraycopy(vars, 0, allvars, 0, vars.length);
            System.arraycopy(card, 0, allvars, vars.length, card.length);
            return allvars;
        }
        return vars;
    }

    public BoundGccVar(IntDomainVar[] vars, IntDomainVar[] card, int firstDomainValue, int lastDomainValue) {
        super(BoundGccVar.makeVarTable(vars, card));
        this.card = card;
        this.build(vars.length, firstDomainValue, lastDomainValue);
    }

    public void build(int n, int firstDomainValue, int lastDomainValue) {
        int range = lastDomainValue - firstDomainValue + 1;
        this.nbVars = n;
        this.t = new int[2 * n + 2];
        this.d = new int[2 * n + 2];
        this.h = new int[2 * n + 2];
        this.bounds = new int[2 * n + 2];
        this.stableInterval = new int[2 * n + 2];
        this.potentialStableSets = new int[2 * n + 2];
        this.newMin = new int[n];
        this.intervals = new Interval[n];
        this.minsorted = new Interval[n];
        this.maxsorted = new Interval[n];
        for (int i = 0; i < this.nbVars; ++i) {
            this.intervals[i] = new Interval();
            this.intervals[i].var = this.vars[i];
            this.intervals[i].idx = i;
            this.minsorted[i] = this.intervals[i];
            this.maxsorted[i] = this.intervals[i];
        }
        this.offset = firstDomainValue;
        this.firstValue = firstDomainValue;
        this.range = range;
    }

    public int getMaxOcc(int i) {
        return this.card[i].getSup();
    }

    public int getMinOcc(int i) {
        return this.card[i].getInf();
    }

    public void updateSup(IntDomainVar v, int nsup, int idx) throws ContradictionException {
        v.updateSup(nsup, -1);
    }

    public void updateInf(IntDomainVar v, int ninf, int idx) throws ContradictionException {
        v.updateInf(ninf, -1);
    }

    protected void sortmin() {
        boolean sorted = false;
        int current = this.nbVars - 1;
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < current; ++i) {
                if (this.minsorted[i].var.getInf() <= this.minsorted[i + 1].var.getInf()) continue;
                Interval t = this.minsorted[i];
                this.minsorted[i] = this.minsorted[i + 1];
                this.minsorted[i + 1] = t;
                sorted = false;
            }
            --current;
        }
    }

    protected void sortmax() {
        boolean sorted = false;
        int current = 0;
        while (!sorted) {
            sorted = true;
            for (int i = this.nbVars - 1; i > current; --i) {
                if (this.maxsorted[i].var.getSup() >= this.maxsorted[i - 1].var.getSup()) continue;
                Interval t = this.maxsorted[i];
                this.maxsorted[i] = this.maxsorted[i - 1];
                this.maxsorted[i - 1] = t;
                sorted = false;
            }
            ++current;
        }
    }

    protected void sortIt() {
        this.sortmin();
        this.sortmax();
        int min = this.minsorted[0].var.getInf();
        int max = this.maxsorted[0].var.getSup() + 1;
        int last = this.l.firstValue + 1;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.nbVars && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.minsorted[i].minrank = nb;
                if (++i >= this.nbVars) continue;
                min = this.minsorted[i].var.getInf();
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.maxsorted[j].maxrank = nb;
            if (++j == this.nbVars) break;
            max = this.maxsorted[j].var.getSup() + 1;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.u.lastValue + 1;
    }

    protected void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    protected int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    protected int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    protected void filterLowerMax() throws ContradictionException {
        int i;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.t[i] = this.h[i] = i - 1;
            this.d[i] = this.u.sum(this.bounds[i - 1], this.bounds[i] - 1);
        }
        for (i = 0; i < this.nbVars; ++i) {
            int x = this.maxsorted[i].minrank;
            int y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.t, x + 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z + 1;
                z = this.pathmax(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x + 1, z, z);
            if (this.d[z] < this.u.sum(this.bounds[y], this.bounds[z] - 1)) {
                this.fail();
            }
            if (this.h[x] > x) {
                int w = this.pathmax(this.h, this.h[x]);
                this.updateInf(this.maxsorted[i].var, this.bounds[w], this.maxsorted[i].idx);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.u.sum(this.bounds[y], this.bounds[z] - 1)) continue;
            this.pathset(this.h, this.h[y], j - 1, y);
            this.h[y] = j - 1;
        }
    }

    protected void filterUpperMax() throws ContradictionException {
        int i;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.t[i] = this.h[i] = i + 1;
            this.d[i] = this.u.sum(this.bounds[i], this.bounds[this.h[i]] - 1);
        }
        i = this.nbVars;
        while (--i >= 0) {
            int x = this.minsorted[i].maxrank;
            int y = this.minsorted[i].minrank;
            int z = this.pathmin(this.t, x - 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z - 1;
                z = this.pathmin(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x - 1, z, z);
            if (this.d[z] < this.u.sum(this.bounds[z], this.bounds[y] - 1)) {
                this.fail();
            }
            if (this.h[x] < x) {
                int w = this.pathmin(this.h, this.h[x]);
                this.updateSup(this.minsorted[i].var, this.bounds[w] - 1, this.minsorted[i].idx);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.u.sum(this.bounds[z], this.bounds[y] - 1)) continue;
            this.pathset(this.h, this.h[y], j + 1, y);
            this.h[y] = j + 1;
        }
    }

    public void filterLowerMin() throws ContradictionException {
        int y;
        int x;
        int i;
        int w = i = this.nbBounds + 1;
        while (i > 0) {
            this.potentialStableSets[i] = this.stableInterval[i] = i - 1;
            this.d[i] = this.l.sum(this.bounds[i - 1], this.bounds[i] - 1);
            if (this.d[i] == 0) {
                this.h[i - 1] = w;
            } else {
                w = this.h[w] = i - 1;
            }
            --i;
        }
        for (i = w = this.nbBounds + 1; i >= 0; --i) {
            if (this.d[i] == 0) {
                this.t[i] = w;
                continue;
            }
            w = this.t[w] = i;
        }
        for (i = 0; i < this.nbVars; ++i) {
            int v;
            x = this.maxsorted[i].minrank;
            y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.t, x + 1);
            int j = this.t[z];
            if (z != x + 1) {
                w = this.pathmax(this.potentialStableSets, x + 1);
                v = this.potentialStableSets[w];
                this.pathset(this.potentialStableSets, x + 1, w, w);
                w = y < z ? y : z;
                this.pathset(this.potentialStableSets, this.potentialStableSets[w], v, w);
                this.potentialStableSets[w] = v;
            }
            if (this.d[z] <= this.l.sum(this.bounds[y], this.bounds[z] - 1)) {
                w = this.pathmax(this.stableInterval, this.potentialStableSets[y]);
                this.pathset(this.stableInterval, this.potentialStableSets[y], w, w);
                v = this.stableInterval[w];
                this.pathset(this.stableInterval, this.stableInterval[y], v, y);
                this.stableInterval[y] = v;
            } else {
                int n = z;
                this.d[n] = this.d[n] - 1;
                if (this.d[n] == 0) {
                    this.t[z] = z + 1;
                    z = this.pathmax(this.t, this.t[z]);
                    this.t[z] = j;
                }
                if (this.h[x] > x) {
                    w = this.newMin[i] = this.pathmax(this.h, x);
                    this.pathset(this.h, x, w, w);
                } else {
                    this.newMin[i] = x;
                }
                if (this.d[z] == this.l.sum(this.bounds[y], this.bounds[z] - 1)) {
                    if (this.h[y] > y) {
                        y = this.h[y];
                    }
                    this.pathset(this.h, this.h[y], j - 1, y);
                    this.h[y] = j - 1;
                }
            }
            this.pathset(this.t, x + 1, z, z);
        }
        if (this.h[this.nbBounds] != 0) {
            this.fail();
        }
        for (i = this.nbBounds + 1; i > 0; --i) {
            if (this.stableInterval[i] > i) {
                this.stableInterval[i] = w;
                continue;
            }
            w = i;
        }
        for (i = this.nbVars - 1; i >= 0; --i) {
            x = this.maxsorted[i].minrank;
            y = this.maxsorted[i].maxrank;
            if (this.stableInterval[x] > x && y <= this.stableInterval[x]) continue;
            this.updateInf(this.maxsorted[i].var, this.l.skipNonNullElementsRight(this.bounds[this.newMin[i]]), -1);
        }
    }

    public void filterUpperMin() throws ContradictionException {
        int y;
        int x;
        int i;
        int w = 0;
        int n = this.nbVars;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.d[i] = this.l.sum(this.bounds[i], this.bounds[i + 1] - 1);
            if (this.d[i] == 0) {
                this.t[i] = w;
                continue;
            }
            w = this.t[w] = i;
        }
        this.t[w] = i;
        w = 0;
        for (i = 1; i <= this.nbBounds; ++i) {
            if (this.d[i - 1] == 0) {
                this.h[i] = w;
                continue;
            }
            w = this.h[w] = i;
        }
        this.h[w] = i;
        for (i = n - 1; i >= 0; --i) {
            x = this.minsorted[i].maxrank;
            y = this.minsorted[i].minrank;
            int z = this.pathmin(this.t, x - 1);
            int j = this.t[z];
            if (this.d[z] > this.l.sum(this.bounds[z], this.bounds[y] - 1)) {
                int n2 = z;
                this.d[n2] = this.d[n2] - 1;
                if (this.d[n2] == 0) {
                    this.t[z] = z - 1;
                    z = this.pathmin(this.t, this.t[z]);
                    this.t[z] = j;
                }
                if (this.h[x] < x) {
                    this.newMin[i] = w = this.pathmin(this.h, this.h[x]);
                    this.pathset(this.h, x, w, w);
                } else {
                    this.newMin[i] = x;
                }
                if (this.d[z] == this.l.sum(this.bounds[z], this.bounds[y] - 1)) {
                    if (this.h[y] < y) {
                        y = this.h[y];
                    }
                    this.pathset(this.h, this.h[y], j + 1, y);
                    this.h[y] = j + 1;
                }
            }
            this.pathset(this.t, x - 1, z, z);
        }
        for (i = n - 1; i >= 0; --i) {
            x = this.minsorted[i].minrank;
            y = this.minsorted[i].maxrank;
            if (this.stableInterval[x] > x && y <= this.stableInterval[x]) continue;
            this.updateSup(this.minsorted[i].var, this.l.skipNonNullElementsLeft(this.bounds[this.newMin[i]] - 1), -1);
        }
    }

    public void initBackDataStruct() {
        this.val_maxOcc = new IStateInt[this.range];
        this.val_minOcc = new IStateInt[this.range];
        for (int i = 0; i < this.range; ++i) {
            this.val_maxOcc[i] = this.solver.getEnvironment().makeInt(0);
            this.val_minOcc[i] = this.solver.getEnvironment().makeInt(0);
            for (int j = 0; j < this.nbVars; ++j) {
                if (this.vars[j].canBeInstantiatedTo(i + this.offset)) {
                    this.val_maxOcc[i].add(1);
                }
                if (!this.vars[j].isInstantiatedTo(i + this.offset)) continue;
                this.val_minOcc[i].add(1);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.initBackDataStruct();
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiated()) continue;
            this.filterBCOnInst(this.vars[i].getVal());
        }
        this.propagate();
    }

    public void dynamicInitOfPartialSum() {
        int[] minOccurrences = new int[this.range];
        int[] maxOccurrences = new int[this.range];
        for (int i = 0; i < this.range; ++i) {
            maxOccurrences[i] = this.card[i].getSup();
            minOccurrences[i] = this.card[i].getInf();
        }
        this.l = new PartialSum(this.firstValue, this.range, minOccurrences);
        this.u = new PartialSum(this.firstValue, this.range, maxOccurrences);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.propagateSumCard();
        this.dynamicInitOfPartialSum();
        this.sortIt();
        assert (this.l.minValue() == this.u.minValue());
        assert (this.l.maxValue() == this.u.maxValue());
        assert (this.l.minValue() <= this.minsorted[0].var.getInf());
        assert (this.maxsorted[this.nbVars - 1].var.getSup() <= this.u.maxValue());
        if (this.l.sum(this.l.minValue(), this.minsorted[0].var.getInf() - 1) > 0 || this.l.sum(this.maxsorted[this.nbVars - 1].var.getSup() + 1, this.l.maxValue()) > 0) {
            this.fail();
        }
        this.filterLowerMax();
        this.filterLowerMin();
        this.filterUpperMax();
        this.filterUpperMin();
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        this.constAwake(false);
        if (i < this.nbVars && !this.vars[i].hasEnumeratedDomain()) {
            this.filterBCOnInf(i);
        }
    }

    public void filterBCOnInf(int i) throws ContradictionException {
        int inf = this.vars[i].getInf();
        int nbInf = this.val_minOcc[inf - this.offset].get();
        if (this.vars[i].isInstantiatedTo(inf)) {
            --nbInf;
        }
        if (nbInf == this.getMaxOcc(inf - this.offset)) {
            this.vars[i].updateInf(inf + 1, -1);
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        this.constAwake(false);
        if (i < this.nbVars && !this.vars[i].hasEnumeratedDomain()) {
            this.filterBCOnSup(i);
        }
    }

    public void filterBCOnSup(int i) throws ContradictionException {
        int sup = this.vars[i].getSup();
        int nbSup = this.val_minOcc[sup - this.offset].get();
        if (this.vars[i].isInstantiatedTo(sup)) {
            --nbSup;
        }
        if (nbSup == this.getMaxOcc(sup - this.offset)) {
            this.vars[i].updateSup(sup - 1, -1);
        }
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        int val = this.vars[i].getVal();
        this.constAwake(false);
        if (i < this.nbVars) {
            this.val_minOcc[val - this.offset].add(1);
            this.card[val - this.offset].updateInf(this.val_minOcc[val - this.offset].get(), this.cIndices[this.nbVars + val - this.offset]);
            this.filterBCOnInst(val);
        } else {
            this.filterBCOnInst(i - this.nbVars + this.offset);
        }
    }

    public void filterBCOnInst(int val) throws ContradictionException {
        int nbvalsure = this.val_minOcc[val - this.offset].get();
        if (nbvalsure > this.getMaxOcc(val - this.offset)) {
            this.fail();
        } else if (nbvalsure == this.getMaxOcc(val - this.offset)) {
            for (int j = 0; j < this.nbVars; ++j) {
                if (this.vars[j].isInstantiatedTo(val)) continue;
                this.vars[j].removeVal(val, -1);
            }
        }
    }

    public void filterBCOnRem(int val) throws ContradictionException {
        int nbpos = this.val_maxOcc[val - this.offset].get();
        if (nbpos < this.getMinOcc(val - this.offset)) {
            this.fail();
        } else if (nbpos == this.getMinOcc(val - this.offset)) {
            for (int j = 0; j < this.nbVars; ++j) {
                if (!this.vars[j].canBeInstantiatedTo(val)) continue;
                this.vars[j].instantiate(val, -1);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int i) throws ContradictionException {
        if (idx < this.nbVars) {
            this.val_maxOcc[i - this.offset].add(-1);
            this.card[i - this.offset].updateSup(this.val_maxOcc[i - this.offset].get(), -1);
        }
    }

    public void propagateSumCard() throws ContradictionException {
        boolean fixpoint = true;
        while (fixpoint) {
            int i;
            fixpoint = false;
            int lb = 0;
            int ub = 0;
            for (i = 0; i < this.range; ++i) {
                lb += this.card[i].getInf();
                ub += this.card[i].getSup();
            }
            for (i = 0; i < this.range; ++i) {
                fixpoint |= this.card[i].updateSup(this.nbVars - (lb - this.card[i].getInf()), this.cIndices[i + this.nbVars]);
                fixpoint |= this.card[i].updateInf(this.nbVars - (ub - this.card[i].getSup()), this.cIndices[i + this.nbVars]);
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int[] occurrences = new int[this.range];
        for (i = 0; i < this.nbVars; ++i) {
            int n = tuple[i] - this.offset;
            occurrences[n] = occurrences[n] + 1;
        }
        for (i = 0; i < occurrences.length; ++i) {
            int occurrence = occurrences[i];
            if (tuple[this.nbVars + i] == occurrence) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("BoundGcc({");
        for (i = 0; i < this.nbVars; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.range; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("#").append(this.offset + i).append(" = ").append(this.vars[this.nbVars + i].pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on package choco.kernel.solver.constraints.global.BoundAlldiff");
    }

    protected static class PartialSum {
        int[] sum;
        int[] ds;
        int firstValue;
        int lastValue;

        public PartialSum(int firstValue, int count, int[] elt) {
            int i;
            this.sum = new int[count + 5];
            this.firstValue = firstValue - 3;
            this.lastValue = firstValue + count + 1;
            this.sum[0] = 0;
            this.sum[1] = 1;
            this.sum[2] = 2;
            for (i = 2; i < count + 2; ++i) {
                this.sum[i + 1] = this.sum[i] + elt[i - 2];
            }
            this.sum[i + 1] = this.sum[i] + 1;
            this.sum[i + 2] = this.sum[i + 1] + 1;
            this.ds = new int[count + 5];
            i = count + 3;
            int j = i + 1;
            while (i > 0) {
                while (this.sum[i] == this.sum[i - 1]) {
                    this.ds[i--] = j;
                }
                this.ds[j] = i--;
                j = this.ds[j];
            }
            this.ds[j] = 0;
        }

        public int sum(int from, int to) {
            if (from <= to) {
                return this.sum[to - this.firstValue] - this.sum[from - this.firstValue - 1];
            }
            return this.sum[to - this.firstValue - 1] - this.sum[from - this.firstValue];
        }

        public int minValue() {
            return this.firstValue + 3;
        }

        public int maxValue() {
            return this.lastValue - 2;
        }

        public int skipNonNullElementsRight(int value) {
            return (this.ds[value -= this.firstValue] < value ? value : this.ds[value]) + this.firstValue;
        }

        public int skipNonNullElementsLeft(int value) {
            return (this.ds[value -= this.firstValue] > value ? this.ds[this.ds[value]] : value) + this.firstValue;
        }
    }

    protected static class Interval {
        int minrank;
        int maxrank;
        IntDomainVar var;
        int idx;

        protected Interval() {
        }
    }
}

