/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.cp.solver.constraints.global.BoundGccVar;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoundGcc
extends BoundGccVar {
    protected int[] maxOccurrences;
    protected int[] minOccurrences;

    public BoundGcc(IntDomainVar[] vars, int firstDomainValue, int lastDomainValue, int[] minOccurrences, int[] maxOccurrences) {
        super(vars, null, firstDomainValue, lastDomainValue);
        this.maxOccurrences = maxOccurrences;
        this.minOccurrences = minOccurrences;
        this.l = new BoundGccVar.PartialSum(firstDomainValue, this.range, minOccurrences);
        this.u = new BoundGccVar.PartialSum(firstDomainValue, this.range, maxOccurrences);
    }

    @Override
    public int getMaxOcc(int i) {
        return this.maxOccurrences[i];
    }

    @Override
    public int getMinOcc(int i) {
        return this.minOccurrences[i];
    }

    @Override
    public void updateSup(IntDomainVar v, int nsup, int idx) throws ContradictionException {
        v.updateSup(nsup, -1);
    }

    @Override
    public void updateInf(IntDomainVar v, int ninf, int idx) throws ContradictionException {
        v.updateInf(ninf, -1);
    }

    @Override
    public void awake() throws ContradictionException {
        int i;
        this.initBackDataStruct();
        for (i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiated()) continue;
            this.filterBCOnInst(this.vars[i].getVal());
        }
        for (i = 0; i < this.nbVars; ++i) {
            for (int val = this.vars[i].getInf() + 1; val < this.vars[i].getSup(); ++val) {
                if (this.vars[i].canBeInstantiatedTo(val)) continue;
                this.filterBCOnRem(val);
            }
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.sortIt();
        assert (this.l.minValue() == this.u.minValue());
        assert (this.l.maxValue() == this.u.maxValue());
        assert (this.l.minValue() <= this.minsorted[0].var.getInf());
        assert (this.maxsorted[this.nbVars - 1].var.getSup() <= this.u.maxValue());
        if (this.l.sum(this.l.minValue(), this.minsorted[0].var.getInf() - 1) > 0 || this.l.sum(this.maxsorted[this.getNbVars() - 1].var.getSup() + 1, this.l.maxValue()) > 0) {
            this.fail();
        }
        this.filterLowerMax();
        this.filterLowerMin();
        this.filterUpperMax();
        this.filterUpperMin();
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        this.constAwake(false);
        if (!this.vars[i].hasEnumeratedDomain()) {
            this.filterBCOnInf(i);
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        this.constAwake(false);
        if (!this.vars[i].hasEnumeratedDomain()) {
            this.filterBCOnSup(i);
        }
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        int val = this.vars[i].getVal();
        this.constAwake(false);
        this.val_minOcc[val - this.offset].add(1);
        this.filterBCOnInst(val);
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        this.val_maxOcc[val - this.offset].add(-1);
        this.filterBCOnRem(val);
    }

    @Override
    public boolean isSatisfied() {
        int i;
        int[] occurrences = new int[this.range];
        for (i = 0; i < this.vars.length; ++i) {
            IntDomainVar var = this.vars[i];
            int n = var.getVal() - this.offset;
            occurrences[n] = occurrences[n] + 1;
        }
        for (i = 0; i < occurrences.length; ++i) {
            int occurrence = occurrences[i];
            if (this.minOccurrences[i] <= occurrence && occurrence <= this.maxOccurrences[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("BoundGcc({");
        for (i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.minOccurrences.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            int minOccurrence = this.minOccurrences[i];
            int maxOccurrence = this.maxOccurrences[i];
            sb.append(minOccurrence).append(" <= #").append(this.offset + i).append(" <= ").append(maxOccurrence);
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on package choco.kernel.solver.constraints.global.BoundAlldiff");
    }
}

