/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoundAllDiff
extends AbstractLargeIntSConstraint {
    public boolean PROPAGATE_ON_INSTANTIATIONS = true;
    public boolean PROPAGATE_ON_BOUNDS = true;
    int[] t;
    int[] d;
    int[] h;
    int[] bounds;
    int nbBounds;
    Interval[] intervals;
    Interval[] minsorted;
    Interval[] maxsorted;
    boolean infBoundModified = true;
    boolean supBoundModified = true;

    public BoundAllDiff(IntDomainVar[] vars, boolean global) {
        super(vars);
        int n = this.getNbVars();
        if (!global) {
            this.PROPAGATE_ON_BOUNDS = false;
        }
        this.t = new int[2 * n + 2];
        this.d = new int[2 * n + 2];
        this.h = new int[2 * n + 2];
        this.bounds = new int[2 * n + 2];
        this.intervals = new Interval[n];
        this.minsorted = new Interval[n];
        this.maxsorted = new Interval[n];
        for (int i = 0; i < vars.length; ++i) {
            this.intervals[i] = new Interval();
            this.intervals[i].var = vars[i];
            this.intervals[i].idx = i;
            this.minsorted[i] = this.intervals[i];
            this.maxsorted[i] = this.intervals[i];
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    protected void sortmin() {
        boolean sorted = false;
        int current = this.getNbVars() - 1;
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < current; ++i) {
                if (this.minsorted[i].var.getInf() <= this.minsorted[i + 1].var.getInf()) continue;
                Interval t = this.minsorted[i];
                this.minsorted[i] = this.minsorted[i + 1];
                this.minsorted[i + 1] = t;
                sorted = false;
            }
            --current;
        }
    }

    protected void sortmax() {
        boolean sorted = false;
        int current = 0;
        while (!sorted) {
            sorted = true;
            for (int i = this.getNbVars() - 1; i > current; --i) {
                if (this.maxsorted[i].var.getSup() >= this.maxsorted[i - 1].var.getSup()) continue;
                Interval t = this.maxsorted[i];
                this.maxsorted[i] = this.maxsorted[i - 1];
                this.maxsorted[i - 1] = t;
                sorted = false;
            }
            ++current;
        }
    }

    protected void sortIt() {
        this.sortmin();
        this.sortmax();
        int min = this.minsorted[0].var.getInf();
        int max = this.maxsorted[0].var.getSup() + 1;
        int last = min - 2;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.getNbVars() && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.minsorted[i].minrank = nb;
                if (++i >= this.getNbVars()) continue;
                min = this.minsorted[i].var.getInf();
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.maxsorted[j].maxrank = nb;
            if (++j == this.getNbVars()) break;
            max = this.maxsorted[j].var.getSup() + 1;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.bounds[nb] + 2;
    }

    protected void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    protected int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    protected int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    protected void filterLower() throws ContradictionException {
        int i;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.t[i] = this.h[i] = i - 1;
            this.d[i] = this.bounds[i] - this.bounds[i - 1];
        }
        for (i = 0; i < this.getNbVars(); ++i) {
            int x = this.maxsorted[i].minrank;
            int y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.t, x + 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z + 1;
                z = this.pathmax(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x + 1, z, z);
            if (this.d[z] < this.bounds[z] - this.bounds[y]) {
                this.fail();
            }
            if (this.h[x] > x) {
                int w = this.pathmax(this.h, this.h[x]);
                this.maxsorted[i].var.updateInf(this.bounds[w], this.getConstraintIdx(this.maxsorted[i].idx));
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[z] - this.bounds[y]) continue;
            this.pathset(this.h, this.h[y], j - 1, y);
            this.h[y] = j - 1;
        }
    }

    protected void filterUpper() throws ContradictionException {
        int i;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.t[i] = this.h[i] = i + 1;
            this.d[i] = this.bounds[i + 1] - this.bounds[i];
        }
        for (i = this.getNbVars() - 1; i >= 0; --i) {
            int x = this.minsorted[i].maxrank;
            int y = this.minsorted[i].minrank;
            int z = this.pathmin(this.t, x - 1);
            int j = this.t[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.t[z] = z - 1;
                z = this.pathmin(this.t, this.t[z]);
                this.t[z] = j;
            }
            this.pathset(this.t, x - 1, z, z);
            if (this.d[z] < this.bounds[y] - this.bounds[z]) {
                this.fail();
            }
            if (this.h[x] < x) {
                int w = this.pathmin(this.h, this.h[x]);
                this.minsorted[i].var.updateSup(this.bounds[w] - 1, this.getConstraintIdx(this.minsorted[i].idx));
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.bounds[y] - this.bounds[z]) continue;
            this.pathset(this.h, this.h[y], j + 1, y);
            this.h[y] = j + 1;
        }
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiated()) continue;
            for (int j = 0; j < this.vars.length; ++j) {
                if (i == j) continue;
                this.vars[j].removeVal(this.vars[i].getVal(), -1);
            }
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.infBoundModified || this.supBoundModified) {
            this.sortIt();
            this.filterLower();
            this.filterUpper();
            this.infBoundModified = false;
            this.supBoundModified = false;
        }
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        if (this.PROPAGATE_ON_BOUNDS) {
            this.infBoundModified = true;
            this.constAwake(false);
            for (int j = 0; j < this.vars.length; ++j) {
                if (j == i || !this.vars[j].isInstantiated() || this.vars[j].getVal() != this.vars[i].getInf()) continue;
                this.vars[i].updateInf(this.vars[j].getVal() + 1, -1);
            }
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        if (this.PROPAGATE_ON_BOUNDS) {
            this.supBoundModified = true;
            this.constAwake(false);
            for (int j = 0; j < this.vars.length; ++j) {
                if (j == i || !this.vars[j].isInstantiated() || this.vars[j].getVal() != this.vars[i].getSup()) continue;
                this.vars[i].updateSup(this.vars[j].getVal() - 1, -1);
            }
        }
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        if (this.PROPAGATE_ON_INSTANTIATIONS) {
            this.infBoundModified = true;
            this.supBoundModified = true;
            this.constAwake(false);
            int val = this.vars[i].getVal();
            for (int j = 0; j < this.vars.length; ++j) {
                if (j == i) continue;
                this.getIntVar(j).removeVal(val, -1);
            }
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on package choco.kernel.solver.constraints.global.BoundAlldiff");
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.vars.length; ++i) {
            for (int j = i + 1; j < this.vars.length; ++j) {
                if (tuple[i] != tuple[j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("BoundAllDiff({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public int getFineDegree(int idx) {
        return this.vars.length - 1;
    }

    private static class Interval {
        int minrank;
        int maxrank;
        IntDomainVar var;
        int idx;

        private Interval() {
        }
    }
}

