/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.IntList;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;

public class AtMostNValue
extends AbstractLargeIntSConstraint {
    protected static boolean debug = false;
    protected BitSet gval;
    protected int nGval;
    protected IntList freeVars;
    protected IntList dVar;
    protected BitSet[] ngraph;
    protected int[] ngraphSize;
    protected int maxDSize;
    protected int nVars;

    public static IntDomainVar[] makeVarTable(IntDomainVar[] vars, IntDomainVar Nvalue) {
        IntDomainVar[] vs = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, vs, 0, vars.length);
        vs[vars.length] = Nvalue;
        return vs;
    }

    public AtMostNValue(IntDomainVar[] vars, IntDomainVar Nvalue) {
        super(AtMostNValue.makeVarTable(vars, Nvalue));
        this.cste = Integer.MAX_VALUE;
        this.maxDSize = 0;
        for (IntDomainVar v : vars) {
            if (this.cste > v.getInf()) {
                this.cste = v.getInf();
            }
            if (this.maxDSize <= v.getSup() - v.getInf() + 1) continue;
            this.maxDSize = v.getSup() - v.getInf() + 1;
        }
        this.cste = -this.cste;
        this.gval = new BitSet(this.maxDSize);
        this.dVar = new IntList(vars.length);
        this.freeVars = new IntList(vars.length);
        this.ngraph = new BitSet[vars.length];
        this.ngraphSize = new int[vars.length];
        for (int i = 0; i < this.ngraph.length; ++i) {
            this.ngraph[i] = new BitSet(vars.length);
        }
        this.nVars = vars.length;
    }

    public void restrict(int db, IntDomainVar v, BitSet allowvalues) throws ContradictionException {
        int offset = v.getInf();
        BitSet allowedDomain = allowvalues.get(v.getInf() + this.cste, v.getSup() + this.cste + 1);
        int newInf = allowedDomain.nextSetBit(0) + offset;
        int newSup = allowedDomain.length() + offset;
        if (debug) {
            System.out.println(db + " updateInf " + newInf + " of " + v);
        }
        v.updateInf(newInf, -1);
        v.updateSup(newSup, -1);
        if (v.hasEnumeratedDomain()) {
            IntDomain dom = v.getDomain();
            DisposableIntIterator it = dom.getIterator();
            while (it.hasNext()) {
                int val = it.next();
                if (allowedDomain.get(val - offset)) continue;
                if (debug) {
                    System.out.println("2 remove value " + val + " from " + v);
                }
                v.removeVal(val, -1);
            }
            it.dispose();
        }
    }

    public boolean emptyIntersectionWithGval(IntDomainVar v) {
        DisposableIntIterator vdom = v.getDomain().getIterator();
        while (vdom.hasNext()) {
            if (!this.gval.get(vdom.next() + this.cste)) continue;
            return false;
        }
        return true;
    }

    public BitSet intersectionDomains() {
        if (this.dVar.getSize() > 0) {
            LinkedList<Integer> inter = new LinkedList<Integer>();
            DisposableIntIterator vdom = this.vars[this.dVar.getFirst()].getDomain().getIterator();
            while (vdom.hasNext()) {
                inter.add(vdom.next());
            }
            IntIterator intIt = this.dVar.iterator();
            while (intIt.hasNext()) {
                IntDomainVar v = this.vars[intIt.next()];
                Iterator it = inter.iterator();
                while (it.hasNext()) {
                    if (v.canBeInstantiatedTo((Integer)it.next())) continue;
                    it.remove();
                }
            }
            BitSet interDvar = new BitSet(this.maxDSize);
            for (Integer i : inter) {
                interDvar.set(i + this.cste);
            }
            return interDvar;
        }
        return new BitSet();
    }

    public boolean basicPruning() throws ContradictionException {
        this.nGval = 0;
        this.gval.clear();
        this.dVar.reInit();
        this.freeVars.reInit();
        for (int i = 0; i < this.nVars; ++i) {
            IntDomainVar v = this.vars[i];
            if (v.isInstantiated()) {
                if (!this.gval.get(v.getVal() + this.cste)) {
                    ++this.nGval;
                }
                this.gval.set(v.getVal() + this.cste);
                continue;
            }
            this.freeVars.add(i);
        }
        this.vars[this.nVars].updateInf(this.nGval, this.cIndices[this.nVars]);
        int K = this.vars[this.vars.length - 1].getSup() - this.nGval;
        if (K == 0) {
            this.pruningK0();
            return false;
        }
        if (this.nGval == 0) {
            this.dVar = this.freeVars.copy();
        } else {
            IntIterator intIt = this.freeVars.iterator();
            while (intIt.hasNext()) {
                int i = intIt.next();
                if (!this.emptyIntersectionWithGval(this.vars[i])) continue;
                this.dVar.add(i);
            }
        }
        if (K == 1) {
            if (this.dVar.getSize() > 0) {
                this.pruningK1();
            }
            return false;
        }
        return true;
    }

    public void pruningK0() throws ContradictionException {
        IntIterator intIt = this.freeVars.iterator();
        while (intIt.hasNext()) {
            int i = intIt.next();
            this.restrict(1, this.vars[i], this.gval);
        }
    }

    public void pruningK1() throws ContradictionException {
        BitSet interDvar = this.intersectionDomains();
        interDvar.or(this.gval);
        IntIterator intIt = this.freeVars.iterator();
        while (intIt.hasNext()) {
            int i = intIt.next();
            this.restrict(2, this.vars[i], interDvar);
        }
    }

    public void MDPruning() throws ContradictionException {
        if (this.basicPruning() && this.nGval + this.dVar.getSize() >= this.vars[this.nVars].getSup()) {
            LinkedList<IntDomainVar> A = new LinkedList<IntDomainVar>();
            this.computeNeighborsGraph();
            while (this.dVar.getSize() > 0) {
                int next;
                int min = Integer.MAX_VALUE;
                int y = -1;
                IntIterator intIt = this.dVar.iterator();
                while (intIt.hasNext()) {
                    next = intIt.next();
                    if (min < this.ngraph[next].size()) continue;
                    min = this.ngraph[next].size();
                    y = next;
                }
                intIt = this.dVar.iterator();
                while (intIt.hasNext()) {
                    next = intIt.next();
                    if (next != y && !this.ngraph[y].get(next)) continue;
                    intIt.remove();
                }
                A.add(this.vars[y]);
            }
            int lb = A.size() + this.nGval;
            this.vars[this.nVars].updateInf(lb, this.cIndices[this.nVars]);
            if (lb == this.vars[this.nVars].getSup()) {
                this.pruning(A);
            }
        }
    }

    public void computeNeighborsGraph() {
        for (int i = 0; i < this.ngraph.length; ++i) {
            this.ngraph[i].clear();
            this.ngraphSize[i] = 0;
        }
        IntIterator intIt = this.dVar.iterator();
        while (intIt.hasNext()) {
            int j;
            int i = intIt.next();
            IntIterator intIt2 = this.dVar.iterator();
            while (intIt2.hasNext() && i > (j = intIt2.next())) {
                if (!this.vars[i].canBeEqualTo(this.vars[j])) continue;
                this.ngraph[i].set(j);
                this.ngraph[j].set(i);
                int n = i;
                this.ngraphSize[n] = this.ngraphSize[n] + 1;
                int n2 = j;
                this.ngraphSize[n2] = this.ngraphSize[n2] + 1;
            }
        }
    }

    public void pruning(LinkedList<IntDomainVar> A) throws ContradictionException {
        BitSet unionOfAllowedValue = this.gval;
        for (IntDomainVar x : A) {
            DisposableIntIterator it = x.getDomain().getIterator();
            while (it.hasNext()) {
                int value = it.next();
                unionOfAllowedValue.set(value + this.cste);
            }
        }
        IntIterator intIt = this.freeVars.iterator();
        while (intIt.hasNext()) {
            int i = intIt.next();
            this.restrict(3, this.vars[i], unionOfAllowedValue);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (debug) {
            System.out.println("inf " + this.vars[idx] + " to " + this.vars[idx].getInf());
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (debug) {
            System.out.println("instantiate " + this.vars[idx] + " to " + this.vars[idx].getVal());
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (debug) {
            System.out.println("sup " + this.vars[idx] + " to " + this.vars[idx].getSup());
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (debug) {
            while (deltaDomain.hasNext()) {
                System.out.println("remove from " + this.vars[idx] + " value " + deltaDomain.next());
            }
        }
        this.constAwake(false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.MDPruning();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        BitSet b = new BitSet();
        int nval = 0;
        for (int i = 0; i < this.nVars; ++i) {
            int val = tuple[i];
            if (b.get(val)) continue;
            ++nval;
            b.set(val);
        }
        return nval <= tuple[this.nVars];
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AtMostNValue({");
        for (int i = 0; i < this.vars.length - 1; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}, ").append(this.vars[this.vars.length - 1]).append(")");
        return sb.toString();
    }
}

