/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ConstantSConstraint
extends AbstractIntSConstraint
implements IntSConstraint {
    private boolean satisfied;

    public ConstantSConstraint(boolean value) {
        super(0);
        this.satisfied = value;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int getNbVars() {
        return 0;
    }

    @Override
    public Var getVar(int i) {
        return null;
    }

    @Override
    public IntDomainVar getIntVar(int i) {
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.satisfied;
    }

    @Override
    public void setVar(int i, Var v) {
        throw new SolverException("BUG in CSP network management: too large index for setVar");
    }

    @Override
    public boolean isCompletelyInstantiated() {
        return true;
    }

    @Override
    public boolean isSatisfied() {
        return this.satisfied;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (!this.satisfied) {
            this.fail();
        }
    }

    @Override
    public boolean isConsistent() {
        return this.satisfied;
    }

    @Override
    public void setConstraintIndex(int i, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getConstraintIdx(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean isEntailed() {
        return this.satisfied ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public AbstractSConstraint opposite() {
        return new ConstantSConstraint(!this.satisfied);
    }

    @Override
    public String pretty() {
        return "Constant constraint: " + this.isSatisfied();
    }
}

