/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints;

import choco.cp.solver.SettingType;
import java.util.Set;

public final class BitFlags {
    private long flags;

    public BitFlags() {
        this.flags = 0L;
    }

    public BitFlags(BitFlags toCopy) {
        this.flags = toCopy.flags;
    }

    public long getValue() {
        return this.flags;
    }

    public void clear() {
        this.flags = 0L;
    }

    public boolean isEmpty() {
        return this.flags == 0L;
    }

    public boolean contains(long mask) {
        return (this.flags & mask) == mask;
    }

    public boolean or(SettingType ... settings) {
        for (SettingType setting : settings) {
            if (!this.contains(setting)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(SettingType setting) {
        return this.contains(setting.getBitMask());
    }

    public void set(long mask) {
        this.flags |= mask;
    }

    public void toggle(long mask) {
        this.flags ^= mask;
    }

    public void unset(long mask) {
        this.flags &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void read(Set<String> options, SettingType ... settings) {
        for (SettingType setting : settings) {
            if (!options.contains(setting.getOptionName())) continue;
            this.set(setting);
        }
    }

    public void set(BitFlags f) {
        this.set(f.getValue());
    }

    public void unset(SettingType ... settings) {
        for (SettingType setting : settings) {
            this.unset(setting.getBitMask());
        }
    }

    public void set(SettingType ... settings) {
        for (SettingType setting : settings) {
            this.set(setting.getBitMask());
        }
    }

    public String toSettingsString() {
        StringBuilder b = new StringBuilder();
        for (SettingType setting : SettingType.values()) {
            if (!this.contains(setting)) continue;
            b.append(setting.getName()).append(" ");
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return new String(b);
    }

    public String toSettingsLabels() {
        StringBuilder b = new StringBuilder();
        for (SettingType setting : SettingType.values()) {
            if (!this.contains(setting)) continue;
            b.append(setting.getLabel()).append("-");
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return new String(b);
    }

    public String toString() {
        return String.valueOf(this.flags);
    }
}

