/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPModelToCPSolver;
import choco.cp.solver.constraints.ConstantSConstraint;
import choco.cp.solver.constraints.global.Occurrence;
import choco.cp.solver.constraints.global.scheduling.SchedulerConfig;
import choco.cp.solver.constraints.integer.EqualXC;
import choco.cp.solver.constraints.integer.EqualXYC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXYC;
import choco.cp.solver.constraints.integer.IntLinComb;
import choco.cp.solver.constraints.integer.LessOrEqualXC;
import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.cp.solver.constraints.integer.NotEqualXC;
import choco.cp.solver.constraints.integer.NotEqualXYC;
import choco.cp.solver.constraints.integer.NotEqualXYCEnum;
import choco.cp.solver.constraints.integer.bool.BoolIntLinComb;
import choco.cp.solver.constraints.integer.bool.BoolSum;
import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.cp.solver.constraints.integer.channeling.ReifiedIntSConstraint;
import choco.cp.solver.constraints.integer.extension.AC2001BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBitBinSConstraint;
import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001LargeSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001PositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmPositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GACstrPositiveLargeSConstraint;
import choco.cp.solver.constraints.real.Equation;
import choco.cp.solver.constraints.real.MixedEqXY;
import choco.cp.solver.constraints.real.exp.RealCos;
import choco.cp.solver.constraints.real.exp.RealIntegerPower;
import choco.cp.solver.constraints.real.exp.RealMinus;
import choco.cp.solver.constraints.real.exp.RealMult;
import choco.cp.solver.constraints.real.exp.RealPlus;
import choco.cp.solver.constraints.real.exp.RealSin;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.set.Disjoint;
import choco.cp.solver.constraints.set.IsIncluded;
import choco.cp.solver.constraints.set.MemberXY;
import choco.cp.solver.constraints.set.SetCard;
import choco.cp.solver.constraints.set.SetEq;
import choco.cp.solver.constraints.set.SetIntersection;
import choco.cp.solver.constraints.set.SetNotEq;
import choco.cp.solver.constraints.set.SetUnion;
import choco.cp.solver.goals.GoalSearchSolver;
import choco.cp.solver.propagation.ChocEngine;
import choco.cp.solver.search.BranchAndBound;
import choco.cp.solver.search.GlobalSearchStrategy;
import choco.cp.solver.search.OptimizeWithRestarts;
import choco.cp.solver.search.SearchLoopWithRecomputation;
import choco.cp.solver.search.SearchLoopWithRestart;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.cp.solver.search.integer.branching.DomOverWDegBranching;
import choco.cp.solver.search.integer.branching.ImpactBasedBranching;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.RandomIntVarSelector;
import choco.cp.solver.search.limit.BackTrackLimit;
import choco.cp.solver.search.limit.CpuTimeLimit;
import choco.cp.solver.search.limit.FailLimit;
import choco.cp.solver.search.limit.NodeLimit;
import choco.cp.solver.search.limit.TimeLimit;
import choco.cp.solver.search.real.AbstractRealOptimize;
import choco.cp.solver.search.real.AssignInterval;
import choco.cp.solver.search.real.CyclicRealVarSelector;
import choco.cp.solver.search.real.RealBranchAndBound;
import choco.cp.solver.search.real.RealIncreasingDomain;
import choco.cp.solver.search.real.RealOptimizeWithRestarts;
import choco.cp.solver.search.restart.AbstractRestartStrategyOnLimit;
import choco.cp.solver.search.restart.GeometricalRestart;
import choco.cp.solver.search.restart.LimitedNumberOfRestart;
import choco.cp.solver.search.restart.LubyRestart;
import choco.cp.solver.search.restart.RestartStrategy;
import choco.cp.solver.search.set.AssignSetVar;
import choco.cp.solver.search.set.MinDomSet;
import choco.cp.solver.search.set.MinEnv;
import choco.cp.solver.search.set.RandomSetValSelector;
import choco.cp.solver.search.set.RandomSetVarSelector;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.cp.solver.variables.integer.IntTerm;
import choco.cp.solver.variables.real.RealVarImpl;
import choco.cp.solver.variables.set.SetVarImpl;
import choco.kernel.common.IndexFactory;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.LightFormatter;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.memory.recomputation.EnvironmentRecomputation;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.AbstractIntBranching;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.integer.IntSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.CouplesTable;
import choco.kernel.solver.constraints.integer.extension.IterLargeRelation;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.constraints.integer.extension.TuplesTable;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.set.SetSConstraint;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.propagation.AbstractPropagationEngine;
import choco.kernel.solver.propagation.ConstraintEvent;
import choco.kernel.solver.propagation.ConstraintEventQueue;
import choco.kernel.solver.propagation.EventQueue;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.VarEventQueue;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractOptimize;
import choco.kernel.solver.search.GlobalSearchLimit;
import choco.kernel.solver.search.Limit;
import choco.kernel.solver.search.integer.AbstractIntVarSelector;
import choco.kernel.solver.search.integer.ValIterator;
import choco.kernel.solver.search.integer.ValSelector;
import choco.kernel.solver.search.real.RealValIterator;
import choco.kernel.solver.search.real.RealVarSelector;
import choco.kernel.solver.search.set.AbstractSetVarSelector;
import choco.kernel.solver.search.set.SetValSelector;
import choco.kernel.solver.search.set.SetVarSelector;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import choco.kernel.visu.IVisu;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class CPSolver
implements Solver {
    public static final SConstraint TRUE = new ConstantSConstraint(true);
    public static final SConstraint FALSE = new ConstantSConstraint(false);
    private static Logger logger = Logger.getLogger("choco");
    protected final IndexFactory indexfactory;
    public Boolean feasible = null;
    protected boolean solved = false;
    protected IEnvironment environment;
    protected AbstractPropagationEngine propagationEngine;
    protected VarEventQueue[] veqCopy = null;
    protected ConstraintEventQueue[] ceqCopy = null;
    public static final IntTerm ZERO = new IntTerm(0);
    public static final IntTerm UN = new IntTerm(1);
    protected boolean useRecomputation = false;
    public boolean cardinalityReasonningsOnSETS = true;
    public IStateInt indexOfLastInitializedStaticConstraint;
    public CPModel model;
    protected PartiallyStoredVector<Propagator> constraints;
    protected ArrayList<IntDomainVar> intVars;
    protected ArrayList<SetVar> setVars;
    protected ArrayList<RealVar> floatVars;
    protected ArrayList<TaskVar> taskVars;
    protected ArrayList<IntDomainVar> intDecisionVars;
    protected ArrayList<SetVar> setDecisionVars;
    protected ArrayList<RealVar> floatDecisionVars;
    protected ArrayList<TaskVar> taskDecisionVars;
    protected HashMap<Integer, IntDomainVar> intconstantVars;
    protected HashMap<Double, RealIntervalConstant> realconstantVars;
    protected TIntObjectHashMap<Var> mapvariables;
    protected TIntObjectHashMap<SConstraint> mapconstraints;
    protected double precision = 1.0E-6;
    protected double reduction = 0.99;
    protected Var objective;
    protected boolean doMaximize;
    protected final SchedulerConfig scheduler;
    public ClauseStore nogoodStore;
    public int propNogoodWorld;
    public int loggingMaxDepth = 5;
    protected boolean restart = false;
    protected RestartStrategy restartS = null;
    protected boolean recordNogoodFromRestart = false;
    protected boolean firstSolution = true;
    protected AbstractGlobalSearchStrategy strategy;
    protected VarSelector varIntSelector = null;
    protected RealVarSelector varRealSelector = null;
    protected SetVarSelector varSetSelector = null;
    protected ValIterator valIntIterator = null;
    protected ValIterator valRealIterator = null;
    protected ValIterator valSetIterator = null;
    protected ValSelector valIntSelector = null;
    protected ValSelector valRealSelector = null;
    protected SetValSelector valSetSelector = null;
    protected int timeLimit = Integer.MAX_VALUE;
    protected int cpuTimeLimit = Integer.MAX_VALUE;
    protected int nodeLimit = Integer.MAX_VALUE;
    protected int backTrackLimit = Integer.MAX_VALUE;
    protected int failLimit = Integer.MAX_VALUE;
    protected Map<Limit, Boolean> limits = new HashMap<Limit, Boolean>();
    protected CPModelToCPSolver mod2sol = new CPModelToCPSolver(this);
    public AbstractIntBranching tempGoal;
    protected Goal ilogGoal = null;
    private int eventQueueType = 0;
    public static final int SILENT = 0;
    public static final int SOLUTION = 1;
    public static final int SEARCH = 2;
    public static final int PROPAGATION = 3;
    public static final int FINEST = 4;

    @Override
    public void setLoggingMaxDepth(int loggingMaxDepth) {
        this.loggingMaxDepth = loggingMaxDepth;
    }

    @Override
    public AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.strategy;
    }

    public void resetSearchStrategy() {
        this.strategy = null;
    }

    public CPSolver() {
        this(new EnvironmentTrailing());
    }

    public CPSolver(IEnvironment env) {
        this.mapvariables = new TIntObjectHashMap();
        this.mapconstraints = new TIntObjectHashMap();
        this.intVars = new ArrayList();
        this.setVars = new ArrayList();
        this.floatVars = new ArrayList();
        this.taskVars = new ArrayList();
        this.intDecisionVars = new ArrayList();
        this.setDecisionVars = new ArrayList();
        this.floatDecisionVars = new ArrayList();
        this.taskDecisionVars = new ArrayList();
        this.intconstantVars = new HashMap();
        this.realconstantVars = new HashMap();
        this.propagationEngine = new ChocEngine(this);
        this.environment = env;
        this.constraints = env.makePartiallyStoredVector();
        this.indexfactory = new IndexFactory();
        this.scheduler = new SchedulerConfig(this);
        if (env instanceof EnvironmentRecomputation) {
            this.useRecomputation = true;
        }
        CPSolver.setDefaultHandler();
        CPSolver.setVerbosity(0);
        this.indexOfLastInitializedStaticConstraint = env.makeInt(PartiallyStoredVector.getFirstStaticIndex() - 1);
        this.initLimit();
    }

    @Override
    public void visualize(IVisu visu) {
        this.eventQueueType = 1;
        this.propagationEngine.setVarEventQueues(this.eventQueueType);
        visu.init(this);
        visu.setVisible(true);
    }

    @Override
    public IndexFactory getIndexfactory() {
        return this.indexfactory;
    }

    public boolean contains(Variable v) {
        return this.mapvariables.containsKey(v.getIndexIn(this.model.getIndex()));
    }

    public String getSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Pb[");
        buffer.append(this.getNbIntVars() + this.getNbRealVars() + this.getNbSetVars()).append(" vars, ");
        buffer.append(this.getNbTaskVars()).append(" tasks, ");
        buffer.append(this.getNbIntConstraints()).append(" cons]");
        if (this.strategy != null) {
            buffer.append("\nLimits");
            buffer.append(ChocoUtil.pretty(this.strategy.limits));
        }
        return new String(buffer);
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer(this.getSummary());
        buf.append('\n');
        buf.append(this.varsToString());
        buf.append(this.constraintsToString());
        return new String(buf);
    }

    public String varsToString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("==== VARIABLES ====\n");
        for (i = 0; i < this.getNbIntVars(); ++i) {
            buf.append(this.getIntVar(i).pretty());
            buf.append("\n");
        }
        for (int i1 = 0; i1 < this.floatVars.size(); ++i1) {
            RealVar floatVar;
            RealVar realVar = floatVar = this.floatVars.get(i1);
            buf.append(realVar.pretty());
        }
        for (i = 0; i < this.setVars.size(); ++i) {
            buf.append(this.getSetVar(i).pretty());
            buf.append("\n");
        }
        buf.append("==== TASKS ====\n");
        buf.append(ChocoUtil.prettyOnePerLine(this.taskVars));
        return new String(buf);
    }

    public String constraintsToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("==== CONSTRAINTS ====\n");
        DisposableIntIterator it = this.constraints.getIndexIterator();
        while (it.hasNext()) {
            int i = it.next();
            AbstractSConstraint c = (AbstractSConstraint)this.constraints.get(i);
            buf.append(c.pretty());
            buf.append("\n");
        }
        return new String(buf);
    }

    @Override
    public void read(Model m) {
        this.model = (CPModel)m;
        this.initReading();
        this.mod2sol.readVariables(this.model);
        this.mod2sol.readDecisionVariables();
        this.mod2sol.readConstraints(this.model);
    }

    protected void initReading() {
        this.getEnvironment().createSharedBipartiteSet(this.model.getNbBoolVar());
    }

    public SConstraint makeSConstraint(Constraint mc) {
        return this.mod2sol.makeSConstraint(mc);
    }

    public SConstraint makeSConstraint(Constraint mc, boolean b) {
        return this.mod2sol.makeSConstraint(mc, b);
    }

    public void addConstraint(Constraint ... tabic) {
        for (int i = 0; i < tabic.length; ++i) {
            Constraint ic = tabic[i];
            Iterator<Variable> it = ic.getVariableIterator();
            while (it.hasNext()) {
                Variable v = it.next();
                if (this.mapvariables.containsKey(v.getIndexIn(this.model.getIndex()))) continue;
                v.findManager(this.model.properties);
                this.mod2sol.readModelVariable(v);
            }
            ic.findManager(this.model.properties);
            this.mod2sol.readConstraint(ic, this.model.getDefaultExpressionDecomposition());
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model) {
        this.model = (CPModel)model;
    }

    @Override
    public void setPrecision(double precision) {
        this.precision = precision;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void setReduction(double reduction) {
        this.reduction = reduction;
    }

    @Override
    public double getReduction() {
        return this.reduction;
    }

    @Override
    public final IEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public final int getEventQueueType() {
        return this.eventQueueType;
    }

    @Override
    public void setFeasible(boolean b) {
        this.feasible = b;
    }

    @Override
    public Boolean getFeasible() {
        return this.feasible;
    }

    @Override
    public String solutionToString() {
        Var v;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            v = this.getIntVar(i);
            if (!v.isInstantiated()) continue;
            buf.append(v.toString());
            buf.append(", ");
        }
        for (int j = 0; j < this.getNbRealVars(); ++j) {
            v = this.getRealVar(j);
            if (!v.isInstantiated()) continue;
            buf.append(v.toString());
            buf.append(", ");
        }
        for (int k = 0; k < this.getNbSetVars(); ++k) {
            v = this.getSetVar(k);
            if (!v.isInstantiated()) continue;
            buf.append(v.toString());
            buf.append(", ");
        }
        return new String(buf);
    }

    public void setRandomSelectors(long seed) {
        this.setRandomSelectors(new Random(seed));
    }

    public void setRandomSelectors() {
        this.setRandomSelectors(new Random());
    }

    public void setRandomSelectors(Random manager) {
        Var[] v;
        if (this.intDecisionVars == null || this.intDecisionVars.isEmpty()) {
            this.setVarIntSelector(new RandomIntVarSelector(this, manager.nextLong()));
        } else {
            v = this.intDecisionVars.toArray(new IntDomainVar[this.intDecisionVars.size()]);
            this.setVarIntSelector(new RandomIntVarSelector(this, (IntDomainVar[])v, manager.nextLong()));
        }
        this.setValIntSelector(new RandomIntValSelector(manager.nextLong()));
        if (this.setDecisionVars == null || this.setDecisionVars.isEmpty()) {
            this.setVarSetSelector(new RandomSetVarSelector(this, manager.nextLong()));
        } else {
            v = this.setDecisionVars.toArray(new SetVar[this.setDecisionVars.size()]);
            this.setVarSetSelector(new RandomSetVarSelector(this, (SetVar[])v, manager.nextLong()));
        }
        this.setValSetSelector(new RandomSetValSelector(manager.nextLong()));
    }

    @Override
    public void generateSearchStrategy() {
        if (this.tempGoal == null || !(this.tempGoal instanceof ImpactBasedBranching) || this.strategy == null) {
            if (null == this.objective) {
                this.strategy = this.ilogGoal != null ? new GoalSearchSolver(this, this.ilogGoal) : new GlobalSearchStrategy(this);
            } else {
                if (this.ilogGoal != null) {
                    throw new UnsupportedOperationException("Ilog goal are not yet available in optimization");
                }
                if (this.restart) {
                    if (this.objective instanceof IntDomainVar) {
                        this.strategy = new OptimizeWithRestarts((IntDomainVarImpl)this.objective, this.doMaximize);
                    } else if (this.objective instanceof RealVar) {
                        this.strategy = new RealOptimizeWithRestarts((RealVar)this.objective, this.doMaximize);
                    }
                } else if (this.objective instanceof IntDomainVar) {
                    this.strategy = new BranchAndBound((IntDomainVarImpl)this.objective, this.doMaximize);
                } else if (this.objective instanceof RealVar) {
                    this.strategy = new RealBranchAndBound((RealVar)this.objective, this.doMaximize);
                }
            }
        }
        this.strategy.stopAtFirstSol = this.firstSolution;
        this.strategy.setLoggingMaxDepth(this.loggingMaxDepth);
        this.addLimitsAndRestartStrategy();
        if (this.useRecomputation()) {
            this.strategy.setSearchLoop(new SearchLoopWithRecomputation(this.strategy));
        }
        if (this.ilogGoal == null) {
            if (this.tempGoal == null) {
                this.generateGoal();
            } else {
                this.attachGoal(this.tempGoal);
                this.tempGoal = null;
            }
        }
    }

    public AbstractIntBranching generateRealGoal() {
        if (this.varRealSelector == null) {
            this.varRealSelector = new CyclicRealVarSelector(this);
        }
        if (this.valRealIterator == null && this.valRealSelector == null) {
            this.valRealIterator = new RealIncreasingDomain();
        }
        return this.valRealIterator != null ? new AssignInterval(this.varRealSelector, this.valRealIterator) : new AssignVar((VarSelector)this.varRealSelector, this.valRealSelector);
    }

    public AbstractIntBranching generateSetGoal() {
        if (this.varSetSelector == null) {
            if (this.setDecisionVars.isEmpty()) {
                this.varSetSelector = new MinDomSet(this);
            } else {
                SetVar[] t = new SetVar[this.setDecisionVars.size()];
                this.setDecisionVars.toArray(t);
                this.varSetSelector = new MinDomSet(this, t);
            }
        }
        if (this.valSetSelector == null) {
            this.valSetSelector = new MinEnv(this);
        }
        return new AssignSetVar(this.varSetSelector, this.valSetSelector);
    }

    public AbstractIntBranching generateIntGoal() {
        if (this.valIntIterator == null && this.valIntSelector == null) {
            this.valIntIterator = new IncreasingDomain();
        }
        if (this.varIntSelector == null) {
            if (this.intDecisionVars.isEmpty()) {
                return this.valIntIterator != null ? new DomOverWDegBranching((Solver)this, this.valIntIterator) : new DomOverWDegBranching((Solver)this, this.valIntSelector);
            }
            IntVar[] t = new IntDomainVar[this.intDecisionVars.size()];
            this.intDecisionVars.toArray(t);
            return this.valIntIterator != null ? new DomOverWDegBranching((Solver)this, this.valIntIterator, t) : new DomOverWDegBranching((Solver)this, this.valIntSelector);
        }
        return this.valIntIterator != null ? new AssignVar(this.varIntSelector, this.valIntIterator) : new AssignVar(this.varIntSelector, this.valIntSelector);
    }

    protected void generateGoal() {
        boolean first = true;
        if (this.getNbSetVars() > 0) {
            this.attachGoal(this.generateSetGoal());
            first = false;
        }
        if (this.getNbIntVars() > 0) {
            if (first) {
                this.attachGoal(this.generateIntGoal());
                first = false;
            } else {
                this.addGoal(this.generateIntGoal());
            }
        }
        if (this.getNbRealVars() > 0) {
            if (first) {
                this.attachGoal(this.generateRealGoal());
            } else {
                this.addGoal(this.generateRealGoal());
            }
        }
    }

    @Override
    public boolean checkDecisionVariables() {
        int i;
        if (this.intDecisionVars != null) {
            for (i = 0; i < this.intDecisionVars.size(); ++i) {
                if (this.intDecisionVars.get(i).isInstantiated()) continue;
                return false;
            }
        }
        if (this.setDecisionVars != null) {
            for (i = 0; i < this.setDecisionVars.size(); ++i) {
                if (this.setDecisionVars.get(i).isInstantiated()) continue;
                return false;
            }
        }
        if (this.floatDecisionVars != null) {
            for (i = 0; i < this.floatDecisionVars.size(); ++i) {
                if (this.floatDecisionVars.get(i).isInstantiated()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void attachGoal(AbstractIntBranching branching) {
        if (this.strategy == null) {
            this.tempGoal = branching;
        } else {
            for (AbstractIntBranching br = branching; br != null; br = (AbstractIntBranching)br.getNextBranching()) {
                br.setSolver(this.strategy);
            }
            this.strategy.mainGoal = branching;
        }
    }

    @Override
    public void addGoal(AbstractIntBranching branching) {
        AbstractIntBranching br;
        if (this.strategy == null) {
            br = this.tempGoal;
        } else {
            branching.setSolver(this.strategy);
            br = this.strategy.mainGoal;
        }
        while (br.getNextBranching() != null) {
            br = (AbstractIntBranching)br.getNextBranching();
        }
        br.setNextBranching(branching);
    }

    @Override
    public void setIlogGoal(Goal ilogGoal) {
        this.ilogGoal = ilogGoal;
    }

    @Override
    public void launch() {
        this.strategy.incrementalRun();
    }

    @Override
    public int getNbSolutions() {
        return this.strategy.nbSolutions;
    }

    public void initLimit() {
        this.limits.put(Limit.TIME, true);
        this.limits.put(Limit.CPU_TIME, false);
        this.limits.put(Limit.NODE, true);
        this.limits.put(Limit.BACKTRACK, false);
        this.limits.put(Limit.FAIL, false);
    }

    protected void addLimitsAndRestartStrategy() {
        if (this.limits.get((Object)Limit.TIME).booleanValue()) {
            this.strategy.limits.add(new TimeLimit(this.strategy, this.timeLimit));
        }
        if (this.limits.get((Object)Limit.CPU_TIME).booleanValue()) {
            this.strategy.limits.add(new CpuTimeLimit(this.strategy, this.cpuTimeLimit));
        }
        if (this.limits.get((Object)Limit.NODE).booleanValue()) {
            this.strategy.limits.add(new NodeLimit(this.strategy, this.nodeLimit));
        }
        if (this.limits.get((Object)Limit.BACKTRACK).booleanValue()) {
            this.strategy.limits.add(new BackTrackLimit(this.strategy, this.backTrackLimit));
        }
        if (this.limits.get((Object)Limit.FAIL).booleanValue()) {
            this.strategy.limits.add(new FailLimit(this.strategy, this.failLimit));
        }
        if (this.restartS != null) {
            if (this.useRecomputation) {
                throw new SolverException("restart can not be used in recomputation mode");
            }
            if (this.restartS instanceof AbstractRestartStrategyOnLimit) {
                AbstractRestartStrategyOnLimit rs = (AbstractRestartStrategyOnLimit)this.restartS;
                AbstractGlobalSearchLimit l = this.strategy.getLimit(rs.getLimit());
                if (l == null) {
                    throw new SolverException("restart can not be find the limit: " + (Object)((Object)rs.getLimit()));
                }
                rs.setFailLimit(l);
            }
            this.strategy.setSearchLoop(new SearchLoopWithRestart(this.strategy, this.restartS));
        }
    }

    @Override
    public void monitorTimeLimit(boolean b) {
        this.limits.put(Limit.TIME, b);
    }

    @Override
    public void monitorCpuTimeLimit(boolean b) {
        this.limits.put(Limit.CPU_TIME, b);
    }

    @Override
    public void monitorNodeLimit(boolean b) {
        this.limits.put(Limit.NODE, b);
    }

    @Override
    public void monitorBackTrackLimit(boolean b) {
        this.limits.put(Limit.BACKTRACK, b);
    }

    @Override
    public void monitorFailLimit(boolean b) {
        this.limits.put(Limit.FAIL, b);
    }

    @Override
    public void setTimeLimit(int timeLimit) {
        this.limits.put(Limit.TIME, true);
        this.timeLimit = timeLimit;
    }

    @Override
    public void setCpuTimeLimit(int cpuTimeLimit) {
        this.limits.put(Limit.CPU_TIME, true);
        this.cpuTimeLimit = cpuTimeLimit;
    }

    @Override
    public void setNodeLimit(int nodeLimit) {
        this.limits.put(Limit.NODE, true);
        this.nodeLimit = nodeLimit;
    }

    @Override
    public void setBackTrackLimit(int backTrackLimit) {
        this.limits.put(Limit.BACKTRACK, true);
        this.backTrackLimit = backTrackLimit;
    }

    @Override
    public void setFailLimit(int failLimit) {
        this.limits.put(Limit.FAIL, true);
        this.failLimit = failLimit;
    }

    @Override
    public int getTimeCount() {
        return this.strategy.getTimeCount();
    }

    @Override
    public int getCpuTimeCount() {
        return this.strategy.getCpuTimeCount();
    }

    @Override
    public int getNodeCount() {
        return this.strategy.getNodeCount();
    }

    @Override
    public int getBackTrackCount() {
        return this.strategy.getBackTrackCount();
    }

    @Override
    public int getFailCount() {
        return this.strategy.getFailCount();
    }

    @Override
    public boolean getFirstSolution() {
        return this.firstSolution;
    }

    @Override
    public void setFirstSolution(boolean firstSolution) {
        this.firstSolution = firstSolution;
    }

    @Override
    public void setVarIntSelector(VarSelector varSelector) {
        this.varIntSelector = varSelector;
        IntDomainVar[] vars = ((AbstractIntVarSelector)varSelector).getVars();
        if (vars != null) {
            this.intDecisionVars.clear();
            for (int i = 0; i < vars.length; ++i) {
                this.intDecisionVars.add(vars[i]);
            }
        } else if (!this.intDecisionVars.isEmpty()) {
            vars = new IntDomainVar[this.intDecisionVars.size()];
            this.intDecisionVars.toArray(vars);
            ((AbstractIntVarSelector)varSelector).setVars(vars);
        } else {
            this.intDecisionVars.addAll(this.intVars);
        }
    }

    @Override
    public void setVarRealSelector(RealVarSelector realVarSelector) {
        this.varRealSelector = realVarSelector;
        this.floatDecisionVars.addAll(this.floatVars);
    }

    @Override
    public void setVarSetSelector(SetVarSelector setVarIntSelector) {
        this.varSetSelector = setVarIntSelector;
        SetVar[] vars = ((AbstractSetVarSelector)setVarIntSelector).getVars();
        if (vars != null) {
            this.setDecisionVars.clear();
            for (int i = 0; i < vars.length; ++i) {
                this.setDecisionVars.add(vars[i]);
            }
        } else if (!this.setDecisionVars.isEmpty()) {
            vars = new SetVar[this.setDecisionVars.size()];
            this.intDecisionVars.toArray(vars);
            ((AbstractSetVarSelector)setVarIntSelector).setVars(vars);
        } else {
            this.setDecisionVars.addAll(this.setVars);
        }
    }

    @Override
    public void setValIntIterator(ValIterator valIterator) {
        this.valIntIterator = valIterator;
    }

    @Override
    public void setValRealIterator(RealValIterator realValIterator) {
        this.valRealIterator = realValIterator;
    }

    @Override
    public void setValSetIterator(ValIterator valIterator) {
        this.valSetIterator = valIterator;
    }

    @Override
    public void setValIntSelector(ValSelector valSelector) {
        this.valIntSelector = valSelector;
    }

    @Override
    public void setValRealSelector(ValSelector valSelector) {
        this.valRealSelector = valSelector;
    }

    @Override
    public void setValSetSelector(SetValSelector setValIntSelector) {
        this.valSetSelector = setValIntSelector;
    }

    public void setGeometricRestart(int base, double grow) {
        this.setRestartStrategy(new GeometricalRestart(Limit.BACKTRACK, grow, base));
    }

    public void setGeometricRestart(int base, double grow, int restartLimit) {
        this.setRestartStrategy(new LimitedNumberOfRestart(new GeometricalRestart(Limit.BACKTRACK, grow, base), restartLimit));
    }

    @Deprecated
    public void setLasVegasRestart(int base) {
        this.setRestartStrategy(new LubyRestart(Limit.BACKTRACK, base));
    }

    @Deprecated
    public void setLasVegasRestart(int base, int restartLimit) {
        this.setRestartStrategy(new LimitedNumberOfRestart(new LubyRestart(Limit.BACKTRACK, base), restartLimit));
    }

    public void setLubyRestart(int base, int grow, int restartLimit) {
        this.setRestartStrategy(new LimitedNumberOfRestart(new LubyRestart(Limit.BACKTRACK, grow, base), restartLimit));
    }

    public void setLubyRestart(int base, int grow) {
        this.setRestartStrategy(new LubyRestart(Limit.BACKTRACK, grow, base));
    }

    public void setLubyRestart(int base) {
        this.setRestartStrategy(new LubyRestart(Limit.BACKTRACK, base));
    }

    @Deprecated
    public void cancelGeometricRestart() {
        this.restartS = null;
    }

    public void cancelRestartStrategy() {
        this.restartS = null;
    }

    public void setRestartStrategy(RestartStrategy restartS) {
        if (this.useRecomputation) {
            throw new SolverException("restart can not be used in recomputation mode");
        }
        if (restartS instanceof AbstractRestartStrategyOnLimit) {
            AbstractRestartStrategyOnLimit rs = (AbstractRestartStrategyOnLimit)restartS;
            this.limits.put(rs.getLimit(), true);
        }
        this.restartS = restartS;
    }

    public RestartStrategy getRestartStrategy() {
        return this.restartS;
    }

    public final boolean isRecordingNogoodFromRestart() {
        return this.recordNogoodFromRestart;
    }

    public final void setRecordNogoodFromRestart(boolean recordNogoodFromRestart) {
        this.recordNogoodFromRestart = recordNogoodFromRestart;
    }

    @Override
    public void setRestart(boolean restart) {
        this.restart = restart;
    }

    @Override
    public void setDoMaximize(boolean doMaximize) {
        this.doMaximize = doMaximize;
    }

    @Override
    public void setObjective(Var objective) {
        this.objective = objective;
    }

    @Override
    public Number getOptimumValue() {
        if (this.strategy instanceof AbstractOptimize) {
            return ((AbstractOptimize)this.strategy).getBestObjectiveValue();
        }
        if (this.strategy instanceof AbstractRealOptimize) {
            return ((AbstractRealOptimize)this.strategy).getBestObjectiveValue();
        }
        return null;
    }

    public final SchedulerConfig getScheduler() {
        return this.scheduler;
    }

    @Override
    public final void setHorizon(int horizon) {
        this.scheduler.setMakespan(horizon);
    }

    @Override
    public final IntDomainVar getMakespan() {
        return this.scheduler.getMakespan();
    }

    @Override
    public final int getMakespanValue() {
        return this.scheduler.getMakespanValue();
    }

    public final void postMakespanConstraint() {
        if (this.getMakespan() != null) {
            IntDomainVar[] vars = new IntDomainVar[this.getNbTaskVars() + 1];
            vars[0] = this.getMakespan();
            for (int i = 0; i < this.getNbTaskVars(); ++i) {
                vars[i + 1] = this.getTaskVar(i).end();
            }
            this.post((SConstraint)new MaxOfAList(vars));
        }
    }

    public final void postRedundantTaskConstraints() {
        if (this.scheduler.isRedundantReasonningsOnTasks()) {
            for (int i = 0; i < this.getNbTaskVars(); ++i) {
                this.postRedundantTaskConstraint(this.getTaskVar(i));
            }
        } else {
            for (int i = 0; i < this.getNbTaskVars(); ++i) {
                TaskVar t = this.getTaskVar(i);
                if (t.getNbConstraints() != 0) continue;
                this.postRedundantTaskConstraint(this.getTaskVar(i));
            }
        }
        this.postMakespanConstraint();
    }

    protected void postRedundantTaskConstraint(TaskVar t) {
        if (t.duration().isInstantiatedTo(0)) {
            if (!t.start().equals(t.end())) {
                this.post(this.eq((IntExp)t.start(), (IntExp)t.end()));
            }
        } else {
            this.post(this.eq(this.plus((IntExp)t.start(), (IntExp)t.duration()), (IntExp)t.end()));
        }
    }

    @Override
    public boolean isEncounteredLimit() {
        return this.strategy.isEncounteredLimit();
    }

    @Override
    public GlobalSearchLimit getEncounteredLimit() {
        return this.strategy.getEncounteredLimit();
    }

    @Override
    public PropagationEngine getPropagationEngine() {
        return this.propagationEngine;
    }

    protected <E> List<E> getDecisionList(List<E> decisions, List<E> all) {
        return Collections.unmodifiableList(decisions.isEmpty() ? all : decisions);
    }

    public final List<IntDomainVar> getIntDecisionVars() {
        return this.getDecisionList(this.intDecisionVars, this.intVars);
    }

    public final List<SetVar> getSetDecisionVars() {
        return this.getDecisionList(this.setDecisionVars, this.setVars);
    }

    public final List<RealVar> getRealDecisionVars() {
        return this.getDecisionList(this.floatDecisionVars, this.floatVars);
    }

    public final List<TaskVar> getTaskDecisionVars() {
        return this.getDecisionList(this.taskDecisionVars, this.taskVars);
    }

    @Override
    public final IntVar getIntVar(int i) {
        return this.intVars.get(i);
    }

    public final void addIntVar(IntDomainVar v) {
        this.intVars.add(v);
    }

    @Override
    public final Var getIntConstant(int i) {
        return this.intconstantVars.get(i);
    }

    public final void addIntConstant(int value, IntDomainVar i) {
        this.intconstantVars.put(value, i);
    }

    @Override
    public final Var getRealConstant(double i) {
        return this.realconstantVars.get(i);
    }

    public final void addrealConstant(double value, RealIntervalConstant i) {
        this.realconstantVars.put(value, i);
    }

    @Override
    public final Collection<Integer> getIntConstantSet() {
        return this.intconstantVars.keySet();
    }

    @Override
    public final Collection<Double> getRealConstantSet() {
        return this.realconstantVars.keySet();
    }

    public final int getNbIntConstants() {
        return this.intconstantVars.size();
    }

    public final int getNbRealConstants() {
        return this.realconstantVars.size();
    }

    @Override
    public final int getNbConstants() {
        return this.intconstantVars.size() + this.realconstantVars.size();
    }

    @Override
    public int getIntVarIndex(IntVar c) {
        return this.intVars.indexOf(c);
    }

    public int getIntVarIndex(IntDomainVar c) {
        return this.intVars.indexOf(c);
    }

    @Override
    public final int getNbIntVars() {
        return this.intVars.size();
    }

    @Override
    public final RealVar getRealVar(int i) {
        return this.floatVars.get(i);
    }

    public final void addRealVar(RealVar rv) {
        this.floatVars.add(rv);
    }

    @Override
    public final int getNbRealVars() {
        return this.floatVars.size();
    }

    @Override
    public final SetVar getSetVar(int i) {
        return this.setVars.get(i);
    }

    public final void addSetVar(SetVar sv) {
        this.setVars.add(sv);
    }

    @Override
    public final int getNbSetVars() {
        return this.setVars.size();
    }

    @Override
    public int getNbTaskVars() {
        return this.taskVars.size();
    }

    @Override
    public TaskVar getTaskVar(int i) {
        return this.taskVars.get(i);
    }

    @Override
    public final int getNbIntConstraints() {
        return this.constraints.size();
    }

    @Override
    @Deprecated
    public final IntSConstraint getIntConstraint(int i) {
        return (IntSConstraint)this.constraints.get(i);
    }

    @Override
    public Iterator<SConstraint> getIntConstraintIterator() {
        return new Iterator<SConstraint>(){
            IntIterator it;
            {
                this.it = CPSolver.this.constraints.getIndexIterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Propagator next() {
                return CPSolver.this.constraints.get(this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final Boolean isFeasible() {
        return this.feasible;
    }

    public final boolean isConsistent() {
        Iterator<SConstraint> ctit = this.getIntConstraintIterator();
        while (ctit.hasNext()) {
            if (((Propagator)ctit.next()).isConsistent()) continue;
            return false;
        }
        return true;
    }

    public boolean isCompletelyInstantiated() {
        int n = this.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            if (this.getIntVar(i).isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void eraseConstraint(SConstraint c) {
        this.constraints.remove(c);
        ((AbstractSConstraint)c).setPassive();
        for (int i = 0; i < c.getNbVars(); ++i) {
            AbstractVar v = (AbstractVar)c.getVar(i);
            v.eraseConstraint(c);
        }
    }

    @Override
    public void post(SConstraint cc) {
        if (cc instanceof Propagator) {
            if (!(cc.equals(TRUE) && this.constraints.contains(TRUE) || cc.equals(FALSE) && this.constraints.contains(FALSE))) {
                Propagator c = (Propagator)cc;
                c.setSolver(this);
                this.constraints.add(c);
                c.addListener(true);
                ConstraintEvent event = (ConstraintEvent)c.getEvent();
                PropagationEngine pe = this.getPropagationEngine();
                pe.registerEvent(event);
                pe.postConstAwake(c, true);
                this.postRedundantSetConstraints(cc);
            }
        } else if (cc instanceof ExpressionSConstraint) {
            ExpressionSConstraint p = (ExpressionSConstraint)cc;
            p.setScope(this);
            this.decisionOnExpression(p);
        } else {
            throw new SolverException("impossible to post to a Model constraints that are not Propagators");
        }
    }

    public void post(SConstraint ... ccs) {
        for (SConstraint cc : ccs) {
            this.post(cc);
        }
    }

    protected void decisionOnExpression(ExpressionSConstraint exp) {
        Boolean decomp = exp.isDecomposeExp();
        if (decomp != null) {
            if (decomp.booleanValue() && exp.checkDecompositionIsPossible()) {
                this.post(exp.getDecomposition(this));
            } else {
                this.post(exp.getExtensionnal(this));
            }
        } else if (exp.getNbVars() == 0) {
            if (exp.checkTuple(new int[0])) {
                this.post(TRUE);
            } else {
                this.post(FALSE);
            }
        } else {
            this.post(exp.getExtensionnal(this));
        }
    }

    public void postRedundantSetConstraints(SConstraint p) {
        if (this.cardinalityReasonningsOnSETS && p instanceof SetSConstraint && p.getNbVars() > 1) {
            if (p instanceof MemberXY) {
                IntDomainVar card0 = ((SetVar)p.getVar(1)).getCard();
                this.post(this.geq((IntExp)card0, 1));
            } else if (p instanceof IsIncluded) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                this.post(this.leq((IntExp)card0, (IntExp)card1));
            } else if (p instanceof SetUnion) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                IntDomainVar card3 = ((SetVar)p.getVar(2)).getCard();
                this.post(this.geq(this.plus((IntExp)card0, (IntExp)card1), (IntExp)card3));
            } else if (p instanceof SetIntersection) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                IntDomainVar card3 = ((SetVar)p.getVar(2)).getCard();
                this.post(this.geq((IntExp)card0, (IntExp)card3));
                this.post(this.geq((IntExp)card1, (IntExp)card3));
            } else if (p instanceof Disjoint) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                int ub = Math.max(((SetVar)p.getVar(0)).getEnveloppeSup(), ((SetVar)p.getVar(1)).getEnveloppeSup());
                int lb = Math.min(((SetVar)p.getVar(0)).getEnveloppeInf(), ((SetVar)p.getVar(1)).getEnveloppeInf());
                SetVar z = this.createBoundSetVar("var_inter: " + p, lb, ub);
                this.setVars.add(z);
                this.intVars.add(z.getCard());
                this.post((SConstraint)new SetUnion((SetVar)p.getVar(0), (SetVar)p.getVar(1), z));
                this.post(this.eq(this.plus((IntExp)card0, (IntExp)card1), (IntExp)z.getCard()));
            }
        }
    }

    @Override
    public void postCut(SConstraint cc) {
        if (cc instanceof Propagator) {
            if (!(cc.equals(TRUE) && this.constraints.contains(TRUE) || cc.equals(FALSE) && this.constraints.contains(FALSE))) {
                Propagator c = (Propagator)cc;
                c.setSolver(this);
                int idx = this.constraints.staticAdd(c);
                this.indexOfLastInitializedStaticConstraint.set(idx);
                c.addListener(false);
                ConstraintEvent event = (ConstraintEvent)c.getEvent();
                PropagationEngine pe = this.getPropagationEngine();
                pe.registerEvent(event);
                pe.postConstAwake(c, true);
                if (this.strategy != null) {
                    this.strategy.initMainGoal(cc);
                }
            }
        } else {
            throw new SolverException("impossible to post to a Model cuts that are not Propagators");
        }
    }

    public void addNogood(IntDomainVar[] poslit, IntDomainVar[] neglit) {
        if (this.nogoodStore == null) {
            this.nogoodStore = new ClauseStore(this.getBooleanVariables());
            this.postCut(this.nogoodStore);
        }
        this.nogoodStore.addDynamicClause(poslit, neglit);
        this.propNogoodWorld = this.getWorldIndex();
        this.nogoodStore.constAwake(false);
    }

    public int getNbBooleanVars() {
        int cpt = 0;
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            IntDomainVar v = (IntDomainVar)this.getIntVar(i);
            if (!v.hasBooleanDomain()) continue;
            ++cpt;
        }
        return cpt;
    }

    public IntDomainVar[] getBooleanVariables() {
        ArrayList<IntDomainVar> bvs = new ArrayList<IntDomainVar>();
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            IntDomainVar v = (IntDomainVar)this.getIntVar(i);
            if (!v.hasBooleanDomain()) continue;
            bvs.add(v);
        }
        IntDomainVar[] boolvars = new IntDomainVar[bvs.size()];
        bvs.toArray(boolvars);
        return boolvars;
    }

    @Override
    public void propagate() throws ContradictionException {
        PropagationEngine pe = this.getPropagationEngine();
        boolean someEvents = true;
        while (someEvents) {
            EventQueue q = pe.getNextActiveEventQueue();
            if (q != null) {
                q.propagateSomeEvents();
                continue;
            }
            someEvents = false;
        }
        assert (pe.checkCleanState());
    }

    @Override
    public void worldPush() {
        this.environment.worldPush();
    }

    @Override
    public void worldPop() {
        this.environment.worldPop();
        this.propagationEngine.flushEvents();
        int lastStaticIdx = this.constraints.getLastStaticIndex();
        for (int i = this.indexOfLastInitializedStaticConstraint.get() + 1; i <= lastStaticIdx; ++i) {
            Propagator c = this.constraints.get(i);
            if (c == null) continue;
            c.setPassive();
            c.constAwake(true);
        }
        if (this.nogoodStore != null && this.propNogoodWorld > this.getWorldIndex()) {
            this.nogoodStore.constAwake(false);
            this.propNogoodWorld = this.getWorldIndex();
        }
    }

    @Override
    public void worldPopUntil(int n) {
        while (this.environment.getWorldIndex() > n) {
            this.worldPop();
        }
    }

    @Override
    public final void worldPushDuringPropagation() {
        int q;
        this.veqCopy = new VarEventQueue[this.propagationEngine.getVarEventQueues().length];
        for (q = 0; q < this.veqCopy.length; ++q) {
            this.veqCopy[q] = this.propagationEngine.getVarEventQueues()[q];
        }
        this.propagationEngine.setVarEventQueues(this.eventQueueType);
        this.ceqCopy = new ConstraintEventQueue[this.propagationEngine.getConstraintEventQueues().length];
        for (q = 0; q < this.ceqCopy.length; ++q) {
            this.ceqCopy[q] = this.propagationEngine.getConstraintEventQueues()[q];
            this.propagationEngine.getConstraintEventQueues()[q] = new ConstraintEventQueue(this.propagationEngine);
        }
        this.environment.worldPush();
    }

    @Override
    public final void worldPopDuringPropagation() {
        this.environment.worldPop();
        this.propagationEngine.flushEvents();
        this.propagationEngine.setVarEventQueues(this.veqCopy);
        this.propagationEngine.setConstraintEventQueues(this.ceqCopy);
        this.veqCopy = null;
        this.ceqCopy = null;
    }

    @Override
    public int getWorldIndex() {
        return this.environment.getWorldIndex();
    }

    @Override
    public Boolean solve(boolean all) {
        this.setFirstSolution(!all);
        this.generateSearchStrategy();
        this.launch();
        return this.isFeasible();
    }

    @Override
    public Boolean solve() {
        return this.solve(false);
    }

    @Override
    public Boolean solveAll() {
        return this.solve(true);
    }

    @Override
    public Boolean nextSolution() {
        return this.getSearchStrategy().nextSolution();
    }

    @Override
    public Boolean checkSolution(boolean printAll) {
        Boolean isSolution = true;
        StringBuffer st = new StringBuffer("~~~~~SOLUTION CHECKER~~~~~").append("\n");
        if (printAll) {
            st.append("(check wether every constraints define isSatisfied())").append("\n");
        }
        Iterator<SConstraint> ctit = this.getIntConstraintIterator();
        while (ctit.hasNext()) {
            SConstraint c = ctit.next();
            if (c.isSatisfied()) {
                if (!printAll) continue;
                st.append(c.pretty()).append(" - ok").append("\n");
                continue;
            }
            st.append("WARNINNG - ").append(c.pretty()).append(" - ko").append("\n");
            isSolution = false;
        }
        st.append("\n");
        if (isSolution.booleanValue()) {
            st.append("This solution satisfies every constraints.");
        } else {
            st.append("One or more constraint is not satisfied.").append("\n").append("Or the search is not finished.");
        }
        st.append("\n").append("~~~~~~~~~~~~~~~~~~~~~~~~~~").append("\n");
        Logger.getLogger("choco").log(Level.INFO, st.toString());
        CPSolver.flushLogs();
        return isSolution;
    }

    @Override
    public void printRuntimeSatistics() {
        this.getSearchStrategy().printRuntimeStatistics();
    }

    public String runtimeSatistics() {
        return this.getSearchStrategy().runtimeStatistics();
    }

    @Override
    public Boolean minimize(Var obj, boolean restart) {
        return this.optimize(false, obj, restart);
    }

    @Override
    public Boolean minimize(boolean restart) {
        if (this.objective == null) {
            throw new SolverException("No objective variable defined");
        }
        return this.optimize(false, this.objective, restart);
    }

    @Override
    public Boolean maximize(Var obj, boolean restart) {
        return this.optimize(true, obj, restart);
    }

    @Override
    public Boolean maximize(boolean restart) {
        if (this.objective == null) {
            throw new SolverException("No objective variable defined");
        }
        return this.optimize(true, this.objective, restart);
    }

    protected Boolean optimize(boolean maximize, Var obj, boolean restart) {
        this.setDoMaximize(maximize);
        this.setObjective(obj);
        this.setRestart(restart);
        this.setFirstSolution(false);
        this.generateSearchStrategy();
        this.launch();
        return this.isFeasible();
    }

    public final void setMinimizationObjective(IntVar obj) {
        this.objective = obj;
        this.doMaximize = false;
    }

    public final void setMaximizationObjective(IntVar obj) {
        this.objective = obj;
        this.doMaximize = true;
    }

    public boolean useRecomputation() {
        return this.useRecomputation;
    }

    public void setRecomputation(boolean on) {
        this.useRecomputation = on;
    }

    public <V extends Var> V[] getVar(Class c, Variable ... v) {
        Var[] tmp = (Var[])Array.newInstance(c, v.length);
        for (int i = 0; i < v.length; ++i) {
            tmp[i] = this.mapvariables.get(v[i].getIndexIn(this.model.getIndex()));
        }
        return tmp;
    }

    @Override
    public Var getVar(Variable v) {
        return this.mapvariables.get(v.getIndexIn(this.model.getIndex()));
    }

    @Override
    public Var[] getVar(Variable ... v) {
        return this.getVar(Variable.class, v);
    }

    @Override
    public IntDomainVar getVar(IntegerVariable v) {
        return (IntDomainVar)this.mapvariables.get(v.getIndexIn(this.model.getIndex()));
    }

    @Override
    public IntDomainVar[] getVar(IntegerVariable ... v) {
        return (IntDomainVar[])this.getVar(IntDomainVar.class, v);
    }

    @Override
    public RealVar getVar(RealVariable v) {
        return (RealVar)this.mapvariables.get(v.getIndexIn(this.model.getIndex()));
    }

    @Override
    public RealVar[] getVar(RealVariable ... v) {
        return (RealVar[])this.getVar(RealVar.class, v);
    }

    @Override
    public SetVar getVar(SetVariable v) {
        return (SetVar)this.mapvariables.get(v.getIndexIn(this.model.getIndex()));
    }

    @Override
    public SetVar[] getVar(SetVariable ... v) {
        return (SetVar[])this.getVar(SetVar.class, v);
    }

    @Override
    public TaskVar getVar(TaskVariable v) {
        return (TaskVar)this.mapvariables.get(v.getIndexIn(this.model.getIndex()));
    }

    @Override
    public TaskVar[] getVar(TaskVariable ... v) {
        return (TaskVar[])this.getVar(TaskVar.class, v);
    }

    @Override
    public SConstraint getCstr(Constraint ic) {
        return this.mapconstraints.get(ic.getIndexIn(this.model.getIndex()));
    }

    @Override
    public void setCardReasoning(boolean creas) {
        this.cardinalityReasonningsOnSETS = creas;
    }

    public void setTaskReasoning(boolean treas) {
        this.scheduler.setRedundantReasonningsOnTasks(treas);
    }

    @Override
    public Solution recordSolution() {
        Solution sol = new Solution(this);
        int nbv = this.getNbIntVars();
        for (int i = 0; i < nbv; ++i) {
            IntDomainVar vari = (IntDomainVar)this.getIntVar(i);
            if (!vari.isInstantiated()) continue;
            sol.recordIntValue(i, vari.getVal());
        }
        int nbsv = this.getNbSetVars();
        for (int i = 0; i < nbsv; ++i) {
            SetVar vari = this.getSetVar(i);
            if (!vari.isInstantiated()) continue;
            sol.recordSetValue(i, vari.getValue());
        }
        int nbrv = this.getNbRealVars();
        for (int i = 0; i < nbrv; ++i) {
            RealVar vari = this.getRealVar(i);
            sol.recordRealValue(i, vari.getValue());
        }
        if (this.strategy instanceof AbstractOptimize) {
            sol.recordIntObjective(((AbstractOptimize)this.strategy).getObjectiveValue());
        }
        for (Limit limit : this.limits.keySet()) {
            if (this.limits.get((Object)limit) != Boolean.TRUE) continue;
            sol.recordLimit(this.getSearchStrategy().getLimit(limit));
        }
        return sol;
    }

    @Override
    public void restoreSolution(Solution sol) {
        try {
            Var vari;
            int i;
            int nbv = this.getNbIntVars();
            for (i = 0; i < nbv; ++i) {
                vari = (IntDomainVar)this.getIntVar(i);
                if (sol.getIntValue(i) == Integer.MAX_VALUE) continue;
                vari.setVal(sol.getIntValue(i));
            }
            nbv = this.getNbSetVars();
            for (i = 0; i < nbv; ++i) {
                vari = this.getSetVar(i);
                vari.setVal(sol.getSetValue(i));
            }
            nbv = this.getNbRealVars();
            for (i = 0; i < nbv; ++i) {
                vari = this.getRealVar(i);
                vari.intersect(sol.getRealValue(i));
            }
            if (Choco.DEBUG) {
                if (this.nogoodStore != null) {
                    this.nogoodStore.setPassive();
                }
                CPSolver.flushLogs();
                this.propagate();
                if (this.nogoodStore != null) {
                    this.nogoodStore.setActive();
                }
            }
        }
        catch (ContradictionException e) {
            logger.severe("BUG in restoring solution !!!!!!!!!!!!!!!!");
            throw new SolverException("Restored solution not consistent !!");
        }
    }

    @Override
    public Collection<AbstractGlobalSearchLimit> getSolutionLimits() {
        if (this.strategy.existsSolution()) {
            return this.strategy.solutionLimits == null ? Collections.unmodifiableCollection(this.strategy.limits) : this.strategy.solutionLimits;
        }
        return null;
    }

    private static void setDefaultHandler() {
        CPSolver.setHandler(Logger.getLogger("choco"), new StreamHandler(System.err, new LightFormatter()));
        CPSolver.setHandler(Logger.getLogger("choco.kernel.solver.search"), new StreamHandler(System.err, new LightFormatter()));
        CPSolver.setHandler(Logger.getLogger("choco.kernel.solver.propagation"), new StreamHandler(System.err, new LightFormatter()));
        Logger.getLogger("choco.kernel.solver.propagation.const").setLevel(Level.SEVERE);
        Logger.getLogger("choco.kernel.memory").setLevel(Level.SEVERE);
        Logger.getLogger("choco.currentElement").setLevel(Level.SEVERE);
    }

    private static void setHandler(Logger logger, Handler handler) {
        logger.setUseParentHandlers(false);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(handler);
    }

    public static void setVerbosity(int verbosity) {
        switch (verbosity) {
            case 1: {
                CPSolver.setVerbosity(Logger.getLogger("choco"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search.branching"), Level.SEVERE);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.propagation"), Level.SEVERE);
                break;
            }
            case 2: {
                CPSolver.setVerbosity(Logger.getLogger("choco"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search.branching"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.propagation"), Level.SEVERE);
                break;
            }
            case 3: {
                CPSolver.setVerbosity(Logger.getLogger("choco"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search.branching"), Level.ALL);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.propagation"), Level.INFO);
                break;
            }
            case 4: {
                CPSolver.setVerbosity(Logger.getLogger("choco"), Level.FINEST);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search"), Level.FINEST);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search.branching"), Level.FINEST);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.propagation"), Level.FINEST);
                break;
            }
            default: {
                CPSolver.setVerbosity(Logger.getLogger("choco"), Level.SEVERE);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search"), Level.SEVERE);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.search.branching"), Level.SEVERE);
                CPSolver.setVerbosity(Logger.getLogger("choco.kernel.solver.propagation"), Level.SEVERE);
            }
        }
    }

    public static void flushLogs() {
        CPSolver.flushLog(Logger.getLogger("choco"));
        CPSolver.flushLog(Logger.getLogger("choco.kernel.solver.search"));
        CPSolver.flushLog(Logger.getLogger("choco.kernel.solver.search.branching"));
        CPSolver.flushLog(Logger.getLogger("choco.kernel.solver.propagation"));
    }

    protected static void setVerbosity(Logger logger, Level level) {
        logger.setLevel(level);
        for (Handler h : logger.getHandlers()) {
            h.setLevel(level);
        }
    }

    protected static void flushLog(Logger logger) {
        for (Handler h : logger.getHandlers()) {
            h.flush();
        }
    }

    @Override
    public IntDomainVar createIntVar(String name, int domainType, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, domainType, min, max);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBooleanVar(String name) {
        BooleanVarImpl v = new BooleanVarImpl(this, name);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createEnumIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 0, min, max);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBoundIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 1, min, max);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBinTreeIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 3, min, max);
        this.intVars.add(v);
        return v;
    }

    public IntDomainVar createListIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 2, min, max);
        this.intVars.add(v);
        return v;
    }

    public IntDomainVar createListIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 2, sortedValues);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createEnumIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 0, sortedValues);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBinTreeIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 3, sortedValues);
        this.intVars.add(v);
        return v;
    }

    @Override
    public RealVar createRealVal(String name, double min, double max) {
        RealVarImpl v = new RealVarImpl(this, name, min, max, 0);
        this.floatVars.add(v);
        return v;
    }

    @Override
    public RealIntervalConstant createRealIntervalConstant(double a, double b) {
        return new RealIntervalConstant(a, b);
    }

    @Override
    public RealIntervalConstant cst(double d) {
        return this.createRealIntervalConstant(d, d);
    }

    @Override
    public RealIntervalConstant cst(double a, double b) {
        return this.createRealIntervalConstant(a, b);
    }

    public SetVar createSetVar(String name, int a, int b, IntDomainVar card) {
        SetVarImpl s = new SetVarImpl((Solver)this, name, a, b, card);
        this.setVars.add(s);
        this.post((SConstraint)new SetCard(s, s.getCard(), true, true));
        return s;
    }

    @Override
    public SetVar createSetVar(String name, int a, int b, int type) {
        SetVarImpl s = new SetVarImpl(this, name, a, b, null, type);
        this.setVars.add(s);
        this.intVars.add(s.getCard());
        this.post((SConstraint)new SetCard(s, s.getCard(), true, true));
        return s;
    }

    @Override
    public SetVar createBoundSetVar(String name, int a, int b) {
        return this.createSetVar(name, a, b, 0);
    }

    @Override
    public SetVar createEnumSetVar(String name, int a, int b) {
        return this.createSetVar(name, a, b, 1);
    }

    @Override
    public TaskVar createTaskVar(String name, IntDomainVar start, IntDomainVar end, IntDomainVar duration) {
        TaskVar t = new TaskVar(this, this.getNbTaskVars(), name, start, end, duration);
        this.taskVars.add(t);
        return t;
    }

    @Override
    public IntDomainVar createIntegerConstant(String name, int val) {
        if (this.intconstantVars.containsKey(val)) {
            return this.intconstantVars.get(val);
        }
        IntDomainVar v = this.createIntVar(name, 1, val, val);
        this.intconstantVars.put(val, v);
        return v;
    }

    @Override
    public RealIntervalConstant createRealConstant(String name, double val) {
        if (this.realconstantVars.containsKey(val)) {
            return this.realconstantVars.get(val);
        }
        RealIntervalConstant v = this.createRealIntervalConstant(val, val);
        this.realconstantVars.put(val, v);
        return v;
    }

    public IntDomainVar makeConstantIntVar(String name, int val) {
        return this.createIntegerConstant(name, val);
    }

    public IntDomainVar makeConstantIntVar(int val) {
        return this.createIntegerConstant("", val);
    }

    @Override
    public SConstraint eq(IntExp x, IntExp y) {
        if (x instanceof IntVar && y instanceof IntVar) {
            return new EqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
        }
        if ((x instanceof IntTerm || x instanceof IntVar) && (y instanceof IntTerm || y instanceof IntVar)) {
            return this.eq(this.minus(x, y), 0);
        }
        if (x == null) {
            return this.eq(y, 0);
        }
        if (y == null) {
            return this.eq(x, 0);
        }
        throw new SolverException("IntExp not a good exp");
    }

    @Override
    public SConstraint eq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            IntTerm t = (IntTerm)x;
            int nbvars = t.getSize();
            int c2 = c - t.getConstant();
            if (t.getSize() == 1) {
                if (t.getCoefficient(0) == 0) {
                    if (c2 == 0) {
                        return TRUE;
                    }
                    return FALSE;
                }
                if (c2 % t.getCoefficient(0) == 0) {
                    return new EqualXC((IntDomainVar)t.getVariable(0), c2 / t.getCoefficient(0));
                }
                return FALSE;
            }
            if (nbvars == 2 && t.getCoefficient(0) + t.getCoefficient(1) == 0) {
                return new EqualXYC((IntDomainVar)t.getVariable(0), (IntDomainVar)t.getVariable(1), c2 / t.getCoefficient(0));
            }
            return this.makeIntLinComb(t.getVariables(), t.getCoefficients(), -c2, 0);
        }
        if (x instanceof IntVar) {
            return new EqualXC((IntDomainVar)x, c);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public SConstraint eq(int c, IntExp x) {
        return this.eq(x, c);
    }

    @Override
    public SConstraint eq(RealVar r, IntDomainVar i) {
        return new MixedEqXY(r, i);
    }

    public SConstraint eqCard(SetVar s, IntDomainVar i) {
        return this.eq((IntExp)s.getCard(), (IntExp)i);
    }

    public SConstraint eqCard(SetVar s, int i) {
        return this.eq((IntExp)s.getCard(), i);
    }

    @Override
    public SConstraint geq(IntExp x, IntExp y) {
        if (x instanceof IntVar && y instanceof IntVar) {
            return new GreaterOrEqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
        }
        if ((x instanceof IntTerm || x instanceof IntVar) && (y instanceof IntTerm || y instanceof IntVar)) {
            return this.geq(this.minus(x, y), 0);
        }
        if (y == null) {
            return this.geq(x, 0);
        }
        if (x == null) {
            return this.geq(0, y);
        }
        throw new SolverException("IntExp not a good exp");
    }

    @Override
    public SConstraint geq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            IntTerm t = (IntTerm)x;
            if (t.getSize() == 2 && t.getCoefficient(0) + t.getCoefficient(1) == 0) {
                if (t.getCoefficient(0) > 0) {
                    return new GreaterOrEqualXYC((IntDomainVar)t.getVariable(0), (IntDomainVar)t.getVariable(1), (c - t.getConstant()) / t.getCoefficient(0));
                }
                return new GreaterOrEqualXYC((IntDomainVar)t.getVariable(1), (IntDomainVar)t.getVariable(0), (c - t.getConstant()) / t.getCoefficient(1));
            }
            return this.makeIntLinComb(((IntTerm)x).getVariables(), ((IntTerm)x).getCoefficients(), ((IntTerm)x).getConstant() - c, 1);
        }
        if (x instanceof IntVar) {
            return new GreaterOrEqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            if (c <= 0) {
                return TRUE;
            }
            return FALSE;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public SConstraint geq(int c, IntExp x) {
        if (x instanceof IntTerm) {
            int[] coeffs = ((IntTerm)x).getCoefficients();
            int n = coeffs.length;
            int[] oppcoeffs = new int[n];
            for (int i = 0; i < n; ++i) {
                oppcoeffs[i] = -coeffs[i];
            }
            return this.makeIntLinComb(((IntTerm)x).getVariables(), oppcoeffs, c - ((IntTerm)x).getConstant(), 1);
        }
        if (x instanceof IntVar) {
            return new LessOrEqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            if (c <= 0) {
                return TRUE;
            }
            return FALSE;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public SConstraint geqCard(SetVar sv, IntDomainVar v) {
        return this.geq((IntExp)sv.getCard(), (IntExp)v);
    }

    public SConstraint geqCard(SetVar sv, int v) {
        return this.geq((IntExp)sv.getCard(), v);
    }

    @Override
    public SConstraint gt(IntExp x, IntExp y) {
        return this.geq(this.minus(x, y), 1);
    }

    @Override
    public SConstraint gt(IntExp x, int c) {
        return this.geq(x, c + 1);
    }

    @Override
    public SConstraint gt(int c, IntExp x) {
        return this.geq(c - 1, x);
    }

    @Override
    public SConstraint leq(IntExp v1, IntExp v2) {
        return this.geq(v2, v1);
    }

    @Override
    public SConstraint leq(IntExp v1, int v2) {
        return this.geq(v2, v1);
    }

    @Override
    public SConstraint leq(int v1, IntExp v2) {
        return this.geq(v2, v1);
    }

    public SConstraint leqCard(SetVar sv, IntDomainVar i) {
        return this.leq((IntExp)sv.getCard(), (IntExp)i);
    }

    public SConstraint leqCard(SetVar sv, int i) {
        return this.leq((IntExp)sv.getCard(), i);
    }

    @Override
    public SConstraint lt(IntExp v1, IntExp v2) {
        return this.gt(v2, v1);
    }

    @Override
    public SConstraint lt(IntExp v1, int v2) {
        return this.gt(v2, v1);
    }

    @Override
    public SConstraint lt(int v1, IntExp v2) {
        return this.gt(v2, v1);
    }

    public IntExp minus(IntExp t1, IntExp t2) {
        if (t1 == ZERO) {
            return this.mult(-1, t2);
        }
        if (t2 == ZERO) {
            return t1;
        }
        if (t1 instanceof IntTerm) {
            if (t2 instanceof IntTerm) {
                int[] coeffs2 = ((IntTerm)t2).getCoefficients();
                int n2 = coeffs2.length;
                int[] oppcoeffs2 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    oppcoeffs2[i] = -coeffs2[i];
                }
                return CPSolver.plus(((IntTerm)t1).getCoefficients(), ((IntTerm)t1).getVariables(), ((IntTerm)t1).getConstant(), oppcoeffs2, ((IntTerm)t2).getVariables(), -((IntTerm)t2).getConstant());
            }
            if (t2 instanceof IntVar) {
                return CPSolver.plus(((IntTerm)t1).getCoefficients(), ((IntTerm)t1).getVariables(), ((IntTerm)t1).getConstant(), new int[]{-1}, new IntVar[]{(IntVar)t2}, 0);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (t1 instanceof IntVar) {
            if (t2 instanceof IntTerm) {
                int[] coeffs2 = ((IntTerm)t2).getCoefficients();
                int n2 = coeffs2.length;
                int[] oppcoeffs2 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    oppcoeffs2[i] = -coeffs2[i];
                }
                return CPSolver.plus(new int[]{1}, new IntVar[]{(IntVar)t1}, 0, oppcoeffs2, ((IntTerm)t2).getVariables(), -((IntTerm)t2).getConstant());
            }
            if (t2 instanceof IntVar) {
                IntTerm t = new IntTerm(2);
                t.setCoefficient(0, 1);
                t.setCoefficient(1, -1);
                t.setVariable(0, (IntVar)t1);
                t.setVariable(1, (IntVar)t2);
                t.setConstant(0);
                return t;
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public IntExp minus(IntExp t, int c) {
        if (t == ZERO) {
            IntTerm t2 = new IntTerm(0);
            t2.setConstant(-c);
            return t2;
        }
        if (t instanceof IntTerm) {
            IntTerm t2 = new IntTerm((IntTerm)t);
            t2.setConstant(((IntTerm)t).getConstant() - c);
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, 1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(-c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public IntExp minus(int c, IntExp t) {
        if (t instanceof IntTerm) {
            IntTerm t1 = (IntTerm)t;
            int n = t1.getSize();
            IntTerm t2 = new IntTerm(n);
            for (int i = 0; i < n; ++i) {
                t2.setCoefficient(i, -t1.getCoefficient(i));
                t2.setVariable(i, t1.getVariable(i));
            }
            t2.setConstant(c - t1.getConstant());
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, -1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public IntExp plus(IntExp t1, IntExp t2) {
        if (t1 == ZERO) {
            return t2;
        }
        if (t2 == ZERO) {
            return t1;
        }
        if (t1 instanceof IntTerm) {
            if (t2 instanceof IntTerm) {
                return CPSolver.plus(((IntTerm)t1).getCoefficients(), ((IntTerm)t1).getVariables(), ((IntTerm)t1).getConstant(), ((IntTerm)t2).getCoefficients(), ((IntTerm)t2).getVariables(), ((IntTerm)t2).getConstant());
            }
            if (t2 instanceof IntVar) {
                return CPSolver.plus(((IntTerm)t1).getCoefficients(), ((IntTerm)t1).getVariables(), ((IntTerm)t1).getConstant(), new int[]{1}, new IntVar[]{(IntVar)t2}, 0);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (t1 instanceof IntVar) {
            if (t2 instanceof IntTerm) {
                return CPSolver.plus(new int[]{1}, new IntVar[]{(IntVar)t1}, 0, ((IntTerm)t2).getCoefficients(), ((IntTerm)t2).getVariables(), ((IntTerm)t2).getConstant());
            }
            if (t2 instanceof IntVar) {
                IntTerm t = new IntTerm(2);
                t.setCoefficient(0, 1);
                t.setCoefficient(1, 1);
                t.setVariable(0, (IntVar)t1);
                t.setVariable(1, (IntVar)t2);
                t.setConstant(0);
                return t;
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public IntExp plus(IntExp t, int c) {
        if (t == ZERO) {
            IntTerm t2 = new IntTerm(0);
            t2.setConstant(c);
            return t2;
        }
        if (t instanceof IntTerm) {
            IntTerm t2 = new IntTerm((IntTerm)t);
            t2.setConstant(((IntTerm)t).getConstant() + c);
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, 1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public final IntExp plus(int c, IntExp t1) {
        return this.plus(t1, c);
    }

    protected static IntExp plus(int[] coeffs1, IntVar[] vars1, int cste1, int[] coeffs2, IntVar[] vars2, int cste2) {
        int i;
        int n1 = vars1.length;
        int n2 = vars2.length;
        IntTerm t = new IntTerm(n1 + n2);
        for (i = 0; i < n1; ++i) {
            t.setVariable(i, vars1[i]);
            t.setCoefficient(i, coeffs1[i]);
        }
        for (i = 0; i < n2; ++i) {
            t.setVariable(n1 + i, vars2[i]);
            t.setCoefficient(n1 + i, coeffs2[i]);
        }
        t.setConstant(cste1 + cste2);
        return t;
    }

    public IntExp mult(int a, IntExp x) {
        if (a != 0 && x != ZERO) {
            IntTerm t = new IntTerm(1);
            t.setCoefficient(0, a);
            t.setVariable(0, (IntVar)x);
            return t;
        }
        return ZERO;
    }

    @Override
    public SConstraint neq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            IntTerm t = (IntTerm)x;
            if (t.getSize() == 2 && t.getCoefficient(0) + t.getCoefficient(1) == 0) {
                IntDomainVar v1 = (IntDomainVar)t.getVariable(0);
                IntDomainVar v2 = (IntDomainVar)t.getVariable(1);
                if (v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain()) {
                    return new NotEqualXYCEnum(v1, v2, (c - t.getConstant()) / t.getCoefficient(0));
                }
                return new NotEqualXYC(v1, v2, (c - t.getConstant()) / t.getCoefficient(0));
            }
            return this.makeIntLinComb(((IntTerm)x).getVariables(), ((IntTerm)x).getCoefficients(), -c, 2);
        }
        if (x instanceof IntVar) {
            return new NotEqualXC((IntDomainVar)x, c);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public SConstraint neq(int c, IntExp x) {
        return this.neq(x, c);
    }

    @Override
    public SConstraint neq(IntExp x, IntExp y) {
        if (x instanceof IntTerm) {
            return this.neq(this.minus(x, y), 0);
        }
        if (x instanceof IntVar) {
            if (y instanceof IntTerm) {
                return this.neq(this.minus(x, y), 0);
            }
            if (y instanceof IntVar) {
                if (((IntDomainVar)x).hasEnumeratedDomain() && ((IntDomainVar)y).hasEnumeratedDomain()) {
                    return new NotEqualXYCEnum((IntDomainVar)x, (IntDomainVar)y, 0);
                }
                return new NotEqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
            }
            if (y == null) {
                return this.neq(x, 0);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (x == null) {
            return this.neq(0, y);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public SConstraint eq(SetVar s1, SetVar s2) {
        return new SetEq(s1, s2);
    }

    public SConstraint neq(SetVar s1, SetVar s2) {
        return new SetNotEq(s1, s2);
    }

    public SConstraint occurence(IntDomainVar[] vars, IntDomainVar occ, int value) {
        IntDomainVar[] tmpvars = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, tmpvars, 0, vars.length);
        tmpvars[tmpvars.length - 1] = occ;
        return new Occurrence(tmpvars, value, true, true);
    }

    public int countNonNullCoeffs(int[] lcoeffs) {
        int nbNonNull = 0;
        for (int lcoeff : lcoeffs) {
            if (lcoeff == 0) continue;
            ++nbNonNull;
        }
        return nbNonNull;
    }

    protected SConstraint makeIntLinComb(IntVar[] lvars, int[] lcoeffs, int c, int linOperator) {
        int i;
        int nbNonNullCoeffs = this.countNonNullCoeffs(lcoeffs);
        int[] sortedCoeffs = new int[nbNonNullCoeffs];
        IntVar[] sortedVars = new IntVar[nbNonNullCoeffs];
        int j = 0;
        for (i = 0; i < lvars.length; ++i) {
            if (lcoeffs[i] <= 0) continue;
            sortedVars[j] = lvars[i];
            sortedCoeffs[j] = lcoeffs[i];
            ++j;
        }
        int nbPositiveCoeffs = j;
        for (i = 0; i < lvars.length; ++i) {
            if (lcoeffs[i] >= 0) continue;
            sortedVars[j] = lvars[i];
            sortedCoeffs[j] = lcoeffs[i];
            ++j;
        }
        if (nbNonNullCoeffs == 0) {
            if (linOperator == 0 && c == 0) {
                return TRUE;
            }
            if (linOperator == 1 && 0 <= c) {
                return TRUE;
            }
            if (linOperator == 3 && 0 >= c) {
                return TRUE;
            }
            return FALSE;
        }
        return this.createIntLinComb(sortedVars, sortedCoeffs, nbPositiveCoeffs, c, linOperator);
    }

    protected SConstraint createIntLinComb(IntVar[] sortedVars, int[] sortedCoeffs, int nbPositiveCoeffs, int c, int linOperator) {
        IntVar[] tmpVars = new IntDomainVar[sortedVars.length];
        System.arraycopy(sortedVars, 0, tmpVars, 0, sortedVars.length);
        if (this.isBoolLinComb((IntDomainVar[])tmpVars, sortedCoeffs, linOperator)) {
            return this.createBoolLinComb(tmpVars, sortedCoeffs, c, linOperator);
        }
        return new IntLinComb((IntDomainVar[])tmpVars, sortedCoeffs, nbPositiveCoeffs, c, linOperator);
    }

    protected boolean isBoolLinComb(IntDomainVar[] lvars, int[] lcoeffs, int linOperator) {
        if (linOperator == 2) {
            return false;
        }
        if (lvars.length <= 1) {
            return false;
        }
        int nbEnum = 0;
        for (IntDomainVar lvar : lvars) {
            if (!lvar.hasBooleanDomain()) {
                ++nbEnum;
            }
            if (nbEnum <= 1) continue;
            return false;
        }
        return true;
    }

    protected SConstraint createBoolLinComb(IntVar[] vars, int[] lcoeffs, int c, int linOperator) {
        IntDomainVar[] lvars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, lvars, 0, vars.length);
        int idxSingleEnum = -1;
        int coefSingleEnum = Integer.MIN_VALUE;
        for (int i = 0; i < lvars.length; ++i) {
            if (lvars[i].hasBooleanDomain()) continue;
            idxSingleEnum = i;
            coefSingleEnum = -lcoeffs[i];
        }
        int nbVar = idxSingleEnum == -1 ? lvars.length : lvars.length - 1;
        IntDomainVar[] vs = new IntDomainVar[nbVar];
        int[] coefs = new int[nbVar];
        int cpt = 0;
        for (int i = 0; i < lvars.length; ++i) {
            if (i == idxSingleEnum) continue;
            vs[cpt] = lvars[i];
            coefs[cpt] = lcoeffs[i];
            ++cpt;
        }
        if (idxSingleEnum == -1) {
            return this.createBoolLinComb(vs, coefs, null, Integer.MAX_VALUE, c, linOperator);
        }
        return this.createBoolLinComb(vs, coefs, lvars[idxSingleEnum], coefSingleEnum, c, linOperator);
    }

    protected SConstraint createBoolLinComb(IntDomainVar[] vs, int[] coefs, IntDomainVar obj, int objcoef, int c, int linOperator) {
        UtilAlgo.quicksort(coefs, vs, 0, coefs.length - 1);
        if (obj == null) {
            boolean isAsum = true;
            for (int i = 0; i < vs.length && isAsum; ++i) {
                if (coefs[i] == 1) continue;
                isAsum = false;
            }
            if (isAsum) {
                return new BoolSum(vs, -c, linOperator);
            }
            IntDomainVar dummyObj = this.makeConstantIntVar(-c);
            return new BoolIntLinComb(vs, coefs, dummyObj, 1, 0, linOperator);
        }
        int newLinOp = linOperator;
        if (objcoef < 0) {
            if (linOperator != 2) {
                objcoef = -objcoef;
                c = -c;
                UtilAlgo.reverse(coefs, vs);
                UtilAlgo.inverseSign(coefs);
            }
            if (linOperator == 1) {
                newLinOp = 3;
            } else if (linOperator == 3) {
                newLinOp = 1;
            }
        }
        return new BoolIntLinComb(vs, coefs, obj, objcoef, c, newLinOp);
    }

    public SConstraint makeEquation(RealExp exp, RealIntervalConstant cst) {
        HashSet<RealVar> collectedVars = new HashSet<RealVar>();
        exp.collectVars(collectedVars);
        RealVar[] tmpVars = new RealVar[]{};
        tmpVars = collectedVars.toArray(tmpVars);
        return this.createEquation(tmpVars, exp, cst);
    }

    public SConstraint eq(RealExp exp1, RealExp exp2) {
        if (exp1 instanceof RealIntervalConstant) {
            return this.makeEquation(exp2, (RealIntervalConstant)exp1);
        }
        if (exp2 instanceof RealIntervalConstant) {
            return this.makeEquation(exp1, (RealIntervalConstant)exp2);
        }
        return this.makeEquation(this.minus(exp1, exp2), this.cst(0.0));
    }

    public SConstraint eq(RealExp exp, double cst) {
        return this.makeEquation(exp, this.cst(cst));
    }

    public SConstraint eq(double cst, RealExp exp) {
        return this.makeEquation(exp, this.cst(cst));
    }

    public SConstraint leq(RealExp exp1, RealExp exp2) {
        if (exp1 instanceof RealIntervalConstant) {
            return this.makeEquation(exp2, this.cst(exp1.getInf(), Double.POSITIVE_INFINITY));
        }
        if (exp2 instanceof RealIntervalConstant) {
            return this.makeEquation(exp1, this.cst(Double.NEGATIVE_INFINITY, exp2.getSup()));
        }
        return this.makeEquation(this.minus(exp1, exp2), this.cst(Double.NEGATIVE_INFINITY, 0.0));
    }

    public SConstraint leq(RealExp exp, double cst) {
        return this.makeEquation(exp, this.cst(Double.NEGATIVE_INFINITY, cst));
    }

    public SConstraint leq(double cst, RealExp exp) {
        return this.makeEquation(exp, this.cst(cst, Double.POSITIVE_INFINITY));
    }

    public SConstraint geq(RealExp exp1, RealExp exp2) {
        return this.leq(exp2, exp1);
    }

    public SConstraint geq(RealExp exp, double cst) {
        return this.leq(cst, exp);
    }

    public SConstraint geq(double cst, RealExp exp) {
        return this.leq(exp, cst);
    }

    public RealExp plus(RealExp exp1, RealExp exp2) {
        return this.createRealPlus(exp1, exp2);
    }

    public RealExp minus(RealExp exp1, RealExp exp2) {
        return this.createRealMinus(exp1, exp2);
    }

    public RealExp mult(RealExp exp1, RealExp exp2) {
        return this.createRealMult(exp1, exp2);
    }

    public RealExp power(RealExp exp, int power) {
        return this.createRealIntegerPower(exp, power);
    }

    public RealExp cos(RealExp exp) {
        return this.createRealCos(exp);
    }

    public RealExp sin(RealExp exp) {
        return this.createRealSin(exp);
    }

    public RealIntervalConstant around(double d) {
        return this.cst(RealMath.prevFloat(d), RealMath.nextFloat(d));
    }

    protected RealExp createRealSin(RealExp exp) {
        return new RealSin(this, exp);
    }

    protected RealExp createRealCos(RealExp exp) {
        return new RealCos(this, exp);
    }

    protected RealExp createRealPlus(RealExp exp1, RealExp exp2) {
        return new RealPlus(this, exp1, exp2);
    }

    protected RealExp createRealMinus(RealExp exp1, RealExp exp2) {
        return new RealMinus(this, exp1, exp2);
    }

    protected RealExp createRealMult(RealExp exp1, RealExp exp2) {
        return new RealMult(this, exp1, exp2);
    }

    protected RealExp createRealIntegerPower(RealExp exp, int power) {
        return new RealIntegerPower(this, exp, power);
    }

    protected SConstraint createEquation(RealVar[] tmpVars, RealExp exp, RealIntervalConstant cst) {
        return new Equation(this, tmpVars, exp, cst);
    }

    @Override
    public IntExp scalar(int[] lc, IntDomainVar[] lv) {
        int n = lc.length;
        assert (lv.length == n);
        IntTerm t = new IntTerm(n);
        for (int i = 0; i < n; ++i) {
            t.setCoefficient(i, lc[i]);
            if (!(lv[i] instanceof IntVar)) {
                throw new SolverException("unknown kind of IntDomainVar");
            }
            t.setVariable(i, lv[i]);
        }
        return t;
    }

    @Override
    public final IntExp scalar(IntDomainVar[] lv, int[] lc) {
        return this.scalar(lc, lv);
    }

    @Override
    public IntExp sum(IntExp ... lv) {
        int n = lv.length;
        IntTerm t = new IntTerm(n);
        for (int i = 0; i < n; ++i) {
            t.setCoefficient(i, 1);
            if (!(lv[i] instanceof IntVar)) {
                throw new SolverException("unexpected kind of IntExp");
            }
            t.setVariable(i, (IntVar)lv[i]);
        }
        return t;
    }

    public SConstraint feasiblePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint feasiblePairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint infeasiblePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint infeasiblePairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    @Override
    public BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2);
        for (int[] couple : mat) {
            if (couple.length != 2) {
                throw new SolverException("Wrong dimension : " + couple.length + " for a couple");
            }
            relation.setCouple(couple[0], couple[1]);
        }
        return relation;
    }

    @Override
    public BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas) {
        return this.makeBinRelation(min, max, mat, feas, false);
    }

    public BinRelation makeBinRelation(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas, boolean bitset) {
        IntDomainVar x = v1;
        IntDomainVar y = v2;
        int n1 = x.getSup() - x.getInf() + 1;
        int n2 = y.getSup() - y.getInf() + 1;
        if (n1 == mat.length && n2 == mat[0].length) {
            ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, v1.getInf(), v2.getInf(), n1, n2) : new CouplesTable(feas, v1.getInf(), v2.getInf(), n1, n2);
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!mat[i][j]) continue;
                    relation.setCouple(i + v1.getInf(), j + v2.getInf());
                }
            }
            return relation;
        }
        throw new SolverException("Wrong dimension for the matrix of consistency : " + mat.length + " X " + mat[0].length + " instead of " + n1 + "X" + n2);
    }

    public BinRelation makeBinRelation(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas) {
        return this.makeBinRelation(v1, v2, mat, feas, false);
    }

    private SConstraint makePairAC(IntDomainVar x, IntDomainVar y, List<int[]> mat, boolean feas, int ac) {
        int[] min = new int[]{x.getInf(), y.getInf()};
        int[] max = new int[]{x.getSup(), y.getSup()};
        BinRelation relation = this.makeBinRelation(min, max, mat, feas, ac == 322);
        return this.relationPairAC(x, y, relation, ac);
    }

    public SConstraint makeTupleAC(IntDomainVar[] vs, List<int[]> tuples, boolean feas) {
        int[] min = new int[vs.length];
        int[] max = new int[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            min[i] = vs[i].getInf();
            max[i] = vs[i].getSup();
        }
        LargeRelation relation = this.makeLargeRelation(min, max, tuples, feas);
        return this.relationTupleAC(vs, relation);
    }

    private SConstraint makePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas, int ac) {
        BinRelation relation = this.makeBinRelation(v1, v2, mat, feas, ac == 322);
        return this.relationPairAC(v1, v2, relation, ac);
    }

    public SConstraint feasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.feasibleTupleAC(vars, tuples, 32);
    }

    public SConstraint infeasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.infeasibleTupleAC(vars, tuples, 32);
    }

    public SConstraint feasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples, int ac) {
        LargeRelation relation = this.makeRelation(vars, tuples, true);
        if (ac == 2001) {
            return new GAC2001PositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        if (ac == 32) {
            return new GAC3rmPositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        throw new SolverException("unknown ac algorithm, must be 32 or 2001");
    }

    public SConstraint infeasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples, int ac) {
        LargeRelation relation = this.makeRelation(vars, tuples, false);
        if (ac == 2001) {
            return new GAC2001PositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        if (ac == 32) {
            return new GAC3rmPositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        throw new SolverException("unknown ac algorithm, must be 32 or 2001");
    }

    public SConstraint relationPairAC(IntDomainVar v1, IntDomainVar v2, BinRelation binR, int ac) {
        if (ac == 3) {
            return new AC3BinSConstraint(v1, v2, binR);
        }
        if (ac == 4) {
            throw new SolverException("ac4 not implemented in choco2");
        }
        if (ac == 2001) {
            return new AC2001BinSConstraint(v1, v2, binR);
        }
        if (ac == 32) {
            return new AC3rmBinSConstraint(v1, v2, binR);
        }
        if (ac == 322) {
            return new AC3rmBitBinSConstraint(v1, v2, (CouplesBitSetTable)binR);
        }
        throw new UnsupportedOperationException("Ac " + ac + " algorithm not yet implemented");
    }

    @Deprecated
    public LargeRelation makeRelation(IntVar[] vs, List<int[]> tuples, boolean feas) {
        int[] min = new int[vs.length];
        int[] max = new int[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            min[i] = ((IntDomainVar)vs[i]).getInf();
            max[i] = ((IntDomainVar)vs[i]).getSup();
        }
        return this.makeLargeRelation(min, max, tuples, feas);
    }

    @Override
    public LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas) {
        return this.makeLargeRelation(min, max, tuples, feas, feas ? 0 : 1);
    }

    @Override
    public LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas, int scheme) {
        LargeRelation relation;
        int n = min.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = max[i] - min[i] + 1;
            offsets[i] = min[i];
        }
        if (scheme == 0) {
            relation = new IterTuplesTable(tuples, offsets, sizes);
        } else if (scheme == 1) {
            relation = new TuplesTable(feas, offsets, sizes);
            for (int[] tuple : tuples) {
                if (tuple.length != n) {
                    throw new SolverException("Wrong dimension : " + tuple.length + " for a tuple (should be " + n + ")");
                }
                ((TuplesTable)relation).setTuple(tuple);
            }
        } else {
            relation = new TuplesList(tuples);
        }
        return relation;
    }

    public SConstraint makeTupleFC(IntDomainVar[] vs, List<int[]> tuples, boolean feas) {
        int n = vs.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            IntDomainVar vi = vs[i];
            sizes[i] = vi.getSup() - vi.getInf() + 1;
            offsets[i] = vi.getInf();
        }
        TuplesTable relation = new TuplesTable(feas, offsets, sizes);
        for (int[] tuple : tuples) {
            if (tuple.length != n) {
                throw new SolverException("Wrong dimension : " + tuple.length + " for a tuple (should be " + n + ")");
            }
            relation.setTuple(tuple);
        }
        return this.createFCLargeConstraint(vs, relation);
    }

    public SConstraint feasibleTupleFC(IntDomainVar[] vars, TuplesTable tuples) {
        return new CspLargeSConstraint(vars, tuples);
    }

    public SConstraint infeasibleTupleFC(IntDomainVar[] vars, TuplesTable tuples) {
        return new CspLargeSConstraint(vars, tuples);
    }

    public SConstraint infeasTupleFC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleFC(vars, tuples, false);
    }

    public SConstraint feasTupleFC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleFC(vars, tuples, true);
    }

    public SConstraint infeasTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleAC(vars, tuples, false);
    }

    public SConstraint feasTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleAC(vars, tuples, true);
    }

    public SConstraint relationTupleFC(IntDomainVar[] vs, LargeRelation rela) {
        return this.createFCLargeConstraint(vs, rela);
    }

    protected SConstraint createFCLargeConstraint(IntDomainVar[] vars, LargeRelation relation) {
        IntDomainVar[] tmpVars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, tmpVars, 0, vars.length);
        return new CspLargeSConstraint(tmpVars, relation);
    }

    @Override
    public SConstraint relationTupleAC(IntDomainVar[] vs, LargeRelation rela) {
        return this.relationTupleAC(vs, rela, 32);
    }

    @Override
    public SConstraint relationTupleAC(IntDomainVar[] vs, LargeRelation rela, int ac) {
        if (rela instanceof IterLargeRelation) {
            if (ac == 32) {
                return new GAC3rmPositiveLargeConstraint(vs, (IterTuplesTable)rela);
            }
            if (ac == 2001) {
                return new GAC2001PositiveLargeConstraint(vs, (IterTuplesTable)rela);
            }
            throw new SolverException("GAC algo unknown, choose between 32 or 2001");
        }
        if (ac == 32) {
            return new GAC3rmLargeConstraint(vs, rela);
        }
        if (ac == 2001) {
            return new GAC2001LargeSConstraint(vs, rela);
        }
        if (ac == 2008) {
            return new GACstrPositiveLargeSConstraint(vs, rela);
        }
        throw new SolverException("GAC algo unknown, choose between 32, 2001, 2008");
    }

    public SConstraint relationPairAC(IntDomainVar v1, IntDomainVar v2, BinRelation binR) {
        return this.relationPairAC(v1, v2, binR, binR instanceof CouplesBitSetTable ? 322 : 32);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat) {
        return this.makePairAC(v1, v2, mat, false, 322);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat) {
        return this.makePairAC(v1, v2, mat, true, 322);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat) {
        return this.makePairAC(v1, v2, mat, false, 322);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat) {
        return this.makePairAC(v1, v2, mat, true, 322);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint reifiedIntConstraint(IntDomainVar binVar, SConstraint c) {
        return new ReifiedIntSConstraint(binVar, (AbstractIntSConstraint)c);
    }

    public SConstraint reifiedIntConstraint(IntDomainVar binVar, SConstraint c, SConstraint opc) {
        return new ReifiedIntSConstraint(binVar, (AbstractIntSConstraint)c, (AbstractIntSConstraint)opc);
    }

    static {
        try {
            CPSolver.setDefaultHandler();
            CPSolver.setVerbosity(0);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

