/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver;

import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.preprocessor.detectors.ExpressionDetector;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.IComponentVariable;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealConstantVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetConstantVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CPModelToCPSolver {
    protected CPSolver cpsolver;
    protected ExpressionDetector expDetect;
    public static final ArrayList<Class> CLASS_LIST = new ArrayList();
    protected HashMap<String, VariableManager> variableManagers = new HashMap();
    private HashSet<IntDomainVar> intDecisionVar = new HashSet();
    private HashSet<IntDomainVar> intNoDecisionVar = new HashSet();
    private HashSet<SetVar> setDecisionVar = new HashSet();
    private HashSet<SetVar> setNoDecisionVar = new HashSet();
    private HashSet<RealVar> realDecisionVar = new HashSet();
    private HashSet<RealVar> realNoDecisionVar = new HashSet();
    private HashSet<TaskVar> taskDecisionVar = new HashSet();
    private HashSet<TaskVar> taskNoDecisionVar = new HashSet();

    public CPModelToCPSolver(CPSolver cpsolver) {
        this.cpsolver = cpsolver;
        this.expDetect = new ExpressionDetector();
    }

    public void readVariables(CPModel model) {
        Iterator it = model.getIntVarIterator();
        while (it.hasNext()) {
            IntegerVariable i = (IntegerVariable)it.next();
            if (this.cpsolver.mapvariables.containsKey(i.getIndexIn(model.getIndex()))) continue;
            this.cpsolver.mapvariables.put(i.getIndexIn(model.getIndex()), this.readModelVariable(i));
        }
        it = model.getRealVarIterator();
        while (it.hasNext()) {
            RealVariable r = (RealVariable)it.next();
            if (this.cpsolver.mapvariables.containsKey(r.getIndexIn(model.getIndex()))) continue;
            this.cpsolver.mapvariables.put(r.getIndexIn(model.getIndex()), this.readModelVariable(r));
        }
        it = model.getSetVarIterator();
        while (it.hasNext()) {
            SetVariable s = (SetVariable)it.next();
            if (this.cpsolver.mapvariables.containsKey(s.getIndexIn(model.getIndex()))) continue;
            SetVar setVar = (SetVar)this.readModelVariable(s);
            this.cpsolver.mapvariables.put(s.getIndexIn(model.getIndex()), setVar);
            this.cpsolver.mapvariables.put(s.getCard().getIndexIn(model.getIndex()), setVar.getCard());
            this.checkOptions(s.getCard(), setVar.getCard());
        }
        it = model.getConstVarIterator();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            if (this.cpsolver.mapvariables.containsKey(v.getIndexIn(model.getIndex()))) continue;
            switch (v.getVariableType()) {
                case CONSTANT_INTEGER: {
                    IntegerConstantVariable ci = (IntegerConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(ci.getIndexIn(model.getIndex()))) break;
                    this.cpsolver.mapvariables.put(ci.getIndexIn(model.getIndex()), this.readModelVariable(ci));
                    break;
                }
                case CONSTANT_DOUBLE: {
                    RealConstantVariable cr = (RealConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(cr.getIndexIn(model.getIndex()))) break;
                    this.cpsolver.mapvariables.put(cr.getIndexIn(model.getIndex()), this.readModelVariable(cr));
                    break;
                }
                case CONSTANT_SET: {
                    SetConstantVariable cs = (SetConstantVariable)v;
                    if (this.cpsolver.mapvariables.containsKey(cs.getIndexIn(model.getIndex()))) break;
                    this.cpsolver.mapvariables.put(cs.getIndexIn(model.getIndex()), this.readModelVariable(cs));
                }
            }
        }
        it = model.getMultipleVarIterator();
        while (it.hasNext()) {
            MultipleVariables mv = (MultipleVariables)it.next();
            if (this.cpsolver.mapvariables.containsKey(mv.getIndexIn(model.getIndex()))) continue;
            this.cpsolver.mapvariables.put(mv.getIndexIn(model.getIndex()), this.readModelVariable(mv));
        }
        this.cpsolver.setPrecision(model.getPrecision());
        this.cpsolver.setReduction(model.getReduction());
    }

    public Var readModelVariable(Variable v) {
        if (v instanceof IComponentVariable) {
            IComponentVariable vv = (IComponentVariable)((Object)v);
            VariableManager vm = this.variableManagers.get(vv.getComponentClass());
            if (vm == null) {
                Class<?> componentClass = null;
                try {
                    componentClass = Class.forName(vv.getComponentClass());
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Component class could not be found: " + vv.getComponentClass());
                    System.exit(-1);
                }
                try {
                    vm = (VariableManager)componentClass.newInstance();
                }
                catch (InstantiationException e) {
                    System.err.println("Component class could not be instantiated: " + vv.getComponentClass());
                    System.exit(-1);
                }
                catch (IllegalAccessException e) {
                    System.err.println("Component class could not be accessed: " + vv.getComponentClass());
                    System.exit(-1);
                }
                this.variableManagers.put(vv.getComponentClass(), vm);
            }
            Var var = vm.makeVariable(this.cpsolver, v);
            this.checkOptions(v, var);
            return var;
        }
        return null;
    }

    private void checkOptions(Variable v, Var var) {
        if (v.getOptions().contains("cp:decision")) {
            this.checkDecision(var, true);
        } else if (v.getOptions().contains("cp:no_decision")) {
            this.checkDecision(var, false);
        }
        if (v.getOptions().contains("cp:objective")) {
            this.cpsolver.setObjective(var);
        }
        if (v.getOptions().contains("cp:makespan")) {
            this.cpsolver.getScheduler().setMakespan((IntDomainVar)var);
        }
    }

    private void checkDecision(Var v, boolean decision) {
        if (v instanceof IntDomainVar) {
            (decision ? this.intDecisionVar : this.intNoDecisionVar).add((IntDomainVar)v);
        } else if (v instanceof SetVar) {
            (decision ? this.setDecisionVar : this.setNoDecisionVar).add((SetVar)v);
        } else if (v instanceof RealVar) {
            (decision ? this.realDecisionVar : this.realNoDecisionVar).add((RealVar)v);
        } else if (v instanceof TaskVar) {
            (decision ? this.taskDecisionVar : this.taskNoDecisionVar).add((TaskVar)v);
        }
    }

    protected void readDecisionVariables() {
        if (!this.intDecisionVar.isEmpty()) {
            this.cpsolver.intDecisionVars.addAll(this.intDecisionVar);
        } else if (!this.intNoDecisionVar.isEmpty()) {
            this.cpsolver.intDecisionVars.addAll(this.cpsolver.intVars);
            this.cpsolver.intDecisionVars.removeAll(this.intNoDecisionVar);
            this.cpsolver.intDecisionVars.removeAll(this.cpsolver.getIntConstantSet());
        }
        if (!this.setDecisionVar.isEmpty()) {
            this.cpsolver.setDecisionVars.addAll(this.setDecisionVar);
        } else if (!this.setNoDecisionVar.isEmpty()) {
            this.cpsolver.setDecisionVars.addAll(this.cpsolver.setVars);
            this.cpsolver.setDecisionVars.removeAll(this.setNoDecisionVar);
        }
        if (!this.realDecisionVar.isEmpty()) {
            this.cpsolver.floatDecisionVars.addAll(this.realDecisionVar);
        } else if (!this.realNoDecisionVar.isEmpty()) {
            this.cpsolver.floatDecisionVars.addAll(this.cpsolver.floatVars);
            this.cpsolver.floatDecisionVars.removeAll(this.realNoDecisionVar);
            this.cpsolver.intDecisionVars.removeAll(this.cpsolver.getRealConstantSet());
        }
        if (!this.taskDecisionVar.isEmpty()) {
            this.cpsolver.taskDecisionVars.addAll(this.taskDecisionVar);
        } else if (!this.taskNoDecisionVar.isEmpty()) {
            this.cpsolver.taskDecisionVars.addAll(this.cpsolver.taskVars);
            this.cpsolver.taskDecisionVars.removeAll(this.taskNoDecisionVar);
        }
    }

    public void readConstraints(CPModel model) {
        Boolean decomp = model.getDefaultExpressionDecomposition();
        Iterator<Constraint> it = model.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ic = it.next();
            int ind = ic.getIndexIn(model.getIndex());
            if (this.cpsolver.mapconstraints.containsKey(ind)) continue;
            if (ic.getOptions().contains("cp:decomp")) {
                decomp = true;
            }
            SConstraint c = this.readModelConstraint(ic, decomp);
            this.cpsolver.post(c);
            this.cpsolver.mapconstraints.put(ind, c);
        }
        this.cpsolver.postRedundantTaskConstraints();
    }

    public void readConstraint(Constraint ic, Boolean decomp) {
        int ind = ic.getIndexIn(this.cpsolver.getModel().getIndex());
        if (!this.cpsolver.mapconstraints.containsKey(ind)) {
            SConstraint c = this.readModelConstraint(ic, decomp);
            this.cpsolver.mapconstraints.put(ind, c);
            this.cpsolver.post(c);
        }
    }

    public SConstraint makeSConstraint(Constraint ic, Boolean decomp) {
        return this.readModelConstraint(ic, decomp);
    }

    public SConstraint makeSConstraint(Constraint ic) {
        return this.readModelConstraint(ic, false);
    }

    protected SConstraint readModelConstraint(Constraint ic, Boolean decomp) {
        if (ic instanceof MetaConstraint) {
            return this.createMetaConstraint(ic, decomp);
        }
        if (ic instanceof ComponentConstraint) {
            if (!ic.getConstraintType().equals((Object)ConstraintType.REIFIEDINTCONSTRAINT) && !this.allSimpleVariable(ic.getVariables())) {
                return this.createMetaConstraint(ic, decomp);
            }
            ComponentConstraint cc = (ComponentConstraint)ic;
            ConstraintManager cm = cc.getCm();
            return cm.makeConstraint(this.cpsolver, cc.getVariables(), cc.getParameters(), cc.getOptions());
        }
        return null;
    }

    private boolean allSimpleVariable(Variable[] vars) {
        if (vars == null) {
            return true;
        }
        for (Variable v : vars) {
            VariableType type = v.getVariableType();
            if (type != VariableType.INTEGER_EXPRESSION) continue;
            return false;
        }
        return true;
    }

    private IntDomainVar[] integerVariableToIntDomainVar(int modelInd, Variable[] tab) {
        return this.integerVariableToIntDomainVar(modelInd, tab, tab.length);
    }

    private IntDomainVar[] integerVariableToIntDomainVar(int modelInd, Variable[] tab, int n) {
        IntDomainVar[] newTab = new IntDomainVar[n];
        for (int i = 0; i < n; ++i) {
            newTab[i] = (IntDomainVar)this.cpsolver.mapvariables.get(tab[i].getIndexIn(modelInd));
        }
        return newTab;
    }

    private IntDomainVar[][] integerVariableToIntDomainVar(int modelInd, Variable[][] tab, int n) {
        IntDomainVar[][] newTab = new IntDomainVar[n][];
        for (int i = 0; i < n; ++i) {
            newTab[i] = this.integerVariableToIntDomainVar(modelInd, tab[i]);
        }
        return newTab;
    }

    protected IntDomainVar[][] integerVariableToIntDomainVar(int modelInd, Variable[][] tab) {
        return this.integerVariableToIntDomainVar(modelInd, tab, tab.length);
    }

    protected SConstraint createMetaConstraint(Constraint ic, Boolean decomp) {
        ExpressionSConstraint c = new ExpressionSConstraint(this.buildBoolNode(ic));
        c.setDecomposeExp(decomp);
        c.setScope(this.cpsolver);
        if (ic.getOptions().contains("cp:ac")) {
            c.setLevelAc(0);
        } else if (ic.getOptions().contains("cp:fc")) {
            c.setLevelAc(1);
        }
        SConstraint intensional = this.expDetect.getScalarConstraint(c, this.cpsolver);
        if (intensional != null) {
            return intensional;
        }
        return c;
    }

    protected BoolNode buildBoolNode(Constraint ic) {
        IntegerExpressionVariable[] vars = null;
        if (ic.getNbVars() > 0) {
            vars = new IntegerExpressionVariable[ic.getNbVars()];
            for (int i = 0; i < ic.getVariables().length; ++i) {
                vars[i] = (IntegerExpressionVariable)ic.getVariables()[i];
            }
        }
        return (BoolNode)((Object)ic.getEm().makeNode(this.cpsolver, new Constraint[]{ic}, vars));
    }
}

