/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.variables;

import choco.Choco;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.leaves.ConstantLeaf;
import choco.cp.solver.constraints.reified.leaves.VariableLeaf;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.Iterator;

public class IntegerVariableManager
implements VariableManager {
    protected IntDomainVar makeConstant(CPSolver solver, IntegerVariable iv) {
        int value = iv.getLowB();
        IntDomainVar v = (IntDomainVar)solver.getIntConstant(value);
        if (v == null) {
            if (iv.isBoolean()) {
                v = new BooleanVarImpl(solver, iv.getName());
                v.getDomain().restrict(value);
            } else {
                v = new IntDomainVarImpl(solver, iv.getName(), 1, value, value);
            }
            solver.addIntConstant(value, v);
        }
        return v;
    }

    @Override
    public Var makeVariable(Solver solver, Variable var) {
        if (solver instanceof CPSolver) {
            IntegerVariable iv = (IntegerVariable)var;
            IntDomainVarImpl v = null;
            if (iv.isConstant()) {
                return this.makeConstant((CPSolver)solver, iv);
            }
            if (iv.isBoolean()) {
                v = new BooleanVarImpl(solver, iv.getName());
            } else if (iv.getValues() == null) {
                if (iv.getLowB() != iv.getUppB()) {
                    int type = -1;
                    type = iv.getOptions().contains("cp:enum") ? 0 : (iv.getOptions().contains("cp:bound") ? 1 : (iv.getOptions().contains("cp:link") ? 2 : (iv.getOptions().contains("cp:btree") ? 3 : (iv.getOptions().contains("cp:blist") ? 4 : this.getIntelligentDomain(iv)))));
                    v = new IntDomainVarImpl(solver, iv.getName(), type, iv.getLowB(), iv.getUppB());
                }
            } else {
                int[] values = iv.getValues();
                if (values.length > 1) {
                    int type = 0;
                    if (iv.getOptions().contains("cp:link")) {
                        type = 2;
                    } else if (iv.getOptions().contains("cp:btree")) {
                        type = 3;
                    } else if (iv.getOptions().contains("cp:blist")) {
                        type = 4;
                    }
                    v = new IntDomainVarImpl(solver, iv.getName(), type, values);
                }
            }
            ((CPSolver)solver).addIntVar(v);
            return v;
        }
        if (Choco.DEBUG) {
            System.err.println("Count not found implementation for IntegerVariable !");
            System.exit(-1);
        }
        return null;
    }

    @Override
    public INode makeNode(Solver solver, Constraint[] cstrs, IntegerExpressionVariable[] vars) {
        if (vars[0] instanceof IntegerConstantVariable) {
            IntegerConstantVariable c = (IntegerConstantVariable)vars[0];
            return new ConstantLeaf(c.getValue());
        }
        if (vars[0] instanceof IntegerVariable) {
            return new VariableLeaf((IntegerVariable)vars[0]);
        }
        return null;
    }

    public int getIntelligentDomain(IntegerVariable v) {
        int[] scoreForDomain = new int[10];
        BitSet posDom = new BitSet(10);
        posDom.set(0, 20);
        if (v.getValues() != null) {
            posDom.clear(1);
        }
        if (v.getUppB() - v.getLowB() + 1 == v.getDomainSize() && v.getDomainSize() > 300) {
            posDom.clear(0);
            posDom.clear(2);
        }
        Iterator<Constraint> it = v.getConstraintIterator();
        while (it.hasNext()) {
            Constraint cc = it.next();
            int[] prefereddoms = cc.getFavoriteDomains();
            if (prefereddoms.length <= 0) continue;
            BitSet posCdom = new BitSet();
            for (int i = 0; i < prefereddoms.length; ++i) {
                int n = prefereddoms[i];
                scoreForDomain[n] = scoreForDomain[n] + (i + 1);
                posCdom.set(prefereddoms[i]);
            }
            posDom.and(posCdom);
        }
        int bestDom = this.possibleArgMin(scoreForDomain, posDom);
        if (bestDom == -1) {
            throw new ModelException("no suitable domain for " + v + " that can be accepted by all constraints");
        }
        return bestDom;
    }

    public int possibleArgMin(int[] tab, BitSet posDom) {
        int bestDom = -1;
        int minScore = Integer.MAX_VALUE;
        for (int i = 0; i < tab.length; ++i) {
            if (!posDom.get(i) || minScore <= tab[i]) continue;
            minScore = tab[i];
            bestDom = i;
        }
        return bestDom;
    }
}

