/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.cp.solver.constraints.integer.MaxXYZ;
import choco.cp.solver.constraints.integer.MinOfAList;
import choco.cp.solver.constraints.integer.MinXYZ;
import choco.cp.solver.constraints.set.MaxOfASet;
import choco.cp.solver.constraints.set.MinOfASet;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntVar;
import java.util.HashSet;

public class MinMaxManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Boolean) {
            Boolean min = (Boolean)parameters;
            int n = variables.length - 1;
            IntegerVariable varOpt = (IntegerVariable)variables[n];
            if (min.booleanValue()) {
                if (variables.length == 3) {
                    return new MinXYZ(solver.getVar((IntegerVariable)variables[0]), solver.getVar((IntegerVariable)variables[1]), solver.getVar(varOpt));
                }
                if (variables[0] instanceof SetVariable) {
                    SetVariable set = (SetVariable)variables[0];
                    IntegerVariable[] tmp = new IntegerVariable[n];
                    tmp[0] = varOpt;
                    System.arraycopy(variables, 1, tmp, 1, n - 1);
                    return new MinOfASet((IntVar[])solver.getVar(tmp), solver.getVar(set));
                }
                IntegerVariable[] tmpVars = new IntegerVariable[variables.length];
                tmpVars[0] = varOpt;
                System.arraycopy(variables, 0, tmpVars, 1, variables.length - 1);
                return new MinOfAList(solver.getVar(tmpVars));
            }
            if (variables.length == 3) {
                return new MaxXYZ(solver.getVar((IntegerVariable)variables[0]), solver.getVar((IntegerVariable)variables[1]), solver.getVar(varOpt));
            }
            if (variables[0] instanceof SetVariable) {
                SetVariable set = (SetVariable)variables[0];
                IntegerVariable[] tmp = new IntegerVariable[n];
                tmp[0] = varOpt;
                System.arraycopy(variables, 1, tmp, 1, n - 1);
                return new MaxOfASet((IntVar[])solver.getVar(tmp), solver.getVar(set));
            }
            IntegerVariable[] tmpVars = new IntegerVariable[variables.length];
            tmpVars[0] = varOpt;
            System.arraycopy(variables, 0, tmpVars, 1, variables.length - 1);
            return new MaxOfAList(solver.getVar(tmpVars));
        }
        if (Choco.DEBUG) {
            throw new RuntimeException("Could not found an implementation of min or max !");
        }
        return null;
    }
}

