/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.InverseChanneling;
import choco.cp.solver.constraints.integer.channeling.BooleanChanneling;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;

public class ChannelingManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver && parameters instanceof ConstraintType) {
            ConstraintType type = (ConstraintType)((Object)parameters);
            if (ConstraintType.CHANNELING.equals((Object)type)) {
                IntDomainVar intv;
                IntDomainVar boolv;
                IntDomainVar yij = solver.getVar((IntegerVariable)variables[0]);
                IntDomainVar xi = solver.getVar((IntegerVariable)variables[1]);
                int j = ((IntegerConstantVariable)variables[2]).getValue();
                if (yij.getInf() >= 0 && yij.getSup() <= 1) {
                    boolv = yij;
                    intv = xi;
                } else {
                    boolv = xi;
                    intv = yij;
                }
                if (boolv.getInf() >= 0 && boolv.getSup() <= 1 && intv.canBeInstantiatedTo(j)) {
                    return new BooleanChanneling(boolv, intv, j);
                }
                throw new SolverException(yij + " should be a boolean variable and " + j + " should belongs to the domain of " + xi);
            }
            if (ConstraintType.INVERSECHANNELING.equals((Object)type)) {
                IntDomainVar[] var = solver.getVar((IntegerVariable[])variables);
                return new InverseChanneling(var, var.length / 2);
            }
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of channeling !");
        }
        return null;
    }
}

