/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.tree.TreeSConstraint;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.tree.TreeNodeObject;
import choco.kernel.model.variables.tree.TreeParametersObject;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import java.util.HashSet;

public class TreeManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver && parameters instanceof TreeParametersObject) {
            TreeParametersObject tpo = (TreeParametersObject)parameters;
            int nbNodes = tpo.getNbNodes();
            TreeNodeObject[] tnodes = tpo.getNodes();
            Node[] nodes = new Node[tnodes.length];
            TreeParameters params = null;
            for (int i = 0; i < tnodes.length; ++i) {
                TreeNodeObject tn = tnodes[i];
                nodes[i] = new Node(solver, nbNodes, tn.getIdx(), solver.getVar(tn.getSuccessors()), solver.getVar(tn.getInDegree()), solver.getVar(tn.getTimeWindow()), tpo.getGraphs());
            }
            params = new TreeParameters(solver, nbNodes, solver.getVar(tpo.getNTree()), solver.getVar(tpo.getNproper()), solver.getVar(tpo.getObjective()), nodes, tpo.getTravel());
            return new TreeSConstraint(params.getAllVars(), params);
        }
        if (Choco.DEBUG) {
            throw new RuntimeException("Could not found implementation for Tree !");
        }
        return null;
    }
}

