/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.regular.Regular;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.Transition;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class RegularManager
extends IntConstraintManager {
    private int nID;

    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] vars, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] variables = solver.getVar((IntegerVariable[])vars);
            if (parameters instanceof int[][]) {
                int[] coefs = ((int[][])parameters)[0];
                int value = ((int[][])parameters)[1][0];
                return this.knapsack(solver, (IntegerVariable[])vars, value, coefs);
            }
            if (parameters instanceof Object[]) {
                Object[] params = (Object[])parameters;
                return new Regular(new DFA((List)params[0], (int[])params[1], (int[])params[2]), variables);
            }
            if (parameters instanceof List) {
                return new Regular(new DFA((List)parameters), variables);
            }
            if (parameters instanceof DFA) {
                return new Regular((DFA)parameters, variables);
            }
            if (parameters instanceof String) {
                return new Regular(new DFA((String)parameters, vars.length), variables);
            }
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of regular !");
        }
        return null;
    }

    @Override
    public int[] getFavoriteDomains(HashSet<String> options) {
        return new int[]{0, 2, 3};
    }

    public SConstraint knapsack(Solver s, IntegerVariable[] bools, int goal, int[] A) {
        int i;
        int i2;
        int[] temp = new int[A.length + 1];
        System.arraycopy(A, 0, temp, 1, A.length);
        temp[0] = 0;
        A = temp;
        int U = goal;
        int L = goal;
        int[][] P = new int[A.length][U + 1];
        int[][] G = new int[A.length][U + 1];
        for (i2 = 0; i2 < P.length; ++i2) {
            for (int j = 0; j < P[0].length; ++j) {
                G[i2][j] = 0;
                P[i2][j] = 0;
            }
        }
        P[0][0] = 1;
        for (i2 = 1; i2 < P.length; ++i2) {
            for (int b = 0; b < P[0].length; ++b) {
                if (P[i2 - 1][b] != 1) continue;
                IntIterator it = bools[i2 - 1].getDomainIterator();
                while (it.hasNext()) {
                    int x = it.next();
                    if (b + A[i2] * x > U) continue;
                    P[i2][b + A[i2] * x] = 1;
                }
            }
        }
        boolean sat = false;
        for (i = U; i >= L; --i) {
            sat |= P[P.length - 1][U] == 1;
        }
        G[G.length - 1][U] = 1;
        if (sat) {
            int i3;
            for (i = G.length - 2; i >= 0; --i) {
                for (int b = 0; b < G[0].length; ++b) {
                    if (G[i + 1][b] != 1) continue;
                    IntIterator it = bools[i].getDomainIterator();
                    while (it.hasNext()) {
                        int x = it.next();
                        if (b - A[i + 1] * x < 0 || P[i][b - A[i + 1] * x] != 1) continue;
                        G[i][b - A[i + 1] * x] = 1;
                    }
                }
            }
            LinkedList<Transition> t = new LinkedList<Transition>();
            LinkedList<Integer> ints = new LinkedList<Integer>();
            this.nID = 0;
            int[][] labels = new int[G.length][G[0].length];
            for (i3 = 0; i3 < labels.length; ++i3) {
                for (int j = 0; j < labels[0].length; ++j) {
                    labels[i3][j] = -1;
                }
            }
            this.generateTransitionList(0, 0, t, labels, A, G, bools);
            for (i3 = 0; i3 <= L - U; ++i3) {
                ints.add(G.length + i3 - 1);
            }
            DFA dfa = new DFA(t, ints, (Integer)ints.get(0));
            return new Regular(dfa, s.getVar(bools));
        }
        return CPSolver.FALSE;
    }

    private void generateTransitionList(int x, int y, List<Transition> t, int[][] labels, int[] A, int[][] G, IntegerVariable[] bools) {
        if (x >= G.length - 1) {
            return;
        }
        int[] vars = bools[x].getValues();
        if (vars == null) {
            for (int var = bools[x].getLowB(); var <= bools[x].getUppB(); ++var) {
                if (y + A[x + 1] * var >= G[0].length || G[x + 1][y + A[x + 1] * var] != 1) continue;
                if (labels[x][y] == -1) {
                    labels[x][y] = this.nID++;
                }
                if (labels[x + 1][y + A[x + 1] * var] == -1) {
                    labels[x + 1][y + A[x + 1] * var] = this.nID++;
                }
                t.add(new Transition(labels[x][y], var, labels[x + 1][y + A[x + 1] * var]));
                this.generateTransitionList(x + 1, y + A[x + 1] * var, t, labels, A, G, bools);
            }
        } else {
            for (int var = 0; var < vars.length; ++var) {
                if (y + A[x + 1] * vars[var] >= G[0].length || G[x + 1][y + A[x + 1] * vars[var]] != 1) continue;
                if (labels[x][y] == -1) {
                    labels[x][y] = this.nID++;
                }
                if (labels[x + 1][y + A[x + 1] * vars[var]] == -1) {
                    labels[x + 1][y + A[x + 1] * vars[var]] = this.nID++;
                }
                t.add(new Transition(labels[x][y], vars[var], labels[x + 1][y + A[x + 1] * vars[var]]));
                this.generateTransitionList(x + 1, y + A[x + 1] * vars[var], t, labels, A, G, bools);
            }
        }
    }
}

