/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.scheduling.Precedence;
import choco.cp.solver.constraints.global.scheduling.PrecedenceDisjoint;
import choco.cp.solver.constraints.global.scheduling.PrecedenceReified;
import choco.cp.solver.constraints.global.scheduling.VariablePrecedenceDisjoint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.global.scheduling.IPrecedenceNetwork;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.HashSet;

public class PrecedingManager
extends IntConstraintManager {
    protected final SConstraint createSolverConstraint(CPSolver s, TaskVar t1, TaskVar t2, IntDomainVar dir) {
        if (dir.isInstantiated()) {
            return dir.isInstantiatedTo(1) ? s.leq((IntExp)t1.end(), (IntExp)t2.start()) : s.leq((IntExp)t2.end(), (IntExp)t1.start());
        }
        return new VariablePrecedenceDisjoint(dir, t1.start(), t1.duration(), t2.start(), t2.duration());
    }

    protected final SConstraint createNetworkConstraint(IPrecedenceNetwork network, TaskVar t1, TaskVar t2, IntDomainVar dir) {
        if (dir.isInstantiated()) {
            if (dir.isInstantiatedTo(1)) {
                network.addStaticPrecedence(t1, t2);
            } else {
                network.addStaticPrecedence(t2, t1);
            }
            return CPSolver.TRUE;
        }
        return new Precedence(network, t1, t2, dir);
    }

    protected final SConstraint createIntVarsConstraint(CPSolver solver, Variable[] variables) {
        if (variables.length == 4) {
            IntDomainVar x0 = solver.getVar((IntegerVariable)variables[0]);
            int k = ((IntegerConstantVariable)variables[1]).getValue();
            IntDomainVar x1 = solver.getVar((IntegerVariable)variables[2]);
            IntDomainVar b = solver.getVar((IntegerVariable)variables[3]);
            return new PrecedenceReified(x0, k, x1, b);
        }
        if (variables.length == 5) {
            IntDomainVar v1 = solver.getVar((IntegerVariable)variables[0]);
            int d1 = ((IntegerConstantVariable)variables[1]).getValue();
            IntDomainVar v2 = solver.getVar((IntegerVariable)variables[2]);
            int d2 = ((IntegerConstantVariable)variables[3]).getValue();
            IntDomainVar bool = solver.getVar((IntegerVariable)variables[4]);
            return new PrecedenceDisjoint(v1, d1, v2, d2, bool);
        }
        throw new SolverException("invalid precedence signature");
    }

    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            CPSolver s = (CPSolver)solver;
            if (parameters == Boolean.TRUE) {
                TaskVar t1 = solver.getVar((TaskVariable)variables[0]);
                TaskVar t2 = solver.getVar((TaskVariable)variables[1]);
                IntDomainVar dir = solver.getVar((IntegerVariable)variables[2]);
                IPrecedenceNetwork network = s.getScheduler().createPrecedenceNetwork();
                if (network == null) {
                    return this.createSolverConstraint(s, t1, t2, dir);
                }
                return this.createNetworkConstraint(network, t1, t2, dir);
            }
            return this.createIntVarsConstraint(s, variables);
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of preceding/precedingReifeid !");
        }
        return null;
    }
}

