/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundGcc;
import choco.cp.solver.constraints.global.BoundGccVar;
import choco.cp.solver.constraints.global.matching.GlobalCardinality;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;

public class GlobalCardinalityManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Object[]) {
            Object[] params = (Object[])parameters;
            ConstraintType type = (ConstraintType)((Object)params[0]);
            if (ConstraintType.GLOBALCARDINALITYMAX.equals((Object)type)) {
                int min = (Integer)params[1];
                int max = (Integer)params[2];
                int[] low = (int[])params[3];
                int[] up = (int[])params[4];
                IntDomainVar[] vars = solver.getVar((IntegerVariable[])variables);
                if (options.contains("cp:ac")) {
                    return new GlobalCardinality(vars, min, max, low, up);
                }
                if (options.contains("cp:bc")) {
                    return new BoundGcc(vars, min, max, low, up);
                }
                if (vars[0].hasEnumeratedDomain()) {
                    return new GlobalCardinality(vars, min, max, low, up);
                }
                return new BoundGcc(vars, min, max, low, up);
            }
            if (ConstraintType.GLOBALCARDINALITY.equals((Object)type)) {
                int[] low = (int[])params[1];
                int[] up = (int[])params[2];
                IntDomainVar[] vars = solver.getVar((IntegerVariable[])variables);
                if (options.contains("cp:ac")) {
                    return new GlobalCardinality(vars, 1, low.length, low, up);
                }
                if (options.contains("cp:bc")) {
                    return new BoundGcc(vars, 1, low.length, low, up);
                }
                if (vars[0].hasEnumeratedDomain()) {
                    return new GlobalCardinality(vars, 1, low.length, low, up);
                }
                return new BoundGcc(vars, 1, low.length, low, up);
            }
            if (ConstraintType.GLOBALCARDINALITYVAR.equals((Object)type)) {
                int min = (Integer)params[1];
                int max = (Integer)params[2];
                int n = (Integer)params[3];
                IntDomainVar[] vars = solver.getVar((IntegerVariable[])variables);
                IntDomainVar[] varT = new IntDomainVar[n];
                IntDomainVar[] card = new IntDomainVar[vars.length - n];
                System.arraycopy(vars, 0, varT, 0, n);
                System.arraycopy(vars, n, card, 0, card.length);
                return new BoundGccVar(varT, card, min, max);
            }
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of alldifferent !");
        }
        return null;
    }

    @Override
    public int[] getFavoriteDomains(HashSet<String> options) {
        if (options.contains("cp:bc")) {
            return this.getBCFavoriteIntDomains();
        }
        return this.getACFavoriteIntDomains();
    }
}

