/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.constraints.global.AbstractResourceManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.global.scheduling.AltDisjunctive;
import choco.cp.solver.constraints.global.scheduling.Disjunctive;
import choco.cp.solver.constraints.global.scheduling.ForbiddenIntervals;
import choco.kernel.model.variables.Variable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.global.scheduling.RscData;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.HashSet;

public class DisjunctiveManager
extends AbstractResourceManager {
    @Override
    public int[] getFavoriteDomains(HashSet<String> options) {
        return this.getBCFavoriteIntDomains();
    }

    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            Disjunctive cstr;
            RscData param = (RscData)parameters;
            CPSolver s = (CPSolver)solver;
            TaskVar[] tasks = this.readTaskVar(s, variables, 0, param.getNbTasks());
            IntDomainVar uppBound = this.getUppBound(s, param);
            if (options.contains(SettingType.FORBIDDEN_INTERVALS.getOptionName())) {
                if (uppBound == null) {
                    throw new SolverException("you must set the makespan variable or manually set an upper bound variable");
                }
                if (param.getNbOptionalTasks() > 0) {
                    throw new SolverException("no Forbidden intervals with alternative resources.");
                }
                s.post((SConstraint)new ForbiddenIntervals("ForbInt-" + param.getRscName(), tasks, uppBound));
            }
            if (param.getNbOptionalTasks() > 0) {
                IntDomainVar[] usages = this.readIntVar(s, variables, param.getNbTasks(), param.getNbOptionalTasks());
                cstr = new AltDisjunctive(param.getRscName(), tasks, usages, uppBound);
            } else {
                cstr = new Disjunctive(param.getRscName(), tasks, uppBound);
            }
            DisjunctiveManager.readDisjunctiveSettings(options, cstr.getFlags());
            return cstr;
        }
        return null;
    }
}

