/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.constraints.global.AbstractResourceManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.global.scheduling.AltCumulative;
import choco.cp.solver.constraints.global.scheduling.AltDisjunctive;
import choco.cp.solver.constraints.global.scheduling.Cumulative;
import choco.cp.solver.constraints.global.scheduling.Disjunctive;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.global.scheduling.RscData;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.HashSet;
import java.util.LinkedList;

public class CumulativeManager
extends AbstractResourceManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            CPSolver s = (CPSolver)solver;
            RscData param = (RscData)parameters;
            int n = param.getNbTasks();
            int no = param.getNbOptionalTasks();
            TaskVar[] tasks = this.readTaskVar(s, variables, 0, n);
            IntDomainVar[] heights = this.readIntVar(s, variables, n, n);
            IntDomainVar[] usages = this.readIntVar(s, variables, 2 * n, no);
            IntDomainVar uppBound = this.getUppBound(s, param);
            IntDomainVar consumption = s.getVar((IntegerVariable)variables[2 * n + no]);
            IntDomainVar capacity = s.getVar((IntegerVariable)variables[2 * n + no + 1]);
            if (consumption.getSup() > capacity.getInf()) {
                solver.post(s.leq((IntExp)consumption, (IntExp)capacity));
            }
            Cumulative cstr = usages.length == 0 ? new Cumulative(param.getRscName(), tasks, heights, consumption, capacity, uppBound) : new AltCumulative(param.getRscName(), tasks, heights, usages, consumption, capacity, uppBound);
            this.readCumulativeSettings(options, cstr.getFlags());
            if (cstr.getFlags().isEmpty() && usages.length == 0 && cstr.hasOnlyPosisiveHeights()) {
                cstr.getFlags().set(SettingType.TASK_INTERVAL);
            }
            if (options.contains(SettingType.EXTRACT_DISJ.getOptionName()) && cstr.hasOnlyPosisiveHeights()) {
                LinkedList<TaskVar> vars = new LinkedList<TaskVar>();
                LinkedList<IntDomainVar> usg = new LinkedList<IntDomainVar>();
                int limit = capacity.getSup() / 2;
                for (int i = 0; i < heights.length; ++i) {
                    if (heights[i].getInf() <= limit) continue;
                    vars.add(tasks[i]);
                    if (i < param.getNbRequiredTasks()) continue;
                    usg.add(usages[i]);
                }
                if (vars.size() > 2) {
                    TaskVar[] dtasks = vars.toArray(new TaskVar[vars.size()]);
                    Disjunctive disj = usg.isEmpty() ? new Disjunctive("exDisj-" + param.getRscName(), dtasks, uppBound) : new AltDisjunctive("exDisj-" + param.getRscName(), dtasks, usg.toArray(new IntDomainVar[usg.size()]), uppBound);
                    CumulativeManager.readDisjunctiveSettings(options, disj.getFlags());
                    s.post((SConstraint)disj);
                }
            }
            return cstr;
        }
        return null;
    }
}

