/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;

public class ClausesManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] vars, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] vs = (IntDomainVar[])((CPSolver)solver).getVar(IntDomainVar.class, vars);
            ClauseStore cs = new ClauseStore(vs);
            Constraint[] constraints = (Constraint[])((Object[])parameters)[1];
            for (int c = 0; c < constraints.length; ++c) {
                ComponentConstraint clause = (ComponentConstraint)constraints[c];
                int offset = (Integer)clause.getParameters();
                IntegerVariable[] posLits = new IntegerVariable[offset];
                IntegerVariable[] negLits = new IntegerVariable[clause.getNbVars() - offset];
                for (int v = 0; v < clause.getNbVars(); ++v) {
                    if (v < offset) {
                        posLits[v] = (IntegerVariable)clause.getVariables()[v];
                        continue;
                    }
                    negLits[v - offset] = (IntegerVariable)clause.getVariables()[v];
                }
                cs.addClause(solver.getVar(posLits), solver.getVar(negLits));
            }
            return cs;
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of Clauses manager !");
        }
        return null;
    }
}

