/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundAllDiff;
import choco.cp.solver.constraints.global.matching.AllDifferent;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;

public class AllDifferentManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] vars, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] variables = solver.getVar((IntegerVariable[])vars);
            if (options.contains("cp:ac")) {
                return new AllDifferent(variables);
            }
            if (options.contains("cp:bc")) {
                return new BoundAllDiff(variables, true);
            }
            if (options.contains("cp:clique")) {
                return new BoundAllDiff(variables, false);
            }
            return this.defaultDetection(variables);
        }
        if (Choco.DEBUG) {
            System.err.println("Could not found an implementation of alldifferent !");
        }
        return null;
    }

    @Override
    public int[] getFavoriteDomains(HashSet<String> options) {
        if (options.contains("cp:bc")) {
            return this.getBCFavoriteIntDomains();
        }
        return this.getACFavoriteIntDomains();
    }

    public SConstraint defaultDetection(IntDomainVar[] vars) {
        int maxdszise = 0;
        int nbnoninstvar = 0;
        boolean holes = false;
        boolean boundOnly = true;
        for (int i = 0; i < vars.length; ++i) {
            boundOnly &= !vars[i].hasEnumeratedDomain();
            int span = vars[i].getSup() - vars[i].getInf() + 1;
            if (vars[i].getDomainSize() > maxdszise) {
                maxdszise = vars[i].getDomainSize();
            }
            if (vars[i].getDomainSize() > 1) {
                ++nbnoninstvar;
            }
            holes |= 0.7 * (double)span > (double)vars[i].getDomainSize();
        }
        if (vars.length <= 3) {
            return new BoundAllDiff(vars, false);
        }
        if (boundOnly) {
            return new BoundAllDiff(vars, true);
        }
        if (holes || maxdszise <= 30 && (vars.length <= 10 || nbnoninstvar < vars.length && nbnoninstvar < 20)) {
            return new AllDifferent(vars);
        }
        return new BoundAllDiff(vars, true);
    }
}

