/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.BitFlags;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.RscData;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractResourceManager
extends IntConstraintManager {
    protected IntDomainVar getUppBound(CPSolver solver, RscData param) {
        return param.getUppBound() == null ? solver.getScheduler().createMakespan() : solver.getVar(param.getUppBound());
    }

    protected IntDomainVar[] readIntVar(CPSolver solver, Variable[] source, int begin, int length) {
        IntDomainVar[] vars = new IntDomainVar[length];
        for (int i = 0; i < length; ++i) {
            vars[i] = solver.getVar((IntegerVariable)source[begin + i]);
        }
        return vars;
    }

    protected TaskVar[] readTaskVar(CPSolver solver, Variable[] source, int begin, int length) {
        TaskVar[] vars = new TaskVar[length];
        for (int i = 0; i < length; ++i) {
            vars[i] = solver.getVar((TaskVariable)source[begin + i]);
        }
        return vars;
    }

    protected SetVar[] readSetVar(CPSolver solver, Variable[] source, int begin, int length) {
        SetVar[] vars = new SetVar[length];
        for (int i = 0; i < length; ++i) {
            vars[i] = solver.getVar((SetVariable)source[begin + i]);
        }
        return vars;
    }

    protected static BitFlags readPackSettings(Set<String> options) {
        BitFlags flags = new BitFlags();
        flags.read(options, SettingType.ADDITIONAL_RULES, SettingType.DYNAMIC_LB, SettingType.FILL_BIN);
        return flags;
    }

    protected void readCumulativeSettings(Set<String> options, BitFlags flags) {
        flags.read(options, SettingType.TASK_INTERVAL, SettingType.TASK_INTERVAL_SLOW, SettingType.VHM_CEF_ALGO_N2K, SettingType.VILIM_CEF_ALGO);
    }

    protected static void readDisjunctiveSettings(Set<String> options, BitFlags flags) {
        flags.read(options, SettingType.OVERLOAD_CHECKING, SettingType.NF_NL, SettingType.DETECTABLE_PRECEDENCE, SettingType.EDGE_FINDING_D);
        if (flags.isEmpty()) {
            flags.set(SettingType.NF_NL, SettingType.DETECTABLE_PRECEDENCE, SettingType.EDGE_FINDING_D);
        }
        int cpt = 0;
        if (options.contains(SettingType.VILIM_FILTERING.getOptionName())) {
            flags.set(SettingType.VILIM_FILTERING);
            ++cpt;
        }
        if (options.contains(SettingType.DEFAULT_FILTERING.getOptionName())) {
            flags.set(SettingType.DEFAULT_FILTERING);
            ++cpt;
        }
        if (options.contains(SettingType.SINGLE_RULE_FILTERING.getOptionName())) {
            throw new SolverException("invalid disjunctive setting:" + SettingType.SINGLE_RULE_FILTERING.getName());
        }
        if (cpt == 0) {
            flags.set(SettingType.DEFAULT_FILTERING);
        } else if (cpt > 1) {
            throw new SolverException("cant set only one filtering algorithm");
        }
    }

    @Override
    public int[] getFavoriteDomains(HashSet<String> options) {
        return this.getBCFavoriteIntDomains();
    }
}

