/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.model.managers.RealConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.ConstantSConstraint;
import choco.cp.solver.constraints.integer.EqualXC;
import choco.cp.solver.constraints.integer.EqualXYC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXYC;
import choco.cp.solver.constraints.integer.LessOrEqualXC;
import choco.cp.solver.constraints.integer.NotEqualXC;
import choco.cp.solver.constraints.integer.NotEqualXYC;
import choco.cp.solver.constraints.integer.NotEqualXYCEnum;
import choco.cp.solver.constraints.real.MixedEqXY;
import choco.cp.solver.constraints.real.exp.RealMinus;
import choco.cp.solver.constraints.reified.leaves.bool.EqNode;
import choco.cp.solver.constraints.reified.leaves.bool.GeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.GtNode;
import choco.cp.solver.constraints.reified.leaves.bool.LeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.LtNode;
import choco.cp.solver.constraints.reified.leaves.bool.NeqNode;
import choco.cp.solver.constraints.set.SetEq;
import choco.cp.solver.constraints.set.SetNotEq;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealExpressionVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealVar;
import java.util.HashSet;

public class EqManager
extends IntConstraintManager {
    @Override
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, HashSet<String> options) {
        if (solver instanceof CPSolver && parameters instanceof ConstraintType) {
            ConstraintType type = (ConstraintType)((Object)parameters);
            CPSolver cpsolver = (CPSolver)solver;
            Variable v1 = variables[0];
            Variable v2 = variables[1];
            int ty = ChocoUtil.checkType(v1.getVariableType(), v2.getVariableType());
            switch (type) {
                case EQ: {
                    switch (ty) {
                        case 11: {
                            return this.createIntEq(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 22: {
                            return new SetEq(cpsolver.getVar((SetVariable)v1), cpsolver.getVar((SetVariable)v2));
                        }
                        case 33: {
                            return this.createRealEq(cpsolver, (RealExpressionVariable)v1, (RealExpressionVariable)v2);
                        }
                        case 13: {
                            return new MixedEqXY(cpsolver.getVar((RealVariable)v2), cpsolver.getVar((IntegerVariable)v1));
                        }
                        case 31: {
                            return new MixedEqXY(cpsolver.getVar((RealVariable)v1), cpsolver.getVar((IntegerVariable)v2));
                        }
                        case 21: {
                            return this.createIntEq(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                        case 12: {
                            return this.createIntEq(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                    }
                    return null;
                }
                case NEQ: {
                    switch (ty) {
                        case 11: {
                            return this.createIntNeq(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 22: {
                            return new SetNotEq(cpsolver.getVar((SetVariable)v1), cpsolver.getVar((SetVariable)v2));
                        }
                        case 12: {
                            return this.createIntNeq(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                        case 21: {
                            return this.createIntNeq(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                    }
                    return null;
                }
                case GEQ: {
                    switch (ty) {
                        case 11: {
                            return this.createIntGeq(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 21: {
                            return this.createIntGeq(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                        case 12: {
                            return this.createIntGeq(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                        case 33: {
                            return this.createRealLeq(cpsolver, (RealExpressionVariable)v2, (RealExpressionVariable)v1);
                        }
                    }
                    return null;
                }
                case GT: {
                    switch (ty) {
                        case 11: {
                            return this.createIntGt(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 21: {
                            return this.createIntGt(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                        case 12: {
                            return this.createIntGt(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                    }
                    return null;
                }
                case LEQ: {
                    switch (ty) {
                        case 11: {
                            return this.createIntLeq(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 21: {
                            return this.createIntLeq(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                        case 12: {
                            return this.createIntLeq(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                        case 33: {
                            return this.createRealLeq(cpsolver, (RealExpressionVariable)v1, (RealExpressionVariable)v2);
                        }
                    }
                    return null;
                }
                case LT: {
                    switch (ty) {
                        case 11: {
                            return this.createIntLt(cpsolver, (IntegerVariable)v1, (IntegerVariable)v2);
                        }
                        case 21: {
                            return this.createIntLt(cpsolver, ((SetVariable)v1).getCard(), (IntegerVariable)v2);
                        }
                        case 12: {
                            return this.createIntLt(cpsolver, (IntegerVariable)v1, ((SetVariable)v2).getCard());
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        if (Choco.DEBUG) {
            throw new RuntimeException("Could not find manager for Eq !");
        }
        return null;
    }

    @Override
    public INode makeNode(Solver solver, Constraint[] cstrs, IntegerExpressionVariable[] vars) {
        ComponentConstraint cc = (ComponentConstraint)cstrs[0];
        if (cc.getParameters() instanceof ConstraintType) {
            ConstraintType type = (ConstraintType)((Object)cc.getParameters());
            INode[] nt = new INode[cc.getVariables().length];
            for (int i = 0; i < cc.getVariables().length; ++i) {
                IntegerExpressionVariable v = (IntegerExpressionVariable)cc.getVariable(i);
                nt[i] = v.getEm().makeNode(solver, v.getConstraints(), v.getVariables());
            }
            if (ConstraintType.EQ == type) {
                return new EqNode(nt);
            }
            if (ConstraintType.NEQ == type) {
                return new NeqNode(nt);
            }
            if (ConstraintType.GEQ == type) {
                return new GeqNode(nt);
            }
            if (ConstraintType.LEQ == type) {
                return new LeqNode(nt);
            }
            if (ConstraintType.GT == type) {
                return new GtNode(nt);
            }
            if (ConstraintType.LT == type) {
                return new LtNode(nt);
            }
        }
        return null;
    }

    SConstraint createIntEq(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c == ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new EqualXC(s.getVar(v2), c);
                    }
                }
            }
            case INTEGER: {
                int c;
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        c = ((IntegerConstantVariable)v2).getValue();
                        return new EqualXC(s.getVar(v1), c);
                    }
                    case INTEGER: {
                        return new EqualXYC(s.getVar(v1), s.getVar(v2), 0);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createRealEq(CPSolver s, RealExpressionVariable v1, RealExpressionVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        RealIntervalConstant zero = new RealIntervalConstant(0.0, 0.0);
        switch (tv1) {
            case CONSTANT_DOUBLE: {
                RealExp t1 = (RealIntervalConstant)s.getVar((Variable)v1);
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        RealIntervalConstant t2 = (RealIntervalConstant)s.getVar((Variable)v2);
                        return new ConstantSConstraint(v1.getLowB() == v2.getLowB());
                    }
                    case REAL: {
                        RealVar t2 = (RealVar)s.getVar((Variable)v2);
                        return s.makeEquation(t2, (RealIntervalConstant)t1);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(t2, (RealIntervalConstant)t1);
                    }
                }
            }
            case REAL: {
                RealExp t1 = (RealVar)s.getVar((Variable)v1);
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        RealIntervalConstant t2 = (RealIntervalConstant)s.getVar((Variable)v2);
                        return s.makeEquation(t1, t2);
                    }
                    case REAL: {
                        RealVar t2 = (RealVar)s.getVar((Variable)v2);
                        return s.makeEquation(new RealMinus(s, t1, t2), zero);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(new RealMinus(s, t1, t2), zero);
                    }
                }
            }
            case REAL_EXPRESSION: {
                RealExp t1 = ((RealConstraintManager)v1.getRcm()).makeRealExpression(s, v1.getVariables());
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        RealIntervalConstant t2 = (RealIntervalConstant)s.getVar((Variable)v2);
                        return s.makeEquation(t1, t2);
                    }
                    case REAL: {
                        RealExp t2 = (RealExp)((Object)s.getVar((Variable)v2));
                        return s.makeEquation(new RealMinus(s, t1, t2), zero);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(new RealMinus(s, t1, t2), zero);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createIntNeq(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c != ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new NotEqualXC(s.getVar(v2), c);
                    }
                }
            }
            case INTEGER: {
                int c;
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        c = ((IntegerConstantVariable)v2).getValue();
                        return new NotEqualXC(s.getVar(v1), c);
                    }
                    case INTEGER: {
                        if (s.getVar(v1).hasEnumeratedDomain() && s.getVar(v2).hasEnumeratedDomain()) {
                            return new NotEqualXYCEnum(s.getVar(v1), s.getVar(v2), 0);
                        }
                        return new NotEqualXYC(s.getVar(v1), s.getVar(v2), 0);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createIntGeq(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c >= ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new LessOrEqualXC(s.getVar(v2), c);
                    }
                }
            }
            case INTEGER: {
                int c;
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        c = ((IntegerConstantVariable)v2).getValue();
                        return new GreaterOrEqualXC(s.getVar(v1), c);
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXYC(s.getVar(v1), s.getVar(v2), 0);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createIntGt(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c > ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new LessOrEqualXC(s.getVar(v2), c - 1);
                    }
                }
            }
            case INTEGER: {
                int c;
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        c = ((IntegerConstantVariable)v2).getValue();
                        return new GreaterOrEqualXC(s.getVar(v1), c + 1);
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXYC(s.getVar(v1), s.getVar(v2), 1);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createIntLeq(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c <= ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXC(s.getVar(v2), c);
                    }
                }
            }
            case INTEGER: {
                int c;
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        c = ((IntegerConstantVariable)v2).getValue();
                        return new LessOrEqualXC(s.getVar(v1), c);
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXYC(s.getVar(v2), s.getVar(v1), 0);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createRealLeq(CPSolver s, RealExpressionVariable v1, RealExpressionVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        Double POS = Double.POSITIVE_INFINITY;
        Double NEG = Double.NEGATIVE_INFINITY;
        RealIntervalConstant INF = new RealIntervalConstant(NEG, 0.0);
        switch (tv1) {
            case CONSTANT_DOUBLE: {
                RealIntervalConstant cst = new RealIntervalConstant(v1.getLowB(), POS);
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        return new ConstantSConstraint(v1.getUppB() <= v2.getUppB());
                    }
                    case REAL: {
                        RealVar t2 = (RealVar)s.getVar((Variable)v2);
                        return s.makeEquation(t2, cst);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(t2, cst);
                    }
                }
            }
            case REAL: {
                RealIntervalConstant cst;
                RealExp t1 = (RealVar)s.getVar((Variable)v1);
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        cst = new RealIntervalConstant(NEG, v1.getLowB());
                        return s.makeEquation(t1, cst);
                    }
                    case REAL: {
                        RealVar t2 = (RealVar)s.getVar((Variable)v2);
                        return s.makeEquation(new RealMinus(s, t1, t2), INF);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(new RealMinus(s, t1, t2), INF);
                    }
                }
            }
            case REAL_EXPRESSION: {
                RealIntervalConstant cst;
                RealExp t1 = ((RealConstraintManager)v1.getRcm()).makeRealExpression(s, v1.getVariables());
                switch (tv2) {
                    case CONSTANT_DOUBLE: {
                        cst = new RealIntervalConstant(NEG, v1.getLowB());
                        return s.makeEquation(t1, cst);
                    }
                    case REAL: {
                        RealExp t2 = (RealExp)((Object)s.getVar((Variable)v2));
                        return s.makeEquation(new RealMinus(s, t1, t2), INF);
                    }
                    case REAL_EXPRESSION: {
                        RealExp t2 = ((RealConstraintManager)v2.getRcm()).makeRealExpression(s, v2.getVariables());
                        return s.makeEquation(new RealMinus(s, t1, t2), INF);
                    }
                }
            }
        }
        return null;
    }

    SConstraint createIntLt(CPSolver s, IntegerVariable v1, IntegerVariable v2) {
        VariableType tv1 = v1.getVariableType();
        VariableType tv2 = v2.getVariableType();
        switch (tv1) {
            case CONSTANT_INTEGER: {
                int c1 = ((IntegerConstantVariable)v1).getValue();
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        return new ConstantSConstraint(c1 < ((IntegerConstantVariable)v2).getValue());
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXC(s.getVar(v2), c1 + 1);
                    }
                }
            }
            case INTEGER: {
                switch (tv2) {
                    case CONSTANT_INTEGER: {
                        int c2 = ((IntegerConstantVariable)v2).getValue();
                        return new LessOrEqualXC(s.getVar(v1), c2 - 1);
                    }
                    case INTEGER: {
                        return new GreaterOrEqualXYC(s.getVar(v2), s.getVar(v1), 1);
                    }
                }
            }
        }
        return null;
    }
}

