/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model;

import choco.Choco;
import choco.kernel.common.IndexFactory;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.IOptions;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.ComponentConstraintWithSubConstraints;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealExpressionVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetExpressionVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Logger;

public class CPModel
implements Model {
    private static Logger logger = Logger.getLogger("choco");
    protected double precision = 1.0E-6;
    protected double reduction = 0.99;
    protected TIntObjectHashMap<Constraint> constraints;
    protected List<IntegerVariable> intVars = new ArrayList<IntegerVariable>();
    protected int nbBoolVar;
    protected List<SetVariable> setVars = new ArrayList<SetVariable>();
    protected List<RealVariable> floatVars = new ArrayList<RealVariable>();
    protected List<Variable> constantVars = new ArrayList<Variable>();
    protected List<IntegerExpressionVariable> expVars = new ArrayList<IntegerExpressionVariable>();
    protected List<MultipleVariables> storedMultipleVariables = new ArrayList<MultipleVariables>(0);
    private EnumMap<ConstraintType, TIntObjectHashMap<Constraint>> constraintsByType;
    protected IntVar objective;
    protected boolean doMaximize;
    protected final int index;
    protected Boolean defDecExp;
    protected ComponentConstraintWithSubConstraints clausesStore = null;
    protected final IndexFactory indexfactory;
    public final Properties properties;

    public CPModel() {
        this.constraints = new TIntObjectHashMap();
        this.index = IndexFactory.getId();
        this.indexfactory = new IndexFactory();
        this.constraintsByType = new EnumMap(ConstraintType.class);
        this.properties = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream("/application.properties");
            this.properties.load(is);
        }
        catch (IOException e) {
            logger.severe("Could not open application.properties");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("Pb[" + this.getNbTotVars() + " vars, " + this.getNbStoredMultipleVars() + " multiple vars, " + this.getNbConstraints() + " cons]\n");
        buf.append(this.varsToString());
        buf.append(this.constraintsToString());
        return new String(buf);
    }

    @Override
    public String varsToString() {
        StringBuffer buf = new StringBuffer("==== VARIABLES ====\n");
        for (IntegerVariable intVar : this.intVars) {
            buf.append(intVar.pretty()).append("\n");
        }
        for (RealVariable floatVar : this.floatVars) {
            buf.append(floatVar.pretty()).append('\n');
        }
        for (SetVariable setVar : this.setVars) {
            buf.append(setVar.pretty()).append("\n");
        }
        for (Variable constantVar : this.constantVars) {
            buf.append(constantVar.pretty()).append("\n");
        }
        buf.append("==== MULTIPLE VARIABLES ====\n");
        buf.append(ChocoUtil.prettyOnePerLine(this.storedMultipleVariables));
        return new String(buf);
    }

    @Override
    public String constraintsToString() {
        StringBuffer buf = new StringBuffer("==== CONSTRAINTS ====\n");
        TIntObjectIterator<Constraint> it = this.constraints.iterator();
        while (it.hasNext()) {
            it.advance();
            Constraint c = it.value();
            buf.append(c.pretty());
            buf.append("\n");
        }
        return new String(buf);
    }

    @Override
    public String solutionToString() {
        int k;
        ComponentVariable v;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            v = this.getIntVar(i);
            buf.append(v.toString());
            buf.append(", ");
        }
        for (int j = 0; j < this.getNbRealVars(); ++j) {
            v = this.getRealVar(j);
            buf.append(v.toString());
            buf.append(", ");
        }
        for (k = 0; k < this.getNbSetVars(); ++k) {
            v = this.getSetVar(k);
            buf.append(v.toString());
            buf.append(", ");
        }
        for (k = 0; k < this.getNbConstantVars(); ++k) {
            v = this.getConstantVar(k);
            buf.append(v.toString());
            buf.append(", ");
        }
        return new String(buf);
    }

    @Override
    @Deprecated
    public int getIntVarIndex(IntDomainVar c) {
        throw new ModelException("CPModel: ?");
    }

    @Override
    @Deprecated
    public int getIntVarIndex(IntVar c) {
        throw new ModelException("CPModel: ?");
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(double precision) {
        this.precision = precision;
    }

    @Override
    public double getReduction() {
        return this.reduction;
    }

    @Override
    public void setReduction(double reduction) {
        this.reduction = reduction;
    }

    @Override
    public Boolean getDefaultExpressionDecomposition() {
        return this.defDecExp;
    }

    @Override
    public void setDefaultExpressionDecomposition(Boolean defDecExp) {
        this.defDecExp = defDecExp;
    }

    @Override
    public final IntegerVariable getIntVar(int i) {
        return this.intVars.get(i);
    }

    @Override
    public final int getNbIntVars() {
        return this.intVars.size();
    }

    @Override
    public final RealVariable getRealVar(int i) {
        return this.floatVars.get(i);
    }

    @Override
    public final int getNbRealVars() {
        return this.floatVars.size();
    }

    @Override
    public final SetVariable getSetVar(int i) {
        return this.setVars.get(i);
    }

    @Override
    public final int getNbSetVars() {
        return this.setVars.size();
    }

    @Override
    public int getNbTotVars() {
        return this.getNbIntVars() + this.getNbRealVars() + this.getNbSetVars();
    }

    @Override
    public IntegerConstantVariable getConstantVar(int i) {
        return (IntegerConstantVariable)this.constantVars.get(i);
    }

    @Override
    public int getNbConstantVars() {
        return this.constantVars.size();
    }

    @Override
    public int getNbStoredMultipleVars() {
        return this.storedMultipleVariables.size();
    }

    @Override
    public MultipleVariables getStoredMultipleVar(int i) {
        return this.storedMultipleVariables.get(i);
    }

    @Override
    public final int getNbConstraints() {
        return this.constraints.size();
    }

    @Override
    public final Constraint getConstraint(int i) {
        return (Constraint)this.constraints.getValues()[i];
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getIntConstraintIterator() {
        return this.getConstraintIterator();
    }

    @Override
    public Iterator<Constraint> getConstraintIterator() {
        return new TroveIterator(this.constraints.iterator());
    }

    @Override
    public Iterator<Constraint> getConstraintByType(ConstraintType t) {
        TIntObjectHashMap<Constraint> hs = this.constraintsByType.get((Object)t);
        if (hs != null) {
            return new TroveIterator(hs.iterator());
        }
        return new EmptyIterator();
    }

    @Override
    public int getNbConstraintByType(ConstraintType t) {
        TIntObjectHashMap<Constraint> hs = this.constraintsByType.get((Object)t);
        if (hs != null) {
            return hs.size();
        }
        return 0;
    }

    @Override
    public <E extends IOptions> void addOption(String option, E ... element) {
        for (E anElement : element) {
            anElement.addOption(option);
        }
    }

    protected <E extends Variable> void addVariable(E v, List<E> vars) {
        if (!v.alreadyIn(this.index).booleanValue()) {
            vars.add(v);
            v.addModelIndex(this.index);
            v.setIndexIn(this.index, this.indexfactory.getIndex());
        }
    }

    @Override
    public void addVariable(Variable v) {
        this.addVariables("", v);
    }

    @Override
    public void addVariable(String options, Variable v) {
        this.addVariables(options, v);
    }

    @Override
    @Deprecated
    public void addVariable(Variable ... v) {
        this.addVariables("", v);
    }

    @Override
    @Deprecated
    public void addVariable(String options, Variable ... v) {
        this.addVariables(options, v);
    }

    @Override
    public void addVariables(Variable ... tabv) {
        this.addVariables("", tabv);
    }

    @Override
    public void addVariables(String options, Variable ... tabv) {
        Variable[] arr$ = tabv;
        int len$ = arr$.length;
        block12: for (int i$ = 0; i$ < len$; ++i$) {
            Variable aTabv;
            Variable v = aTabv = arr$[i$];
            if (options != null && !"".equals(options)) {
                String[] optionsStrings;
                for (String optionsString : optionsStrings = options.split(" ")) {
                    v.addOption(optionsString);
                }
            }
            v.findManager(this.properties);
            switch (v.getVariableType()) {
                case INTEGER: {
                    if (((IntegerVariable)v).isBoolean()) {
                        ++this.nbBoolVar;
                    }
                    this.addVariable((IntegerVariable)v, this.intVars);
                    continue block12;
                }
                case SET: {
                    this.addVariable((SetVariable)v, this.setVars);
                    this.addVariable(options, (Variable)((SetVariable)v).getCard());
                    continue block12;
                }
                case REAL: {
                    this.addVariable((RealVariable)v, this.floatVars);
                    continue block12;
                }
                case CONSTANT_INTEGER: {
                    if (((IntegerConstantVariable)v).isBoolean()) {
                        ++this.nbBoolVar;
                    }
                    this.addVariable(v, this.constantVars);
                    continue block12;
                }
                case CONSTANT_DOUBLE: {
                    this.addVariable(v, this.constantVars);
                    continue block12;
                }
                case CONSTANT_SET: {
                    this.addVariable(v, this.constantVars);
                    this.addVariable(options, (Variable)((SetVariable)v).getCard());
                    continue block12;
                }
                case INTEGER_EXPRESSION: {
                    IntegerExpressionVariable iev = (IntegerExpressionVariable)v;
                    Iterator<Variable> it = iev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable(it.next());
                    }
                    continue block12;
                }
                case SET_EXPRESSION: {
                    SetExpressionVariable sev = (SetExpressionVariable)v;
                    Iterator<Variable> it = sev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable(it.next());
                    }
                    continue block12;
                }
                case REAL_EXPRESSION: {
                    RealExpressionVariable rev = (RealExpressionVariable)v;
                    Iterator<Variable> it = rev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable(it.next());
                    }
                    continue block12;
                }
                case MULTIPLE_VARIABLES: {
                    MultipleVariables mv = (MultipleVariables)v;
                    Iterator<Variable> it = mv.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable(it.next());
                    }
                    if (!mv.isStored() || this.storedMultipleVariables.contains(mv)) continue block12;
                    mv.addModelIndex(this.index);
                    mv.setIndexIn(this.index, this.indexfactory.getIndex());
                    this.storedMultipleVariables.add(mv);
                    continue block12;
                }
                default: {
                    throw new ModelException("unknown variable type :" + (Object)((Object)v.getVariableType()));
                }
            }
        }
    }

    public int getNbBoolVar() {
        return this.nbBoolVar;
    }

    @Deprecated
    protected <E extends Variable> void removeVariable(E v, List<E> vars) {
        vars.remove(v);
        v.remModelIndex(this.index);
        Iterator<Constraint> it = v.getConstraintIterator(this);
        while (it.hasNext()) {
            Constraint c = it.next();
            it.remove();
            this.removeConstraint(c);
        }
    }

    protected <E extends Variable> void remVariable(E v) {
        switch (v.getVariableType()) {
            case INTEGER: {
                IntegerVariable vi = (IntegerVariable)v;
                this.intVars.remove(vi);
                break;
            }
            case SET: {
                SetVariable sv = (SetVariable)v;
                this.intVars.remove(sv.getCard());
                this.setVars.remove(sv);
                break;
            }
            case REAL: {
                RealVariable rv = (RealVariable)v;
                this.floatVars.remove(rv);
                break;
            }
            case CONSTANT_INTEGER: 
            case CONSTANT_DOUBLE: 
            case CONSTANT_SET: {
                return;
            }
            case INTEGER_EXPRESSION: {
                IntegerExpressionVariable iev = (IntegerExpressionVariable)v;
                Iterator<Variable> it = iev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable(it.next());
                }
                break;
            }
            case SET_EXPRESSION: {
                SetExpressionVariable sev = (SetExpressionVariable)v;
                Iterator<Variable> it = sev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable(it.next());
                }
                break;
            }
            case REAL_EXPRESSION: {
                RealExpressionVariable rev = (RealExpressionVariable)v;
                Iterator<Variable> it = rev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable(it.next());
                }
                break;
            }
            case MULTIPLE_VARIABLES: {
                MultipleVariables mv = (MultipleVariables)v;
                Iterator<Variable> it = mv.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable(it.next());
                }
                break;
            }
            default: {
                throw new ModelException("unknown variable type :" + (Object)((Object)v.getVariableType()));
            }
        }
        v.remModelIndex(this.index);
    }

    public void remove(Object ob) {
        Variable v;
        Constraint c;
        TIntHashSet conSet = new TIntHashSet();
        TIntHashSet varSet = new TIntHashSet();
        ArrayDeque<Constraint> conQueue = new ArrayDeque<Constraint>();
        ArrayDeque<Variable> varQueue = new ArrayDeque<Variable>();
        if (ob instanceof Constraint) {
            c = (Constraint)ob;
            conQueue.add(c);
            c.removedFrom(this.index);
            this.constraints.remove(c.getIndexIn(this.index));
        } else if (ob instanceof Variable) {
            v = (Variable)ob;
            varQueue.add(v);
            this.remVariable(v);
        }
        while (!varQueue.isEmpty() || !conQueue.isEmpty()) {
            if (!conQueue.isEmpty()) {
                c = (Constraint)conQueue.remove();
                Iterator<Variable> itv = c.getVariableIterator();
                while (itv.hasNext()) {
                    v = itv.next();
                    v.removeConstraint(c);
                    if (v.getNbConstraint(this) != 0 || varSet.contains(v.getIndexIn(this.index))) continue;
                    this.remVariable(v);
                    varQueue.add(v);
                }
                conSet.add(c.getIndexIn(this.index));
            }
            if (varQueue.isEmpty()) continue;
            v = (Variable)varQueue.remove();
            Iterator<Constraint> itc = v.getConstraintIterator(this);
            while (itc.hasNext()) {
                c = itc.next();
                if (conSet.contains(c.getIndexIn(this.index))) continue;
                conQueue.add(c);
                c.removedFrom(this.index);
                this.constraints.remove(c.getIndexIn(this.index));
            }
            varSet.add(v.getIndexIn(this.index));
        }
    }

    @Override
    public void removeConstraint(Constraint c) {
        this.remove(c);
    }

    @Override
    @Deprecated
    public void removeVariable(Variable ... v) {
        for (Variable aV : v) {
            this.remove(aV);
        }
    }

    @Override
    public void removeVariable(Variable v) {
        this.remove(v);
    }

    @Override
    public void removeVariables(Variable ... v) {
        for (Variable aV : v) {
            this.remove(aV);
        }
    }

    private void updateConstraintByType(ConstraintType t, Constraint c) {
        TIntObjectHashMap<Constraint> hs = this.constraintsByType.get((Object)t);
        if (hs == null) {
            hs = new TIntObjectHashMap();
        }
        if (!hs.containsKey(c.getIndexIn(this.index))) {
            hs.put(c.getIndexIn(this.index), c);
        }
        this.constraintsByType.put(t, hs);
    }

    @Override
    @Deprecated
    public void addConstraint(Constraint ... c) {
        this.addConstraints("", c);
    }

    @Override
    @Deprecated
    public void addConstraint(String options, Constraint ... c) {
        this.addConstraints(options, c);
    }

    @Override
    public void addConstraint(Constraint c) {
        this.addConstraints("", c);
    }

    @Override
    public void addConstraints(Constraint ... c) {
        this.addConstraints("", c);
    }

    @Override
    public void addConstraint(String options, Constraint c) {
        this.addConstraints(options, c);
    }

    @Override
    public void addConstraints(String options, Constraint ... tabc) {
        Constraint[] arr$ = tabc;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Constraint aTabc;
            Constraint c = aTabc = arr$[i$];
            if (options != null && !"".equals(options)) {
                String[] optionsStrings;
                for (String optionsString : optionsStrings = options.split(" ")) {
                    c.addOption(optionsString);
                }
            }
            c.findManager(this.properties);
            switch (c.getConstraintType()) {
                case CLAUSES: {
                    this.storeClauses((ComponentConstraint)c);
                    break;
                }
                default: {
                    if (c.alreadyIn(this.index).booleanValue()) break;
                    c.addedTo(this.index);
                    c.setIndexIn(this.index, this.indexfactory.getIndex());
                    this.constraints.put(c.getIndexIn(this.index), c);
                }
            }
            this.updateConstraintByType(c.getConstraintType(), c);
            Iterator<Variable> it = c.getVariableIterator();
            while (it.hasNext()) {
                Variable v = it.next();
                if (Choco.DEBUG && v == null) {
                    logger.severe("Adding null variable in the model !");
                }
                this.addVariable(v);
                if (v.getVariableType() == VariableType.CONSTANT_INTEGER || v.getVariableType() == VariableType.CONSTANT_SET) continue;
                v.addConstraint(c);
            }
        }
    }

    private void storeClauses(ComponentConstraint clause) {
        if (this.clausesStore == null) {
            this.clausesStore = new ComponentConstraintWithSubConstraints(ConstraintType.CLAUSES, clause.getVariables(), null, clause);
            this.clausesStore.findManager(this.properties);
            this.clausesStore.addedTo(this.index);
            this.clausesStore.setIndexIn(this.index, this.indexfactory.getIndex());
            this.constraints.put(this.clausesStore.getIndexIn(this.index), this.clausesStore);
        } else {
            this.clausesStore.addElements(clause.getVariables(), new Constraint[]{clause});
        }
    }

    public ListIterator<IntegerVariable> getIntVarIterator() {
        return ChocoUtil.getImmutableIterator(this.intVars);
    }

    public ListIterator<RealVariable> getRealVarIterator() {
        return ChocoUtil.getImmutableIterator(this.floatVars);
    }

    public ListIterator<SetVariable> getSetVarIterator() {
        return ChocoUtil.getImmutableIterator(this.setVars);
    }

    public ListIterator<Variable> getConstVarIterator() {
        return ChocoUtil.getImmutableIterator(this.constantVars);
    }

    public ListIterator<IntegerExpressionVariable> getExprVarIterator() {
        return ChocoUtil.getImmutableIterator(this.expVars);
    }

    public ListIterator<MultipleVariables> getMultipleVarIterator() {
        return ChocoUtil.getImmutableIterator(this.storedMultipleVariables);
    }

    static class TroveIterator
    implements Iterator<Constraint> {
        private TIntObjectIterator<Constraint> iterator;

        TroveIterator(TIntObjectIterator<Constraint> tit) {
            this.iterator = tit;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Constraint next() {
            this.iterator.advance();
            return this.iterator.value();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class EmptyIterator
    implements Iterator<Constraint> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Constraint next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

