/*
 * Decompiled with CFR 0.152.
 */
package choco;

import choco.kernel.common.IndexFactory;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.ComponentConstraintWithSubConstraints;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.constraints.MetaTaskConstraint;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.model.constraints.pack.PackModeler;
import choco.kernel.model.variables.ConstantFactory;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.geost.GeostObject;
import choco.kernel.model.variables.geost.IExternalConstraint;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.integer.MetaIntegerExpressionVariable;
import choco.kernel.model.variables.real.RealConstantVariable;
import choco.kernel.model.variables.real.RealExpressionVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetConstantVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.model.variables.tree.TreeParametersObject;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.RscData;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.CouplesTable;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.constraints.integer.extension.TuplesTable;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class Choco {
    static Logger logger = Logger.getLogger("choco");
    public static boolean DEBUG = false;
    public static int MIN_LOWER_BOUND = -21474836;
    public static int MAX_LOWER_BOUND = 21474836;
    public static final Constraint TRUE = new ComponentConstraint(ConstraintType.TRUE, (Object)true, (Variable[])new IntegerVariable[0]);
    public static final Constraint FALSE = new ComponentConstraint(ConstraintType.FALSE, (Object)false, (Variable[])new IntegerVariable[0]);

    public static IntegerVariable makeIntVar(String name, int lowB, int uppB, String ... options) {
        if (lowB > uppB) {
            throw new ModelException("makeIntVar : lowB > uppB");
        }
        if (lowB < MIN_LOWER_BOUND || uppB > MAX_LOWER_BOUND) {
            logger.warning("WARNING! Domains over [" + MIN_LOWER_BOUND + ", " + MAX_LOWER_BOUND + "] are strongly inadvisable ! ");
        }
        IntegerVariable v = new IntegerVariable(name, VariableType.INTEGER, lowB, uppB);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable makeIntVar(String name, String ... options) {
        return Choco.makeIntVar(name, MIN_LOWER_BOUND, MAX_LOWER_BOUND, options);
    }

    public static IntegerVariable makeIntVar(String name, TIntArrayList valuesList, String ... options) {
        int[] vars = new int[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            vars[i] = valuesList.get(i);
        }
        Arrays.sort(vars);
        if (vars[0] < MIN_LOWER_BOUND || vars[vars.length - 1] > MAX_LOWER_BOUND) {
            logger.warning("Domains over [" + MIN_LOWER_BOUND + ", " + MAX_LOWER_BOUND + "] are strongly inadvisable ! ");
        }
        IntegerVariable v = new IntegerVariable(name, VariableType.INTEGER, vars);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable makeIntVar(String name, int[] valuesArray, String ... options) {
        int[] values2 = new int[valuesArray.length];
        System.arraycopy(valuesArray, 0, values2, 0, valuesArray.length);
        Arrays.sort(values2);
        if (values2[0] < MIN_LOWER_BOUND || values2[values2.length - 1] > MAX_LOWER_BOUND) {
            logger.warning("Domains over [" + MIN_LOWER_BOUND + ", " + MAX_LOWER_BOUND + "] are strongly inadvisable ! ");
        }
        IntegerVariable v = new IntegerVariable(name, VariableType.INTEGER, values2);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable makeBooleanVar(String name, String ... options) {
        IntegerVariable v = new IntegerVariable(name, VariableType.INTEGER, 0, 1);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static IntegerVariable[] makeBooleanVarArray(String name, int dim, String ... options) {
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeBooleanVar(name + "_" + i, options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, int lowB, int uppB, String ... options) {
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVar(name + "_" + i, lowB, uppB, options);
        }
        return vars;
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, String ... options) {
        return Choco.makeIntVarArray(name, dim, MIN_LOWER_BOUND, MAX_LOWER_BOUND, options);
    }

    public static IntegerVariable[] makeIntVarArray(String name, int dim, int[] valuesArray, String ... options) {
        IntegerVariable[] vars = new IntegerVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVar(name + "_" + i, valuesArray, options);
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, int lowB, int uppB, String ... options) {
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVarArray(name + "_" + i, dim2, lowB, uppB, options);
        }
        return vars;
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, String ... options) {
        return Choco.makeIntVarArray(name, dim1, dim2, MIN_LOWER_BOUND, MAX_LOWER_BOUND, options);
    }

    public static IntegerVariable[][] makeIntVarArray(String name, int dim1, int dim2, int[] valuesArray, String ... options) {
        IntegerVariable[][] vars = new IntegerVariable[dim1][dim2];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeIntVarArray(name + "_" + i, dim2, valuesArray, options);
        }
        return vars;
    }

    public static SetVariable makeSetVar(String name, int lowB, int uppB, String ... options) {
        int c = uppB - lowB + 1;
        IntegerVariable card = Choco.makeIntVar(name, 0, c, options);
        SetVariable var = new SetVariable(name, VariableType.SET, lowB, uppB, card);
        for (String option : options) {
            var.addOption(option);
        }
        return var;
    }

    public static SetVariable makeSetVar(String name, int[] valuesArray, String ... options) {
        int[] values2 = new int[valuesArray.length];
        System.arraycopy(valuesArray, 0, values2, 0, valuesArray.length);
        Arrays.sort(values2);
        int c = values2.length;
        IntegerVariable card = Choco.makeIntVar("|" + name + "|", 0, c, options);
        SetVariable var = new SetVariable(name, VariableType.SET, values2, card);
        for (String option : options) {
            var.addOption(option);
        }
        return var;
    }

    public static SetVariable[] makeSetVarArray(String name, int dim, int lowB, int uppB, String ... options) {
        SetVariable[] vars = new SetVariable[dim];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Choco.makeSetVar(name + "_" + i, lowB, uppB, options);
        }
        return vars;
    }

    public static RealVariable makeRealVar(String name, double lowB, double uppB, String ... options) {
        if (lowB > uppB) {
            throw new ModelException("makeRealVar : lowB > uppB");
        }
        RealVariable v = new RealVariable(name, VariableType.REAL, lowB, uppB);
        for (String option : options) {
            v.addOption(option);
        }
        return v;
    }

    public static TaskVariable makeTaskVar(String name, IntegerVariable start, IntegerVariable end, IntegerVariable duration, String ... options) {
        TaskVariable tv = new TaskVariable(name, start, end, duration);
        for (String opt : options) {
            tv.addOption(opt);
        }
        return tv;
    }

    public static TaskVariable makeTaskVar(String name, IntegerVariable start, IntegerVariable duration, String ... options) {
        IntegerVariable end = Choco.makeIntVar("end-" + name, 0, start.getUppB() + duration.getUppB(), options);
        TaskVariable tv = new TaskVariable(name, start, end, duration);
        for (String opt : options) {
            tv.addOption(opt);
        }
        return tv;
    }

    public static TaskVariable makeTaskVar(String name, int binf, int bsup, IntegerVariable duration, String ... options) {
        IntegerVariable start = Choco.makeIntVar("start-" + name, binf, bsup, options);
        IntegerVariable end = Choco.makeIntVar("end-" + name, binf, bsup, options);
        return Choco.makeTaskVar(name, start, end, duration, options);
    }

    public static TaskVariable makeTaskVar(String name, int binf, int bsup, int duration, String ... options) {
        return Choco.makeTaskVar(name, binf, bsup, (IntegerVariable)Choco.constant(duration), options);
    }

    public static TaskVariable makeTaskVar(String name, int bsup, IntegerVariable duration, String ... options) {
        return Choco.makeTaskVar(name, 0, bsup, duration, options);
    }

    public static TaskVariable makeTaskVar(String name, int bsup, int duration, String ... options) {
        return Choco.makeTaskVar(name, 0, bsup, (IntegerVariable)Choco.constant(duration), options);
    }

    public static TaskVariable[] makeTaskVarArray(String prefix, IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, String ... options) {
        if (starts != null && durations != null && starts.length == durations.length) {
            if (ends == null) {
                TaskVariable[] vars = new TaskVariable[starts.length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = Choco.makeTaskVar(prefix + "_" + i, starts[i], durations[i], options);
                }
                return vars;
            }
            if (starts.length == ends.length) {
                TaskVariable[] vars = new TaskVariable[starts.length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = Choco.makeTaskVar(prefix + "_" + i, starts[i], ends[i], durations[i], options);
                }
                return vars;
            }
            throw new ModelException("invalid ends array length.");
        }
        throw new ModelException("starts and durations are required and should have equal lengths.");
    }

    public static TaskVariable[] makeTaskVarArray(String name, int binf, int bsup, IntegerVariable[] durations, String ... options) {
        int n = durations.length;
        TaskVariable[] vars = new TaskVariable[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = Choco.makeTaskVar(name + "_" + i, binf, bsup, durations[i], options);
        }
        return vars;
    }

    public static TaskVariable[] makeTaskVarArray(String name, int binf, int bsup, int[] durations, String ... options) {
        return Choco.makeTaskVarArray(name, binf, bsup, (IntegerVariable[])Choco.constantArray(durations), options);
    }

    public static TaskVariable[][] makeTaskVarArray(String name, int binf, int bsup, IntegerVariable[][] durations, String ... options) {
        int n = durations.length;
        int m = durations[0].length;
        TaskVariable[][] vars = new TaskVariable[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                vars[i][j] = Choco.makeTaskVar(name + "_" + i + "_" + j, binf, bsup, durations[i][j], options);
            }
        }
        return vars;
    }

    public static TaskVariable[][] makeTaskVarArray(String name, int binf, int bsup, int[][] durations, String ... options) {
        return Choco.makeTaskVarArray(name, binf, bsup, Choco.constantArray(durations), options);
    }

    public static SetVariable constant(String name, int ... value) {
        return ConstantFactory.getConstant(name, value);
    }

    public static RealConstantVariable constant(String name, double value) {
        return ConstantFactory.getConstant(name, value);
    }

    public static IntegerConstantVariable constant(String name, int value) {
        return ConstantFactory.getConstant(name, value);
    }

    public static IntegerConstantVariable constant(int a) {
        return ConstantFactory.getConstant(a);
    }

    public static SetConstantVariable constant(int[] a) {
        return ConstantFactory.getConstant(a);
    }

    public static SetConstantVariable emptySet() {
        return ConstantFactory.getConstant(new int[0]);
    }

    public static RealConstantVariable constant(double a) {
        return ConstantFactory.getConstant(a);
    }

    public static IntegerConstantVariable[] constantArray(int[] values) {
        IntegerConstantVariable[] tmp = new IntegerConstantVariable[values.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Choco.constant(values[i]);
        }
        return tmp;
    }

    public static IntegerConstantVariable[][] constantArray(int[][] values) {
        IntegerConstantVariable[][] tmp = new IntegerConstantVariable[values.length][values[0].length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                tmp[i][j] = Choco.constant(values[i][j]);
            }
        }
        return tmp;
    }

    public static RealConstantVariable[] constantArray(double[] values) {
        RealConstantVariable[] tmp = new RealConstantVariable[values.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Choco.constant(values[i]);
        }
        return tmp;
    }

    public static Constraint neq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint neq(int c, IntegerExpressionVariable x) {
        return Choco.neq(x, c);
    }

    public static Constraint neq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{x, y});
    }

    public static Constraint geq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, y});
    }

    public static Constraint geq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint geq(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint geq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, y});
    }

    public static Constraint geq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint geq(double c, RealExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint gt(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{x, y});
    }

    public static Constraint gt(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint gt(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.GT, (Object)ConstraintType.GT, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint eq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, y});
    }

    public static Constraint eq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint eq(int c, IntegerExpressionVariable x) {
        return Choco.eq(x, c);
    }

    public static Constraint eq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, y});
    }

    public static Constraint eq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint eq(double c, RealExpressionVariable x) {
        return Choco.eq(x, c);
    }

    public static Constraint eq(RealVariable r, IntegerVariable i) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{r, i});
    }

    public static Constraint eq(IntegerVariable i, RealVariable r) {
        return Choco.eq(r, i);
    }

    public static Constraint leq(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint leq(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint leq(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, y});
    }

    public static Constraint leq(RealExpressionVariable x, double c) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint leq(double c, RealExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint leq(RealExpressionVariable x, RealExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{x, y});
    }

    public static Constraint lt(IntegerExpressionVariable x, int c) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{x, Choco.constant(c)});
    }

    public static Constraint lt(int c, IntegerExpressionVariable x) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{Choco.constant(c), x});
    }

    public static Constraint lt(IntegerExpressionVariable x, IntegerExpressionVariable y) {
        return new ComponentConstraint(ConstraintType.LT, (Object)ConstraintType.LT, new Variable[]{x, y});
    }

    public static Constraint times(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{x, y, z});
    }

    public static Constraint times(int x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{Choco.constant(x), y, z});
    }

    public static Constraint times(IntegerVariable x, int y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.TIMES, null, (Variable[])new IntegerVariable[]{x, Choco.constant(y), z});
    }

    public static Constraint intDiv(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.EUCLIDEANDIVISION, null, (Variable[])new IntegerVariable[]{x, y, z});
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2);
        for (int[] couple : mat) {
            if (couple.length != 2) {
                throw new ModelException("Wrong dimension : " + couple.length + " for a couple");
            }
            relation.setCouple(couple[0], couple[1]);
        }
        return relation;
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas) {
        return Choco.makeBinRelation(min, max, mat, feas, false);
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, boolean[][] mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        if (n1 == mat.length && n2 == mat[0].length) {
            ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2);
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!mat[i][j]) continue;
                    relation.setCouple(i + min[0], j + min[1]);
                }
            }
            return relation;
        }
        throw new SolverException("Wrong dimension for the matrix of consistency : " + mat.length + " X " + mat[0].length + " instead of " + n1 + "X" + n2);
    }

    public static BinRelation makeBinRelation(int[] min, int[] max, boolean[][] mat, boolean feas) {
        return Choco.makeBinRelation(min, max, mat, feas, false);
    }

    private static Constraint makePairAC(String options, IntegerVariable v1, IntegerVariable v2, Object mat, boolean feas) {
        if (options == null) {
            return new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, new Variable[]{v1, v2});
        }
        ComponentConstraint c = new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, new Variable[]{v1, v2});
        c.addOption(options);
        return c;
    }

    public static Constraint infeasPairAC(IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(null, v1, v2, mat, false);
    }

    public static Constraint infeasPairAC(String options, IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(options, v1, v2, mat, false);
    }

    public static Constraint feasPairAC(IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(null, v1, v2, mat, true);
    }

    public static Constraint feasPairAC(String options, IntegerVariable v1, IntegerVariable v2, List<int[]> mat) {
        return Choco.makePairAC(options, v1, v2, mat, true);
    }

    public static Constraint infeasPairAC(IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(null, v1, v2, mat, false);
    }

    public static Constraint infeasPairAC(String options, IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(options, v1, v2, mat, false);
    }

    public static Constraint feasPairAC(IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(null, v1, v2, mat, true);
    }

    public static Constraint feasPairAC(String options, IntegerVariable v1, IntegerVariable v2, boolean[][] mat) {
        return Choco.makePairAC(options, v1, v2, mat, true);
    }

    public static Constraint relationPairAC(IntegerVariable v1, IntegerVariable v2, BinRelation binR) {
        return Choco.makePairAC(null, v1, v2, binR, false);
    }

    public static Constraint relationPairAC(String options, IntegerVariable v1, IntegerVariable v2, BinRelation binR) {
        return Choco.makePairAC(options, v1, v2, binR, false);
    }

    public static LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas) {
        return Choco.makeLargeRelation(min, max, tuples, feas, feas ? 0 : 1);
    }

    public static LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas, int scheme) {
        LargeRelation relation;
        int n = min.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = max[i] - min[i] + 1;
            offsets[i] = min[i];
        }
        if (scheme == 0) {
            relation = new IterTuplesTable(tuples, offsets, sizes);
        } else if (scheme == 1) {
            relation = new TuplesTable(feas, offsets, sizes);
            for (int[] tuple : tuples) {
                if (tuple.length != n) {
                    throw new SolverException("Wrong dimension : " + tuple.length + " for a tuple (should be " + n + ")");
                }
                ((TuplesTable)relation).setTuple(tuple);
            }
        } else {
            relation = new TuplesList(tuples);
        }
        return relation;
    }

    private static Constraint makeTupleACFC(String options, IntegerVariable[] vs, Object mat, boolean feas) {
        if (options == null) {
            return new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])vs);
        }
        ComponentConstraint c = new ComponentConstraint(ConstraintType.TABLE, (Object)new Object[]{feas, mat}, (Variable[])vs);
        c.addOption(options);
        return c;
    }

    public static Constraint infeasTupleFC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:fc", vars, tuples, false);
    }

    public static Constraint feasTupleFC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:fc", vars, tuples, true);
    }

    public static Constraint infeasTupleAC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:ac32", vars, tuples, false);
    }

    public static Constraint feasTupleAC(List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC("cp:ac32", vars, tuples, true);
    }

    public static Constraint infeasTupleAC(String options, List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC(options, vars, tuples, false);
    }

    public static Constraint feasTupleAC(String options, List<int[]> tuples, IntegerVariable ... vars) {
        return Choco.makeTupleACFC(options, vars, tuples, true);
    }

    public static Constraint relationTupleFC(IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC("cp:fc", vs, rela, false);
    }

    public static Constraint relationTupleAC(IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC(null, vs, rela, false);
    }

    public static Constraint relationTupleAC(String options, IntegerVariable[] vs, LargeRelation rela) {
        return Choco.makeTupleACFC(options, vs, rela, false);
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceNEQ(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)3, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, Choco.constant(c)});
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceEQ(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)0, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceLT(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)1, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, IntegerVariable z, int c) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(c)});
    }

    public static Constraint distanceGT(IntegerVariable x, IntegerVariable y, IntegerVariable z) {
        return new ComponentConstraint(ConstraintType.DISTANCE, (Object)2, (Variable[])new IntegerVariable[]{x, y, z, Choco.constant(0)});
    }

    public static Constraint abs(IntegerVariable x, IntegerVariable y) {
        return new ComponentConstraint(ConstraintType.ABS, null, (Variable[])new IntegerVariable[]{x, y});
    }

    public static Constraint min(SetVariable svar, IntegerVariable[] vars, IntegerVariable min) {
        Variable[] tmp = new Variable[vars.length + 2];
        tmp[0] = svar;
        System.arraycopy(vars, 0, tmp, 1, vars.length);
        tmp[tmp.length - 1] = min;
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, tmp);
    }

    public static Constraint min(IntegerVariable[] vars, IntegerVariable min) {
        Variable[] tmp = new Variable[vars.length + 1];
        System.arraycopy(vars, 0, tmp, 0, vars.length);
        tmp[tmp.length - 1] = min;
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, tmp);
    }

    public static Constraint max(SetVariable svar, IntegerVariable[] vars, IntegerVariable max) {
        Variable[] tmp = new Variable[vars.length + 2];
        tmp[0] = svar;
        System.arraycopy(vars, 0, tmp, 1, vars.length);
        tmp[tmp.length - 1] = max;
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, tmp);
    }

    public static Constraint max(IntegerVariable[] vars, IntegerVariable max) {
        Variable[] tmp = new Variable[vars.length + 1];
        System.arraycopy(vars, 0, tmp, 0, vars.length);
        tmp[tmp.length - 1] = max;
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, tmp);
    }

    public static Constraint min(IntegerVariable x, IntegerVariable y, IntegerVariable min) {
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, (Variable[])new IntegerVariable[]{x, y, min});
    }

    public static Constraint min(int x, IntegerVariable y, IntegerVariable min) {
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, (Variable[])new IntegerVariable[]{Choco.constant(x), y, min});
    }

    public static Constraint min(IntegerVariable x, int y, IntegerVariable min) {
        return new ComponentConstraint(ConstraintType.MIN, (Object)true, (Variable[])new IntegerVariable[]{x, Choco.constant(y), min});
    }

    public static Constraint max(IntegerVariable x, IntegerVariable y, IntegerVariable max) {
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, (Variable[])new IntegerVariable[]{x, y, max});
    }

    public static Constraint max(int x, IntegerVariable y, IntegerVariable max) {
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, (Variable[])new IntegerVariable[]{Choco.constant(x), y, max});
    }

    public static Constraint max(IntegerVariable x, int y, IntegerVariable max) {
        return new ComponentConstraint(ConstraintType.MAX, (Object)false, (Variable[])new IntegerVariable[]{x, Choco.constant(y), max});
    }

    public static Constraint occurrence(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)0, variables);
    }

    public static Constraint occurrenceMin(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)-1, variables);
    }

    public static Constraint occurrenceMax(int value, IntegerVariable occurrence, IntegerVariable ... vars) {
        Variable[] variables = new IntegerVariable[vars.length + 2];
        variables[0] = Choco.constant(value);
        variables[1] = occurrence;
        System.arraycopy(vars, 0, variables, 2, vars.length);
        return new ComponentConstraint(ConstraintType.OCCURRENCE, (Object)1, variables);
    }

    public static Constraint nth(IntegerVariable index, int[] values, IntegerVariable val) {
        return Choco.nth(index, values, val, 0);
    }

    public static Constraint nth(IntegerVariable index, int[] values, IntegerVariable val, int offset) {
        Variable[] vars = new IntegerVariable[values.length + 2];
        for (int i = 0; i < values.length; ++i) {
            vars[i] = Choco.constant(values[i]);
        }
        vars[vars.length - 2] = index;
        vars[vars.length - 1] = val;
        return new ComponentConstraint(ConstraintType.NTH, (Object)offset, vars);
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val) {
        Variable[] vars = UtilAlgo.append(varArray, {index, val});
        return new ComponentConstraint(ConstraintType.NTH, (Object)0, vars);
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable index2, int[][] varArray, IntegerVariable val) {
        return new ComponentConstraint(ConstraintType.NTH, (Object)varArray, (Variable[])new IntegerVariable[]{index, index2, val});
    }

    public static Constraint nth(IntegerVariable index, IntegerVariable[] varArray, IntegerVariable val, int offset) {
        Variable[] vars = UtilAlgo.append(varArray, {index, val});
        return new ComponentConstraint(ConstraintType.NTH, (Object)offset, vars);
    }

    public static Constraint boolChanneling(IntegerVariable b, IntegerVariable x, int j) {
        return new ComponentConstraint(ConstraintType.CHANNELING, (Object)ConstraintType.CHANNELING, (Variable[])new IntegerVariable[]{b, x, Choco.constant(j)});
    }

    public static Constraint inverseChanneling(IntegerVariable[] x, IntegerVariable[] y) {
        if (y.length != x.length) {
            throw new SolverException("not a valid inverse channeling constraint with two arrays of different sizes");
        }
        Variable[] vars = UtilAlgo.append(x, y);
        return new ComponentConstraint(ConstraintType.INVERSECHANNELING, (Object)ConstraintType.INVERSECHANNELING, vars);
    }

    public static Constraint allDifferent(IntegerVariable ... vars) {
        return new ComponentConstraint(ConstraintType.ALLDIFFERENT, null, (Variable[])vars);
    }

    public static Constraint allDifferent(String options, IntegerVariable ... vars) {
        Constraint c = Choco.allDifferent(vars);
        c.addOption(options);
        return c;
    }

    private static void globalCardinalityTest(IntegerVariable[] vars, int min, int max, int[] low, int[] up) {
        if (low.length != up.length) {
            throw new ModelException("globalCardinality : low and up do not have same size");
        }
        if (low.length != max - min + 1) {
            throw new ModelException("globalCardinality : low.length != max - min + 1");
        }
        if (up.length != max - min + 1) {
            throw new ModelException("globalCardinality : up.length != max - min + 1");
        }
        int sumL = 0;
        for (int i = 0; i < low.length; ++i) {
            sumL += low[i];
            if (low[i] <= up[i]) continue;
            throw new ModelException("globalCardinality : incorrect low and up (" + i + ")");
        }
        if (vars.length < sumL) {
            throw new ModelException("globalCardinality : not enough minimum values");
        }
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int min, int max, int[] low, int[] up) {
        Choco.globalCardinalityTest(vars, min, max, low, up);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYMAX, min, max, low, up}, (Variable[])vars);
    }

    public static Constraint globalCardinality(String options, IntegerVariable[] vars, int min, int max, int[] low, int[] up) {
        Constraint c = Choco.globalCardinality(vars, min, max, low, up);
        c.addOption(options);
        return c;
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int[] low, int[] up) {
        Choco.globalCardinalityTest(vars, 1, low.length, low, up);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITY, low, up}, (Variable[])vars);
    }

    public static Constraint globalCardinality(String options, IntegerVariable[] vars, int[] low, int[] up) {
        Constraint c = Choco.globalCardinality(vars, low, up);
        c.addOption(options);
        return c;
    }

    public static Constraint globalCardinality(IntegerVariable[] vars, int min, int max, IntegerVariable[] card) {
        int n = vars.length;
        Variable[] variables = new IntegerVariable[vars.length + card.length];
        System.arraycopy(vars, 0, variables, 0, n);
        System.arraycopy(card, 0, variables, n, card.length);
        return new ComponentConstraint(ConstraintType.GLOBALCARDINALITY, (Object)new Object[]{ConstraintType.GLOBALCARDINALITYVAR, min, max, n}, variables);
    }

    public static Constraint stretchPath(List<int[]> stretchesParameters, IntegerVariable ... vars) {
        return new ComponentConstraint(ConstraintType.STRETCHPATH, stretchesParameters, (Variable[])vars);
    }

    public static Constraint pack(int[] sizes, int nbBins, int capacity, String ... options) {
        return Choco.pack(new PackModeler(sizes, nbBins, capacity), options);
    }

    public static Constraint pack(PackModeler modeler, String ... options) {
        return Choco.pack(modeler.itemSets, modeler.loads, modeler.bins, modeler.sizes, modeler.nbNonEmpty, options);
    }

    public static Constraint pack(SetVariable[] itemSets, IntegerVariable[] loads, IntegerVariable[] bins, IntegerConstantVariable[] sizes, String ... options) {
        return Choco.pack(itemSets, loads, bins, sizes, Choco.makeIntVar("nbNonEmpty", 0, loads.length, "cp:bound"), options);
    }

    public static Constraint pack(SetVariable[] itemSets, IntegerVariable[] loads, IntegerVariable[] bins, IntegerConstantVariable[] sizes, IntegerVariable nbNonEmpty, String ... options) {
        if (itemSets.length != loads.length || bins.length != sizes.length) {
            throw new ModelException("lenght of arrays are invalid");
        }
        int n = bins.length;
        int m = loads.length;
        for (int i = 1; i < n; ++i) {
            if (sizes[i].getValue() <= sizes[i - 1].getValue()) continue;
            throw new ModelException("sizes must be sorted according to non increasing order.");
        }
        Variable[] vars = new Variable[2 * (n + m) + 1];
        System.arraycopy(itemSets, 0, vars, 0, m);
        System.arraycopy(loads, 0, vars, m, m);
        System.arraycopy(bins, 0, vars, 2 * m, n);
        System.arraycopy(sizes, 0, vars, 2 * m + n, n);
        vars[vars.length - 1] = nbNonEmpty;
        ComponentConstraint pack = new ComponentConstraint(ConstraintType.PACK, (Object)new Object[]{n, m}, vars);
        pack.addOptions(options);
        return pack;
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, IntegerVariable capacity, IntegerVariable uppBound, String ... options) {
        if (tasks.length == heights.length && consumption != null && capacity != null) {
            Variable[] variableArray;
            RscData param = new RscData(name, tasks, usages, uppBound);
            Variable[][] variableArrayArray = new Variable[5][];
            variableArrayArray[0] = tasks;
            variableArrayArray[1] = heights;
            variableArrayArray[2] = usages;
            variableArrayArray[3] = new Variable[]{consumption, capacity};
            if (uppBound == null) {
                variableArray = null;
            } else {
                Variable[] variableArray2 = new Variable[1];
                variableArray = variableArray2;
                variableArray2[0] = uppBound;
            }
            variableArrayArray[4] = variableArray;
            Variable[] vars = UtilAlgo.appendAndCast(Variable.class, variableArrayArray);
            ComponentConstraint c = new ComponentConstraint(ConstraintType.CUMULATIVE, (Object)param, vars);
            c.addOptions(options);
            return c;
        }
        throw new ModelException("can't build cumulative constraint : invalid arguments.");
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, consumption, capacity, null, options);
    }

    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable consumption, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, consumption, capacity, null, options);
    }

    public static Constraint cumulativeMax(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, (IntegerVariable)Choco.constant(0), capacity, null, options);
    }

    public static Constraint cumulativeMax(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable capacity, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, (IntegerVariable)Choco.constant(0), capacity, null, options);
    }

    public static Constraint cumulativeMax(TaskVariable[] tasks, int[] heights, int capacity, String ... options) {
        return Choco.cumulativeMax(null, tasks, (IntegerVariable[])Choco.constantArray(heights), Choco.constant(capacity), options);
    }

    public static Constraint cumulativeMin(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable[] usages, IntegerVariable consumption, String ... options) {
        return Choco.cumulative(name, tasks, heights, usages, consumption, (IntegerVariable)Choco.constant(Integer.MAX_VALUE), null, options);
    }

    public static Constraint cumulativeMin(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable consumption, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, consumption, (IntegerVariable)Choco.constant(Integer.MAX_VALUE), null, options);
    }

    public static Constraint cumulativeMin(TaskVariable[] tasks, int[] heights, int consumption, String ... options) {
        return Choco.cumulativeMin(null, tasks, (IntegerVariable[])Choco.constantArray(heights), Choco.constant(consumption), options);
    }

    @Deprecated
    public static Constraint cumulative(String name, TaskVariable[] tasks, IntegerVariable[] heights, IntegerVariable capa, String ... options) {
        return Choco.cumulative(name, tasks, heights, null, (IntegerVariable)Choco.constant(0), capa, null, options);
    }

    @Deprecated
    public static Constraint cumulative(TaskVariable[] tasks, int[] heights, int capa, String ... options) {
        return Choco.cumulative(null, tasks, (IntegerVariable[])Choco.constantArray(heights), null, (IntegerVariable)Choco.constant(capa), null, null, options);
    }

    @Deprecated
    public static Constraint cumulative(String name, IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, IntegerVariable[] heights, IntegerVariable capa, String ... options) {
        TaskVariable[] tasks = Choco.makeTaskVarArray("t", starts, ends, durations, new String[0]);
        return Choco.cumulative(name, tasks, heights, capa, null, options);
    }

    @Deprecated
    public static Constraint cumulative(IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, IntegerVariable[] heights, IntegerVariable capa, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], ends[i], durations[i], new String[0]);
        }
        return Choco.cumulative(null, t, heights, capa, null, options);
    }

    @Deprecated
    public static Constraint cumulative(IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, int[] heights, int capa, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], ends[i], durations[i], new String[0]);
        }
        return Choco.cumulative(null, t, (IntegerVariable[])Choco.constantArray(heights), (IntegerVariable)Choco.constant(capa), null, options);
    }

    @Deprecated
    public static Constraint cumulative(IntegerVariable[] starts, IntegerVariable[] durations, IntegerVariable[] heights, IntegerVariable capa, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], durations[i], new String[0]);
        }
        return Choco.cumulative(null, t, heights, capa, null, options);
    }

    @Deprecated
    public static Constraint disjunctive(IntegerVariable[] starts, int[] durations, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], (IntegerVariable)Choco.constant(durations[i]), new String[0]);
        }
        return Choco.disjunctive(null, t, null, options);
    }

    @Deprecated
    public static Constraint disjunctive(IntegerVariable[] starts, IntegerVariable[] durations, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], durations[i], new String[0]);
        }
        return Choco.disjunctive(null, t, null, options);
    }

    @Deprecated
    public static Constraint disjunctive(IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, String ... options) {
        TaskVariable[] t = new TaskVariable[starts.length];
        for (int i = 0; i < starts.length; ++i) {
            t[i] = Choco.makeTaskVar("", starts[i], ends[i], durations[i], new String[0]);
        }
        return Choco.disjunctive(null, t, null, options);
    }

    @Deprecated
    public static Constraint disjunctive(String name, IntegerVariable[] starts, IntegerVariable[] ends, IntegerVariable[] durations, IntegerVariable uppBound, String ... options) {
        TaskVariable[] tasks = Choco.makeTaskVarArray("task-", starts, ends, durations, new String[0]);
        return Choco.disjunctive(name, tasks, null, uppBound, options);
    }

    public static Constraint disjunctive(TaskVariable[] tasks, String ... options) {
        return Choco.disjunctive(null, tasks, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, String ... options) {
        return Choco.disjunctive(name, tasks, null, options);
    }

    public static Constraint disjunctive(TaskVariable[] tasks, IntegerVariable[] usages, String ... options) {
        return Choco.disjunctive(null, tasks, usages, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, IntegerVariable[] usages, String ... options) {
        return Choco.disjunctive(name, tasks, usages, null, options);
    }

    public static Constraint disjunctive(String name, TaskVariable[] tasks, IntegerVariable[] usages, IntegerVariable uppBound, String ... options) {
        RscData param = new RscData(name, tasks, usages, uppBound);
        Variable[] vars = uppBound == null ? UtilAlgo.appendAndCast(Variable.class, tasks, usages) : UtilAlgo.appendAndCast(Variable.class, tasks, usages, {uppBound});
        ComponentConstraint c = new ComponentConstraint(ConstraintType.DISJUNCTIVE, (Object)param, vars);
        c.addOptions(options);
        return c;
    }

    public static Constraint preceding(IntegerVariable v1, int dur1, IntegerVariable v2, int dur2, IntegerVariable bool) {
        return new ComponentConstraint(ConstraintType.PRECEDING, (Object)Boolean.FALSE, new Variable[]{v1, Choco.constant(dur1), v2, Choco.constant(dur2), bool});
    }

    public static Constraint preceding(TaskVariable t1, TaskVariable t2) {
        return Choco.preceding(t1, t2, Choco.constant(1));
    }

    public static Constraint preceding(TaskVariable t1, TaskVariable t2, IntegerVariable direction) {
        if (direction.isBoolean()) {
            return new ComponentConstraint(ConstraintType.PRECEDING, (Object)Boolean.TRUE, new Variable[]{t1, t2, direction});
        }
        throw new ModelException("direction is not boolean !");
    }

    public static Constraint[] preceding(TaskVariable[] clique, String prefix, String ... boolvarOptions) {
        int n = clique.length;
        Constraint[] cstr = new Constraint[n * (n - 1) / 2];
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                cstr[idx++] = Choco.preceding(clique[i], clique[j], Choco.makeBooleanVar(prefix + "_" + i + "_" + j, boolvarOptions));
            }
        }
        return cstr;
    }

    public static Constraint precedenceReified(IntegerVariable x0, int k, IntegerVariable x1, IntegerVariable b) {
        return new ComponentConstraint(ConstraintType.PRECEDENCEREIFIED, null, new Variable[]{x0, Choco.constant(k), x1, b});
    }

    public static Constraint geost(int dim, Vector<GeostObject> objects, Vector<ShiftedBox> shiftedBoxes, Vector<IExternalConstraint> eCtrs) {
        return Choco.geost(dim, objects, shiftedBoxes, eCtrs, null);
    }

    public static Constraint geost(int dim, Vector<GeostObject> objects, Vector<ShiftedBox> shiftedBoxes, Vector<IExternalConstraint> eCtrs, Vector<int[]> ctrlVs) {
        int originOfObjects = objects.size() * dim;
        int otherVariables = objects.size() * 4;
        Variable[] vars = new IntegerVariable[originOfObjects + otherVariables];
        for (int i = 0; i < objects.size(); ++i) {
            for (int j = 0; j < dim; ++j) {
                vars[i * (dim + 4) + j] = objects.elementAt(i).getCoordinates()[j];
            }
            vars[i * (dim + 4) + dim] = objects.elementAt(i).getShapeId();
            vars[i * (dim + 4) + dim + 1] = objects.elementAt(i).getStartTime();
            vars[i * (dim + 4) + dim + 2] = objects.elementAt(i).getDurationTime();
            vars[i * (dim + 4) + dim + 3] = objects.elementAt(i).getEndTime();
        }
        return new ComponentConstraint(ConstraintType.GEOST, (Object)new Object[]{dim, shiftedBoxes, eCtrs, objects, ctrlVs}, vars);
    }

    public static Constraint lexeq(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        Variable[] vars = UtilAlgo.append(v1, v2);
        return new ComponentConstraint(ConstraintType.LEX, (Object)new Object[]{ConstraintType.LEXEQ, offset}, vars);
    }

    public static Constraint lex(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        Variable[] vars = UtilAlgo.append(v1, v2);
        return new ComponentConstraint(ConstraintType.LEX, (Object)new Object[]{ConstraintType.LEX, offset}, vars);
    }

    public static Constraint lexChain(IntegerVariable[] ... arrayOfVectors) {
        int n = arrayOfVectors[0].length;
        Variable[] vs = new IntegerVariable[arrayOfVectors.length * n];
        for (int i = 0; i < arrayOfVectors.length; ++i) {
            if (arrayOfVectors[i].length != n) {
                throw new ModelException("LexChain : every arrays in parameters are of different size");
            }
            System.arraycopy(arrayOfVectors[i], 0, vs, n * i, n);
        }
        return new ComponentConstraint(ConstraintType.LEXCHAIN, (Object)new Object[]{true, n}, vs);
    }

    public static Constraint lexChainEq(IntegerVariable[] ... arrayOfVectors) {
        int n = arrayOfVectors[0].length;
        Variable[] vs = new IntegerVariable[arrayOfVectors.length * n];
        for (int i = 0; i < arrayOfVectors.length; ++i) {
            System.arraycopy(arrayOfVectors[i], 0, vs, n * i, n);
        }
        return new ComponentConstraint(ConstraintType.LEXCHAIN, (Object)new Object[]{false, n}, vs);
    }

    public static Constraint sorting(IntegerVariable[] v1, IntegerVariable[] v2) {
        int offset = v1.length;
        Variable[] vars = UtilAlgo.append(v1, v2);
        return new ComponentConstraint(ConstraintType.SORTING, (Object)offset, vars);
    }

    public static Constraint leximin(IntegerVariable[] v1, IntegerVariable[] v2) {
        Variable[] vars = new IntegerVariable[v1.length + v2.length];
        System.arraycopy(v1, 0, vars, 0, v1.length);
        System.arraycopy(v2, 0, vars, v1.length, v2.length);
        return new ComponentConstraint(ConstraintType.LEXIMIN, null, vars);
    }

    public static Constraint leximin(int[] v1, IntegerVariable[] v2) {
        return new ComponentConstraint(ConstraintType.LEXIMIN, (Object)v1, (Variable[])v2);
    }

    public static Constraint atMostNValue(IntegerVariable[] vars, IntegerVariable nvalue) {
        Variable[] tmp = new IntegerVariable[vars.length + 1];
        System.arraycopy(vars, 0, tmp, 0, vars.length);
        tmp[tmp.length - 1] = nvalue;
        return new ComponentConstraint(ConstraintType.ATMOSTNVALUE, null, tmp);
    }

    public static Constraint setInter(SetVariable sv1, SetVariable sv2, SetVariable inter) {
        return new ComponentConstraint(ConstraintType.SETINTER, null, new Variable[]{sv1, sv2, inter});
    }

    public static Constraint setUnion(SetVariable sv1, SetVariable sv2, SetVariable union) {
        return new ComponentConstraint(ConstraintType.SETUNION, null, new Variable[]{sv1, sv2, union});
    }

    public static Constraint eq(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{sv1, sv2});
    }

    public static Constraint eqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{sv, v});
    }

    public static Constraint eqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.EQ, (Object)ConstraintType.EQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint neqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{sv, v});
    }

    public static Constraint neqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint geqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{sv, v});
    }

    public static Constraint geqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.GEQ, (Object)ConstraintType.GEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint leqCard(SetVariable sv, IntegerVariable v) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{sv, v});
    }

    public static Constraint leqCard(SetVariable sv, int val) {
        return new ComponentConstraint(ConstraintType.LEQ, (Object)ConstraintType.LEQ, new Variable[]{sv, Choco.constant(val)});
    }

    public static Constraint setDisjoint(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.SETDISJOINT, null, new Variable[]{sv1, sv2});
    }

    public static Constraint member(int val, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.MEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint member(SetVariable sv1, int val) {
        return new ComponentConstraint(ConstraintType.MEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint member(SetVariable sv1, IntegerVariable var) {
        return new ComponentConstraint(ConstraintType.MEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint member(IntegerVariable var, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.MEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint notMember(int val, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint notMember(SetVariable sv1, int val) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, (Object)val, new Variable[]{sv1});
    }

    public static Constraint notMember(SetVariable sv1, IntegerVariable var) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint notMember(IntegerVariable var, SetVariable sv1) {
        return new ComponentConstraint(ConstraintType.NOTMEMBER, null, new Variable[]{sv1, var});
    }

    public static Constraint neq(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.NEQ, (Object)ConstraintType.NEQ, new Variable[]{sv1, sv2});
    }

    public static Constraint isIncluded(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.ISINCLUDED, null, new Variable[]{sv1, sv2});
    }

    public static Constraint isNotIncluded(SetVariable sv1, SetVariable sv2) {
        return new ComponentConstraint(ConstraintType.ISNOTINCLUDED, null, new Variable[]{sv1, sv2});
    }

    public static Constraint regular(DFA auto, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)auto, (Variable[])vars);
    }

    public static Constraint regular(String regexp, IntegerVariable[] vars) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)regexp, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, List<int[]> tuples) {
        return new ComponentConstraint(ConstraintType.REGULAR, tuples, (Variable[])vars);
    }

    public static Constraint regular(IntegerVariable[] vars, List<int[]> tuples, int[] min, int[] max) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)new Object[]{tuples, min, max}, (Variable[])vars);
    }

    public static Constraint costRegular(IntegerVariable[] vars, IntegerVariable cvar, Automaton auto, int[][] costs) {
        return new ComponentConstraint(ConstraintType.COSTREGULAR, (Object)new Object[]{auto, costs}, (Variable[])UtilAlgo.append(vars, {cvar}));
    }

    public static Constraint multiCostRegular(IntegerVariable[] vars, IntegerVariable[] cvar, Automaton auto, int[][][] costs) {
        return new ComponentConstraint(ConstraintType.MULTICOSTREGULAR, (Object)new Object[]{vars.length, auto, costs}, (Variable[])UtilAlgo.append(vars, cvar));
    }

    public static Constraint tree(TreeParametersObject param) {
        return new ComponentConstraint(ConstraintType.TREE, (Object)param, param.extractVariables());
    }

    public static Constraint equation(IntegerVariable[] vars, int[] coeffs, int val) {
        return new ComponentConstraint(ConstraintType.REGULAR, (Object)new int[][]{coeffs, {val}}, (Variable[])vars);
    }

    public static Constraint sameSign(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new ComponentConstraint(ConstraintType.SIGNOP, (Object)true, new Variable[]{n1, n2});
    }

    public static Constraint oppositeSign(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new ComponentConstraint(ConstraintType.SIGNOP, (Object)false, new Variable[]{n1, n2});
    }

    public static Constraint mod(IntegerVariable v0, IntegerVariable v1, int c) {
        return new ComponentConstraint(ConstraintType.MOD, null, (Variable[])new IntegerVariable[]{v0, v1, Choco.constant(c)});
    }

    public static Constraint reifiedIntConstraint(IntegerVariable binVar, Constraint cst) {
        Variable[] vars = UtilAlgo.append({binVar}, cst.getVariables());
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDINTCONSTRAINT, vars, null, cst);
    }

    public static Constraint reifiedIntConstraint(IntegerVariable binVar, Constraint cst, Constraint oppCst) {
        return new ComponentConstraintWithSubConstraints(ConstraintType.REIFIEDINTCONSTRAINT, (Variable[])new IntegerVariable[]{binVar}, null, cst, oppCst);
    }

    public static Constraint clause(IntegerVariable[] positiveLiterals, IntegerVariable[] negativeLiterals) {
        Variable[] literals = UtilAlgo.append(positiveLiterals, negativeLiterals);
        return new ComponentConstraint(ConstraintType.CLAUSES, (Object)positiveLiterals.length, literals);
    }

    public static IntegerExpressionVariable mult(IntegerExpressionVariable t1, int a) {
        return new IntegerExpressionVariable(null, Operator.MULT, t1, Choco.constant(a));
    }

    public static IntegerExpressionVariable mult(int a, IntegerExpressionVariable t1) {
        return new IntegerExpressionVariable(null, Operator.MULT, t1, Choco.constant(a));
    }

    public static IntegerExpressionVariable mult(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MULT, n1, n2);
    }

    public static IntegerExpressionVariable plus(IntegerExpressionVariable t1, IntegerExpressionVariable t2) {
        return new IntegerExpressionVariable(null, Operator.PLUS, t1, t2);
    }

    public static IntegerExpressionVariable plus(IntegerExpressionVariable t, int c) {
        return Choco.plus(t, (IntegerExpressionVariable)Choco.constant(c));
    }

    public static IntegerExpressionVariable plus(int c, IntegerExpressionVariable t) {
        return Choco.plus(t, (IntegerExpressionVariable)Choco.constant(c));
    }

    public static IntegerExpressionVariable minus(IntegerExpressionVariable t1, IntegerExpressionVariable t2) {
        return new IntegerExpressionVariable(null, Operator.MINUS, t1, t2);
    }

    public static IntegerExpressionVariable minus(IntegerExpressionVariable t, int c) {
        return new IntegerExpressionVariable(null, Operator.MINUS, t, Choco.constant(c));
    }

    public static IntegerExpressionVariable minus(int c, IntegerExpressionVariable t) {
        return new IntegerExpressionVariable(null, Operator.MINUS, Choco.constant(c), t);
    }

    public static IntegerExpressionVariable scalar(int[] lc, IntegerVariable[] lv) {
        if (lc.length != lv.length) {
            throw new ModelException("scalar: parameters length are differents");
        }
        IntegerExpressionVariable[] tmp = new IntegerVariable[lc.length + lv.length];
        for (int i = 0; i < lc.length; ++i) {
            tmp[i] = Choco.constant(lc[i]);
        }
        System.arraycopy(lv, 0, tmp, lc.length, lv.length);
        return new IntegerExpressionVariable(null, Operator.SCALAR, tmp);
    }

    public static IntegerExpressionVariable scalar(IntegerVariable[] lv, int[] lc) {
        return Choco.scalar(lc, lv);
    }

    public static IntegerExpressionVariable sum(IntegerExpressionVariable ... lv) {
        return new IntegerExpressionVariable(null, Operator.SUM, lv);
    }

    public static IntegerExpressionVariable abs(IntegerExpressionVariable n) {
        return new IntegerExpressionVariable(null, Operator.ABS, n);
    }

    public static IntegerExpressionVariable distEq(IntegerExpressionVariable n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new IntegerExpressionVariable(null, Operator.DISTANCEEQ, n1, n2, n3);
    }

    public static IntegerExpressionVariable distGt(IntegerExpressionVariable n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new IntegerExpressionVariable(null, Operator.DISTANCEGT, n1, n2, n3);
    }

    public static IntegerExpressionVariable distLt(IntegerExpressionVariable n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new IntegerExpressionVariable(null, Operator.DISTANCELT, n1, n2, n3);
    }

    public static IntegerExpressionVariable distNeq(IntegerExpressionVariable n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new IntegerExpressionVariable(null, Operator.DISTANCENEQ, n1, n2, n3);
    }

    public static IntegerExpressionVariable div(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.DIV, n1, n2);
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, n1, n2);
    }

    public static IntegerExpressionVariable max(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, Choco.constant(n1), n2);
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MAX, n1, Choco.constant(n2));
    }

    public static IntegerExpressionVariable max(IntegerExpressionVariable[] n1) {
        return new IntegerExpressionVariable(null, Operator.MAX, n1);
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, n1, n2);
    }

    public static IntegerExpressionVariable min(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, Choco.constant(n1), n2);
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MIN, n1, Choco.constant(n2));
    }

    public static IntegerExpressionVariable min(IntegerExpressionVariable[] n1) {
        return new IntegerExpressionVariable(null, Operator.MIN, n1);
    }

    public static IntegerExpressionVariable mod(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, n1, n2);
    }

    public static IntegerExpressionVariable mod(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, Choco.constant(n1), n2);
    }

    public static IntegerExpressionVariable mod(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.MOD, n1, Choco.constant(n2));
    }

    public static IntegerExpressionVariable neg(IntegerExpressionVariable n) {
        return new IntegerExpressionVariable(null, Operator.NEG, n);
    }

    public static IntegerExpressionVariable power(IntegerExpressionVariable n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, n1, n2);
    }

    public static IntegerExpressionVariable power(int n1, IntegerExpressionVariable n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, Choco.constant(n1), n2);
    }

    public static IntegerExpressionVariable power(IntegerExpressionVariable n1, int n2) {
        return new IntegerExpressionVariable(null, Operator.POWER, n1, Choco.constant(n2));
    }

    public static IntegerExpressionVariable ifThenElse(Constraint n1, IntegerExpressionVariable n2, IntegerExpressionVariable n3) {
        return new MetaIntegerExpressionVariable(Operator.IFTHENELSE, n1, n2, n3);
    }

    public static RealExpressionVariable mult(double a, RealExpressionVariable x) {
        return new RealExpressionVariable(null, Operator.MULT, Choco.constant(a), x);
    }

    public static RealExpressionVariable mult(RealExpressionVariable x, int a) {
        return Choco.mult((double)a, x);
    }

    public static RealExpressionVariable mult(RealExpressionVariable x, RealExpressionVariable y) {
        return new RealExpressionVariable(null, Operator.MULT, x, y);
    }

    public static RealExpressionVariable plus(RealExpressionVariable t1, RealExpressionVariable t2) {
        return new RealExpressionVariable(null, Operator.PLUS, t1, t2);
    }

    public static RealExpressionVariable plus(RealExpressionVariable t, double c) {
        return Choco.plus(t, (RealExpressionVariable)Choco.constant(c));
    }

    public static RealExpressionVariable plus(double c, RealExpressionVariable t) {
        return Choco.plus(t, (RealExpressionVariable)Choco.constant(c));
    }

    public static RealExpressionVariable minus(RealExpressionVariable t1, RealExpressionVariable t2) {
        return new RealExpressionVariable(null, Operator.MINUS, t1, t2);
    }

    public static RealExpressionVariable minus(RealExpressionVariable t, double c) {
        return new RealExpressionVariable(null, Operator.MINUS, t, Choco.constant(c));
    }

    public static RealExpressionVariable minus(double c, RealExpressionVariable t) {
        return new RealExpressionVariable(null, Operator.MINUS, Choco.constant(c), t);
    }

    public static RealExpressionVariable power(RealExpressionVariable exp, int power) {
        return new RealExpressionVariable(null, Operator.POWER, exp, Choco.constant((double)power));
    }

    public static RealExpressionVariable cos(RealExpressionVariable exp) {
        return new RealExpressionVariable(null, Operator.COS, exp);
    }

    public static RealExpressionVariable sin(RealExpressionVariable exp) {
        return new RealExpressionVariable(null, Operator.SIN, exp);
    }

    public static Constraint and(Constraint ... n) {
        if (n.length == 0) {
            return TRUE;
        }
        if (n.length == 1) {
            return n[0];
        }
        return new MetaConstraint(ConstraintType.AND, n);
    }

    public static Constraint ifOnlyIf(Constraint n1, Constraint n2) {
        return new MetaConstraint(ConstraintType.IFONLYIF, new Constraint[]{n1, n2});
    }

    public static Constraint ifThenElse(Constraint n1, Constraint n2, Constraint n3) {
        return new MetaConstraint(ConstraintType.IFTHENELSE, new Constraint[]{n1, n2, n3});
    }

    public static Constraint implies(Constraint n1, Constraint n2) {
        return new MetaConstraint(ConstraintType.IMPLIES, new Constraint[]{n1, n2});
    }

    public static Constraint not(Constraint n) {
        return new MetaConstraint(ConstraintType.NOT, new Constraint[]{n});
    }

    public static Constraint or(Constraint ... n) {
        if (n.length == 0) {
            return TRUE;
        }
        if (n.length == 1) {
            return n[0];
        }
        return new MetaConstraint(ConstraintType.OR, n);
    }

    protected static Constraint timeWindow(IntegerVariable var, int min, int max) {
        return Choco.eq((IntegerExpressionVariable)var, (IntegerExpressionVariable)Choco.makeIntVar("internal-tw-" + IndexFactory.getId(), min, max, "cp:bound", "cp:no_decision"));
    }

    public static Constraint endsBetween(TaskVariable t, int min, int max) {
        return Choco.timeWindow(t.end(), min, max);
    }

    public static Constraint startsBetween(TaskVariable t, int min, int max) {
        return Choco.timeWindow(t.start(), min, max);
    }

    public static Constraint endsBefore(TaskVariable t, int max) {
        return Choco.leq((IntegerExpressionVariable)t.end(), max);
    }

    public static Constraint startsBefore(TaskVariable t, int max) {
        return Choco.leq((IntegerExpressionVariable)t.start(), max);
    }

    public static Constraint endsAfter(TaskVariable t, int min) {
        return Choco.geq((IntegerExpressionVariable)t.end(), min);
    }

    public static Constraint startsAfter(TaskVariable t, int min) {
        return Choco.geq((IntegerExpressionVariable)t.start(), min);
    }

    public static Constraint startsBeforeBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new Variable[]{t1, t2}, Choco.leq(Choco.plus((IntegerExpressionVariable)t1.start(), delta), (IntegerExpressionVariable)t2.start()));
    }

    public static Constraint startsBeforeBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.startsBeforeBegin(t1, t2, 0);
    }

    public static Constraint startsAfterBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.startsBeforeBegin(t2, t1, delta);
    }

    public static Constraint startsAfterBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.startsAfterBegin(t1, t2, 0);
    }

    public static Constraint startsAfterEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new Variable[]{t1, t2}, Choco.geq((IntegerExpressionVariable)t1.start(), Choco.plus((IntegerExpressionVariable)t2.end(), delta)));
    }

    public static Constraint startsAfterEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.preceding(t2, t1);
    }

    public static Constraint endsBeforeBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.startsAfterEnd(t2, t1, delta);
    }

    public static Constraint endsBeforeBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.preceding(t1, t2);
    }

    public static Constraint startsBeforeEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new Variable[]{t1, t2}, Choco.leq(Choco.plus((IntegerExpressionVariable)t1.start(), delta), (IntegerExpressionVariable)t2.end()));
    }

    public static Constraint startsBeforeEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.startsBeforeEnd(t1, t2, 0);
    }

    public static Constraint endsAfterBegin(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.startsBeforeEnd(t2, t1, delta);
    }

    public static Constraint endsAfterBegin(TaskVariable t1, TaskVariable t2) {
        return Choco.endsAfterBegin(t1, t2, 0);
    }

    public static Constraint endsBeforeEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return new MetaTaskConstraint(new Variable[]{t1, t2}, Choco.leq((IntegerExpressionVariable)t1.end(), Choco.plus((IntegerExpressionVariable)t2.end(), delta)));
    }

    public static Constraint endsBeforeEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.endsBeforeEnd(t1, t2, 0);
    }

    public static Constraint endsAfterEnd(TaskVariable t1, TaskVariable t2, int delta) {
        return Choco.endsBeforeEnd(t2, t1, delta);
    }

    public static Constraint endsAfterEnd(TaskVariable t1, TaskVariable t2) {
        return Choco.endsAfterEnd(t1, t2, 0);
    }
}

